/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deconvolve an image using the Landweber deconvolution algorithm.


This filter implements the Landweber deconvolution algorithm as
defined in Bertero M and Boccacci P, "Introduction to Inverse
Problems in Imaging", 1998. The algorithm assumes that the input
image has been formed by a linear shift-invariant system with a known
kernel.

The Landweber algorithm converges to a solution that minimizes the sum
of squared errors $||f \\otimes h - g||$ where $f$ is the estimate of the unblurred image, $\\otimes$ is the convolution operator, $h$ is the blurring kernel, and $g$ is the blurred input image. As such, it is best suited for images
that have zero-mean Gaussian white noise.

This is the base implementation of the Landweber algorithm. It may
produce results with negative values. For a version of this algorithm
that enforces a positivity constraint on each intermediate solution,
see ProjectedLandweberDeconvolutionImageFilter .

This code was adapted from the Insight Journal contribution:

"Deconvolution: infrastructure and reference algorithms" by Gaetan
Lehmann https://doi.org/10.54294/tvgfv1


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France

Cory Quammen, The University of North Carolina at Chapel Hill

See:
 IterativeDeconvolutionImageFilter

 RichardsonLucyDeconvolutionImageFilter

 ProjectedLandweberDeconvolutionImageFilter

 itk::simple::LandweberDeconvolution for the procedural interface

 itk::LandweberDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLandweberDeconvolutionImageFilter.h
*/
public class LandweberDeconvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LandweberDeconvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LandweberDeconvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LandweberDeconvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LandweberDeconvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LandweberDeconvolutionImageFilter::~LandweberDeconvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LandweberDeconvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LandweberDeconvolutionImageFilter::LandweberDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LandweberDeconvolutionImageFilter() {
    this(SimpleITKJNI.new_LandweberDeconvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::SetAlpha(double Alpha)

Set/get relaxation factor.

*/
public  void setAlpha(double Alpha) {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_setAlpha(swigCPtr, this, Alpha);
  }

  /**
double itk::simple::LandweberDeconvolutionImageFilter::GetAlpha() const

Set/get relaxation factor.

*/
public  double getAlpha() {
    return SimpleITKJNI.LandweberDeconvolutionImageFilter_getAlpha(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::SetNumberOfIterations(int NumberOfIterations)

Set the number of iterations.

*/
public  void setNumberOfIterations(int NumberOfIterations) {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
int itk::simple::LandweberDeconvolutionImageFilter::GetNumberOfIterations() const

Get the number of iterations.

*/
public  int getNumberOfIterations() {
    return SimpleITKJNI.LandweberDeconvolutionImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::LandweberDeconvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.LandweberDeconvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(LandweberDeconvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::LandweberDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public  LandweberDeconvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return LandweberDeconvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.LandweberDeconvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::LandweberDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(LandweberDeconvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.LandweberDeconvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::LandweberDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public  LandweberDeconvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return LandweberDeconvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.LandweberDeconvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::LandweberDeconvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LandweberDeconvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LandweberDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LandweberDeconvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LandweberDeconvolutionImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.LandweberDeconvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public final static class BoundaryConditionType {
    public final static LandweberDeconvolutionImageFilter.BoundaryConditionType ZERO_PAD = new LandweberDeconvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static LandweberDeconvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new LandweberDeconvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static LandweberDeconvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new LandweberDeconvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static LandweberDeconvolutionImageFilter.OutputRegionModeType SAME = new LandweberDeconvolutionImageFilter.OutputRegionModeType("SAME");
    public final static LandweberDeconvolutionImageFilter.OutputRegionModeType VALID = new LandweberDeconvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
