/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.binder.internal;

import org.hibernate.AnnotationException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.binder.AttributeBinder;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;

public class BatchSizeBinder
implements TypeBinder<BatchSize>,
AttributeBinder<BatchSize> {
    @Override
    public void bind(BatchSize batchSize, MetadataBuildingContext context, PersistentClass persistentClass) {
        persistentClass.setBatchSize(batchSize.size());
    }

    @Override
    public void bind(BatchSize batchSize, MetadataBuildingContext context, Component embeddableClass) {
        throw new AnnotationException("Class '" + embeddableClass.getComponentClassName() + "' is an '@Embeddable' type and may not be annotated '@BatchSize'");
    }

    @Override
    public void bind(BatchSize batchSize, MetadataBuildingContext context, PersistentClass persistentClass, Property property) {
        Value value = property.getValue();
        if (!(value instanceof Collection)) {
            throw new AnnotationException("Property '" + property.getName() + "' may not be annotated '@BatchSize'");
        }
        Collection collection = (Collection)value;
        collection.setBatchSize(batchSize.size());
    }
}

