/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.DefaultWorkflowProvider;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.timer.ScheduledTask;

public class ScheduledWorkflowRunner
implements ScheduledTask {
    private static final Logger log = Logger.getLogger(DefaultWorkflowProvider.class);
    private final String workflowId;
    private final String realmId;

    public ScheduledWorkflowRunner(String workflowId, String realmId) {
        this.workflowId = workflowId;
        this.realmId = realmId;
    }

    public void run(KeycloakSession session) {
        RealmModel realm = session.realms().getRealm(this.realmId);
        if (realm == null) {
            log.warnf("Realm %s for scheduled workflow %s not found, cancelling task", (Object)this.realmId, (Object)this.workflowId);
            throw new IllegalStateException("Realm for scheduled workflow not found: " + this.realmId);
        }
        session.getContext().setRealm(realm);
        WorkflowProvider provider = (WorkflowProvider)session.getProvider(WorkflowProvider.class);
        Workflow workflow = provider.getWorkflow(this.workflowId);
        if (workflow == null) {
            log.warnf("Scheduled workflow %s in realm %s not found, cancelling task", (Object)this.workflowId, (Object)this.realmId);
            throw new IllegalStateException("Scheduled workflow not found: " + this.workflowId);
        }
        log.debugf("Executing scheduled workflow '%s' in realm %s", (Object)workflow.getName(), (Object)realm.getName());
        try {
            provider.activateForAllEligibleResources(workflow);
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Error while executing scheduled workflow %s in realm %s", (Object)workflow.getName(), (Object)realm.getName());
        }
        log.debugf("Finished executing scheduled workflow '%s' in realm %s", (Object)workflow.getName(), (Object)realm.getName());
    }

    public String getTaskName() {
        return "workflow-" + this.workflowId;
    }
}

