/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.client;

import org.jetbrains.kotlin.org.apache.http.config.Lookup;
import org.jetbrains.kotlin.org.apache.http.config.RegistryBuilder;
import org.jetbrains.kotlin.org.apache.http.conn.util.PublicSuffixMatcher;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieSpecProvider;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.RFC6265CookieSpecProvider;

public final class CookieSpecRegistries {
    public static RegistryBuilder<CookieSpecProvider> createDefaultBuilder(PublicSuffixMatcher publicSuffixMatcher) {
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider(publicSuffixMatcher);
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        return RegistryBuilder.create().register("default", defaultProvider).register("best-match", defaultProvider).register("compatibility", defaultProvider).register("standard", (DefaultCookieSpecProvider)((Object)laxStandardProvider)).register("standard-strict", (DefaultCookieSpecProvider)((Object)strictStandardProvider)).register("netscape", (DefaultCookieSpecProvider)((Object)new NetscapeDraftSpecProvider())).register("ignoreCookies", (DefaultCookieSpecProvider)((Object)new IgnoreSpecProvider()));
    }

    public static Lookup<CookieSpecProvider> createDefault(PublicSuffixMatcher publicSuffixMatcher) {
        return CookieSpecRegistries.createDefaultBuilder(publicSuffixMatcher).build();
    }
}

