/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.HttpConnection;
import com.install4j.runtime.installer.platform.win32.wininet.IgnoreCaseString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpConnectionWrapper
implements HttpConnection {
    private Map<IgnoreCaseString, List<String>> requestHeaders = new HashMap<IgnoreCaseString, List<String>>();
    private String requestMethod = "GET";
    private long postContentLength = 0L;
    private boolean acceptAllCertificates;
    private int connectTimeout;
    private int readTimeout;
    private URL url;

    public AbstractHttpConnectionWrapper(URL url, boolean acceptAllCertificates) {
        this.url = url;
        this.acceptAllCertificates = acceptAllCertificates;
    }

    protected abstract void checkConnected();

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    @Override
    public void setRequestMethod(String requestMethod) throws ProtocolException {
        this.requestMethod = requestMethod;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.requestHeaders.put(new IgnoreCaseString(key), new ArrayList<String>(Collections.singletonList(value)));
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.requestHeaders.computeIfAbsent(new IgnoreCaseString(key), s2 -> new ArrayList()).add(value);
    }

    @Override
    public void setDoOutput(long contentLength) {
        this.postContentLength = contentLength;
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    protected int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private void setRequestHeaderIfNotSet(String key, String value) {
        this.requestHeaders.computeIfAbsent(new IgnoreCaseString(key), s2 -> new ArrayList<String>(Collections.singletonList(value)));
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.setRequestHeaderIfNotSet("cache-control", "no-cache");
        this.setRequestHeaderIfNotSet("pragma", "no-cache");
    }

    @Override
    public long getContentLengthLong() {
        String responseHeader = this.getHeaderField("content-length");
        if (responseHeader != null) {
            try {
                return Long.parseLong(responseHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    protected void checkConnectedAndFound() throws IOException {
        this.checkConnected();
        if (this.getResponseCode() == 404) {
            throw new FileNotFoundException(this.getURL().toExternalForm());
        }
    }

    protected Map<IgnoreCaseString, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    protected String getRequestMethod() {
        return this.requestMethod;
    }

    protected long getPostContentLength() {
        return this.postContentLength;
    }

    protected boolean isAcceptAllCertificates() {
        return this.acceptAllCertificates;
    }
}

