/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.jdbc.BorrowContextUpdater;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.util.OpaqueString;

public interface BorrowContext {
    default public String getUser() {
        return null;
    }

    default public OpaqueString getPassword() {
        return null;
    }

    default public Properties getLabels() {
        return null;
    }

    default public Properties getProxyProperties() {
        return null;
    }

    default public Integer getProxyType() {
        return null;
    }

    default public String getServiceName() {
        return null;
    }

    default public String getUserRequestedServiceName() {
        return null;
    }

    default public String getServiceNameFromUser() {
        return null;
    }

    default public OracleShardingKey getShardingKey() {
        return null;
    }

    default public OracleShardingKey getSuperShardingKey() {
        return null;
    }

    default public Properties getPdbRoles() {
        return null;
    }

    default public SSLContext getSSLContext() {
        return null;
    }

    default public PoolDataSource.HostnameResolver getHostnameResolver() {
        return null;
    }

    default public Boolean isReadOnlyInstanceAllowed() {
        return null;
    }

    default public OracleShardingKey getLookupShardingKey() {
        return null;
    }

    default public Duration getConnectionWaitDuration() {
        return null;
    }

    default public Long getConnectionWaitDurationInMillis() {
        return null;
    }

    default public PoolDataSourceImpl getPoolDataSource() {
        return null;
    }

    public static BorrowContext build(final PoolDataSourceImpl pds) {
        return new BorrowContext(){

            @Override
            public String getUser() {
                return pds.getUser();
            }

            @Override
            public OpaqueString getPassword() {
                return pds.getPasswordInternal();
            }

            @Override
            public String getServiceName() {
                String pdsServicaName = pds.getServiceName();
                if (null != pdsServicaName) {
                    return pdsServicaName;
                }
                return pds.connectionPool.getServiceName();
            }

            @Override
            public String getServiceNameFromUser() {
                String pdsServicaName = pds.getServiceName();
                return pdsServicaName;
            }

            @Override
            public Properties getPdbRoles() {
                return pds.getPdbRoles();
            }

            @Override
            public SSLContext getSSLContext() {
                return pds.getSSLContext();
            }

            @Override
            public PoolDataSource.HostnameResolver getHostnameResolver() {
                return pds.getHostnameResolver();
            }

            @Override
            public Boolean isReadOnlyInstanceAllowed() {
                return pds.isReadOnlyInstanceAllowed();
            }

            @Override
            public Duration getConnectionWaitDuration() {
                return pds.getConnectionWaitDuration();
            }

            @Override
            public Long getConnectionWaitDurationInMillis() {
                return pds.getConnectionWaitDurationInMillis();
            }

            @Override
            public PoolDataSourceImpl getPoolDataSource() {
                return pds;
            }
        };
    }

    public static class Impl
    implements BorrowContext {
        private final BorrowContext context;
        private final BorrowContextUpdater updater;

        Impl(BorrowContext context, BorrowContextUpdater updater) {
            this.context = Objects.requireNonNull(context);
            this.updater = Objects.requireNonNull(updater);
        }

        protected BorrowContext getContext() {
            return this.context;
        }

        protected BorrowContextUpdater getUpdater() {
            return this.updater;
        }

        @Override
        public String getUser() {
            String user = this.updater.getUser();
            if (null != user) {
                return user;
            }
            return this.context.getUser();
        }

        @Override
        public OpaqueString getPassword() {
            OpaqueString pwd = this.updater.getPassword();
            if (null != pwd) {
                return pwd;
            }
            return this.context.getPassword();
        }

        @Override
        public Properties getLabels() {
            return this.updater.getLabels();
        }

        @Override
        public Properties getProxyProperties() {
            Properties proxyProps = this.updater.getProxyProperties();
            if (null != proxyProps) {
                return proxyProps;
            }
            return this.context.getProxyProperties();
        }

        @Override
        public Integer getProxyType() {
            Integer proxyType = this.updater.getProxyType();
            if (null != proxyType) {
                return proxyType;
            }
            proxyType = this.context.getProxyType();
            if (null != proxyType) {
                return proxyType;
            }
            return -1;
        }

        @Override
        public String getServiceName() {
            String sn = this.updater.getServiceName();
            if (null != sn) {
                return sn;
            }
            return this.context.getServiceName();
        }

        @Override
        public String getUserRequestedServiceName() {
            String ursn = this.updater.getUserRequestedServiceName();
            if (null != ursn) {
                return ursn;
            }
            return this.context.getUserRequestedServiceName();
        }

        @Override
        public String getServiceNameFromUser() {
            if (null != this.updater.getServiceName()) {
                return this.updater.getServiceName();
            }
            return this.context.getServiceNameFromUser();
        }

        @Override
        public OracleShardingKey getShardingKey() {
            if (null != this.updater) {
                return this.updater.getShardingKey();
            }
            return null;
        }

        @Override
        public OracleShardingKey getSuperShardingKey() {
            if (null != this.updater) {
                return this.updater.getSuperShardingKey();
            }
            return null;
        }

        @Override
        public Properties getPdbRoles() {
            Properties pdbProps = this.updater.getPdbRoles();
            if (null != pdbProps) {
                return pdbProps;
            }
            return this.context.getPdbRoles();
        }

        @Override
        public SSLContext getSSLContext() {
            SSLContext sslCtx = this.updater.getSSLContext();
            if (null != sslCtx) {
                return sslCtx;
            }
            return this.context.getSSLContext();
        }

        @Override
        public PoolDataSource.HostnameResolver getHostnameResolver() {
            PoolDataSource.HostnameResolver hr = this.updater.getHostnameResolver();
            if (null != hr) {
                return hr;
            }
            return this.context.getHostnameResolver();
        }

        @Override
        public Boolean isReadOnlyInstanceAllowed() {
            Boolean roia = this.updater.isReadOnlyInstanceAllowed();
            if (null != roia) {
                return roia;
            }
            roia = this.context.isReadOnlyInstanceAllowed();
            if (null != roia) {
                return roia;
            }
            return false;
        }

        @Override
        public OracleShardingKey getLookupShardingKey() {
            if (null != this.updater) {
                return this.updater.getLookupShardingKey();
            }
            return null;
        }

        @Override
        public Duration getConnectionWaitDuration() {
            Duration connectionWaitDuration = this.updater.getConnectionWaitDuration();
            if (null != connectionWaitDuration) {
                return connectionWaitDuration;
            }
            return this.context.getConnectionWaitDuration();
        }

        @Override
        public Long getConnectionWaitDurationInMillis() {
            Long connectionWaitDurationInMillis = this.updater.getConnectionWaitDurationInMillis();
            if (null != connectionWaitDurationInMillis) {
                return connectionWaitDurationInMillis;
            }
            return this.context.getConnectionWaitDurationInMillis();
        }

        @Override
        public PoolDataSourceImpl getPoolDataSource() {
            return this.context.getPoolDataSource();
        }

        private String toStringHelper(BorrowContext context) {
            return "user=" + this.getUser() + ", password=********" + ", labels=" + this.getLabels() + ", proxyType =" + this.getProxyType() + ", proxyProperties=" + this.getProxyProperties() + ", serviceName=" + this.getServiceName() + ", userRequestedServiceName=" + this.getUserRequestedServiceName() + ", shardingKey=" + this.getShardingKey() + ", superShardingKey=" + this.getSuperShardingKey() + ", pdbRoles=" + this.getPdbRoles() + ", sslContext=" + this.getSSLContext() + ", hostnameResolver=" + this.getHostnameResolver() + ", readOnlyInstanceAllowed=" + this.isReadOnlyInstanceAllowed() + ", lookupShardingKey=" + this.getLookupShardingKey() + ", connectionWaitDuration=" + this.getConnectionWaitDuration();
        }

        public String toString() {
            return "context=[" + this.toStringHelper(this.context) + "], updater=[" + this.toStringHelper(this.updater) + "]";
        }
    }
}

