"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cell = void 0;
const styled_components_1 = __importDefault(require("styled-components"));
const prompt_1 = require("./prompt");
const shadowLevels = {
    FLAT: "none",
    HOVERED: `var(
    --theme-cell-shadow-hover,
    1px 1px 3px rgba(0, 0, 0, 0.12),
    -1px -1px 3px rgba(0, 0, 0, 0.12)
  )`,
    SELECTED: `var(
    --theme-cell-shadow-focus,
    3px 3px 9px rgba(0, 0, 0, 0.12),
    -3px -3px 9px rgba(0, 0, 0, 0.12)
  )`
};
function cellShadowLevel(props) {
    if (props.isSelected) {
        return shadowLevels.SELECTED;
    }
    if (props._hovered) {
        return shadowLevels.HOVERED;
    }
    return shadowLevels.FLAT;
}
exports.Cell = styled_components_1.default.div.attrs(props => ({
    className: props.isSelected ? "selected" : "",
    style: {
        boxShadow: cellShadowLevel(props)
    }
})) `
  & {
    position: relative;
    background: var(--theme-cell-bg, white);
    transition: all 0.1s ease-in-out;
  }

  /* The box shadow for hovered should only apply when not already selected */
  &:hover:not(.selected) {
    box-shadow: ${shadowLevels.HOVERED};
  }

  /*
  Our cells conditionally style the prompt contained within based on if the cell is
  selected or hovered. To do this with styled-components we use their method of
  referring to other components:

  https://www.styled-components.com/docs/advanced#referring-to-other-components

  */
  & ${prompt_1.Prompt} {
    /* We change nothing when the cell is not selected, focused, or hovered */
  }
  &.selected ${prompt_1.Prompt} {
    background-color: var(--theme-cell-prompt-bg-focus, hsl(0, 0%, 90%));
    color: var(--theme-cell-prompt-fg-focus, hsl(0, 0%, 51%));
  }

  &:hover:not(.selected) ${prompt_1.Prompt}, &:active:not(.selected) ${prompt_1.Prompt} {
    background-color: var(--theme-cell-prompt-bg-hover, hsl(0, 0%, 94%));
    color: var(--theme-cell-prompt-fg-hover, hsl(0, 0%, 15%));
  }

  &:focus ${prompt_1.Prompt} {
    background-color: var(--theme-cell-prompt-bg-focus, hsl(0, 0%, 90%));
    color: var(--theme-cell-prompt-fg-focus, hsl(0, 0%, 51%));
  }
  @media print{
    /* make sure all cells look the same in print regarless of focus */
    & ${prompt_1.Prompt}, &.selected ${prompt_1.Prompt}, &:focus ${prompt_1.Prompt}, &:hover:not(.selected) ${prompt_1.Prompt} {
      background-color: var(--theme-cell-prompt-bg, white);
      color: var(--theme-cell-prompt-fg, black);
    }
  }
`;
exports.Cell.displayName = "Cell";
exports.Cell.defaultProps = {
    isSelected: false,
    _hovered: false,
    children: null
};
exports.default = exports.Cell;
//# sourceMappingURL=cell.js.map