/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.promise.ImportCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.parser.BinarySnapshotProvider;
import com.oracle.truffle.js.parser.DirectEvalContext;
import com.oracle.truffle.js.parser.GraalJSParserHelper;
import com.oracle.truffle.js.parser.JSParser;
import com.oracle.truffle.js.parser.JavaScriptTranslator;
import com.oracle.truffle.js.parser.SnapshotProvider;
import com.oracle.truffle.js.parser.date.DateParser;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModuleObject;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.SyntheticModuleRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.objects.WebAssemblyModuleRecord;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public final class GraalJSEvaluator
implements JSParser {
    private static final HiddenKey STORE_MODULE_KEY = new HiddenKey("store-module-key");

    @Override
    public ScriptNode parseEval(JSContext context, Node lastNode, Source source, ScriptOrModule activeScriptOrModule) {
        return GraalJSEvaluator.parseEval(context, lastNode, source, false, null, activeScriptOrModule);
    }

    @Override
    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public ScriptNode parseFunction(JSContext context, String parameterList, String body, boolean generatorFunction, boolean asyncFunction, String sourceName, ScriptOrModule activeScriptOrModule) {
        boolean nashornCompat;
        String wrappedBody = "\n" + body + "\n";
        try {
            GraalJSParserHelper.checkFunctionSyntax(context, context.getParserOptions(), parameterList, wrappedBody, generatorFunction, asyncFunction, sourceName);
        }
        catch (ParserException e) {
            e.setLineNumber(e.getLineNumber() - 1);
            throw GraalJSEvaluator.parserToJSError(null, e, context);
        }
        StringBuilder code = new StringBuilder();
        if (asyncFunction) {
            code.append("(async function");
        } else {
            code.append("(function");
        }
        if (generatorFunction) {
            code.append("*");
        }
        code.append(' ');
        boolean bl = nashornCompat = context.getEcmaScriptVersion() == 5 && context.isOptionNashornCompatibilityMode();
        if (!nashornCompat) {
            code.append("anonymous");
        }
        code.append('(');
        code.append(parameterList);
        if (!nashornCompat) {
            code.append('\n');
        }
        code.append(") {");
        code.append(wrappedBody);
        code.append("})");
        Source source = Source.newBuilder((String)"js", (CharSequence)code.toString(), (String)sourceName).cached(false).build();
        return GraalJSEvaluator.parseEval(context, null, source, false, null, activeScriptOrModule);
    }

    @Override
    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public ScriptNode parseDirectEval(JSContext context, Node lastNode, Source source, Object evalEnv) {
        DirectEvalContext directEval = (DirectEvalContext)evalEnv;
        return GraalJSEvaluator.parseEval(context, lastNode, source, directEval.env.isStrictMode(), directEval, directEval.activeScriptOrModule);
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    private static ScriptNode parseEval(JSContext context, Node lastNode, Source source, boolean isStrict, DirectEvalContext directEval, ScriptOrModule activeScriptOrModule) {
        context.checkEvalAllowed();
        NodeFactory nodeFactory = NodeFactory.getInstance(context);
        try {
            return JavaScriptTranslator.translateEvalScript(nodeFactory, context, source, isStrict, directEval, activeScriptOrModule);
        }
        catch (ParserException e) {
            throw GraalJSEvaluator.parserToJSError(lastNode, e, context);
        }
    }

    private static JSException parserToJSError(Node lastNode, ParserException e, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        Object message = context.isOptionV8CompatibilityMode() ? e.getRawMessage() : e.getMessage();
        message = ((String)message).replace("\r\n", "\n");
        if (e.getErrorType() == JSErrorType.ReferenceError) {
            return Errors.createReferenceError((String)message, e, lastNode);
        }
        assert (e.getErrorType() == JSErrorType.SyntaxError);
        if (context.isOptionNashornCompatibilityMode() && lastNode instanceof EvalNode) {
            SourceSection sourceSection = lastNode.getSourceSection();
            String name = sourceSection.getSource().getName();
            int lineNumber = sourceSection.getStartLine();
            int columnNumber = sourceSection.getStartColumn() - 1;
            message = name + "#" + lineNumber + ":" + columnNumber + (String)message;
        }
        return Errors.createSyntaxError((String)message, e, lastNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ScriptNode evalCompile(JSContext context, String sourceCode, String name) {
        try {
            context.checkEvalAllowed();
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder((String)"js", (CharSequence)sourceCode, (String)name).build(), false, "", "");
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e, context);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ScriptNode parseScript(JSContext context, Source source, String prolog, String epilog, boolean isStrict, List<String> argumentNames) {
        if (GraalJSEvaluator.isModuleSource(source)) {
            return this.fakeScriptForModule(context, source);
        }
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, source, isStrict, prolog, epilog, argumentNames);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e, context);
        }
    }

    private static boolean isModuleSource(Source source) {
        String mimeType = source.getMimeType();
        return "application/javascript+module".equals(mimeType) || mimeType == null && source.getName().endsWith(".mjs");
    }

    private ScriptNode fakeScriptForModule(JSContext context, Source source) {
        JSModuleData parsedModule = this.parseModule(context, source);
        ModuleScriptRoot rootNode = new ModuleScriptRoot(context, parsedModule, source);
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, (CallTarget)rootNode.getCallTarget(), 0, Strings.EMPTY_STRING);
        return ScriptNode.fromFunctionData(functionData);
    }

    private static JSFunctionObject createTopLevelAwaitReject(JSContext context, JSRealm realm) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.TopLevelAwaitReject, c -> GraalJSEvaluator.createTopLevelAwaitRejectImpl(c));
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createTopLevelAwaitRejectImpl(JSContext context) {
        class TopLevelAwaitRejectedRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);

            TopLevelAwaitRejectedRootNode() {
            }

            public Object execute(VirtualFrame frame) {
                Object error = this.argumentNode.execute(frame);
                throw JSRuntime.getException(error);
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new TopLevelAwaitRejectedRootNode().getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private static JSFunctionObject createTopLevelAwaitResolve(JSContext context, JSRealm realm) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.TopLevelAwaitResolve, c -> GraalJSEvaluator.createTopLevelAwaitResolveImpl(c));
        return JSFunction.create(realm, functionData);
    }

    private static JSFunctionData createTopLevelAwaitResolveImpl(JSContext context) {
        class TopLevelAwaitFulfilledRootNode
        extends JavaScriptRootNode {
            TopLevelAwaitFulfilledRootNode() {
            }

            public Object execute(VirtualFrame frame) {
                return Undefined.instance;
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new TopLevelAwaitFulfilledRootNode().getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    @Override
    public ScriptNode parseScript(JSContext context, String sourceCode) {
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder((String)"js", (CharSequence)sourceCode, (String)"<unknown>").build(), false, "", "");
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e, context);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Integer[] parseDate(JSRealm realm, String date, boolean extraLenient) {
        DateParser dateParser = new DateParser(realm, date, extraLenient);
        return dateParser.parse() ? dateParser.getDateFields() : null;
    }

    @Override
    public String parseToJSON(JSContext context, String code, String name, boolean includeLoc) {
        return GraalJSParserHelper.parseToJSON(code, name, includeLoc, context);
    }

    @Override
    public Object getDefaultNodeFactory() {
        return NodeFactory.getDefaultInstance();
    }

    public static Supplier<ScriptNode> internalParseForTiming(JSContext context, Source source) {
        FunctionNode ast = GraalJSParserHelper.parseScript(context, source, context.getParserOptions());
        return () -> JavaScriptTranslator.translateFunction(NodeFactory.getInstance(context), context, null, source, 0, false, ast);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleData parseModule(JSContext context, Source source) {
        try {
            return JavaScriptTranslator.translateModule(NodeFactory.getInstance(context), context, source);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e, context);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleData envParseModule(JSRealm realm, Source source) {
        assert (GraalJSEvaluator.isModuleSource(source)) : source;
        CallTarget parseResult = realm.getEnv().parsePublic(source, new String[0]);
        CallTarget moduleScriptCallTarget = JavaScriptLanguage.getParsedProgramCallTarget(((RootCallTarget)parseResult).getRootNode());
        ModuleScriptRoot moduleScriptRoot = (ModuleScriptRoot)((RootCallTarget)moduleScriptCallTarget).getRootNode();
        return moduleScriptRoot.getModuleData();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public AbstractModuleRecord parseWasmModuleSource(JSRealm realm, Source source) {
        assert (realm.getContextOptions().isWebAssembly());
        Object compiledModule = WebAssemblyBuiltins.moduleDecode(realm, source);
        JSWebAssemblyModuleObject wasmModule = JSWebAssemblyModule.create(realm.getContext(), realm, compiledModule, source);
        return new WebAssemblyModuleRecord(realm.getContext(), source, wasmModule);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public AbstractModuleRecord parseJSONModule(JSRealm realm, Source source) {
        assert ("application/json".equals(source.getMimeType()) || source.getMimeType() == null && source.getName().endsWith(".json")) : source;
        Object json = JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, realm.getJsonParseFunctionObject(), Strings.fromJavaString(source.getCharacters().toString())));
        return GraalJSEvaluator.createDefaultExportSyntheticModule(realm.getContext(), source, json);
    }

    private static SyntheticModuleRecord createDefaultExportSyntheticModule(JSContext ctx, Source source, Object defaultExport) {
        return new SyntheticModuleRecord(ctx, source, defaultExport, List.of(Strings.DEFAULT), module -> module.setSyntheticModuleExport(Strings.DEFAULT, module.getHostDefined()));
    }

    @CompilerDirectives.TruffleBoundary
    private static AbstractModuleRecord hostResolveImportedModule(JSRealm realm, ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        JSModuleLoader moduleLoader = referrer instanceof JSModuleRecord ? ((JSModuleRecord)referrer).getModuleLoader() : realm.getModuleLoader();
        return moduleLoader.resolveImportedModule(referrer, GraalJSEvaluator.filterSupportedImportAttributes(realm.getContext(), moduleRequest));
    }

    private static Module.ModuleRequest filterSupportedImportAttributes(JSContext context, Module.ModuleRequest moduleRequest) {
        if (moduleRequest.attributes().isEmpty() || context.getSupportedImportAttributes().containsAll(moduleRequest.attributes().keySet())) {
            return moduleRequest;
        }
        HashMap<TruffleString, TruffleString> supportedAttributes = new HashMap<TruffleString, TruffleString>();
        for (Map.Entry<TruffleString, TruffleString> attributes : moduleRequest.attributes().entrySet()) {
            TruffleString key = attributes.getKey();
            TruffleString value = attributes.getValue();
            if (!context.getSupportedImportAttributes().contains(key)) continue;
            supportedAttributes.put(key, value);
        }
        return moduleRequest.withAttributes(supportedAttributes);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSPromiseObject loadRequestedModules(JSRealm realm, CyclicModuleRecord moduleRecord, Object hostDefined) {
        PromiseCapabilityRecord pc = NewPromiseCapabilityNode.createDefault(realm);
        GraphLoadingState state = new GraphLoadingState(pc, hostDefined);
        try {
            this.innerModuleLoading(realm, state, moduleRecord, true);
        }
        catch (AbstractTruffleException e) {
            assert (false) : e;
            throw e;
        }
        return (JSPromiseObject)pc.getPromise();
    }

    private void innerModuleLoading(JSRealm realm, GraphLoadingState state, AbstractModuleRecord module, boolean recursiveLoad) {
        CyclicModuleRecord moduleRecord;
        assert (state.isLoading);
        if (recursiveLoad && module instanceof CyclicModuleRecord && (moduleRecord = (CyclicModuleRecord)module).getStatus() == CyclicModuleRecord.Status.New && !state.visited.contains(moduleRecord)) {
            state.visited.add(moduleRecord);
            int requestedModuleCount = moduleRecord.getRequestedModules().size();
            state.pendingModulesCount += requestedModuleCount;
            for (Module.ModuleRequest required : moduleRecord.getRequestedModules()) {
                AbstractModuleRecord resolved = moduleRecord.getLoadedModule(required);
                if (resolved != null) {
                    boolean innerRecursiveLoad = required.phase() != Module.ImportPhase.Source;
                    this.innerModuleLoading(realm, state, resolved, innerRecursiveLoad);
                } else {
                    this.hostLoadImportedModule(realm, moduleRecord, required, state.hostDefined, state);
                }
                if (state.isLoading) continue;
                return;
            }
        }
        assert (state.pendingModulesCount >= 1) : state.pendingModulesCount;
        if (--state.pendingModulesCount == 0) {
            state.isLoading = false;
            for (CyclicModuleRecord loaded : state.visited) {
                if (loaded.getStatus() != CyclicModuleRecord.Status.New) continue;
                loaded.setUnlinked();
            }
            JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, state.promiseCapability.getResolve(), (Object)Undefined.instance));
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void hostLoadImportedModule(JSRealm realm, ScriptOrModule referrer, Module.ModuleRequest moduleRequest, Object hostDefined, Object payload) {
        Completion moduleCompletion;
        try {
            AbstractModuleRecord module = GraalJSEvaluator.hostResolveImportedModule(realm, referrer, moduleRequest);
            moduleCompletion = Completion.forNormal(module);
        }
        catch (AbstractTruffleException e) {
            moduleCompletion = Completion.forThrow(GraalJSEvaluator.getErrorObject(e));
        }
        this.finishLoadingImportedModule(realm, referrer, moduleRequest, payload, moduleCompletion);
    }

    private void finishLoadingImportedModule(JSRealm realm, ScriptOrModule referrer, Module.ModuleRequest moduleRequest, Object payload, Completion moduleCompletion) {
        if (moduleCompletion.isNormal()) {
            AbstractModuleRecord existing;
            AbstractModuleRecord moduleResult = (AbstractModuleRecord)moduleCompletion.getValue();
            AbstractModuleRecord abstractModuleRecord = existing = referrer != null ? referrer.addLoadedModule(realm, moduleRequest, moduleResult) : realm.getModuleLoader().addLoadedModule(moduleRequest, moduleResult);
            if (existing != null) assert (existing == moduleResult);
        }
        if (payload instanceof GraphLoadingState) {
            GraphLoadingState state = (GraphLoadingState)payload;
            this.continueModuleLoading(realm, state, moduleRequest.phase(), moduleCompletion);
        } else {
            GraalJSEvaluator.continueDynamicImport(payload, moduleRequest.phase(), moduleCompletion);
        }
    }

    private void continueModuleLoading(JSRealm realm, GraphLoadingState state, Module.ImportPhase phase, Completion moduleCompletion) {
        if (!state.isLoading) {
            return;
        }
        if (moduleCompletion.isNormal()) {
            boolean recursiveLoad = phase != Module.ImportPhase.Source;
            this.innerModuleLoading(realm, state, (AbstractModuleRecord)moduleCompletion.getValue(), recursiveLoad);
        } else {
            state.isLoading = false;
            JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, state.promiseCapability.getReject(), moduleCompletion.getValue()));
        }
    }

    private static void continueDynamicImport(Object payload, Module.ImportPhase phase, Completion moduleCompletion) {
        ImportCallNode.ContinueDynamicImportPayload continuation = (ImportCallNode.ContinueDynamicImportPayload)payload;
        PromiseCapabilityRecord promiseCapability = continuation.promiseCapability();
        if (moduleCompletion.isAbrupt()) {
            JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), moduleCompletion.getValue()));
            return;
        }
        AbstractModuleRecord module = (AbstractModuleRecord)moduleCompletion.getValue();
        if (phase == Module.ImportPhase.Source) {
            try {
                Object moduleSource = module.getModuleSource();
                JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), moduleSource));
            }
            catch (AbstractTruffleException e) {
                JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), GraalJSEvaluator.getErrorObject(e)));
            }
            return;
        }
        JSFunction.call(JSArguments.create((Object)Undefined.instance, (Object)continuation.continueDynamicImportCallback(), continuation, module));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void moduleLinking(JSRealm realm, CyclicModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() != CyclicModuleRecord.Status.Linking && moduleRecord.getStatus() != CyclicModuleRecord.Status.Evaluating && moduleRecord.getStatus() != CyclicModuleRecord.Status.New) : moduleRecord.getStatus();
        ArrayDeque<CyclicModuleRecord> stack = new ArrayDeque<CyclicModuleRecord>(4);
        try {
            this.innerModuleLinking(realm, moduleRecord, stack, 0);
        }
        catch (AbstractTruffleException e) {
            GraalJSEvaluator.handleModuleLinkingError(moduleRecord, stack);
            throw e;
        }
        assert (moduleRecord.getStatus() == CyclicModuleRecord.Status.Linked || moduleRecord.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || moduleRecord.getStatus() == CyclicModuleRecord.Status.Evaluated);
        assert (stack.isEmpty());
    }

    private static void handleModuleLinkingError(CyclicModuleRecord moduleRecord, Deque<CyclicModuleRecord> stack) {
        for (CyclicModuleRecord m : stack) {
            assert (m.getStatus() == CyclicModuleRecord.Status.Linking);
            m.setUnlinked();
        }
        assert (moduleRecord.getStatus() == CyclicModuleRecord.Status.Unlinked);
    }

    private int innerModuleLinking(JSRealm realm, AbstractModuleRecord abstractModule, Deque<CyclicModuleRecord> stack, int index0) {
        int index;
        block9: {
            CyclicModuleRecord requiredModule;
            index = index0;
            if (!(abstractModule instanceof CyclicModuleRecord)) {
                abstractModule.link(realm);
                return index;
            }
            CyclicModuleRecord moduleRecord = (CyclicModuleRecord)abstractModule;
            if (moduleRecord.getStatus() == CyclicModuleRecord.Status.Linking || moduleRecord.getStatus() == CyclicModuleRecord.Status.Linked || moduleRecord.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || moduleRecord.getStatus() == CyclicModuleRecord.Status.Evaluated) {
                return index;
            }
            assert (moduleRecord.getStatus() == CyclicModuleRecord.Status.Unlinked) : moduleRecord.getStatus();
            moduleRecord.setStatus(CyclicModuleRecord.Status.Linking);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            ++index;
            stack.push(moduleRecord);
            for (Module.ModuleRequest required : moduleRecord.getRequestedModules()) {
                if (required.phase() == Module.ImportPhase.Source) continue;
                AbstractModuleRecord requiredAbstractModule = moduleRecord.getImportedModule(required);
                index = this.innerModuleLinking(realm, requiredAbstractModule, stack, index);
                if (!(requiredAbstractModule instanceof CyclicModuleRecord)) continue;
                CyclicModuleRecord requiredModule2 = (CyclicModuleRecord)requiredAbstractModule;
                assert (requiredModule2.getStatus() == CyclicModuleRecord.Status.Linking || requiredModule2.getStatus() == CyclicModuleRecord.Status.Linked || requiredModule2.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || requiredModule2.getStatus() == CyclicModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == CyclicModuleRecord.Status.Linking == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() != CyclicModuleRecord.Status.Linking) continue;
                moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
            }
            moduleRecord.initializeEnvironment(realm);
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block9;
            do {
                requiredModule = stack.pop();
                requiredModule.setStatus(CyclicModuleRecord.Status.Linked);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSPromiseObject moduleEvaluation(JSRealm realm, CyclicModuleRecord moduleRecord) {
        CyclicModuleRecord module = moduleRecord;
        assert (module.getStatus() == CyclicModuleRecord.Status.Linked || module.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || module.getStatus() == CyclicModuleRecord.Status.Evaluated) : module.getStatus();
        if (module.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || module.getStatus() == CyclicModuleRecord.Status.Evaluated) {
            module = module.getCycleRoot();
        }
        if (module.getTopLevelCapability() != null) {
            return (JSPromiseObject)module.getTopLevelCapability().getPromise();
        }
        ArrayDeque<CyclicModuleRecord> stack = new ArrayDeque<CyclicModuleRecord>(4);
        PromiseCapabilityRecord capability = NewPromiseCapabilityNode.createDefault(realm);
        module.setTopLevelCapability(capability);
        try {
            this.innerModuleEvaluation(realm, module, stack, 0);
            assert (module.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || module.getStatus() == CyclicModuleRecord.Status.Evaluated);
            assert (module.getEvaluationError() == null);
            if (!module.isAsyncEvaluation()) {
                assert (module.getStatus() == CyclicModuleRecord.Status.Evaluated);
                JSFunction.call(JSArguments.create((Object)Undefined.instance, capability.getResolve(), new Object[]{Undefined.instance}));
            }
            assert (stack.isEmpty());
        }
        catch (AbstractTruffleException e) {
            GraalJSEvaluator.handleModuleEvaluationError(module, stack, e);
        }
        return (JSPromiseObject)capability.getPromise();
    }

    private static void handleModuleEvaluationError(CyclicModuleRecord module, Deque<CyclicModuleRecord> stack, AbstractTruffleException e) {
        for (CyclicModuleRecord m : stack) {
            assert (m.getStatus() == CyclicModuleRecord.Status.Evaluating);
            m.setStatus(CyclicModuleRecord.Status.Evaluated);
            m.setEvaluationError(e);
        }
        assert (module.getStatus() == CyclicModuleRecord.Status.Evaluated && module.getEvaluationError() == e);
        PromiseCapabilityRecord capability = module.getTopLevelCapability();
        JSFunction.call(JSArguments.create((Object)Undefined.instance, capability.getReject(), GraalJSEvaluator.getErrorObject(e)));
    }

    private static Object getErrorObject(AbstractTruffleException e) {
        if (e instanceof GraalJSException) {
            GraalJSException jsex = (GraalJSException)e;
            return jsex.getErrorObject();
        }
        return e;
    }

    @CompilerDirectives.TruffleBoundary
    private int innerModuleEvaluation(JSRealm realm, AbstractModuleRecord abstractModule, Deque<CyclicModuleRecord> stack, int index0) {
        int index;
        block24: {
            CyclicModuleRecord requiredModule;
            index = index0;
            if (!(abstractModule instanceof CyclicModuleRecord)) {
                abstractModule.evaluateSync(realm);
                return index;
            }
            CyclicModuleRecord moduleRecord = (CyclicModuleRecord)abstractModule;
            if (moduleRecord.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || moduleRecord.getStatus() == CyclicModuleRecord.Status.Evaluated) {
                if (moduleRecord.getEvaluationError() == null) {
                    return index;
                }
                throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
            }
            if (moduleRecord.getStatus() == CyclicModuleRecord.Status.Evaluating) {
                return index;
            }
            assert (moduleRecord.getStatus() == CyclicModuleRecord.Status.Linked);
            moduleRecord.setStatus(CyclicModuleRecord.Status.Evaluating);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            moduleRecord.setPendingAsyncDependencies(0);
            moduleRecord.initAsyncParentModules();
            ++index;
            LinkedHashSet<AbstractModuleRecord> evaluationList = new LinkedHashSet<AbstractModuleRecord>();
            for (Module.ModuleRequest required : moduleRecord.getRequestedModules()) {
                if (required.phase() == Module.ImportPhase.Source) continue;
                AbstractModuleRecord requiredAbstractModule = moduleRecord.getImportedModule(required);
                if (required.phase() == Module.ImportPhase.Defer) {
                    List<AbstractModuleRecord> additionalModules = requiredAbstractModule.gatherAsynchronousTransitiveDependencies();
                    evaluationList.addAll(additionalModules);
                    continue;
                }
                assert (required.phase() == Module.ImportPhase.Evaluation);
                evaluationList.add(requiredAbstractModule);
            }
            stack.push(moduleRecord);
            for (AbstractModuleRecord requiredAbstractModule : evaluationList) {
                index = this.innerModuleEvaluation(realm, requiredAbstractModule, stack, index);
                if (!(requiredAbstractModule instanceof CyclicModuleRecord)) continue;
                CyclicModuleRecord requiredModule2 = (CyclicModuleRecord)requiredAbstractModule;
                assert (requiredModule2.getStatus() == CyclicModuleRecord.Status.Evaluating || requiredModule2.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || requiredModule2.getStatus() == CyclicModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == CyclicModuleRecord.Status.Evaluating == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() == CyclicModuleRecord.Status.Evaluating) {
                    moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
                } else {
                    requiredModule2 = requiredModule2.getCycleRoot();
                    assert (requiredModule2.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync || requiredModule2.getStatus() == CyclicModuleRecord.Status.Evaluated);
                    if (requiredModule2.getEvaluationError() != null) {
                        throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
                    }
                }
                if (!requiredModule2.isAsyncEvaluation()) continue;
                moduleRecord.incPendingAsyncDependencies();
                requiredModule2.appendAsyncParentModules(moduleRecord);
            }
            if (moduleRecord.getPendingAsyncDependencies() > 0 || moduleRecord.hasTLA()) {
                assert (!moduleRecord.isAsyncEvaluation());
                moduleRecord.setAsyncEvaluation(true);
                moduleRecord.setAsyncEvaluatingOrder(realm.nextAsyncEvaluationOrder());
                if (moduleRecord.getPendingAsyncDependencies() == 0) {
                    GraalJSEvaluator.moduleAsyncExecution(realm, moduleRecord);
                }
            } else {
                Object result = moduleRecord.executeModule(realm, null);
                moduleRecord.setExecutionResult(result);
            }
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block24;
            do {
                if (!(requiredModule = stack.pop()).isAsyncEvaluation()) {
                    requiredModule.setStatus(CyclicModuleRecord.Status.Evaluated);
                } else {
                    requiredModule.setStatus(CyclicModuleRecord.Status.EvaluatingAsync);
                }
                requiredModule.setCycleRoot(moduleRecord);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    private static void moduleAsyncExecution(JSRealm realm, CyclicModuleRecord module) {
        assert (module.getStatus() == CyclicModuleRecord.Status.Evaluating || module.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync);
        assert (module.hasTLA());
        PromiseCapabilityRecord capability = NewPromiseCapabilityNode.createDefault(realm);
        JSFunctionObject onFulfilled = GraalJSEvaluator.createCallAsyncModuleFulfilled(realm, module);
        JSFunctionObject onRejected = GraalJSEvaluator.createCallAsyncModuleRejected(realm, module);
        Object then = JSObject.get(capability.getPromise(), Strings.THEN);
        JSFunction.call(JSArguments.create((Object)capability.getPromise(), then, new Object[]{onFulfilled, onRejected}));
        module.executeModule(realm, capability);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSFunctionObject createCallAsyncModuleFulfilled(JSRealm realm, CyclicModuleRecord module) {
        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncModuleExecutionFulfilled, c -> GraalJSEvaluator.createAsyncModuleExecutionFulfilledImpl(c));
        JSFunctionObject function = JSFunction.create(realm, functionData);
        JSObjectUtil.putHiddenProperty(function, STORE_MODULE_KEY, module);
        return function;
    }

    private static JSFunctionData createAsyncModuleExecutionFulfilledImpl(JSContext context) {
        class AsyncModuleFulfilledRoot
        extends JavaScriptRootNode {
            @Node.Child
            private PropertyGetNode getModule;
            final /* synthetic */ JSContext val$context;

            AsyncModuleFulfilledRoot(JSContext jSContext) {
                this.val$context = jSContext;
                this.getModule = PropertyGetNode.createGetHidden(STORE_MODULE_KEY, this.val$context);
            }

            public Object execute(VirtualFrame frame) {
                Object module = this.getModule.getValue(JSArguments.getFunctionObject(frame.getArguments()));
                return GraalJSEvaluator.asyncModuleExecutionFulfilled(this.getRealm(), (JSModuleRecord)module);
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new AsyncModuleFulfilledRoot(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSFunctionObject createCallAsyncModuleRejected(JSRealm realm, CyclicModuleRecord module) {
        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncModuleExecutionRejected, c -> GraalJSEvaluator.createAsyncModuleExecutionRejectedImpl(c));
        JSFunctionObject function = JSFunction.create(realm, functionData);
        JSObjectUtil.putHiddenProperty(function, STORE_MODULE_KEY, module);
        return function;
    }

    private static JSFunctionData createAsyncModuleExecutionRejectedImpl(JSContext context) {
        class AsyncModuleExecutionRejectedRoot
        extends JavaScriptRootNode {
            @Node.Child
            private PropertyGetNode getModule;
            @Node.Child
            private JavaScriptNode errorArgument;
            final /* synthetic */ JSContext val$context;

            AsyncModuleExecutionRejectedRoot(JSContext jSContext) {
                this.val$context = jSContext;
                this.getModule = PropertyGetNode.createGetHidden(STORE_MODULE_KEY, this.val$context);
                this.errorArgument = AccessIndexedArgumentNode.create(0);
            }

            public Object execute(VirtualFrame frame) {
                JSModuleRecord module = (JSModuleRecord)this.getModule.getValue(JSArguments.getFunctionObject(frame.getArguments()));
                Object error = this.errorArgument.execute(frame);
                return GraalJSEvaluator.asyncModuleExecutionRejected(this.getRealm(), module, error);
            }
        }
        return JSFunctionData.createCallOnly(context, (CallTarget)new AsyncModuleExecutionRejectedRoot(context).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private static void gatherAvailableAncestors(CyclicModuleRecord module, Set<CyclicModuleRecord> execList) {
        for (CyclicModuleRecord m : module.getAsyncParentModules()) {
            if (execList.contains(m) || m.getCycleRoot().getEvaluationError() != null) continue;
            assert (m.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync);
            assert (m.getEvaluationError() == null);
            assert (m.isAsyncEvaluation());
            assert (m.getPendingAsyncDependencies() > 0);
            m.decPendingAsyncDependencies();
            if (m.getPendingAsyncDependencies() != 0) continue;
            execList.add(m);
            if (m.hasTLA()) continue;
            GraalJSEvaluator.gatherAvailableAncestors(m, execList);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asyncModuleExecutionFulfilled(JSRealm realm, JSModuleRecord module) {
        if (module.getStatus() == CyclicModuleRecord.Status.Evaluated) {
            assert (module.getEvaluationError() != null);
            return Undefined.instance;
        }
        assert (module.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync);
        assert (module.isAsyncEvaluation());
        assert (module.getEvaluationError() == null);
        module.setAsyncEvaluation(false);
        module.setStatus(CyclicModuleRecord.Status.Evaluated);
        if (module.getTopLevelCapability() != null) {
            assert (module.getCycleRoot() == module);
            JSFunction.call(JSArguments.create((Object)Undefined.instance, module.getTopLevelCapability().getResolve(), new Object[]{Undefined.instance}));
        }
        TreeSet<CyclicModuleRecord> execList = new TreeSet<CyclicModuleRecord>(new Comparator<CyclicModuleRecord>(){

            @Override
            public int compare(CyclicModuleRecord o1, CyclicModuleRecord o2) {
                return Long.compare(o1.getAsyncEvaluatingOrder(), o2.getAsyncEvaluatingOrder());
            }
        });
        GraalJSEvaluator.gatherAvailableAncestors(module, execList);
        for (CyclicModuleRecord m : execList) {
            if (m.getStatus() == CyclicModuleRecord.Status.Evaluated) {
                assert (m.getEvaluationError() != null);
                continue;
            }
            if (m.hasTLA()) {
                GraalJSEvaluator.moduleAsyncExecution(realm, m);
                continue;
            }
            try {
                Object result = m.executeModule(realm, null);
                m.setExecutionResult(result);
                m.setAsyncEvaluation(false);
                m.setStatus(CyclicModuleRecord.Status.Evaluated);
                if (m.getTopLevelCapability() == null) continue;
                assert (m.getCycleRoot() == m);
                JSFunction.call(JSArguments.create((Object)Undefined.instance, m.getTopLevelCapability().getResolve(), new Object[]{Undefined.instance}));
            }
            catch (AbstractTruffleException ex) {
                GraalJSEvaluator.asyncModuleExecutionRejected(realm, m, GraalJSEvaluator.getErrorObject(ex));
            }
        }
        return Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asyncModuleExecutionRejected(JSRealm realm, CyclicModuleRecord module, Object error) {
        assert (error != null) : "Cannot reject a module creation with null error";
        if (module.getStatus() == CyclicModuleRecord.Status.Evaluated) {
            assert (module.getEvaluationError() != null);
            return Undefined.instance;
        }
        assert (module.getStatus() == CyclicModuleRecord.Status.EvaluatingAsync);
        assert (module.isAsyncEvaluation());
        assert (module.getEvaluationError() == null);
        module.setEvaluationError(JSRuntime.getException(error));
        module.setStatus(CyclicModuleRecord.Status.Evaluated);
        module.setAsyncEvaluation(false);
        for (CyclicModuleRecord m : module.getAsyncParentModules()) {
            GraalJSEvaluator.asyncModuleExecutionRejected(realm, m, error);
        }
        if (module.getTopLevelCapability() != null) {
            assert (module.getCycleRoot() == module);
            JSFunction.call((JSFunctionObject)((Object)module.getTopLevelCapability().getReject()), (Object)Undefined.instance, new Object[]{error});
        }
        return Undefined.instance;
    }

    private static <S extends AbstractModuleRecord, T extends S> boolean occursExactlyOnce(T moduleRecord, Collection<S> stack) {
        return stack.stream().filter(moduleRecord::equals).count() == 1L;
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, ByteBuffer binary) {
        return ScriptNode.fromFunctionRoot((FunctionRootNode)new BinarySnapshotProvider(binary).apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, SnapshotProvider snapshotProvider) {
        return ScriptNode.fromFunctionRoot((FunctionRootNode)snapshotProvider.apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public JavaScriptNode parseInlineScript(JSContext context, Source source, MaterializedFrame lexicalContextFrame, boolean isStrict, Node locationNode) {
        DebugEnvironment env;
        try {
            Object scope = NodeLibrary.getUncached().getScope((Object)locationNode, (Frame)lexicalContextFrame, true);
            env = new DebugEnvironment(null, NodeFactory.getInstance(context), context, scope);
        }
        catch (UnsupportedMessageException e) {
            Object scope = null;
            env = null;
        }
        ScriptNode script = JavaScriptTranslator.translateInlineScript(NodeFactory.getInstance(context), context, env, source, isStrict, EvalNode.findActiveScriptOrModule(locationNode));
        return GraalJSEvaluator.createInlineScriptCallNode(context, script.getFunctionData(), script.getCallTarget(), locationNode);
    }

    private static JavaScriptNode createInlineScriptCallNode(final JSContext context, final JSFunctionData functionData, final RootCallTarget callTarget, final Node locationNode) {
        return new JavaScriptNode(){
            @Node.Child
            private DirectCallNode callNode;
            @Node.Child
            private PropertySetNode setScopeNode;
            @Node.Child
            private NodeLibrary nodeLibrary;
            {
                this.callNode = DirectCallNode.create((CallTarget)callTarget);
                this.setScopeNode = PropertySetNode.createSetHidden(JSFunction.DEBUG_SCOPE_ID, context);
                this.nodeLibrary = (NodeLibrary)NodeLibrary.getFactory().createDispatched(5);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSFunctionObject closure = JSFunction.create(this.getRealm(), functionData);
                try {
                    Object scope = this.nodeLibrary.getScope((Object)locationNode, (Frame)frame, true);
                    this.setScopeNode.setValue((Object)closure, scope);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
                return this.callNode.call(JSArguments.createZeroArg(JSFrameUtil.getThisObj((Frame)frame), (Object)closure));
            }
        };
    }

    @Override
    public Expression parseExpression(JSContext context, String sourceString) {
        return GraalJSParserHelper.parseExpression(context, Source.newBuilder((String)"js", (CharSequence)sourceString, (String)"<unknown>").build(), context.getParserOptions());
    }

    @Override
    public void checkFunctionSyntax(JSContext context, JSParserOptions parserOptions, String parameterList, String body, boolean generator, boolean async, String sourceName) {
        try {
            GraalJSParserHelper.checkFunctionSyntax(context, parserOptions, parameterList, body, generator, async, sourceName);
        }
        catch (ParserException ex) {
            this.parseFunction(context, parameterList, body, false, false, sourceName, null);
        }
    }

    private static final class ModuleScriptRoot
    extends JavaScriptRootNode {
        private final JSContext context;
        private final JSModuleData parsedModule;
        private final Source source;
        @Node.Child
        private PerformPromiseThenNode performPromiseThenNode;

        private ModuleScriptRoot(JSContext context, JSModuleData parsedModule, Source source) {
            super(context.getLanguage(), JSBuiltin.createSourceSection(), null);
            this.context = context;
            this.parsedModule = parsedModule;
            this.source = source;
            this.performPromiseThenNode = PerformPromiseThenNode.create(context);
        }

        public Object execute(VirtualFrame frame) {
            JSRealm realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject((Frame)frame));
            return this.evalModule(realm);
        }

        @CompilerDirectives.TruffleBoundary
        private Object evalModule(JSRealm realm) {
            JSModuleRecord moduleRecord = new JSModuleRecord(this.parsedModule, realm.getModuleLoader());
            Module.ModuleRequest moduleRequest = Module.ModuleRequest.create(Strings.fromJavaString(this.source.getName()));
            if (this.source.isCached()) {
                realm.getModuleLoader().addLoadedModule(moduleRequest, moduleRecord);
            }
            moduleRecord.loadRequestedModulesSync(realm, (Object)Undefined.instance);
            moduleRecord.link(realm);
            JSPromiseObject promise = moduleRecord.evaluate(realm);
            JSFunctionObject onRejected = GraalJSEvaluator.createTopLevelAwaitReject(this.context, realm);
            JSFunctionObject onAccepted = GraalJSEvaluator.createTopLevelAwaitResolve(this.context, realm);
            this.performPromiseThenNode.execute(promise, (Object)onAccepted, (Object)onRejected, null);
            if (this.context.getLanguageOptions().esmEvalReturnsExports()) {
                JSModuleNamespaceObject moduleNamespace = moduleRecord.getModuleNamespace(Module.ImportPhase.Evaluation);
                assert (moduleNamespace != null);
                return moduleNamespace;
            }
            if (this.context.isOptionTopLevelAwait() && moduleRecord.isAsyncEvaluation()) {
                return promise;
            }
            return moduleRecord.getExecutionResultOrThrow();
        }

        JSModuleData getModuleData() {
            return this.parsedModule;
        }
    }

    private static class GraphLoadingState {
        boolean isLoading = true;
        int pendingModulesCount = 1;
        PromiseCapabilityRecord promiseCapability;
        Object hostDefined;
        Set<CyclicModuleRecord> visited;

        GraphLoadingState(PromiseCapabilityRecord promiseCapability, Object hostDefined) {
            this.promiseCapability = promiseCapability;
            this.hostDefined = hostDefined;
            this.visited = new HashSet<CyclicModuleRecord>();
        }
    }
}

