/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.util.Comparator;

public class CharArrayComparators {
    public static final Comparator<char[]> CASE_INSENSITIVE_CHAR_ARRAY_COMPARATOR = (a1, a2) -> {
        int chr1;
        if (a1 == null) {
            return a2 == null ? 0 : 1;
        }
        if (a2 == null) {
            return -1;
        }
        int l1 = ((char[])a1).length;
        int l2 = ((char[])a2).length;
        int n = l1 < l2 ? l1 : l2;
        int max = n;
        for (int i = 0; i < max; i += Character.charCount(chr1)) {
            chr1 = Character.codePointAt(a1, i);
            int chr2 = Character.codePointAt(a2, i);
            int cp = Integer.compare(Character.toLowerCase(chr1), Character.toLowerCase(chr2));
            if (cp == 0) continue;
            return cp;
        }
        return l1 - l2;
    };
    public static final Comparator<char[]> FAST_CHAR_ARRAY_COMPARATOR = (a1, a2) -> {
        if (a1 == null) {
            return a2 == null ? 0 : 1;
        }
        if (a2 == null) {
            return -1;
        }
        int l1 = ((char[])a1).length;
        int l2 = ((char[])a2).length;
        int n = l1 < l2 ? l1 : l2;
        for (int i = 0; i < n; ++i) {
            char a1I = a1[i];
            char a2I = a2[i];
            if (a1I == a2I) continue;
            return a1I - a2I;
        }
        return l1 - l2;
    };
    public static final Comparator<char[]> NORMALIZING_CHAR_ARRAY_COMPARATOR = (a1, a2) -> {
        int i;
        int chr1;
        if (a1 == null) {
            return a2 == null ? 0 : 1;
        }
        if (a2 == null) {
            return -1;
        }
        int l1 = ((char[])a1).length;
        int l2 = ((char[])a2).length;
        if (l1 != l2) {
            return l1 - l2;
        }
        int max = l1;
        for (i = 0; i < max; i += Character.charCount(chr1)) {
            chr1 = Character.codePointAt(a1, i);
            int chr2 = Character.codePointAt(a2, i);
            int cp = Integer.compare(Character.toLowerCase(chr1), Character.toLowerCase(chr2));
            if (cp == 0) continue;
            return cp;
        }
        for (i = 0; i < l1; ++i) {
            char a1I = a1[i];
            char a2I = a2[i];
            if (a1I == a2I) continue;
            return a2I - a1I;
        }
        return 0;
    };

    private CharArrayComparators() {
    }
}

