/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.RejoinLeaderElectionPayload;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/node"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class RejoinLeaderElectionAPI {
    public static final String REJOIN_LEADER_ELECTION_CMD = "rejoin-leader-election";
    private final CoreAdminHandler coreAdminHandler;

    public RejoinLeaderElectionAPI(CoreAdminHandler coreAdminHandler) {
        this.coreAdminHandler = coreAdminHandler;
    }

    @Command(name="rejoin-leader-election")
    public void rejoinLeaderElection(PayloadObj<RejoinLeaderElectionPayload> payload) throws Exception {
        RejoinLeaderElectionPayload v2Body = payload.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION.name().toLowerCase(Locale.ROOT));
        if (v2Body.electionNode != null) {
            v1Params.remove("electionNode");
            v1Params.put("election_node", v2Body.electionNode);
        }
        if (v2Body.coreNodeName != null) {
            v1Params.remove("coreNodeName");
            v1Params.put("core_node_name", v2Body.coreNodeName);
        }
        this.coreAdminHandler.handleRequestBody(ClusterAPI.wrapParams(payload.getRequest(), v1Params), payload.getResponse());
    }
}

