/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationUtils;
import org.apache.solr.security.HttpServletAuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class SolrRequestAuthorizer
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Context
    private ResourceInfo resourceInfo;

    public SolrRequestAuthorizer() {
        log.info("Creating a new SolrRequestAuthorizer");
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        CoreContainer coreContainer = (CoreContainer)requestContext.getProperty(RequestContextKeys.CORE_CONTAINER);
        HttpServletRequest servletRequest = (HttpServletRequest)requestContext.getProperty(RequestContextKeys.HTTP_SERVLET_REQ);
        HttpServletResponse servletResponse = (HttpServletResponse)requestContext.getProperty(RequestContextKeys.HTTP_SERVLET_RSP);
        AuthorizationContext.RequestType requestType = (AuthorizationContext.RequestType)((Object)requestContext.getProperty(RequestContextKeys.REQUEST_TYPE));
        List collectionNames = (List)requestContext.getProperty("collection_name_list");
        SolrParams solrParams = (SolrParams)requestContext.getProperty(RequestContextKeys.SOLR_PARAMS);
        if (coreContainer.getAuthorizationPlugin() == null || this.isAlreadyAuthorizedByPKI(coreContainer, servletRequest)) {
            return;
        }
        AuthorizationContext authzContext = this.getAuthzContext(servletRequest, requestType, collectionNames, solrParams);
        log.debug("Attempting authz with context {}", (Object)authzContext);
        AuthorizationUtils.AuthorizationFailure authzFailure = AuthorizationUtils.authorize(servletRequest, servletResponse, coreContainer, authzContext);
        if (authzFailure != null) {
            Response failureResponse = Response.status((int)authzFailure.getStatusCode()).entity((Object)authzFailure.getMessage()).build();
            requestContext.abortWith(failureResponse);
        }
    }

    private boolean isAlreadyAuthorizedByPKI(CoreContainer coreContainer, HttpServletRequest req) {
        if (coreContainer.getPkiAuthenticationSecurityBuilder() != null && req.getUserPrincipal() != null) {
            boolean needsAuthz = coreContainer.getPkiAuthenticationSecurityBuilder().needsAuthorization(req);
            log.debug("PkiAuthenticationPlugin says authorization required : {} ", (Object)needsAuthz);
            return !needsAuthz;
        }
        return false;
    }

    private AuthorizationContext getAuthzContext(final HttpServletRequest servletRequest, final AuthorizationContext.RequestType reqType, final List<String> collectionNames, final SolrParams solrParams) {
        return new HttpServletAuthorizationContext(servletRequest){

            @Override
            public List<AuthorizationContext.CollectionRequest> getCollectionRequests() {
                return AuthorizationUtils.getCollectionRequests(ServletUtils.getPathAfterContext(servletRequest), collectionNames, solrParams);
            }

            @Override
            public Object getHandler() {
                return new PermissionNameProvider(){

                    @Override
                    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
                        return SolrRequestAuthorizer.this.resourceInfo.getResourceMethod().getAnnotation(PermissionName.class).value();
                    }
                };
            }

            @Override
            public SolrParams getParams() {
                return solrParams;
            }

            @Override
            public AuthorizationContext.RequestType getRequestType() {
                return reqType;
            }
        };
    }
}

