/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.DoubleToIntFunction;
import javax.measure.Unit;
import org.apache.sis.coverage.ConvertedCategory;
import org.apache.sis.coverage.ConvertedRange;
import org.apache.sis.coverage.IllegalSampleDimensionException;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Types;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class Category
implements Serializable {
    private static final long serialVersionUID = 2630516005075467646L;
    static final Comparator<Category> COMPARATOR = (category, category2) -> Category.compare(category.range.getMinDouble(true), category2.range.getMinDouble(true));
    final InternationalString name;
    final NumberRange<?> range;
    final MathTransform1D toConverse;
    final Category converse;

    static int compare(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            long l;
            long l2 = Double.doubleToRawLongBits(d);
            if (l2 < (l = Double.doubleToRawLongBits(d2))) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
        }
        return Double.compare(d, d2);
    }

    protected Category(Category category) {
        this.name = category.name;
        this.range = category.range;
        this.toConverse = category.toConverse;
        this.converse = category.converse == category ? this : new Category(category.converse, this);
    }

    Category(Category category, Category category2) {
        this.name = category.name;
        this.range = category.range;
        if (category2 != null) {
            this.toConverse = category.toConverse;
            this.converse = category2;
        } else {
            this.toConverse = Category.identity();
            this.converse = this;
        }
    }

    protected Category(CharSequence charSequence, NumberRange<?> numberRange, MathTransform1D mathTransform1D, Unit<?> unit, DoubleToIntFunction doubleToIntFunction) {
        ArgumentChecks.ensureNonEmpty("name", charSequence);
        ArgumentChecks.ensureNonNull("samples", numberRange);
        if (unit != null) {
            ArgumentChecks.ensureNonNull("toUnits", mathTransform1D);
        }
        this.name = Types.toInternationalString(charSequence);
        double d = numberRange.getMinDouble(true);
        double d2 = numberRange.getMaxDouble(true);
        boolean bl = Double.isNaN(d);
        if (!(d <= d2 || mathTransform1D == null && bl && Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(d2))) {
            throw new IllegalSampleDimensionException(Resources.format((short)24, charSequence, numberRange));
        }
        if (bl) {
            this.range = numberRange;
            this.converse = this;
            this.toConverse = Category.identity();
        } else {
            try {
                MathTransform1D mathTransform1D2;
                if (mathTransform1D != null) {
                    this.toConverse = mathTransform1D;
                    if (mathTransform1D.isIdentity()) {
                        this.converse = this;
                        if (!(numberRange instanceof MeasurementRange)) {
                            numberRange = new MeasurementRange(numberRange, unit);
                        }
                        this.range = numberRange;
                        return;
                    }
                    mathTransform1D2 = mathTransform1D.inverse();
                } else {
                    ArgumentChecks.ensureNonNull("toNaN", doubleToIntFunction);
                    double d3 = d > 0.0 ? d : (d2 <= 0.0 ? d2 : 0.0);
                    float f = MathFunctions.toNanFloat(doubleToIntFunction.applyAsInt(d3));
                    this.toConverse = (MathTransform1D)MathTransforms.linear((double)0.0, (double)f);
                    mathTransform1D2 = (MathTransform1D)MathTransforms.linear((double)0.0, (double)d3);
                }
                this.range = numberRange;
                this.converse = new ConvertedCategory(this, mathTransform1D2, mathTransform1D != null, unit);
            }
            catch (TransformException transformException) {
                throw new IllegalSampleDimensionException(Resources.format((short)31, charSequence), transformException);
            }
        }
    }

    Category(Category category, MathTransform1D mathTransform1D, boolean bl, Unit<?> unit) throws TransformException {
        this.converse = category;
        this.name = category.name;
        this.toConverse = Objects.requireNonNull(mathTransform1D);
        NumberRange<?> numberRange = category.range;
        boolean bl2 = numberRange.isMinIncluded();
        boolean bl3 = numberRange.isMaxIncluded();
        double[] dArray = new double[]{numberRange.getMinDouble(), numberRange.getMaxDouble(), numberRange.getMinDouble(!bl2), numberRange.getMaxDouble(!bl3)};
        category.toConverse.transform(dArray, 0, dArray, 0, dArray.length);
        double d = dArray[bl2 ? 2 : 0];
        int n = bl3 ? 3 : 1;
        if (d > dArray[n]) {
            ArraysExt.swap(dArray, 0, 1);
            ArraysExt.swap(dArray, 2, 3);
            boolean bl4 = bl2;
            bl2 = bl3;
            bl3 = bl4;
        }
        if (bl) {
            this.range = new ConvertedRange(dArray, bl2, bl3, unit);
        } else {
            double d2 = dArray[bl2 ? 0 : 2];
            float f = (float)d2;
            this.range = Double.doubleToRawLongBits(d2) == Double.doubleToRawLongBits(f) ? NumberRange.create(Float.class, Float.valueOf(f)) : NumberRange.create(Double.class, d2);
        }
    }

    public InternationalString getName() {
        return this.name;
    }

    Category converted() {
        return this.converse;
    }

    final boolean isConvertedQualitative() {
        return Double.isNaN(this.range.getMinDouble());
    }

    public boolean isQuantitative() {
        return !this.converted().isConvertedQualitative();
    }

    public NumberRange<?> getSampleRange() {
        return this.range;
    }

    public Optional<MeasurementRange<?>> getMeasurementRange() {
        NumberRange<?> numberRange = this.converted().range;
        if (Double.isNaN(numberRange.getMinDouble())) {
            return Optional.empty();
        }
        return Optional.of((MeasurementRange)numberRange);
    }

    final Object getRangeLabel() {
        Number number;
        if (this.range != null && (number = (Number)this.range.getMinValue()) != null && number.equals(this.range.getMaxValue())) {
            float f = number.floatValue();
            if (Float.isNaN(f)) {
                return "NaN #" + MathFunctions.toNanOrdinal(f);
            }
            return number;
        }
        return this.range;
    }

    public Optional<MathTransform1D> getTransferFunction() {
        if (this.converse.isConvertedQualitative()) {
            return Optional.empty();
        }
        return Optional.of(this.toConverse);
    }

    public Category forConvertedValues(boolean bl) {
        return bl ? this.converse : this;
    }

    static MathTransform1D identity() {
        return (MathTransform1D)MathTransforms.identity((int)1);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            NumberRange<?> numberRange;
            Category category = (Category)object;
            if (this.name.equals((Object)category.name) && (this.range == (numberRange = category.range) || this.range.equals(numberRange) && Double.doubleToRawLongBits(this.range.getMinDouble()) == Double.doubleToRawLongBits(numberRange.getMinDouble()) && Double.doubleToRawLongBits(this.range.getMaxDouble()) == Double.doubleToRawLongBits(numberRange.getMaxDouble()))) {
                return this.toConverse.equals((Object)category.toConverse);
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\u201c" + (CharSequence)this.name + "\u201d:\u00a0" + this.getRangeLabel() + ']';
    }
}

