/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.truffle;

import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourceHandleUtils;
import org.graalvm.visualvm.gotosource.SourcePathHandle;

final class TruffleSourceHandle
extends SourceHandle {
    private final String language;
    private final String className;
    private final String methodName;
    private final String methodSignature;
    private final int line;
    private String text;
    private int column;
    private int offset;
    private final SourcePathHandle pathHandle;

    TruffleSourceHandle(String language, String className, String methodName, String methodSignature, int line, SourcePathHandle pathHandle) {
        this.language = language;
        this.className = className;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.line = line;
        this.offset = -1;
        this.column = -1;
        this.pathHandle = pathHandle;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        if (this.column == -1) {
            this.column = 1;
        }
        return this.column;
    }

    @Override
    public int getOffset() {
        if (this.offset == -1) {
            this.offset = SourceHandleUtils.lineToOffset(this.getText(), this.getLine());
        }
        return this.offset;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.pathHandle.readText();
        }
        return this.text;
    }

    @Override
    public String getSourceUri() {
        return this.pathHandle.getPath().toUri().toString();
    }

    @Override
    public String getSourceFile() {
        return this.pathHandle.getRegularPath().toAbsolutePath().toString();
    }

    @Override
    protected void close() {
        this.pathHandle.close();
    }
}

