/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.util.Utils;

public class TileTypeChange
extends FreeColSpecObjectType {
    public static final String TAG = "tile-type-change";
    private TileType from;
    private TileType to;
    private AbstractGoods production;
    private static final String FROM_TAG = "from";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String PRODUCTION_TAG = "production";
    private static final String TO_TAG = "to";
    private static final String VALUE_TAG = "value";

    public TileTypeChange(Specification specification) {
        super(specification);
    }

    public TileTypeChange(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    public final TileType getFrom() {
        return this.from;
    }

    public final TileType getTo() {
        return this.to;
    }

    public final AbstractGoods getProduction() {
        return this.production;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        TileTypeChange o = this.copyInCast(other, TileTypeChange.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.from = o.getFrom();
        this.to = o.getTo();
        this.production = o.getProduction();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(FROM_TAG, this.from);
        xw.writeAttribute(TO_TAG, this.to);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.production != null) {
            xw.writeStartElement(PRODUCTION_TAG);
            xw.writeAttribute(GOODS_TYPE_TAG, this.production.getType());
            xw.writeAttribute(VALUE_TAG, this.production.getAmount());
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        this.from = xr.getType(spec, FROM_TAG, TileType.class, null);
        this.to = xr.getType(spec, TO_TAG, TileType.class, null);
    }

    @Override
    protected void clearContainers(FreeColXMLReader xr) throws XMLStreamException {
        super.clearContainers(xr);
        this.production = null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if (PRODUCTION_TAG.equals(tag)) {
                GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
                int amount = xr.getAttribute(VALUE_TAG, 0);
                this.production = new AbstractGoods(type, amount);
                xr.closeTag(PRODUCTION_TAG);
                continue;
            }
            throw new XMLStreamException("Bogus TileTypeChange tag: " + tag);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TileTypeChange) {
            return this.compareTo((TileTypeChange)other) == 0 && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.from);
        hash = 37 * hash + Utils.hashCode(this.to);
        return 37 * hash + Utils.hashCode(this.production);
    }
}

