/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class EvaluationDependencies
implements IExtension {
    private final WeakHashMap<MapModel, DependentNodeReferences> onMapDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, DependentNodeReferences> onNodeDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, DependentNodeReferences> onBranchDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, DependentNodeReferences> onCloneDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, Void> onAnyNodeDependencies = new WeakHashMap();
    private final WeakHashMap<NodeModel, Void> onGlobalNodeDependencies = new WeakHashMap();

    public static EvaluationDependencies of(MapModel map) {
        EvaluationDependencies dependencies = (EvaluationDependencies)map.getExtension(EvaluationDependencies.class);
        if (dependencies == null) {
            dependencies = new EvaluationDependencies();
            map.addExtension((IExtension)dependencies);
        }
        return dependencies;
    }

    public void collectChangedDependencies(Set<NodeModel> accessingNodes, NodeModel accessedNode) {
        Iterable onNode = this.onNodeDependencies.get(accessedNode);
        if (onNode != null) {
            this.collectAccessingNodesRecursively(accessingNodes, onNode);
        }
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : this.onBranchDependencies.entrySet()) {
            NodeModel branchNode = entry.getKey();
            if (!accessedNode.isDescendantOf(branchNode)) continue;
            this.collectAccessingNodesRecursively(accessingNodes, entry.getValue());
        }
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : this.onCloneDependencies.entrySet()) {
            NodeModel cloneNode = entry.getKey();
            if (!cloneNode.allClones().contains(accessedNode) && !cloneNode.subtreeClones().toCollection().stream().anyMatch(t -> t.isDescendantOf(accessedNode))) continue;
            this.collectAccessingNodesRecursively(accessingNodes, entry.getValue());
        }
        if (!this.onAnyNodeDependencies.isEmpty()) {
            ArrayList<NodeModel> onAnyNodeDependendingNodes = new ArrayList<NodeModel>(this.onAnyNodeDependencies.keySet());
            this.onAnyNodeDependencies.clear();
            this.collectAccessingNodesRecursively(accessingNodes, onAnyNodeDependendingNodes);
        }
    }

    public void collectGlobalNodeDependencies(Set<NodeModel> accessingNodes) {
        this.collectAccessingNodesRecursively(accessingNodes, this.onGlobalNodeDependencies.keySet());
    }

    public void removeAndReturnChangedDependencies(Set<NodeModel> accessingNodes, MapModel accessedMap) {
        Iterable onMap = this.onMapDependencies.remove(accessedMap);
        if (onMap != null) {
            this.collectAccessingNodesRecursively(accessingNodes, onMap);
        }
    }

    private void collectAccessingNodesRecursively(Set<NodeModel> accessingNodes, Iterable<NodeModel> changedAccessedNodes) {
        for (NodeModel node : changedAccessedNodes) {
            if (!accessingNodes.add(node)) continue;
            this.collectChangedDependencies(accessingNodes, node);
        }
    }

    public void accessNode(NodeModel accessingNode, NodeModel accessedNode) {
        this.onNodeDependencies.computeIfAbsent(accessedNode, x -> new DependentNodeReferences()).add(accessingNode);
        this.addAccessedMap(accessingNode, accessedNode);
    }

    public void accessBranch(NodeModel accessingNode, NodeModel accessedNode) {
        this.onBranchDependencies.computeIfAbsent(accessedNode, x -> new DependentNodeReferences()).add(accessingNode);
        this.addAccessedMap(accessingNode, accessedNode);
    }

    public void accessClones(NodeModel accessingNode, NodeModel accessedNode) {
        this.onCloneDependencies.computeIfAbsent(accessedNode, x -> new DependentNodeReferences()).add(accessingNode);
        this.addAccessedMap(accessingNode, accessedNode);
    }

    private void addAccessedMap(NodeModel accessingNode, NodeModel accessedNode) {
        MapModel accessedMap = accessedNode.getMap();
        if (accessedMap != accessingNode.getMap()) {
            this.onMapDependencies.computeIfAbsent(accessedMap, x -> new DependentNodeReferences()).add(accessingNode);
        }
    }

    public void accessAll(NodeModel accessingNode) {
        this.onAnyNodeDependencies.put(accessingNode, null);
    }

    public void accessGlobalNode(NodeModel accessingNode) {
        this.onGlobalNodeDependencies.put(accessingNode, null);
    }

    public Iterable<NodeModel> getPossibleDependencies(NodeModel node) {
        List<NodeModel> dependencies = (List<NodeModel>)((Object)this.onNodeDependencies.get(node));
        return dependencies != null ? dependencies : Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : this.onNodeDependencies.entrySet()) {
            builder.append("onNode (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        for (Map.Entry<NodeModel, DependentNodeReferences> entry : this.onBranchDependencies.entrySet()) {
            builder.append("onBranch (" + entry.getKey().getText() + "):\n");
            for (NodeModel nodeModel : entry.getValue()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        if (!this.onAnyNodeDependencies.isEmpty()) {
            builder.append("onAnyNode:\n");
            for (NodeModel nodeModel : this.onAnyNodeDependencies.keySet()) {
                builder.append("  " + nodeModel + "\n");
            }
        }
        return builder.toString();
    }

    static class DependentNodeReferences
    implements Iterable<NodeModel> {
        private final WeakHashMap<NodeModel, Void> references = new WeakHashMap();

        DependentNodeReferences() {
        }

        void add(NodeModel node) {
            this.references.put(node, null);
        }

        @Override
        public Iterator<NodeModel> iterator() {
            return this.references.keySet().iterator();
        }
    }

    static enum Access {
        NODE,
        BRANCH,
        ALL;

    }
}

