/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;

public final class Maven40ResolverUtil {
    public static void handleProjectBuildingException(List<ProjectBuildingResult> buildingResults, ProjectBuildingException e) {
        List results = e.getResults();
        if (results != null && !results.isEmpty()) {
            buildingResults.addAll(results);
        } else {
            Throwable cause = e.getCause();
            if (cause instanceof ModelBuildingException) {
                buildingResults.add(new MyProjectBuildingResult(null, e.getPomFile(), null, ((ModelBuildingException)cause).getProblems(), null));
            } else {
                buildingResults.add(new MyProjectBuildingResult(null, e.getPomFile(), null, Collections.singletonList(new DefaultModelProblem(cause.getMessage(), ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, "", 0, 0, null, (Exception)((Object)e))), null));
            }
        }
    }

    private static class MyProjectBuildingResult
    implements ProjectBuildingResult {
        private final String myProjectId;
        private final File myPomFile;
        private final MavenProject myMavenProject;
        private final List<ModelProblem> myProblems;
        private final DependencyResolutionResult myDependencyResolutionResult;

        MyProjectBuildingResult(String projectId, File pomFile, MavenProject mavenProject, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
            this.myProjectId = projectId;
            this.myPomFile = pomFile;
            this.myMavenProject = mavenProject;
            this.myProblems = problems;
            this.myDependencyResolutionResult = dependencyResolutionResult;
        }

        public String getProjectId() {
            return this.myProjectId;
        }

        public File getPomFile() {
            return this.myPomFile;
        }

        public MavenProject getProject() {
            return this.myMavenProject;
        }

        public List<ModelProblem> getProblems() {
            return this.myProblems;
        }

        public DependencyResolutionResult getDependencyResolutionResult() {
            return this.myDependencyResolutionResult;
        }
    }
}

