/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi.cheminfo;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.InchiStereoType;
import io.github.dan2097.jnarinchi.RinchiInputComponent;
import io.github.dan2097.jnarinchi.cheminfo.MoleculeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StereoUtils {
    public static int getNumberOfTetrahedralChiralityAtoms(InchiInput inchiInput) {
        int nTH = 0;
        for (int i = 0; i < inchiInput.getStereos().size(); ++i) {
            InchiStereo stereo = inchiInput.getStereos().get(i);
            if (stereo.getType() != InchiStereoType.Tetrahedral || stereo.getParity() != InchiStereoParity.ODD && stereo.getParity() != InchiStereoParity.EVEN) continue;
            ++nTH;
        }
        return nTH;
    }

    public static Map<InchiAtom, InchiStereoParity> getAtomParities(InchiInput inchiInput, boolean checkParityAccordingAtomNumbering) {
        HashMap<InchiAtom, InchiStereoParity> parities = new HashMap<InchiAtom, InchiStereoParity>();
        for (int i = 0; i < inchiInput.getStereos().size(); ++i) {
            InchiStereo stereo = inchiInput.getStereos().get(i);
            if (stereo.getType() != InchiStereoType.Tetrahedral || stereo.getParity() != InchiStereoParity.ODD && stereo.getParity() != InchiStereoParity.EVEN && stereo.getParity() != InchiStereoParity.UNKNOWN) continue;
            if (checkParityAccordingAtomNumbering) {
                stereo = StereoUtils.sortTetrahedralLigandsToBeWithIncreasingIndices(inchiInput, stereo);
            }
            if (stereo == null) continue;
            parities.put(stereo.getCentralAtom(), stereo.getParity());
        }
        return parities;
    }

    public static Map<InchiBond, InchiStereoParity> getDoubleBondParities(RinchiInputComponent ric) {
        HashMap<InchiBond, InchiStereoParity> boParities = new HashMap<InchiBond, InchiStereoParity>();
        for (int i = 0; i < ric.getStereos().size(); ++i) {
            InchiBond bo;
            InchiStereo stereo = ric.getStereos().get(i);
            if (stereo.getType() != InchiStereoType.DoubleBond || stereo.getParity() != InchiStereoParity.ODD && stereo.getParity() != InchiStereoParity.EVEN && stereo.getParity() != InchiStereoParity.UNKNOWN || (bo = ric.getBond(stereo.getAtoms()[1], stereo.getAtoms()[2])) == null) continue;
            boParities.put(bo, stereo.getParity());
        }
        return boParities;
    }

    public static InchiStereo createTetrahedralStereo(RinchiInputComponent ric, InchiAtom atom, InchiStereoParity parity) {
        List<InchiAtom> neighbAtoms = ric.getConnectedAtomList(atom);
        if (neighbAtoms.size() < 3 || neighbAtoms.size() > 4) {
            return null;
        }
        if (neighbAtoms.size() == 3) {
            if (atom.getImplicitHydrogen() == 1) {
                if (MoleculeUtils.containsHydrogen(neighbAtoms)) {
                    return null;
                }
                neighbAtoms.add(InchiStereo.STEREO_IMPLICIT_H);
            } else {
                return null;
            }
        }
        InchiAtom[] sortedAtoms = StereoUtils.sortAtomsToBeWithIncreasingIndices(ric, neighbAtoms);
        return InchiStereo.createTetrahedralStereo(atom, sortedAtoms[0], sortedAtoms[1], sortedAtoms[2], sortedAtoms[3], parity);
    }

    public static InchiAtom[] sortAtomsToBeWithIncreasingIndices(InchiInput inchiInput, List<InchiAtom> atoms) {
        if (atoms == null) {
            return null;
        }
        ArrayList<InchiAtom> sortedList = new ArrayList<InchiAtom>(atoms);
        sortedList.sort(Comparator.comparingInt(atom -> inchiInput.getAtoms().indexOf(atom)));
        return sortedList.toArray(new InchiAtom[sortedList.size()]);
    }

    public static InchiStereo sortTetrahedralLigandsToBeWithIncreasingIndices(InchiInput inchiInput, InchiStereo stereo) {
        Object[] ligands = stereo.getAtoms();
        int numOfSwaps = 0;
        int n = ligands.length;
        int numImplH = 0;
        if (ligands[n - 1] == InchiStereo.STEREO_IMPLICIT_H) {
            numImplH = 1;
        }
        for (int i = 0; i < n - 1; ++i) {
            if (ligands[i] != InchiStereo.STEREO_IMPLICIT_H) continue;
            if (numImplH > 0) {
                return null;
            }
            numImplH = 1;
            StereoUtils.swap(i, n - 1, ligands);
            ++numOfSwaps;
        }
        int k = n - numImplH;
        for (int i = k - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (inchiInput.getAtoms().indexOf(ligands[i]) <= inchiInput.getAtoms().indexOf(ligands[j])) continue;
                StereoUtils.swap(i, j, ligands);
                ++numOfSwaps;
            }
        }
        InchiStereoParity newParity = numOfSwaps % 2 == 0 ? stereo.getParity() : StereoUtils.invert(stereo.getParity());
        return InchiStereo.createTetrahedralStereo(stereo.getCentralAtom(), (InchiAtom)ligands[0], (InchiAtom)ligands[1], (InchiAtom)ligands[2], (InchiAtom)ligands[3], newParity);
    }

    public static void guessUndefinedTetrahedralStereosBasedOnBondInfo(RinchiInputComponent ric, Set<InchiAtom> knownCenters) {
        ArrayList<InchiAtom> newCenters = new ArrayList<InchiAtom>();
        for (int i = 0; i < ric.getBonds().size(); ++i) {
            InchiBond bo = ric.getBonds().get(i);
            if (bo.getType() != InchiBondType.SINGLE) continue;
            InchiStereo stereo = null;
            if (bo.getStereo() == InchiBondStereo.SINGLE_1DOWN || bo.getStereo() == InchiBondStereo.SINGLE_1UP || bo.getStereo() == InchiBondStereo.SINGLE_1EITHER) {
                stereo = StereoUtils.createTetrahedralStereo(ric, bo.getStart(), InchiStereoParity.UNDEFINED);
            }
            if (bo.getStereo() == InchiBondStereo.SINGLE_2DOWN || bo.getStereo() == InchiBondStereo.SINGLE_2UP || bo.getStereo() == InchiBondStereo.SINGLE_2EITHER) {
                stereo = StereoUtils.createTetrahedralStereo(ric, bo.getEnd(), InchiStereoParity.UNDEFINED);
            }
            if (stereo == null || newCenters.contains(stereo.getCentralAtom()) || knownCenters.contains(stereo.getCentralAtom())) continue;
            ric.addStereo(stereo);
            newCenters.add(stereo.getCentralAtom());
        }
    }

    public static void swap(int i, int j, Object[] objects) {
        Object obj = objects[i];
        objects[i] = objects[j];
        objects[j] = obj;
    }

    public static InchiStereoParity invert(InchiStereoParity parity) {
        switch (parity) {
            case ODD: {
                return InchiStereoParity.EVEN;
            }
            case EVEN: {
                return InchiStereoParity.ODD;
            }
        }
        return parity;
    }

    public static MolCoordinatesType getMolCoordinatesType(InchiInput inchiInput) {
        int[] stat = StereoUtils.coordinateStatistics(inchiInput);
        if (stat != null) {
            return StereoUtils.getMolCoordinatesType(stat[0], stat[1], stat[2]);
        }
        return null;
    }

    public static int[] coordinateStatistics(InchiInput inchiInput) {
        if (inchiInput == null) {
            return null;
        }
        int nX = 0;
        int nY = 0;
        int nZ = 0;
        for (int i = 0; i < inchiInput.getAtoms().size(); ++i) {
            InchiAtom at = inchiInput.getAtom(i);
            if (at.getX() != 0.0) {
                ++nX;
            }
            if (at.getY() != 0.0) {
                ++nY;
            }
            if (at.getZ() == 0.0) continue;
            ++nZ;
        }
        return new int[]{nX, nY, nZ};
    }

    public static MolCoordinatesType getMolCoordinatesType(int nX, int nY, int nZ) {
        if (nZ != 0) {
            return MolCoordinatesType._3D;
        }
        if (nY != 0) {
            return MolCoordinatesType._2D;
        }
        return MolCoordinatesType._0D;
    }

    public static enum MolCoordinatesType {
        _0D,
        _2D,
        _3D;

    }
}

