/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.processor.internals.SerdeGetter;

public abstract class WrappingNullableSerde<T, InnerK, InnerV>
implements Serde<T> {
    private final WrappingNullableSerializer<T, InnerK, InnerV> serializer;
    private final WrappingNullableDeserializer<T, InnerK, InnerV> deserializer;

    protected WrappingNullableSerde(WrappingNullableSerializer<T, InnerK, InnerV> serializer, WrappingNullableDeserializer<T, InnerK, InnerV> deserializer) {
        Objects.requireNonNull(serializer, "serializer can't be null");
        Objects.requireNonNull(deserializer, "deserializer can't be null");
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public Serializer<T> serializer() {
        return this.serializer;
    }

    public Deserializer<T> deserializer() {
        return this.deserializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.serializer.configure(configs, isKey);
        this.deserializer.configure(configs, isKey);
    }

    public void close() {
        this.serializer.close();
        this.deserializer.close();
    }

    public void setIfUnset(SerdeGetter getter) {
        this.serializer.setIfUnset(getter);
        this.deserializer.setIfUnset(getter);
    }
}

