/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.FileXmlSource;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.SerializationException;

public class CacheableFileXmlSource {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(CacheableFileXmlSource.class);

    public static Binding<? extends JaxbBindableMappingDescriptor> fromCacheableFile(File xmlFile, File serLocation, boolean strict, MappingBinder binder) {
        Origin origin = new Origin(SourceType.FILE, xmlFile.getAbsolutePath());
        return CacheableFileXmlSource.fromCacheableFile(xmlFile, serLocation, origin, strict, binder);
    }

    public static Binding<? extends JaxbBindableMappingDescriptor> fromCacheableFile(File xmlFile, File serLocation, Origin origin, boolean strict, MappingBinder binder) {
        File serFile;
        block8: {
            serFile = CacheableFileXmlSource.resolveSerFile(xmlFile, serLocation);
            if (strict) {
                try {
                    return new Binding(CacheableFileXmlSource.readSerFile(serFile), origin);
                }
                catch (SerializationException e) {
                    throw new MappingException(String.format("Unable to deserialize from cached file [%s]", origin.getName()), (Throwable)((Object)e), origin);
                }
                catch (FileNotFoundException e) {
                    throw new MappingException(String.format("Unable to locate cached file [%s]", origin.getName()), e, origin);
                }
            }
            if (!CacheableFileXmlSource.isSerfileObsolete(xmlFile, serFile)) {
                try {
                    return new Binding(CacheableFileXmlSource.readSerFile(serFile), origin);
                }
                catch (SerializationException e) {
                    log.unableToDeserializeCache(serFile.getName(), e);
                    break block8;
                }
                catch (FileNotFoundException e) {
                    log.cachedFileNotFound(serFile.getName(), e);
                    break block8;
                }
            }
            log.cachedFileObsolete(serFile);
        }
        log.readingMappingsFromFile(xmlFile.getPath());
        Binding<? extends JaxbBindableMappingDescriptor> binding = FileXmlSource.fromFile(xmlFile, binder);
        CacheableFileXmlSource.writeSerFile(binding.getRoot(), xmlFile, serFile);
        return binding;
    }

    public static File resolveSerFile(File xmlFile, File serLocation) {
        if (serLocation == null) {
            return CacheableFileXmlSource.determineCachedFile(xmlFile);
        }
        if (serLocation.isDirectory()) {
            return CacheableFileXmlSource.determineCachedFile(xmlFile, serLocation);
        }
        assert (serLocation.isFile());
        return serLocation;
    }

    public static File determineCachedFile(File xmlFile) {
        return new File(xmlFile.getAbsolutePath() + ".bin");
    }

    public static File determineCachedFile(File xmlFile, File serDirectory) {
        return new File(serDirectory, xmlFile.getName() + ".bin");
    }

    private static <T extends JaxbBindableMappingDescriptor> T readSerFile(File serFile) throws SerializationException, FileNotFoundException {
        log.readingCachedMappings(serFile);
        return (T)((JaxbBindableMappingDescriptor)SerializationHelper.deserialize(new FileInputStream(serFile)));
    }

    private static <T extends JaxbBindableMappingDescriptor> void writeSerFile(T jaxbModel, File xmlFile, File serFile) {
        try (FileOutputStream fos = new FileOutputStream(serFile);){
            if (log.isTraceEnabled()) {
                log.tracef("Writing cache file for: %s to: %s", xmlFile.getAbsolutePath(), serFile.getAbsolutePath());
            }
            SerializationHelper.serialize(jaxbModel, fos);
            boolean success = serFile.setLastModified(System.currentTimeMillis());
            if (!success) {
                log.warn("Could not update cacheable hbm.xml bin file timestamp");
            }
        }
        catch (Exception e) {
            log.unableToWriteCachedFile(serFile.getAbsolutePath(), e.getMessage());
        }
    }

    public static void createSerFile(File xmlFile, MappingBinder binder) {
        CacheableFileXmlSource.createSerFile(xmlFile, CacheableFileXmlSource.determineCachedFile(xmlFile), binder);
    }

    public static void createSerFile(File xmlFile, File outputFile, MappingBinder binder) {
        Binding<? extends JaxbBindableMappingDescriptor> binding = FileXmlSource.fromFile(xmlFile, binder);
        CacheableFileXmlSource.writeSerFile(binding.getRoot(), xmlFile, outputFile);
    }

    public static boolean isSerfileObsolete(File xmlFile, File serFile) {
        return xmlFile.exists() && serFile.exists() && xmlFile.lastModified() > serFile.lastModified();
    }
}

