/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TransportUsageStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TransportUsageStats> {
    @Nonnull
    private final Map<String, Long> rejectionCount;
    public static final JsonpDeserializer<TransportUsageStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransportUsageStats::setupTransportUsageStatsDeserializer);

    private TransportUsageStats(Builder builder) {
        this.rejectionCount = ApiTypeHelper.unmodifiable(builder.rejectionCount);
    }

    public static TransportUsageStats of(Function<Builder, ObjectBuilder<TransportUsageStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Long> rejectionCount() {
        return this.rejectionCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.rejectionCount)) {
            generator.writeKey("rejection_count");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.rejectionCount.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTransportUsageStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rejectionCount, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "rejection_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.rejectionCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportUsageStats other = (TransportUsageStats)o;
        return Objects.equals(this.rejectionCount, other.rejectionCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TransportUsageStats> {
        @Nullable
        private Map<String, Long> rejectionCount;

        public Builder() {
        }

        private Builder(TransportUsageStats o) {
            this.rejectionCount = Builder._mapCopy(o.rejectionCount);
        }

        private Builder(Builder o) {
            this.rejectionCount = Builder._mapCopy(o.rejectionCount);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder rejectionCount(Map<String, Long> map) {
            this.rejectionCount = Builder._mapPutAll(this.rejectionCount, map);
            return this;
        }

        @Nonnull
        public final Builder rejectionCount(String key, Long value) {
            this.rejectionCount = Builder._mapPut(this.rejectionCount, key, value);
            return this;
        }

        @Override
        @Nonnull
        public TransportUsageStats build() {
            this._checkSingleUse();
            return new TransportUsageStats(this);
        }
    }
}

