/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityCircleCross
extends Extremity {
    private final double px;
    private final double py;
    private final XPoint2D dest;
    private final double radius = 7.0;
    private final HColor backgroundColor;

    @Override
    public XPoint2D somePoint() {
        return this.dest;
    }

    public ExtremityCircleCross(XPoint2D p1, HColor backgroundColor) {
        this.px = p1.getX() - 7.0;
        this.py = p1.getY() - 7.0;
        this.dest = new XPoint2D(p1.getX(), p1.getY());
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(this.backgroundColor.bg());
        ug.apply(UStroke.withThickness(1.5)).apply(new UTranslate(this.dest.getX() - 7.0, this.dest.getY() - 7.0)).draw(UEllipse.build(14.0, 14.0));
        ExtremityCircleCross.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(0.7853981633974483), this.getPointOnCircle(3.9269908169872414));
        ExtremityCircleCross.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(-0.7853981633974483), this.getPointOnCircle(2.356194490192345));
    }

    private XPoint2D getPointOnCircle(double angle) {
        double x = this.px + 7.0 + 7.0 * Math.cos(angle);
        double y = this.py + 7.0 + 7.0 * Math.sin(angle);
        return new XPoint2D(x, y);
    }

    private static void drawLine(UGraphic ug, double x, double y, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

