/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.property;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.property.AbstractPropertyDomainFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public abstract class AbstractPropertyDomainFrameSection<P extends OWLProperty, A extends OWLPropertyDomainAxiom>
extends AbstractOWLFrameSection<P, A, OWLClassExpression> {
    public static final String LABEL = "Domains (intersection)";
    Set<OWLClassExpression> addedDomains = new HashSet<OWLClassExpression>();

    public AbstractPropertyDomainFrameSection(OWLEditorKit editorKit, OWLFrame<P> frame) {
        super(editorKit, LABEL, "Domain", frame);
    }

    @Override
    public OWLObjectEditor<OWLClassExpression> getObjectEditor() {
        AxiomType type = this.getRootObject() instanceof OWLObjectProperty ? AxiomType.OBJECT_PROPERTY_DOMAIN : AxiomType.DATA_PROPERTY_DOMAIN;
        return this.getOWLEditorKit().getWorkspace().getOWLComponentFactory().getOWLClassDescriptionEditor(null, type);
    }

    @Override
    public final boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) {
                OWLClassExpression desc = (OWLClassExpression)obj;
                Object ax = this.createAxiom(desc);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    protected abstract AbstractPropertyDomainFrameSectionRow<P, A> createFrameSectionRow(A var1, OWLOntology var2);

    protected abstract Set<A> getAxioms(OWLOntology var1);

    protected abstract NodeSet<OWLClass> getInferredDomains();

    @Override
    protected void clear() {
        this.addedDomains.clear();
    }

    @Override
    protected final void refill(OWLOntology ontology) {
        for (OWLPropertyDomainAxiom ax : this.getAxioms(ontology)) {
            this.addRow(this.createFrameSectionRow(ax, ontology));
            this.addedDomains.add(ax.getDomain());
        }
    }

    @Override
    protected void refillInferred() {
        for (Node domains : this.getInferredDomains()) {
            for (OWLClassExpression domain : domains) {
                if (this.addedDomains.contains(domain)) continue;
                this.addInferredRowIfNontrivial(this.createFrameSectionRow((OWLPropertyDomainAxiom)this.createAxiom(domain), null));
                this.addedDomains.add(domain);
            }
        }
    }

    @Override
    public Comparator<OWLFrameSectionRow<P, A, OWLClassExpression>> getRowComparator() {
        return null;
    }
}

