/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import java.awt.BorderLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionListener;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.IndividualsByInferredTypeHierarchyProvider;
import org.protege.editor.owl.ui.tree.CountingOWLObjectTreeCellRenderer;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.protege.editor.owl.ui.tree.OWLObjectTree;
import org.protege.editor.owl.ui.view.individual.AbstractOWLIndividualViewComponent;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLIndividualsByInferredTypeViewComponent
extends AbstractOWLIndividualViewComponent {
    private IndividualsByInferredTypeHierarchyProvider provider;
    private OWLObjectTree<OWLObject> tree;
    private TreeSelectionListener listener;
    private Set<EventType> updateEvents = new HashSet<EventType>();
    private OWLModelManagerListener managerListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (OWLIndividualsByInferredTypeViewComponent.this.updateEvents.contains((Object)event.getType())) {
                OWLIndividualsByInferredTypeViewComponent.this.provider.setReasoner(OWLIndividualsByInferredTypeViewComponent.this.getOWLModelManager().getReasoner());
            }
        }
    };

    private void transmitSelection() {
        OWLObject obj;
        if (this.isSynchronizing() && (obj = this.tree.getSelectedOWLObject()) instanceof OWLEntity) {
            this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)obj);
        }
    }

    @Override
    public void initialiseIndividualsView() throws Exception {
        this.setLayout(new BorderLayout());
        this.updateEvents.add(EventType.ONTOLOGY_CLASSIFIED);
        this.updateEvents.add(EventType.REASONER_CHANGED);
        this.getOWLModelManager().addListener(this.managerListener);
        this.provider = new IndividualsByInferredTypeHierarchyProvider(this.getOWLModelManager().getOWLOntologyManager());
        this.tree = new OWLModelManagerTree<OWLObject>(this.getOWLEditorKit(), this.provider);
        this.tree.setCellRenderer(new CountingOWLObjectTreeCellRenderer<OWLObject>(this.getOWLEditorKit(), this.tree));
        this.add(new JScrollPane(this.tree));
        this.provider.setReasoner(this.getOWLModelManager().getReasoner());
        this.listener = e -> this.transmitSelection();
        this.tree.addTreeSelectionListener(this.listener);
    }

    @Override
    public OWLNamedIndividual updateView(OWLNamedIndividual selelectedIndividual) {
        OWLObject selObj = this.tree.getSelectedOWLObject();
        if (selelectedIndividual != null && selObj != null && selelectedIndividual.equals((Object)selObj)) {
            return selelectedIndividual;
        }
        this.tree.setSelectedOWLObject((OWLObject)selelectedIndividual);
        return selelectedIndividual;
    }

    @Override
    public void disposeView() {
        this.tree.dispose();
        this.getOWLModelManager().removeListener(this.managerListener);
    }
}

