# ------------------------------------------------------------
# This file was generated using create_marin_data.py
#
# on    : Version 2022.3.1
# under : SymPy 1.10.1
# using : Python 3.8.10
# ------------------------------------------------------------

# generated data function for cubic Hecke algebra
def _read_irr(a, b, c, j):
    r"""
    Return precomputed representation matrices of Ivan Marin

    This code has been generated by ``create_marin_data.py`` (from
    the `database_cubic_hecke repository  <https://github.com/soehms/database_cubic_hecke>`__),
    please don't edit.

    INPUT:

    ``a, b, c, j`` -- values for the variables of the representation matrices

    OUTPUT:

    A triple ``dim_list, repr_list, repr_list_inv`` where each member
    is a list indexed by the number of the representation.

    ``dim_list`` is a list of integers representing the dimension of
    the corresponding representation
    ``repr_list`` is a triple of dictionaries each describing the
    representation matrix of the corresponding generator of the
    cubic Hecke algebra.
    ``repr_list_inv`` is a triple of dictionaries each describing the
    inverse of the correspondig matrix of ``repr_list``.

    EXAMPLES::

        >>> from database_cubic_hecke import _read_irr
        >>> dim_list, repr_list, repr_list_inv = _read_irr(3, 5, 7, 11)
        >>> dim_list
        [1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 6, 6, 6, 6, 6, 6, 8, 8, 8, 9, 9]
        >>> len(repr_list)
        24
        >>> g1, g2, g3 = repr_list[0]
        >>> list(g1.items())[0]
        ((0, 0), 3)
    """

    data = ([1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 6, 6, 6, 6, 6, 6, 8, 8, 8, 9,
        9], [[{(0, 0): a}, {(0, 0): a}, {(0, 0): a}], [{(0, 0): c},
        {(0, 0): c}, {(0, 0): c}], [{(0, 0): b}, {(0, 0): b}, {(0, 0):
        b}], [{(0, 0): b, (1, 0): b*c, (1, 1): c}, {(0, 0): c, (0, 1):
        -1, (1, 1): b}, {(0, 0): b, (1, 0): b*c, (1, 1): c}], [{(0,
        0): a, (1, 0): a*b, (1, 1): b}, {(0, 0): b, (0, 1): -1, (1,
        1): a}, {(0, 0): a, (1, 0): a*b, (1, 1): b}], [{(0, 0): a, (1,
        0): a*c, (1, 1): c}, {(0, 0): c, (0, 1): -1, (1, 1): a}, {(0,
        0): a, (1, 0): a*c, (1, 1): c}], [{(0, 0): c, (1, 0): a*c +
        b**2, (1, 1): b, (2, 0): b, (2, 1): 1, (2, 2): a}, {(0, 0): a,
        (0, 1): -1, (0, 2): b, (1, 1): b, (1, 2): -a*c - b**2, (2, 2):
        c}, {(0, 0): c, (1, 0): a*c + b**2, (1, 1): b, (2, 0): b, (2,
        1): 1, (2, 2): a}], [{(0, 0): a, (1, 1): b, (2, 0): b, (2, 2):
        b}, {(0, 0): b, (0, 1): a - b, (0, 2): -a, (1, 1): a, (1, 2):
        -a, (2, 2): b}, {(0, 0): b, (1, 1): b, (2, 0): -b, (2, 1):
        2*b, (2, 2): a}], [{(0, 0): c, (1, 1): a, (2, 0): a, (2, 2):
        a}, {(0, 0): a, (0, 1): -a + c, (0, 2): -c, (1, 1): c, (1, 2):
        -c, (2, 2): a}, {(0, 0): a, (1, 1): a, (2, 0): -a, (2, 1):
        2*a, (2, 2): c}], [{(0, 0): b, (1, 1): c, (2, 0): c, (2, 2):
        c}, {(0, 0): c, (0, 1): b - c, (0, 2): -b, (1, 1): b, (1, 2):
        -b, (2, 2): c}, {(0, 0): c, (1, 1): c, (2, 0): -c, (2, 1):
        2*c, (2, 2): b}], [{(0, 0): a, (1, 1): c, (2, 0): c, (2, 2):
        c}, {(0, 0): c, (0, 1): a - c, (0, 2): -a, (1, 1): a, (1, 2):
        -a, (2, 2): c}, {(0, 0): c, (1, 1): c, (2, 0): -c, (2, 1):
        2*c, (2, 2): a}], [{(0, 0): b, (1, 1): a, (2, 0): a, (2, 2):
        a}, {(0, 0): a, (0, 1): -a + b, (0, 2): -b, (1, 1): b, (1, 2):
        -b, (2, 2): a}, {(0, 0): a, (1, 1): a, (2, 0): -a, (2, 1):
        2*a, (2, 2): b}], [{(0, 0): c, (1, 1): b, (2, 0): b, (2, 2):
        b}, {(0, 0): b, (0, 1): -b + c, (0, 2): -c, (1, 1): c, (1, 2):
        -c, (2, 2): b}, {(0, 0): b, (1, 1): b, (2, 0): -b, (2, 1):
        2*b, (2, 2): c}], [{(0, 0): c, (1, 0): a**2 + b*c, (1, 1): a,
        (2, 0): a, (2, 1): 1, (2, 2): b, (3, 3): c, (4, 4): c, (5, 3):
        1, (5, 5): a}, {(0, 0): b, (0, 1): -1, (0, 2): a, (0, 3): -1,
        (0, 4): -a, (0, 5): c, (1, 1): a, (1, 2): -a**2 - b*c, (1, 5):
        -a*c, (2, 2): c, (3, 3): a, (3, 4): a**2 + b*c, (3, 5): -a*c,
        (4, 4): c, (5, 5): c}, {(0, 0): c, (1, 1): c, (2, 2): c, (3,
        0): a**2 + b*c, (3, 3): a, (4, 0): -a, (4, 3): -1, (4, 4): b,
        (5, 1): 1, (5, 5): a}], [{(0, 0): b, (1, 0): a*b + c**2, (1,
        1): c, (2, 0): c, (2, 1): 1, (2, 2): a, (3, 3): b, (4, 4): b,
        (5, 3): 1, (5, 5): c}, {(0, 0): a, (0, 1): -1, (0, 2): c, (0,
        3): -1, (0, 4): -c, (0, 5): b, (1, 1): c, (1, 2): -a*b - c**2,
        (1, 5): -b*c, (2, 2): b, (3, 3): c, (3, 4): a*b + c**2, (3,
        5): -b*c, (4, 4): b, (5, 5): b}, {(0, 0): b, (1, 1): b, (2,
        2): b, (3, 0): a*b + c**2, (3, 3): c, (4, 0): -c, (4, 3): -1,
        (4, 4): a, (5, 1): 1, (5, 5): c}], [{(0, 0): a, (1, 0): a*c +
        b**2, (1, 1): b, (2, 0): b, (2, 1): 1, (2, 2): c, (3, 3): a,
        (4, 4): a, (5, 3): 1, (5, 5): b}, {(0, 0): c, (0, 1): -1, (0,
        2): b, (0, 3): -1, (0, 4): -b, (0, 5): a, (1, 1): b, (1, 2):
        -a*c - b**2, (1, 5): -a*b, (2, 2): a, (3, 3): b, (3, 4): a*c +
        b**2, (3, 5): -a*b, (4, 4): a, (5, 5): a}, {(0, 0): a, (1, 1):
        a, (2, 2): a, (3, 0): a*c + b**2, (3, 3): b, (4, 0): -b, (4,
        3): -1, (4, 4): c, (5, 1): 1, (5, 5): b}], [{(0, 0): b, (1,
        0): a**2 + b*c, (1, 1): a, (2, 0): a, (2, 1): 1, (2, 2): c,
        (3, 3): b, (4, 4): b, (5, 3): 1, (5, 5): a}, {(0, 0): c, (0,
        1): -1, (0, 2): a, (0, 3): -1, (0, 4): -a, (0, 5): b, (1, 1):
        a, (1, 2): -a**2 - b*c, (1, 5): -a*b, (2, 2): b, (3, 3): a,
        (3, 4): a**2 + b*c, (3, 5): -a*b, (4, 4): b, (5, 5): b}, {(0,
        0): b, (1, 1): b, (2, 2): b, (3, 0): a**2 + b*c, (3, 3): a,
        (4, 0): -a, (4, 3): -1, (4, 4): c, (5, 1): 1, (5, 5): a}],
        [{(0, 0): c, (1, 0): a*c + b**2, (1, 1): b, (2, 0): b, (2, 1):
        1, (2, 2): a, (3, 3): c, (4, 4): c, (5, 3): 1, (5, 5): b},
        {(0, 0): a, (0, 1): -1, (0, 2): b, (0, 3): -1, (0, 4): -b, (0,
        5): c, (1, 1): b, (1, 2): -a*c - b**2, (1, 5): -b*c, (2, 2):
        c, (3, 3): b, (3, 4): a*c + b**2, (3, 5): -b*c, (4, 4): c, (5,
        5): c}, {(0, 0): c, (1, 1): c, (2, 2): c, (3, 0): a*c + b**2,
        (3, 3): b, (4, 0): -b, (4, 3): -1, (4, 4): a, (5, 1): 1, (5,
        5): b}], [{(0, 0): a, (1, 0): a*b + c**2, (1, 1): c, (2, 0):
        c, (2, 1): 1, (2, 2): b, (3, 3): a, (4, 4): a, (5, 3): 1, (5,
        5): c}, {(0, 0): b, (0, 1): -1, (0, 2): c, (0, 3): -1, (0, 4):
        -c, (0, 5): a, (1, 1): c, (1, 2): -a*b - c**2, (1, 5): -a*c,
        (2, 2): a, (3, 3): c, (3, 4): a*b + c**2, (3, 5): -a*c, (4,
        4): a, (5, 5): a}, {(0, 0): a, (1, 1): a, (2, 2): a, (3, 0):
        a*b + c**2, (3, 3): c, (4, 0): -c, (4, 3): -1, (4, 4): b, (5,
        1): 1, (5, 5): c}], [{(0, 0): b, (1, 0): 1, (1, 1): c, (2, 0):
        c, (2, 1): a*b + c**2, (2, 2): a, (3, 3): b, (4, 0): -1, (4,
        1): -c, (4, 3): b, (4, 4): a, (5, 5): c, (6, 3): b, (6, 5):
        -1, (6, 6): a, (7, 5): b - c, (7, 7): a}, {(0, 0): a, (0, 1):
        -a*b - c**2, (0, 2): c, (1, 1): c, (1, 2): -1, (2, 2): b, (3,
        1): -a, (3, 3): a, (3, 4): -a, (4, 4): b, (5, 2): -a, (5, 4):
        -a*c, (5, 5): a, (5, 6): a*c, (6, 2): -1, (6, 4): b - c, (6,
        6): c, (7, 2): -c, (7, 4): b*c - c**2, (7, 6): a*b + c**2, (7,
        7): a}, {(0, 0): a, (0, 3): b*c - c**2, (1, 1): a, (1, 3): c,
        (1, 5): -1, (2, 2): a, (2, 5): b - c, (2, 6): a*c + c**2, (2,
        7): -c, (3, 3): c, (4, 4): a, (4, 5): 1, (4, 6): -a, (5, 5):
        b, (6, 6): c, (6, 7): -1, (7, 7): b}], [{(0, 0): a, (1, 0): 1,
        (1, 1): b, (2, 0): b, (2, 1): a*c + b**2, (2, 2): c, (3, 3):
        a, (4, 0): -1, (4, 1): -b, (4, 3): a, (4, 4): c, (5, 5): b,
        (6, 3): a, (6, 5): -1, (6, 6): c, (7, 5): a - b, (7, 7): c},
        {(0, 0): c, (0, 1): -a*c - b**2, (0, 2): b, (1, 1): b, (1, 2):
        -1, (2, 2): a, (3, 1): -c, (3, 3): c, (3, 4): -c, (4, 4): a,
        (5, 2): -c, (5, 4): -b*c, (5, 5): c, (5, 6): b*c, (6, 2): -1,
        (6, 4): a - b, (6, 6): b, (7, 2): -b, (7, 4): a*b - b**2, (7,
        6): a*c + b**2, (7, 7): c}, {(0, 0): c, (0, 3): a*b - b**2,
        (1, 1): c, (1, 3): b, (1, 5): -1, (2, 2): c, (2, 5): a - b,
        (2, 6): b**2 + b*c, (2, 7): -b, (3, 3): b, (4, 4): c, (4, 5):
        1, (4, 6): -c, (5, 5): a, (6, 6): b, (6, 7): -1, (7, 7): a}],
        [{(0, 0): c, (1, 0): 1, (1, 1): a, (2, 0): a, (2, 1): a**2 +
        b*c, (2, 2): b, (3, 3): c, (4, 0): -1, (4, 1): -a, (4, 3): c,
        (4, 4): b, (5, 5): a, (6, 3): c, (6, 5): -1, (6, 6): b, (7,
        5): -a + c, (7, 7): b}, {(0, 0): b, (0, 1): -a**2 - b*c, (0,
        2): a, (1, 1): a, (1, 2): -1, (2, 2): c, (3, 1): -b, (3, 3):
        b, (3, 4): -b, (4, 4): c, (5, 2): -b, (5, 4): -a*b, (5, 5): b,
        (5, 6): a*b, (6, 2): -1, (6, 4): -a + c, (6, 6): a, (7, 2):
        -a, (7, 4): -a**2 + a*c, (7, 6): a**2 + b*c, (7, 7): b}, {(0,
        0): b, (0, 3): -a**2 + a*c, (1, 1): b, (1, 3): a, (1, 5): -1,
        (2, 2): b, (2, 5): -a + c, (2, 6): a**2 + a*b, (2, 7): -a, (3,
        3): a, (4, 4): b, (4, 5): 1, (4, 6): -b, (5, 5): c, (6, 6): a,
        (6, 7): -1, (7, 7): c}], [{(0, 0): c, (1, 0): a*c + b**2, (1,
        1): b, (1, 6): -b*c*j**2, (2, 0): b, (2, 1): 1, (2, 2): a, (2,
        6): c, (3, 3): a, (3, 6): -c, (3, 7): c*j, (3, 8): a + b*j**2,
        (4, 0): a*j**2 - b, (4, 4): b, (5, 0): a*j**2, (5, 4): b, (5,
        5): a, (6, 6): c, (7, 7): c, (8, 7): c*j**2, (8, 8): b}, {(0,
        0): a, (0, 1): -1, (0, 2): b, (0, 3): -b*j, (0, 8): b, (1, 1):
        b, (1, 2): -a*c - b**2, (1, 3): -a*c + b**2*j, (1, 8): -a*c -
        b**2, (2, 2): c, (3, 3): c, (4, 2): a, (4, 3): a, (4, 4): a,
        (4, 5): -a, (5, 2): b*j, (5, 5): b, (6, 3): a, (6, 6): a, (6,
        7): a, (6, 8): a, (7, 7): b, (7, 8): -b*j, (8, 8): c}, {(0,
        0): c, (1, 0): a*c + b**2, (1, 1): b, (1, 4): -b*c*j**2, (2,
        2): b, (2, 5): -c*j**2, (3, 2): a + b*j**2, (3, 3): a, (3, 4):
        -c, (3, 5): -c*j, (4, 4): c, (5, 5): c, (6, 0): a*j**2 - b,
        (6, 6): b, (7, 0): -a*j**2, (7, 6): -b, (7, 7): a, (8, 0): b,
        (8, 1): 1, (8, 4): c, (8, 8): a}], [{(0, 0): c, (1, 0): a*c +
        b**2, (1, 1): b, (1, 6): -b*c*j, (2, 0): b, (2, 1): 1, (2, 2):
        a, (2, 6): c, (3, 3): a, (3, 6): -c, (3, 7): c*j**2, (3, 8): a
        + b*j, (4, 0): a*j - b, (4, 4): b, (5, 0): a*j, (5, 4): b, (5,
        5): a, (6, 6): c, (7, 7): c, (8, 7): c*j, (8, 8): b}, {(0, 0):
        a, (0, 1): -1, (0, 2): b, (0, 3): -b*j**2, (0, 8): b, (1, 1):
        b, (1, 2): -a*c - b**2, (1, 3): -a*c + b**2*j**2, (1, 8): -a*c
        - b**2, (2, 2): c, (3, 3): c, (4, 2): a, (4, 3): a, (4, 4): a,
        (4, 5): -a, (5, 2): b*j**2, (5, 5): b, (6, 3): a, (6, 6): a,
        (6, 7): a, (6, 8): a, (7, 7): b, (7, 8): -b*j**2, (8, 8): c},
        {(0, 0): c, (1, 0): a*c + b**2, (1, 1): b, (1, 4): -b*c*j, (2,
        2): b, (2, 5): -c*j, (3, 2): a + b*j, (3, 3): a, (3, 4): -c,
        (3, 5): -c*j**2, (4, 4): c, (5, 5): c, (6, 0): a*j - b, (6,
        6): b, (7, 0): -a*j, (7, 6): -b, (7, 7): a, (8, 0): b, (8, 1):
        1, (8, 4): c, (8, 8): a}]], [[{(0, 0): 1/a}, {(0, 0): 1/a},
        {(0, 0): 1/a}], [{(0, 0): 1/c}, {(0, 0): 1/c}, {(0, 0): 1/c}],
        [{(0, 0): 1/b}, {(0, 0): 1/b}, {(0, 0): 1/b}], [{(0, 0): 1/b,
        (1, 0): -1, (1, 1): 1/c}, {(0, 0): 1/c, (0, 1): 1/(b*c), (1,
        1): 1/b}, {(0, 0): 1/b, (1, 0): -1, (1, 1): 1/c}], [{(0, 0):
        1/a, (1, 0): -1, (1, 1): 1/b}, {(0, 0): 1/b, (0, 1): 1/(a*b),
        (1, 1): 1/a}, {(0, 0): 1/a, (1, 0): -1, (1, 1): 1/b}], [{(0,
        0): 1/a, (1, 0): -1, (1, 1): 1/c}, {(0, 0): 1/c, (0, 1):
        1/(a*c), (1, 1): 1/a}, {(0, 0): 1/a, (1, 0): -1, (1, 1):
        1/c}], [{(0, 0): 1/c, (1, 0): -a/b - b/c, (1, 1): 1/b, (2, 0):
        1/b, (2, 1): -1/(a*b), (2, 2): 1/a}, {(0, 0): 1/a, (0, 1):
        1/(a*b), (0, 2): 1/b, (1, 1): 1/b, (1, 2): a/b + b/c, (2, 2):
        1/c}, {(0, 0): 1/c, (1, 0): -a/b - b/c, (1, 1): 1/b, (2, 0):
        1/b, (2, 1): -1/(a*b), (2, 2): 1/a}], [{(0, 0): 1/a, (1, 1):
        1/b, (2, 0): -1/a, (2, 2): 1/b}, {(0, 0): 1/b, (0, 1): -(a -
        b)/(a*b), (0, 2): 1/b, (1, 1): 1/a, (1, 2): 1/b, (2, 2): 1/b},
        {(0, 0): 1/b, (1, 1): 1/b, (2, 0): 1/a, (2, 1): -2/a, (2, 2):
        1/a}], [{(0, 0): 1/c, (1, 1): 1/a, (2, 0): -1/c, (2, 2): 1/a},
        {(0, 0): 1/a, (0, 1): -(-a + c)/(a*c), (0, 2): 1/a, (1, 1):
        1/c, (1, 2): 1/a, (2, 2): 1/a}, {(0, 0): 1/a, (1, 1): 1/a, (2,
        0): 1/c, (2, 1): -2/c, (2, 2): 1/c}], [{(0, 0): 1/b, (1, 1):
        1/c, (2, 0): -1/b, (2, 2): 1/c}, {(0, 0): 1/c, (0, 1): -(b -
        c)/(b*c), (0, 2): 1/c, (1, 1): 1/b, (1, 2): 1/c, (2, 2): 1/c},
        {(0, 0): 1/c, (1, 1): 1/c, (2, 0): 1/b, (2, 1): -2/b, (2, 2):
        1/b}], [{(0, 0): 1/a, (1, 1): 1/c, (2, 0): -1/a, (2, 2): 1/c},
        {(0, 0): 1/c, (0, 1): -(a - c)/(a*c), (0, 2): 1/c, (1, 1):
        1/a, (1, 2): 1/c, (2, 2): 1/c}, {(0, 0): 1/c, (1, 1): 1/c, (2,
        0): 1/a, (2, 1): -2/a, (2, 2): 1/a}], [{(0, 0): 1/b, (1, 1):
        1/a, (2, 0): -1/b, (2, 2): 1/a}, {(0, 0): 1/a, (0, 1): -(-a +
        b)/(a*b), (0, 2): 1/a, (1, 1): 1/b, (1, 2): 1/a, (2, 2): 1/a},
        {(0, 0): 1/a, (1, 1): 1/a, (2, 0): 1/b, (2, 1): -2/b, (2, 2):
        1/b}], [{(0, 0): 1/c, (1, 1): 1/b, (2, 0): -1/c, (2, 2): 1/b},
        {(0, 0): 1/b, (0, 1): -(-b + c)/(b*c), (0, 2): 1/b, (1, 1):
        1/c, (1, 2): 1/b, (2, 2): 1/b}, {(0, 0): 1/b, (1, 1): 1/b, (2,
        0): 1/c, (2, 1): -2/c, (2, 2): 1/c}], [{(0, 0): 1/c, (1, 0):
        -a/c - b/a, (1, 1): 1/a, (2, 0): 1/a, (2, 1): -1/(a*b), (2,
        2): 1/b, (3, 3): 1/c, (4, 4): 1/c, (5, 3): -1/(a*c), (5, 5):
        1/a}, {(0, 0): 1/b, (0, 1): 1/(a*b), (0, 2): 1/a, (0, 3):
        1/(a*b), (0, 4): -1/a, (0, 5): 1/b, (1, 1): 1/a, (1, 2): a/c +
        b/a, (1, 5): 1, (2, 2): 1/c, (3, 3): 1/a, (3, 4): -a/c - b/a,
        (3, 5): 1, (4, 4): 1/c, (5, 5): 1/c}, {(0, 0): 1/c, (1, 1):
        1/c, (2, 2): 1/c, (3, 0): -a/c - b/a, (3, 3): 1/a, (4, 0):
        -1/a, (4, 3): 1/(a*b), (4, 4): 1/b, (5, 1): -1/(a*c), (5, 5):
        1/a}], [{(0, 0): 1/b, (1, 0): -a/c - c/b, (1, 1): 1/c, (2, 0):
        1/c, (2, 1): -1/(a*c), (2, 2): 1/a, (3, 3): 1/b, (4, 4): 1/b,
        (5, 3): -1/(b*c), (5, 5): 1/c}, {(0, 0): 1/a, (0, 1): 1/(a*c),
        (0, 2): 1/c, (0, 3): 1/(a*c), (0, 4): -1/c, (0, 5): 1/a, (1,
        1): 1/c, (1, 2): a/c + c/b, (1, 5): 1, (2, 2): 1/b, (3, 3):
        1/c, (3, 4): -a/c - c/b, (3, 5): 1, (4, 4): 1/b, (5, 5): 1/b},
        {(0, 0): 1/b, (1, 1): 1/b, (2, 2): 1/b, (3, 0): -a/c - c/b,
        (3, 3): 1/c, (4, 0): -1/c, (4, 3): 1/(a*c), (4, 4): 1/a, (5,
        1): -1/(b*c), (5, 5): 1/c}], [{(0, 0): 1/a, (1, 0): -c/b -
        b/a, (1, 1): 1/b, (2, 0): 1/b, (2, 1): -1/(b*c), (2, 2): 1/c,
        (3, 3): 1/a, (4, 4): 1/a, (5, 3): -1/(a*b), (5, 5): 1/b}, {(0,
        0): 1/c, (0, 1): 1/(b*c), (0, 2): 1/b, (0, 3): 1/(b*c), (0,
        4): -1/b, (0, 5): 1/c, (1, 1): 1/b, (1, 2): c/b + b/a, (1, 5):
        1, (2, 2): 1/a, (3, 3): 1/b, (3, 4): -c/b - b/a, (3, 5): 1,
        (4, 4): 1/a, (5, 5): 1/a}, {(0, 0): 1/a, (1, 1): 1/a, (2, 2):
        1/a, (3, 0): -c/b - b/a, (3, 3): 1/b, (4, 0): -1/b, (4, 3):
        1/(b*c), (4, 4): 1/c, (5, 1): -1/(a*b), (5, 5): 1/b}], [{(0,
        0): 1/b, (1, 0): -a/b - c/a, (1, 1): 1/a, (2, 0): 1/a, (2, 1):
        -1/(a*c), (2, 2): 1/c, (3, 3): 1/b, (4, 4): 1/b, (5, 3):
        -1/(a*b), (5, 5): 1/a}, {(0, 0): 1/c, (0, 1): 1/(a*c), (0, 2):
        1/a, (0, 3): 1/(a*c), (0, 4): -1/a, (0, 5): 1/c, (1, 1): 1/a,
        (1, 2): a/b + c/a, (1, 5): 1, (2, 2): 1/b, (3, 3): 1/a, (3,
        4): -a/b - c/a, (3, 5): 1, (4, 4): 1/b, (5, 5): 1/b}, {(0, 0):
        1/b, (1, 1): 1/b, (2, 2): 1/b, (3, 0): -a/b - c/a, (3, 3):
        1/a, (4, 0): -1/a, (4, 3): 1/(a*c), (4, 4): 1/c, (5, 1):
        -1/(a*b), (5, 5): 1/a}], [{(0, 0): 1/c, (1, 0): -a/b - b/c,
        (1, 1): 1/b, (2, 0): 1/b, (2, 1): -1/(a*b), (2, 2): 1/a, (3,
        3): 1/c, (4, 4): 1/c, (5, 3): -1/(b*c), (5, 5): 1/b}, {(0, 0):
        1/a, (0, 1): 1/(a*b), (0, 2): 1/b, (0, 3): 1/(a*b), (0, 4):
        -1/b, (0, 5): 1/a, (1, 1): 1/b, (1, 2): a/b + b/c, (1, 5): 1,
        (2, 2): 1/c, (3, 3): 1/b, (3, 4): -a/b - b/c, (3, 5): 1, (4,
        4): 1/c, (5, 5): 1/c}, {(0, 0): 1/c, (1, 1): 1/c, (2, 2): 1/c,
        (3, 0): -a/b - b/c, (3, 3): 1/b, (4, 0): -1/b, (4, 3):
        1/(a*b), (4, 4): 1/a, (5, 1): -1/(b*c), (5, 5): 1/b}], [{(0,
        0): 1/a, (1, 0): -b/c - c/a, (1, 1): 1/c, (2, 0): 1/c, (2, 1):
        -1/(b*c), (2, 2): 1/b, (3, 3): 1/a, (4, 4): 1/a, (5, 3):
        -1/(a*c), (5, 5): 1/c}, {(0, 0): 1/b, (0, 1): 1/(b*c), (0, 2):
        1/c, (0, 3): 1/(b*c), (0, 4): -1/c, (0, 5): 1/b, (1, 1): 1/c,
        (1, 2): b/c + c/a, (1, 5): 1, (2, 2): 1/a, (3, 3): 1/c, (3,
        4): -b/c - c/a, (3, 5): 1, (4, 4): 1/a, (5, 5): 1/a}, {(0, 0):
        1/a, (1, 1): 1/a, (2, 2): 1/a, (3, 0): -b/c - c/a, (3, 3):
        1/c, (4, 0): -1/c, (4, 3): 1/(b*c), (4, 4): 1/b, (5, 1):
        -1/(a*c), (5, 5): 1/c}], [{(0, 0): 1/b, (1, 0): -1/(b*c), (1,
        1): 1/c, (2, 0): 1/c, (2, 1): -b/c - c/a, (2, 2): 1/a, (3, 3):
        1/b, (4, 1): 1/a, (4, 3): -1/a, (4, 4): 1/a, (5, 5): 1/c, (6,
        3): -1/a, (6, 5): 1/(a*c), (6, 6): 1/a, (7, 5): -(b -
        c)/(a*c), (7, 7): 1/a}, {(0, 0): 1/a, (0, 1): b/c + c/a, (0,
        2): 1/c, (1, 1): 1/c, (1, 2): 1/(b*c), (2, 2): 1/b, (3, 1):
        1/c, (3, 3): 1/a, (3, 4): 1/b, (3, 2): 1/(b*c), (4, 4): 1/b,
        (5, 4): 1, (5, 5): 1/a, (5, 6): -1, (6, 2): 1/(b*c), (6, 4):
        -(b - c)/(b*c), (6, 6): 1/c, (7, 2): -1/c, (7, 4): -(-b +
        c)/c, (7, 6): -b/c - c/a, (7, 7): 1/a}, {(0, 0): 1/a, (0, 3):
        -(b - c)/a, (1, 1): 1/a, (1, 3): -1/a, (1, 5): 1/(a*b), (2,
        2): 1/a, (2, 5): -(b - c)/(a*b), (2, 6): -(a + c)/a, (2, 7):
        -1/b, (3, 3): 1/c, (4, 4): 1/a, (4, 5): -1/(a*b), (4, 6): 1/c,
        (4, 7): 1/(b*c), (5, 5): 1/b, (6, 6): 1/c, (6, 7): 1/(b*c),
        (7, 7): 1/b}], [{(0, 0): 1/a, (1, 0): -1/(a*b), (1, 1): 1/b,
        (2, 0): 1/b, (2, 1): -a/b - b/c, (2, 2): 1/c, (3, 3): 1/a, (4,
        1): 1/c, (4, 3): -1/c, (4, 4): 1/c, (5, 5): 1/b, (6, 3): -1/c,
        (6, 5): 1/(b*c), (6, 6): 1/c, (7, 5): -(a - b)/(b*c), (7, 7):
        1/c}, {(0, 0): 1/c, (0, 1): a/b + b/c, (0, 2): 1/b, (1, 1):
        1/b, (1, 2): 1/(a*b), (2, 2): 1/a, (3, 1): 1/b, (3, 3): 1/c,
        (3, 4): 1/a, (3, 2): 1/(a*b), (4, 4): 1/a, (5, 4): 1, (5, 5):
        1/c, (5, 6): -1, (6, 2): 1/(a*b), (6, 4): -(a - b)/(a*b), (6,
        6): 1/b, (7, 2): -1/b, (7, 4): -(-a + b)/b, (7, 6): -a/b -
        b/c, (7, 7): 1/c}, {(0, 0): 1/c, (0, 3): -(a - b)/c, (1, 1):
        1/c, (1, 3): -1/c, (1, 5): 1/(a*c), (2, 2): 1/c, (2, 5): -(a -
        b)/(a*c), (2, 6): -(b + c)/c, (2, 7): -1/a, (3, 3): 1/b, (4,
        4): 1/c, (4, 5): -1/(a*c), (4, 6): 1/b, (4, 7): 1/(a*b), (5,
        5): 1/a, (6, 6): 1/b, (6, 7): 1/(a*b), (7, 7): 1/a}], [{(0,
        0): 1/c, (1, 0): -1/(a*c), (1, 1): 1/a, (2, 0): 1/a, (2, 1):
        -a/b - c/a, (2, 2): 1/b, (3, 3): 1/c, (4, 1): 1/b, (4, 3):
        -1/b, (4, 4): 1/b, (5, 5): 1/a, (6, 3): -1/b, (6, 5): 1/(a*b),
        (6, 6): 1/b, (7, 5): -(-a + c)/(a*b), (7, 7): 1/b}, {(0, 0):
        1/b, (0, 1): a/b + c/a, (0, 2): 1/a, (1, 1): 1/a, (1, 2):
        1/(a*c), (2, 2): 1/c, (3, 1): 1/a, (3, 3): 1/b, (3, 4): 1/c,
        (3, 2): 1/(a*c), (4, 4): 1/c, (5, 4): 1, (5, 5): 1/b, (5, 6):
        -1, (6, 2): 1/(a*c), (6, 4): -(-a + c)/(a*c), (6, 6): 1/a, (7,
        2): -1/a, (7, 4): -(a - c)/a, (7, 6): -a/b - c/a, (7, 7):
        1/b}, {(0, 0): 1/b, (0, 3): -(-a + c)/b, (1, 1): 1/b, (1, 3):
        -1/b, (1, 5): 1/(b*c), (2, 2): 1/b, (2, 5): -(-a + c)/(b*c),
        (2, 6): -(a + b)/b, (2, 7): -1/c, (3, 3): 1/a, (4, 4): 1/b,
        (4, 5): -1/(b*c), (4, 6): 1/a, (4, 7): 1/(a*c), (5, 5): 1/c,
        (6, 6): 1/a, (6, 7): 1/(a*c), (7, 7): 1/c}], [{(0, 0): 1/c,
        (1, 0): -a/b - b/c, (1, 1): 1/b, (1, 6): j**2, (2, 0): 1/b,
        (2, 1): -1/(a*b), (2, 2): 1/a, (2, 6): -(j**2 + 1)/a, (3, 8):
        -1/b - j**2/a, (3, 3): 1/a, (3, 6): 1/a, (3, 7): j**2/b +
        j**4/a - j/a, (4, 0): -(a*j**2 - b)/(b*c), (4, 4): 1/b, (5,
        0): -b/(a*c), (5, 4): -1/a, (5, 5): 1/a, (6, 6): 1/c, (7, 7):
        1/c, (8, 8): 1/b, (8, 7): -j**2/b}, {(0, 0): 1/a, (0, 1):
        1/(a*b), (0, 2): 1/b, (0, 3): 1/b, (0, 8): 1/b, (1, 8): a/b +
        b/c, (1, 1): 1/b, (1, 2): a/b + b/c, (1, 3): a/b - b*j/c, (2,
        2): 1/c, (3, 3): 1/c, (4, 2): -(j + 1)/c, (4, 3): -1/c, (4,
        4): 1/a, (4, 5): 1/b, (5, 2): -j/c, (5, 5): 1/b, (6, 8): -(j +
        1)/c, (6, 3): -1/c, (6, 6): 1/a, (6, 7): -1/b, (7, 8): j/c,
        (7, 7): 1/b, (8, 8): 1/c}, {(0, 0): 1/c, (1, 0): -a/b - b/c,
        (1, 1): 1/b, (1, 4): j**2, (2, 2): 1/b, (2, 5): j**2/b, (3,
        2): -1/b - j**2/a, (3, 3): 1/a, (3, 4): 1/a, (3, 5): -j**2/b -
        j**4/a + j/a, (4, 4): 1/c, (5, 5): 1/c, (6, 0): -(a*j**2 -
        b)/(b*c), (6, 6): 1/b, (7, 0): b/(a*c), (7, 6): 1/a, (7, 7):
        1/a, (8, 0): 1/b, (8, 1): -1/(a*b), (8, 4): -(j**2 + 1)/a, (8,
        8): 1/a}], [{(0, 0): 1/c, (1, 0): -a/b - b/c, (1, 1): 1/b, (1,
        6): j, (2, 0): 1/b, (2, 1): -1/(a*b), (2, 2): 1/a, (2, 6): -(j
        + 1)/a, (3, 8): -1/b - j/a, (3, 3): 1/a, (3, 6): 1/a, (3, 7):
        j/b, (4, 0): -(a*j - b)/(b*c), (4, 4): 1/b, (5, 0): -b/(a*c),
        (5, 4): -1/a, (5, 5): 1/a, (6, 6): 1/c, (7, 7): 1/c, (8, 8):
        1/b, (8, 7): -j/b}, {(0, 0): 1/a, (0, 1): 1/(a*b), (0, 2):
        1/b, (0, 3): 1/b, (0, 8): 1/b, (1, 8): a/b + b/c, (1, 1): 1/b,
        (1, 2): a/b + b/c, (1, 3): a/b - b*j**2/c, (2, 2): 1/c, (3,
        3): 1/c, (4, 2): -(j**2 + 1)/c, (4, 3): -1/c, (4, 4): 1/a, (4,
        5): 1/b, (5, 2): -j**2/c, (5, 5): 1/b, (6, 8): -(j**2 + 1)/c,
        (6, 3): -1/c, (6, 6): 1/a, (6, 7): -1/b, (7, 8): j**2/c, (7,
        7): 1/b, (8, 8): 1/c}, {(0, 0): 1/c, (1, 0): -a/b - b/c, (1,
        1): 1/b, (1, 4): j, (2, 2): 1/b, (2, 5): j/b, (3, 2): -1/b -
        j/a, (3, 3): 1/a, (3, 4): 1/a, (3, 5): -j/b, (4, 4): 1/c, (5,
        5): 1/c, (6, 0): -(a*j - b)/(b*c), (6, 6): 1/b, (7, 0):
        b/(a*c), (7, 6): 1/a, (7, 7): 1/a, (8, 0): 1/b, (8, 1):
        -1/(a*b), (8, 4): -(j + 1)/a, (8, 8): 1/a}]])
    return data

