\name{ZeroCrossingBasedEdgeDetectionImageFilter}
\alias{ZeroCrossingBasedEdgeDetectionImageFilter}
\title{ZeroCrossingBasedEdgeDetectionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter implements a zero-crossing based edge detector.
ZeroCrossingBasedEdgeDetectionImageFilter}
\details{
The zero-crossing based edge detector looks for pixels in the
Laplacian of an image where the value of the Laplacian passes through
zero points where the Laplacian changes sign. Such points often occur
at "edges" in images i.e. points where the intensity of the image
changes rapidly, but they also occur at places that are not as easy to
associate with edges. It is best to think of the zero crossing
detector as some sort of feature detector rather than as a specific
edge detector.
Zero crossings always lie on closed contours and so the output from
the zero crossing detector is usually a binary image with single pixel
thickness lines showing the positions of the zero crossing points.
In this implementation, the input image is first smoothed with a
Gaussian filter, then the LaplacianImageFilter is applied to smoothed image. Finally the zero-crossing of the
Laplacian of the smoothed image is detected. The output is a binary
image.
Inputs and Outputs
The input to the filter should be a scalar, itk::Image of arbitrary dimension. The output image is a binary, labeled image.
See itkZeroCrossingImageFilter for more information on requirements of
the data type of the output.
To use this filter, first set the parameters (variance and maximum
error) needed by the embedded DiscreteGaussianImageFilter , i.e. See DiscreteGaussianImageFilter for information about these parameters. Optionally, you may also set
foreground and background values for the zero-crossing filter. The
default label values are Zero for the background and One for the
foreground, as defined in NumericTraits for the data type of the output image.
See:
DiscreteGaussianImageFilter
LaplacianImageFilter
ZeroCrossingImageFilter
ZeroCrossingBasedEdgeDetection for the procedural interface
itk::ZeroCrossingBasedEdgeDetectionImageFilter for the Doxygen on the original ITK class.
ZeroCrossingBasedEdgeDetectionImageFilter}
%C++ includes: sitkZeroCrossingBasedEdgeDetectionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{uint8_t GetBackgroundValue() const:}{
Get/Set the label values for the ZeroCrossingImageFilter
}
\item{uint8_t GetForegroundValue() const:}{
Get/Set the label values for the ZeroCrossingImageFilter
}
\item{double GetMaximumError() const:}{
Standard get/set macros for Gaussian filter parameters.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetVariance() const:}{
Standard get/set macros for Gaussian filter parameters.
}
\item{Self SetBackgroundValue(uint8_t BackgroundValue):}{
Get/Set the label values for the ZeroCrossingImageFilter
}
\item{Self SetForegroundValue(uint8_t ForegroundValue):}{
Get/Set the label values for the ZeroCrossingImageFilter
}
\item{Self SetMaximumError(double MaximumError):}{
Set the MaximumError parameter needed by the embedded gaussian filter
This value is used to set the desired maximum error of the gaussian
approximation. Maximum error is the difference between the area under
the discrete Gaussian curve and the area under the continuous
Gaussian. Maximum error affects the Gaussian operator size. The value
must be between 0.0 and 1.0.
}
\item{Self SetVariance(double Variance):}{
Set the variance parameter needed by the embedded gaussian filter
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ZeroCrossingBasedEdgeDetectionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~ZeroCrossingBasedEdgeDetectionImageFilter():}{
Destructor
}
}
}
