/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler.bytecode_dsl;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.compiler.CompilationScope;
import com.oracle.graal.python.compiler.Compiler;
import com.oracle.graal.python.compiler.SSTUtils;
import com.oracle.graal.python.compiler.Unparser;
import com.oracle.graal.python.compiler.bytecode_dsl.BaseBytecodeDSLVisitor;
import com.oracle.graal.python.compiler.bytecode_dsl.BytecodeDSLCompiler;
import com.oracle.graal.python.compiler.bytecode_dsl.BytecodeDSLCompilerUtils;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLCodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNodeGen;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.scope.Scope;
import com.oracle.graal.python.pegparser.scope.ScopeEnvironment;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.BoolOpTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeParamTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeLabel;
import com.oracle.truffle.api.bytecode.BytecodeLocal;
import com.oracle.truffle.api.bytecode.BytecodeParser;
import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class RootNodeCompiler
implements BaseBytecodeDSLVisitor<BytecodeDSLCompiler.BytecodeDSLCompilerResult> {
    private final BytecodeDSLCompiler.BytecodeDSLCompilerContext ctx;
    private final SSTNode startNode;
    private final Scope scope;
    private final CompilationScope scopeType;
    private final boolean isInteractive;
    private final EnumSet<FutureFeature> futureFeatures;
    private final String privateName;
    private final RootNodeCompiler parent;
    private String qualName;
    private final HashMap<String, Integer> varnames;
    private final HashMap<String, Integer> cellvars;
    private final HashMap<String, Integer> freevars;
    private final int[] cell2arg;
    private final String selfCellName;
    private final Map<String, BytecodeLocal> locals = new HashMap<String, BytecodeLocal>();
    private final Map<String, BytecodeLocal> cellLocals = new HashMap<String, BytecodeLocal>();
    private final Map<String, BytecodeLocal> freeLocals = new HashMap<String, BytecodeLocal>();
    private final HashMap<Object, Integer> constants = new HashMap();
    private final HashMap<String, Integer> names = new HashMap();
    private SourceRange currentLocation;

    public RootNodeCompiler(BytecodeDSLCompiler.BytecodeDSLCompilerContext ctx, RootNodeCompiler parent, SSTNode rootNode, EnumSet<FutureFeature> futureFeatures) {
        this(ctx, parent, null, rootNode, rootNode, futureFeatures);
    }

    public RootNodeCompiler(BytecodeDSLCompiler.BytecodeDSLCompilerContext ctx, RootNodeCompiler parent, String privateName, SSTNode rootNode, Object scopeKey, EnumSet<FutureFeature> futureFeatures) {
        this.ctx = ctx;
        this.startNode = rootNode;
        this.scope = ctx.scopeEnvironment.lookupScope(scopeKey);
        this.scopeType = RootNodeCompiler.getScopeType(this.scope, scopeKey);
        this.parent = parent;
        this.privateName = privateName != null ? privateName : (this.scopeType == CompilationScope.Class ? ((StmtTy.ClassDef)rootNode).name : (parent != null ? parent.privateName : null));
        this.isInteractive = rootNode instanceof ModTy.Interactive;
        this.futureFeatures = futureFeatures;
        this.varnames = new HashMap();
        if (this.scope.isFunction()) {
            for (int i = 0; i < this.scope.getVarnames().size(); ++i) {
                this.varnames.put(this.scope.getVarnames().get(i), i);
            }
            this.varnames.putAll(this.scope.getSymbolsByType(EnumSet.of(Scope.DefUse.Local), EnumSet.of(Scope.DefUse.DefParam, Scope.DefUse.Cell, Scope.DefUse.Free), this.varnames.size()));
        }
        this.cellvars = this.scope.getSymbolsByType(EnumSet.of(Scope.DefUse.Cell), 0);
        if (this.scope.needsClassClosure()) {
            assert (this.scopeType == CompilationScope.Class);
            assert (this.cellvars.isEmpty());
            this.cellvars.put("__class__", 0);
        }
        if (this.scope.needsClassDict()) {
            assert (this.scopeType == CompilationScope.Class);
            this.cellvars.put("__classdict__", this.cellvars.size());
        }
        this.freevars = this.scope.getSymbolsByType(EnumSet.of(Scope.DefUse.Free, Scope.DefUse.DefFreeClass), 0);
        int[] cell2argValue = new int[this.cellvars.size()];
        boolean hasArgCell = false;
        Arrays.fill(cell2argValue, -1);
        String selfCellNameValue = null;
        for (String cellvar : this.cellvars.keySet()) {
            int argIndex;
            if (!this.varnames.containsKey(cellvar)) continue;
            cell2argValue[this.cellvars.get((Object)cellvar).intValue()] = argIndex = this.varnames.get(cellvar).intValue();
            hasArgCell = true;
            if (argIndex != 0) continue;
            assert (selfCellNameValue == null);
            selfCellNameValue = cellvar;
        }
        this.cell2arg = (int[])(hasArgCell ? cell2argValue : null);
        this.selfCellName = selfCellNameValue;
    }

    private static CompilationScope getScopeType(Scope scope, Object scopeKey) {
        if (scope.isModule()) {
            return CompilationScope.Module;
        }
        if (scope.isClass()) {
            return CompilationScope.Class;
        }
        if (scope.isFunction()) {
            if (scopeKey instanceof ExprTy.Lambda) {
                return CompilationScope.Lambda;
            }
            if (scopeKey instanceof StmtTy.AsyncFunctionDef) {
                return CompilationScope.AsyncFunction;
            }
            if (scopeKey instanceof ExprTy.DictComp || scopeKey instanceof ExprTy.ListComp || scopeKey instanceof ExprTy.SetComp || scopeKey instanceof ExprTy.GeneratorExp) {
                return CompilationScope.Comprehension;
            }
            if (scopeKey instanceof TypeParamTy[]) {
                return CompilationScope.TypeParams;
            }
            return CompilationScope.Function;
        }
        throw new IllegalStateException("Unexpected scope: " + String.valueOf(scope));
    }

    private static <T, U> U[] orderedKeys(HashMap<T, Integer> map, U[] base, Function<T, U> converter) {
        U[] result = Arrays.copyOf(base, map.size());
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            result[e.getValue().intValue()] = converter.apply(e.getKey());
        }
        return result;
    }

    private static <T> T[] orderedKeys(HashMap<T, Integer> map, T[] base) {
        return RootNodeCompiler.orderedKeys(map, base, x -> x);
    }

    private Object addConstant(Object c) {
        Integer v = this.constants.get(c);
        if (v == null) {
            v = this.constants.size();
            this.constants.put(c, v);
        }
        return c;
    }

    private static TruffleString[] orderedTruffleStringArray(HashMap<String, Integer> map) {
        return RootNodeCompiler.orderedKeys(map, new TruffleString[0], PythonUtils::toTruffleStringUncached);
    }

    private String getNewScopeQualName(String name, CompilationScope scopeType) {
        RootNodeCompiler parent = this.parent;
        if (parent != null && parent.parent != null) {
            if (parent.scopeType == CompilationScope.TypeParams && parent.parent != null && parent.parent.parent != null) {
                parent = parent.parent;
                if (parent.parent != null && parent.parent.parent == null) {
                    return name;
                }
            }
            if (!EnumSet.of(CompilationScope.Function, CompilationScope.AsyncFunction, CompilationScope.Class).contains((Object)scopeType) || !parent.scope.getUseOfName(ScopeEnvironment.mangle(parent.privateName, name)).contains((Object)Scope.DefUse.GlobalExplicit)) {
                Object base = EnumSet.of(CompilationScope.Function, CompilationScope.AsyncFunction, CompilationScope.Lambda).contains((Object)parent.scopeType) ? parent.qualName + ".<locals>" : parent.qualName;
                return (String)base + "." + name;
            }
        }
        return name;
    }

    private BytecodeDSLCompiler.BytecodeDSLCompilerResult compileRootNode(String name, ArgumentInfo argumentInfo, SourceRange sourceRange, BytecodeParser<PBytecodeDSLRootNodeGen.Builder> parser) {
        this.qualName = this.getNewScopeQualName(name, this.scopeType);
        BytecodeRootNodes<PBytecodeDSLRootNode> nodes = PBytecodeDSLRootNodeGen.create(this.ctx.language, BytecodeConfig.WITH_SOURCE, parser);
        List nodeList = nodes.getNodes();
        assert (nodeList.size() == 1);
        PBytecodeDSLRootNode rootNode = (PBytecodeDSLRootNode)((Object)nodeList.get(0));
        int flags = 3;
        flags |= argumentInfo.takesVarArgs ? 4 : 0;
        flags |= argumentInfo.takesVarKeywordArgs ? 8 : 0;
        if (this.scope.isNested()) {
            flags |= 0x10;
        }
        if (this.scope.isModule()) {
            flags |= 0x1000;
        }
        if (this.scope.isGenerator() && this.scope.isCoroutine()) {
            flags |= 0x200;
        } else if (this.scope.isGenerator()) {
            flags |= 0x20;
        } else if (this.scope.isCoroutine()) {
            flags |= 0x80;
        }
        for (FutureFeature flag : this.futureFeatures) {
            flags |= flag.flagValue;
        }
        int classcellIndex = -1;
        if (this.freeLocals.containsKey("__class__")) {
            classcellIndex = this.freeLocals.get("__class__").getLocalOffset();
        }
        int selfIndex = -1;
        if (argumentInfo.nonEmpty()) {
            selfIndex = 0;
            if (this.selfCellName != null) {
                selfIndex = this.cellLocals.get(this.selfCellName).getLocalOffset();
            }
        }
        BytecodeDSLCodeUnit codeUnit = new BytecodeDSLCodeUnit(PythonUtils.toTruffleStringUncached(name), PythonUtils.toTruffleStringUncached(this.qualName), argumentInfo.argCount, argumentInfo.kwOnlyArgCount, argumentInfo.positionalOnlyArgCount, flags, RootNodeCompiler.orderedTruffleStringArray(this.names), RootNodeCompiler.orderedTruffleStringArray(this.varnames), RootNodeCompiler.orderedTruffleStringArray(this.cellvars), RootNodeCompiler.orderedTruffleStringArray(this.freevars), this.cell2arg, RootNodeCompiler.orderedKeys(this.constants, new Object[0]), sourceRange.startLine, sourceRange.startColumn, sourceRange.endLine, sourceRange.endColumn, classcellIndex, selfIndex, null, nodes);
        rootNode.setMetadata(codeUnit, this.ctx.errorCallback);
        return new BytecodeDSLCompiler.BytecodeDSLCompilerResult(rootNode, codeUnit);
    }

    private void checkForbiddenName(String id, NameOperation context) {
        this.checkForbiddenName(id, context, this.currentLocation);
    }

    private void checkForbiddenName(String id, NameOperation context, SourceRange location) {
        ExprContextTy exprContext = switch (context.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2 -> ExprContextTy.Store;
            case 0 -> ExprContextTy.Load;
            case 3 -> ExprContextTy.Del;
        };
        SSTUtils.checkForbiddenName(this.ctx.errorCallback, location, id, exprContext);
    }

    private boolean containsAnnotations(StmtTy[] stmts) {
        if (stmts == null) {
            return false;
        }
        for (StmtTy stmt : stmts) {
            if (!this.containsAnnotations(stmt)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnnotations(StmtTy stmt) {
        if (stmt instanceof StmtTy.AnnAssign) {
            return true;
        }
        if (stmt instanceof StmtTy.For) {
            return this.containsAnnotations(((StmtTy.For)stmt).body) || this.containsAnnotations(((StmtTy.For)stmt).orElse);
        }
        if (stmt instanceof StmtTy.While) {
            return this.containsAnnotations(((StmtTy.While)stmt).body) || this.containsAnnotations(((StmtTy.While)stmt).orElse);
        }
        if (stmt instanceof StmtTy.If) {
            return this.containsAnnotations(((StmtTy.If)stmt).body) || this.containsAnnotations(((StmtTy.If)stmt).orElse);
        }
        if (stmt instanceof StmtTy.With) {
            return this.containsAnnotations(((StmtTy.With)stmt).body);
        }
        if (stmt instanceof StmtTy.Try) {
            StmtTy.Try tryStmt = (StmtTy.Try)stmt;
            if (tryStmt.handlers != null) {
                for (ExceptHandlerTy h : tryStmt.handlers) {
                    if (!this.containsAnnotations(((ExceptHandlerTy.ExceptHandler)h).body)) continue;
                    return true;
                }
            }
            return this.containsAnnotations(tryStmt.body) || this.containsAnnotations(tryStmt.finalBody) || this.containsAnnotations(tryStmt.orElse);
        }
        return false;
    }

    private List<ParamAnnotation> collectParamAnnotations(ArgumentsTy args, ExprTy returns) {
        ArrayList<ParamAnnotation> result = new ArrayList<ParamAnnotation>();
        if (args != null) {
            this.visitParamAnnotations(result, args.args);
            this.visitParamAnnotations(result, args.posOnlyArgs);
            if (args.varArg != null) {
                this.visitParamAnnotation(result, args.varArg.arg, args.varArg.annotation);
            }
            this.visitParamAnnotations(result, args.kwOnlyArgs);
            if (args.kwArg != null) {
                this.visitParamAnnotation(result, args.kwArg.arg, args.kwArg.annotation);
            }
        }
        this.visitParamAnnotation(result, "return", returns);
        return result;
    }

    private void visitParamAnnotations(List<ParamAnnotation> result, ArgTy[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.visitParamAnnotation(result, args[i].arg, args[i].annotation);
        }
    }

    private void visitParamAnnotation(List<ParamAnnotation> result, String name, ExprTy annotation) {
        if (annotation != null) {
            String mangled = this.mangle(name);
            result.add(new ParamAnnotation(PythonUtils.toTruffleStringUncached(mangled), annotation));
        }
    }

    public BytecodeDSLCompiler.BytecodeDSLCompilerResult compile() {
        return this.startNode.accept(this);
    }

    public void reset() {
        this.currentLocation = null;
    }

    void beginRootNode(SSTNode node, ArgumentsTy args, PBytecodeDSLRootNodeGen.Builder b) {
        this.reset();
        b.beginSource(this.ctx.source);
        this.beginRootSourceSection(node, b);
        b.beginRoot();
        SSTUtils.checkForbiddenArgs(this.ctx.errorCallback, node.getSourceRange(), args);
        this.setUpFrame(args, b);
        b.emitTraceOrProfileCall();
    }

    void endRootNode(PBytecodeDSLRootNodeGen.Builder b) {
        b.endRoot();
        this.endRootSourceSection(b);
        b.endSource();
    }

    boolean beginSourceSection(SSTNode node, PBytecodeDSLRootNodeGen.Builder b) {
        SourceRange sourceRange = node.getSourceRange();
        SourceRange oldSourceRange = this.currentLocation;
        this.currentLocation = sourceRange;
        if (this.ctx.source.hasCharacters()) {
            int startOffset = this.getStartOffset(sourceRange);
            int endOffset = this.getEndOffset(sourceRange);
            int length = endOffset - startOffset;
            if (length == 0) {
                startOffset = 0;
            }
            b.beginSourceSection(startOffset, length);
            if (oldSourceRange == null || oldSourceRange.startLine != sourceRange.startLine) {
                b.beginTag(StandardTags.StatementTag.class);
                b.beginBlock();
                b.emitTraceLine(sourceRange.startLine);
                return true;
            }
        }
        return false;
    }

    void beginRootSourceSection(SSTNode node, PBytecodeDSLRootNodeGen.Builder b) {
        SourceRange sourceRange = node.getSourceRange();
        if (this.ctx.source.hasCharacters()) {
            int startOffset = this.getStartOffset(sourceRange);
            int endOffset = this.getEndOffset(sourceRange);
            int length = endOffset - startOffset;
            if (length == 0) {
                startOffset = 0;
            }
            b.beginSourceSection(startOffset, length);
        }
    }

    void endSourceSection(PBytecodeDSLRootNodeGen.Builder b, boolean closeTag) {
        if (this.ctx.source.hasCharacters()) {
            if (closeTag) {
                b.endBlock();
                b.endTag(StandardTags.StatementTag.class);
            }
            b.endSourceSection();
        }
    }

    void endRootSourceSection(PBytecodeDSLRootNodeGen.Builder b) {
        if (this.ctx.source.hasCharacters()) {
            b.endSourceSection();
        }
    }

    int getStartOffset(SourceRange sourceRange) {
        return this.ctx.source.getLineStartOffset(sourceRange.startLine) + sourceRange.startColumn;
    }

    int getEndOffset(SourceRange sourceRange) {
        return this.ctx.source.getLineStartOffset(sourceRange.endLine) + sourceRange.endColumn;
    }

    void beginReturn(PBytecodeDSLRootNodeGen.Builder b) {
        b.beginReturn();
        b.beginTraceOrProfileReturn();
    }

    void endReturn(PBytecodeDSLRootNodeGen.Builder b) {
        b.endTraceOrProfileReturn();
        b.endReturn();
    }

    String maybeMangle(String name) {
        return this.ctx.maybeMangle(this.privateName, this.scope, name);
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ModTy.Module node) {
        return this.compileRootNode("<module>", ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            this.visitModuleBody(node.body, (PBytecodeDSLRootNodeGen.Builder)b);
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ModTy.Expression node) {
        return this.compileRootNode("<module>", ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            this.beginReturn((PBytecodeDSLRootNodeGen.Builder)b);
            new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b).visitNode(node.body);
            this.endReturn((PBytecodeDSLRootNodeGen.Builder)b);
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ModTy.Interactive node) {
        return this.compileRootNode("<module>", ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            this.visitModuleBody(node.body, (PBytecodeDSLRootNodeGen.Builder)b);
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    private void visitModuleBody(StmtTy[] body, PBytecodeDSLRootNodeGen.Builder b) {
        if (body != null) {
            if (this.containsAnnotations(body)) {
                b.emitSetupAnnotations();
            }
            StatementCompiler statementCompiler = new StatementCompiler(b);
            if (this.isInteractive) {
                for (int i = 0; i < body.length; ++i) {
                    StmtTy bodyNode = body[i];
                    if (i == body.length - 1) {
                        bodyNode.accept(statementCompiler);
                        this.beginReturn(b);
                        b.emitLoadConstant(PNone.NONE);
                        this.endReturn(b);
                        continue;
                    }
                    bodyNode.accept(statementCompiler);
                }
            } else {
                int i = 0;
                TruffleString docstring = RootNodeCompiler.getDocstring(body);
                if (docstring != null) {
                    ++i;
                    if (this.ctx.optimizationLevel < 2) {
                        this.beginStoreLocal("__doc__", b);
                        this.emitPythonConstant(docstring, b);
                        this.endStoreLocal("__doc__", b);
                    }
                }
                if (i == body.length) {
                    this.beginReturn(b);
                    b.emitLoadConstant(PNone.NONE);
                    this.endReturn(b);
                    return;
                }
                while (i < body.length) {
                    StmtTy bodyNode = body[i];
                    if (i == body.length - 1) {
                        if (bodyNode instanceof StmtTy.Expr) {
                            StmtTy.Expr expr = (StmtTy.Expr)bodyNode;
                            this.beginReturn(b);
                            expr.value.accept(statementCompiler);
                            this.endReturn(b);
                        } else {
                            bodyNode.accept(statementCompiler);
                            this.beginReturn(b);
                            b.emitLoadConstant(PNone.NONE);
                            this.endReturn(b);
                        }
                    } else {
                        bodyNode.accept(statementCompiler);
                    }
                    ++i;
                }
            }
        } else {
            this.beginReturn(b);
            b.emitLoadConstant(PNone.NONE);
            this.endReturn(b);
        }
    }

    private static TruffleString getDocstring(StmtTy[] body) {
        StmtTy stmt;
        if (body != null && body.length > 0 && (stmt = body[0]) instanceof StmtTy.Expr) {
            StmtTy.Expr expr = (StmtTy.Expr)stmt;
            ExprTy exprTy = expr.value;
            if (exprTy instanceof ExprTy.Constant) {
                ExprTy.Constant constant = (ExprTy.Constant)exprTy;
                if (constant.value.kind == ConstantValue.Kind.CODEPOINTS) {
                    return PythonUtils.codePointsToTruffleString(constant.value.getCodePoints());
                }
            }
        }
        return null;
    }

    public BytecodeDSLCompiler.BytecodeDSLCompilerResult compileFunctionDef(StmtTy node, String name, ArgumentsTy args, StmtTy[] body) {
        return this.compileRootNode(name, ArgumentInfo.fromArguments(args), node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> this.emitFunctionDefBody(node, args, body, (PBytecodeDSLRootNodeGen.Builder)b, RootNodeCompiler.getDocstring(body), false)));
    }

    private BytecodeDSLCompiler.BytecodeDSLCompilerResult compileFunctionTypeParams(BytecodeDSLCodeUnit codeUnit, StmtTy node, String name, ArgumentsTy args, ExprTy returns, TypeParamTy[] typeParams) {
        assert (this.scopeType == CompilationScope.TypeParams);
        ArgumentsTy typeParamsUnitArgs = BytecodeDSLCompilerUtils.hasDefaultArgs(args) && BytecodeDSLCompilerUtils.hasDefaultKwargs(args) ? BytecodeDSLCompilerUtils.TYPE_PARAMS_DEFAULTS_KWDEFAULTS : (BytecodeDSLCompilerUtils.hasDefaultKwargs(args) ? BytecodeDSLCompilerUtils.TYPE_PARAMS_KWDEFAULTS : (BytecodeDSLCompilerUtils.hasDefaultArgs(args) ? BytecodeDSLCompilerUtils.TYPE_PARAMS_DEFAULTS : BytecodeDSLCompilerUtils.NO_ARGS));
        ArgumentInfo argInfo = ArgumentInfo.fromArguments(typeParamsUnitArgs);
        return this.compileRootNode(name, argInfo, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, typeParamsUnitArgs, (PBytecodeDSLRootNodeGen.Builder)b);
            StatementCompiler statementCompiler = new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b);
            BytecodeLocal typeParamsLocal = b.createLocal();
            b.beginStoreLocal(typeParamsLocal);
            statementCompiler.visitTypeParams(typeParams);
            b.endStoreLocal();
            BytecodeLocal funLocal = b.createLocal();
            b.beginStoreLocal(funLocal);
            List<ParamAnnotation> annotations = this.collectParamAnnotations(args, returns);
            BytecodeLocal defaultArgsLocal = null;
            BytecodeLocal defaultKwargsLocal = null;
            if (BytecodeDSLCompilerUtils.hasDefaultArgs(args)) {
                defaultArgsLocal = this.locals.get(".defaults");
                assert (defaultArgsLocal != null);
            }
            if (BytecodeDSLCompilerUtils.hasDefaultKwargs(args)) {
                defaultKwargsLocal = this.locals.get(".kwdefaults");
                assert (defaultKwargsLocal != null);
            }
            statementCompiler.emitMakeFunction(codeUnit, node, name, defaultArgsLocal, defaultKwargsLocal, null, annotations);
            b.endStoreLocal();
            this.beginSetAttribute("__type_params__", (PBytecodeDSLRootNodeGen.Builder)b);
            b.emitLoadLocal(typeParamsLocal);
            b.emitLoadLocal(funLocal);
            b.endSetAttribute();
            b.beginReturn();
            b.emitLoadLocal(funLocal);
            b.endReturn();
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    private BytecodeDSLCompiler.BytecodeDSLCompilerResult compileBoundTypeVar(TypeParamTy.TypeVar node) {
        assert (node.bound != null);
        return this.compileRootNode(node.name, ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            b.beginReturn();
            node.bound.accept(new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b));
            b.endReturn();
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    private BytecodeDSLCompiler.BytecodeDSLCompilerResult compileTypeAliasBody(StmtTy.TypeAlias node) {
        String name = ((ExprTy.Name)node.name).id;
        return this.compileRootNode(name, ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            BytecodeDSLCompilerUtils.addObject(this.constants, PNone.NONE);
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            b.beginReturn();
            node.value.accept(new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b));
            b.endReturn();
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    private BytecodeDSLCompiler.BytecodeDSLCompilerResult compileTypeAliasTypeParameters(String name, BytecodeDSLCodeUnit codeUnit, StmtTy.TypeAlias node) {
        assert (this.scopeType == CompilationScope.TypeParams);
        String typeParamsName = "<generic parameters of " + name + ">";
        return this.compileRootNode(typeParamsName, ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            StatementCompiler statementCompiler = new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b);
            statementCompiler.emitBuildTypeAlias(codeUnit, node);
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ExprTy.Lambda node) {
        return this.compileRootNode("<lambda>", ArgumentInfo.fromArguments(node.args), node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> this.emitFunctionDefBody(node, node.args, new SSTNode[]{node.body}, (PBytecodeDSLRootNodeGen.Builder)b, null, !this.scope.isGenerator())));
    }

    private void emitFunctionDefBody(SSTNode node, ArgumentsTy args, SSTNode[] body, PBytecodeDSLRootNodeGen.Builder b, Object docstring, boolean isRegularLambda) {
        this.beginRootNode(node, args, b);
        int i = 0;
        if (docstring != null) {
            ++i;
            if (this.ctx.optimizationLevel < 2) {
                this.addConstant(docstring);
            } else {
                this.addConstant(PNone.NONE);
            }
        } else {
            this.addConstant(PNone.NONE);
        }
        StatementCompiler statementCompiler = new StatementCompiler(b);
        if (isRegularLambda) {
            assert (i == 0);
            assert (body[0] instanceof ExprTy);
            this.beginReturn(b);
            body[0].accept(statementCompiler);
            this.endReturn(b);
        } else {
            while (i < body.length) {
                body[i].accept(statementCompiler);
                ++i;
            }
            this.beginReturn(b);
            this.emitPythonConstant(PNone.NONE, b);
            this.endReturn(b);
        }
        this.endRootNode(b);
    }

    public BytecodeDSLCompiler.BytecodeDSLCompilerResult compileClassDefBody(StmtTy.ClassDef node) {
        return this.compileRootNode(node.name, ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            this.beginStoreLocal("__module__", (PBytecodeDSLRootNodeGen.Builder)b);
            this.emitReadLocal("__name__", (PBytecodeDSLRootNodeGen.Builder)b);
            this.endStoreLocal("__module__", (PBytecodeDSLRootNodeGen.Builder)b);
            this.beginStoreLocal("__qualname__", (PBytecodeDSLRootNodeGen.Builder)b);
            this.emitPythonConstant(PythonUtils.toTruffleStringUncached(this.qualName), (PBytecodeDSLRootNodeGen.Builder)b);
            this.endStoreLocal("__qualname__", (PBytecodeDSLRootNodeGen.Builder)b);
            if (node.isGeneric()) {
                this.beginStoreLocal("__type_params__", (PBytecodeDSLRootNodeGen.Builder)b);
                this.emitReadLocal(".type_params", (PBytecodeDSLRootNodeGen.Builder)b);
                this.endStoreLocal("__type_params__", (PBytecodeDSLRootNodeGen.Builder)b);
            }
            if (this.scope.needsClassDict()) {
                assert ("__classdict__".equals(this.mangle("__classdict__")));
                this.emitNameCellOperation("__classdict__", NameOperation.BeginWrite, (PBytecodeDSLRootNodeGen.Builder)b);
                b.emitLoadSpecialArgument();
                this.emitNameCellOperation("__classdict__", NameOperation.EndWrite, (PBytecodeDSLRootNodeGen.Builder)b);
            }
            if (this.containsAnnotations(node.body)) {
                b.emitSetupAnnotations();
            }
            int i = 0;
            TruffleString docstring = RootNodeCompiler.getDocstring(node.body);
            if (docstring != null) {
                ++i;
                if (this.ctx.optimizationLevel < 2) {
                    this.beginStoreLocal("__doc__", (PBytecodeDSLRootNodeGen.Builder)b);
                    this.emitPythonConstant(docstring, (PBytecodeDSLRootNodeGen.Builder)b);
                    this.endStoreLocal("__doc__", (PBytecodeDSLRootNodeGen.Builder)b);
                }
            }
            StatementCompiler statementCompiler = new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b);
            while (i < node.body.length) {
                node.body[i].accept(statementCompiler);
                ++i;
            }
            if (this.scope.needsClassDict()) {
                this.emitNameOperation("__classdictcell__", NameOperation.BeginWrite, (PBytecodeDSLRootNodeGen.Builder)b);
                assert ("__classdict__".equals(this.mangle("__classdict__")));
                BytecodeLocal classDictCell = this.cellLocals.get("__classdict__");
                b.emitLoadLocal(classDictCell);
                this.emitNameOperation("__classdictcell__", NameOperation.EndWrite, (PBytecodeDSLRootNodeGen.Builder)b);
            }
            if (this.scope.needsClassClosure()) {
                this.beginStoreLocal("__classcell__", (PBytecodeDSLRootNodeGen.Builder)b);
                b.emitLoadLocal(this.cellLocals.get("__class__"));
                this.endStoreLocal("__classcell__", (PBytecodeDSLRootNodeGen.Builder)b);
                this.beginReturn((PBytecodeDSLRootNodeGen.Builder)b);
                b.emitLoadLocal(this.cellLocals.get("__class__"));
                this.endReturn((PBytecodeDSLRootNodeGen.Builder)b);
            } else {
                this.beginReturn((PBytecodeDSLRootNodeGen.Builder)b);
                b.emitLoadConstant(PNone.NONE);
                this.endReturn((PBytecodeDSLRootNodeGen.Builder)b);
            }
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    public BytecodeDSLCompiler.BytecodeDSLCompilerResult compileClassTypeParams(StmtTy.ClassDef node, BytecodeDSLCodeUnit classBody) {
        assert (this.scopeType == CompilationScope.TypeParams);
        return this.compileRootNode(node.name, ArgumentInfo.NO_ARGS, node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            StatementCompiler statementCompiler = new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b);
            statementCompiler.emitBuildClass(classBody, node);
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    private boolean beginComprehension(ComprehensionTy comp, int index, PBytecodeDSLRootNodeGen.Builder b) {
        boolean newStatement = this.beginSourceSection(comp, b);
        BytecodeLocal localIter = b.createLocal();
        BytecodeLocal localValue = b.createLocal();
        StatementCompiler statementCompiler = new StatementCompiler(b);
        b.beginStoreLocal(localIter);
        b.beginGetIter();
        if (index == 0) {
            b.emitLoadArgument(9);
        } else {
            comp.iter.accept(statementCompiler);
        }
        b.endGetIter();
        b.endStoreLocal();
        b.beginWhile();
        b.beginBlock();
        b.emitTraceLineAtLoopHeader(this.currentLocation.startLine);
        b.beginForIterate(localValue);
        b.emitLoadLocal(localIter);
        b.endForIterate();
        b.endBlock();
        b.beginBlock();
        ExprTy exprTy = comp.target;
        StatementCompiler statementCompiler2 = statementCompiler;
        Objects.requireNonNull(statementCompiler2);
        exprTy.accept(statementCompiler2.new StatementCompiler.StoreVisitor(() -> b.emitLoadLocal(localValue)));
        if (comp.ifs != null) {
            for (int i = 0; i < comp.ifs.length; ++i) {
                b.beginIfThen();
                statementCompiler.visitCondition(comp.ifs[i]);
                b.beginBlock();
            }
        }
        return newStatement;
    }

    private void endComprehension(ComprehensionTy comp, PBytecodeDSLRootNodeGen.Builder b, boolean newStatement) {
        if (comp.ifs != null) {
            for (int i = 0; i < BytecodeDSLCompilerUtils.len(comp.ifs); ++i) {
                b.endBlock();
                b.endIfThen();
            }
        }
        b.endBlock();
        b.endWhile();
        this.endSourceSection(b, newStatement);
    }

    private BytecodeDSLCompiler.BytecodeDSLCompilerResult buildComprehensionCodeUnit(SSTNode node, ComprehensionTy[] generators, String name, Consumer<StatementCompiler> emptyCollectionProducer, BiConsumer<StatementCompiler, BytecodeLocal> accumulateProducer) {
        return this.compileRootNode(name, new ArgumentInfo(1, 0, 0, false, false), node.getSourceRange(), (BytecodeParser<PBytecodeDSLRootNodeGen.Builder>)((BytecodeParser)b -> {
            int i;
            this.beginRootNode(node, null, (PBytecodeDSLRootNodeGen.Builder)b);
            StatementCompiler statementCompiler = new StatementCompiler((PBytecodeDSLRootNodeGen.Builder)b);
            boolean isGenerator = emptyCollectionProducer == null;
            BytecodeLocal collectionLocal = null;
            if (!isGenerator) {
                collectionLocal = b.createLocal();
                b.beginStoreLocal(collectionLocal);
                emptyCollectionProducer.accept(statementCompiler);
                b.endStoreLocal();
            }
            boolean[] newStatement = new boolean[generators.length];
            for (i = 0; i < generators.length; ++i) {
                newStatement[i] = this.beginComprehension(generators[i], i, (PBytecodeDSLRootNodeGen.Builder)b);
            }
            accumulateProducer.accept(statementCompiler, collectionLocal);
            for (i = generators.length - 1; i >= 0; --i) {
                this.endComprehension(generators[i], (PBytecodeDSLRootNodeGen.Builder)b, newStatement[i]);
            }
            this.beginReturn((PBytecodeDSLRootNodeGen.Builder)b);
            if (isGenerator) {
                b.emitLoadConstant(PNone.NONE);
            } else {
                b.emitLoadLocal(collectionLocal);
            }
            this.endReturn((PBytecodeDSLRootNodeGen.Builder)b);
            this.endRootNode((PBytecodeDSLRootNodeGen.Builder)b);
        }));
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ExprTy.ListComp node) {
        return this.buildComprehensionCodeUnit(node, node.generators, "<listcomp>", statementCompiler -> {
            statementCompiler.b.beginMakeList();
            statementCompiler.b.emitLoadConstant(PythonUtils.EMPTY_OBJECT_ARRAY);
            statementCompiler.b.endMakeList();
        }, (statementCompiler, collection) -> {
            statementCompiler.b.beginListAppend();
            statementCompiler.b.emitLoadLocal((BytecodeLocal)collection);
            node.element.accept(statementCompiler);
            statementCompiler.b.endListAppend();
        });
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ExprTy.DictComp node) {
        return this.buildComprehensionCodeUnit(node, node.generators, "<dictcomp>", statementCompiler -> {
            statementCompiler.b.beginMakeDict(0);
            statementCompiler.b.endMakeDict();
        }, (statementCompiler, collection) -> {
            statementCompiler.b.beginSetDictItem();
            statementCompiler.b.emitLoadLocal((BytecodeLocal)collection);
            node.key.accept(statementCompiler);
            node.value.accept(statementCompiler);
            statementCompiler.b.endSetDictItem();
        });
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ExprTy.SetComp node) {
        return this.buildComprehensionCodeUnit(node, node.generators, "<setcomp>", statementCompiler -> {
            statementCompiler.b.beginMakeSet();
            statementCompiler.b.emitLoadConstant(PythonUtils.EMPTY_OBJECT_ARRAY);
            statementCompiler.b.endMakeSet();
        }, (statementCompiler, collection) -> {
            statementCompiler.b.beginSetAdd();
            statementCompiler.b.emitLoadLocal((BytecodeLocal)collection);
            node.element.accept(statementCompiler);
            statementCompiler.b.endSetAdd();
        });
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(ExprTy.GeneratorExp node) {
        return this.buildComprehensionCodeUnit(node, node.generators, "<genexpr>", null, (statementCompiler, collection) -> RootNodeCompiler.emitYield(statementCompiler_ -> node.element.accept(statementCompiler_), statementCompiler));
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(StmtTy.TypeAlias node) {
        return null;
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(TypeParamTy.TypeVar node) {
        return null;
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(TypeParamTy.ParamSpec node) {
        return null;
    }

    @Override
    public BytecodeDSLCompiler.BytecodeDSLCompilerResult visit(TypeParamTy.TypeVarTuple node) {
        return null;
    }

    private String mangle(String name) {
        return this.ctx.mangle(this.scope, name);
    }

    private void emitNotImplemented(String what, PBytecodeDSLRootNodeGen.Builder b) {
        b.beginRaiseNotImplementedError();
        this.emitPythonConstant(PythonUtils.toTruffleStringUncached(what), b);
        b.endRaiseNotImplementedError();
    }

    private void emitPythonConstant(Object constant, PBytecodeDSLRootNodeGen.Builder b) {
        b.emitLoadConstant(this.addConstant(constant));
    }

    private static void emitYield(Consumer<StatementCompiler> yieldValueProducer, StatementCompiler statementCompiler) {
        statementCompiler.b.beginResumeYield();
        statementCompiler.b.beginYield();
        statementCompiler.b.beginPreYield();
        yieldValueProducer.accept(statementCompiler);
        statementCompiler.b.endPreYield();
        statementCompiler.b.endYield();
        statementCompiler.b.endResumeYield();
    }

    private void beginSetAttribute(String name, PBytecodeDSLRootNodeGen.Builder b) {
        String mangled = this.maybeMangle(name);
        b.beginSetAttribute(PythonUtils.toTruffleStringUncached(mangled));
    }

    private void beginGetAttribute(String name, PBytecodeDSLRootNodeGen.Builder b) {
        String mangled = this.maybeMangle(name);
        b.beginGetAttribute(PythonUtils.toTruffleStringUncached(mangled));
    }

    private void emitNameCellOperation(String mangled, NameOperation op, PBytecodeDSLRootNodeGen.Builder b) {
        BytecodeLocal local;
        int index;
        if (this.freevars.containsKey(mangled)) {
            index = this.freevars.get(mangled) + this.cellvars.size();
            local = this.freeLocals.get(mangled);
        } else {
            index = this.cellvars.get(mangled);
            local = this.cellLocals.get(mangled);
        }
        switch (op.ordinal()) {
            case 0: {
                if (this.scope.isClass()) {
                    b.beginLoadFromDictOrCell(index);
                    b.emitLoadSpecialArgument();
                    b.emitLoadLocal(local);
                    b.endLoadFromDictOrCell();
                    break;
                }
                if (this.scope.canSeeClassScope()) {
                    int classDictIndex = this.freevars.get("__classdict__");
                    BytecodeLocal classDictLocal = this.freeLocals.get("__classdict__");
                    b.beginLoadFromDictOrCell(index);
                    b.beginLoadCell(classDictIndex);
                    b.emitLoadLocal(classDictLocal);
                    b.endLoadCell();
                    b.emitLoadLocal(local);
                    b.endLoadFromDictOrCell();
                    break;
                }
                b.beginLoadCell(index);
                b.emitLoadLocal(local);
                b.endLoadCell();
                break;
            }
            case 3: {
                b.beginClearCell(index);
                b.emitLoadLocal(local);
                b.endClearCell();
                break;
            }
            case 1: {
                b.beginStoreCell();
                b.emitLoadLocal(local);
                break;
            }
            case 2: {
                b.endStoreCell();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown value: " + String.valueOf((Object)op));
            }
        }
    }

    private void emitNameFastOperation(String mangled, NameOperation op, PBytecodeDSLRootNodeGen.Builder b) {
        BytecodeLocal local = this.locals.get(mangled);
        switch (op.ordinal()) {
            case 0: {
                b.emitCheckAndLoadLocal(local, this.varnames.get(mangled));
                break;
            }
            case 3: {
                b.emitDeleteLocal(local, this.varnames.get(mangled));
                break;
            }
            case 1: {
                if (local == null) {
                    throw new NullPointerException("local " + mangled + " not defined");
                }
                b.beginStoreLocal(local);
                break;
            }
            case 2: {
                b.endStoreLocal();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown value: " + String.valueOf((Object)op));
            }
        }
    }

    private void emitNameGlobalOperation(String name, NameOperation op, PBytecodeDSLRootNodeGen.Builder b, boolean isImplicitScope) {
        assert (this.locals.get(name) == null);
        this.names.putIfAbsent(name, this.names.size());
        TruffleString tsName = PythonUtils.toTruffleStringUncached(name);
        switch (op.ordinal()) {
            case 0: {
                if (this.scope.canSeeClassScope() && isImplicitScope) {
                    int classDictIndex = this.freevars.get("__classdict__");
                    BytecodeLocal classDictLocal = this.freeLocals.get("__classdict__");
                    b.beginLoadFromDictOrGlobals(tsName);
                    b.beginLoadCell(classDictIndex);
                    b.emitLoadLocal(classDictLocal);
                    b.endLoadCell();
                    b.endLoadFromDictOrGlobals();
                    break;
                }
                b.emitReadGlobal(tsName);
                break;
            }
            case 3: {
                b.emitDeleteGlobal(tsName);
                break;
            }
            case 1: {
                b.beginWriteGlobal(tsName);
                break;
            }
            case 2: {
                b.endWriteGlobal();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown value: " + String.valueOf((Object)op));
            }
        }
    }

    private void emitNameSlowOperation(String name, NameOperation op, PBytecodeDSLRootNodeGen.Builder b) {
        assert (this.locals.get(name) == null);
        this.names.putIfAbsent(name, this.names.size());
        TruffleString tsName = PythonUtils.toTruffleStringUncached(name);
        switch (op.ordinal()) {
            case 0: {
                b.emitReadName(tsName);
                break;
            }
            case 3: {
                b.emitDeleteName(tsName);
                break;
            }
            case 1: {
                b.beginWriteName(tsName);
                break;
            }
            case 2: {
                b.endWriteName();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown value: " + String.valueOf((Object)op));
            }
        }
    }

    private void emitNameOperation(String name, NameOperation op, PBytecodeDSLRootNodeGen.Builder b) {
        this.checkForbiddenName(name, op);
        String mangled = this.maybeMangle(name);
        EnumSet<Scope.DefUse> uses = this.scope.getUseOfName(mangled);
        if (uses != null) {
            if (uses.contains((Object)Scope.DefUse.Free)) {
                assert (this.freevars.containsKey(mangled)) : String.format("scope analysis did not mark %s as a free variable", mangled);
                this.emitNameCellOperation(mangled, op, b);
                return;
            }
            if (uses.contains((Object)Scope.DefUse.Cell)) {
                assert (this.cellvars.containsKey(mangled)) : String.format("scope analysis did not mark %s as a cell variable", mangled);
                this.emitNameCellOperation(mangled, op, b);
                return;
            }
            if (uses.contains((Object)Scope.DefUse.Local)) {
                if (this.scope.isFunction()) {
                    assert (this.varnames.containsKey(mangled)) : String.format("scope analysis did not mark %s as a regular variable", mangled);
                    this.emitNameFastOperation(mangled, op, b);
                    return;
                }
            } else if (uses.contains((Object)Scope.DefUse.GlobalImplicit)) {
                if (this.scope.isFunction()) {
                    this.emitNameGlobalOperation(mangled, op, b, true);
                    return;
                }
            } else if (uses.contains((Object)Scope.DefUse.GlobalExplicit)) {
                this.emitNameGlobalOperation(mangled, op, b, false);
                return;
            }
        }
        this.emitNameSlowOperation(mangled, op, b);
    }

    private void emitReadLocal(String name, PBytecodeDSLRootNodeGen.Builder b) {
        this.emitNameOperation(name, NameOperation.Read, b);
    }

    private void emitDelLocal(String name, PBytecodeDSLRootNodeGen.Builder b) {
        this.emitNameOperation(name, NameOperation.Delete, b);
    }

    private void beginStoreLocal(String name, PBytecodeDSLRootNodeGen.Builder b) {
        this.emitNameOperation(name, NameOperation.BeginWrite, b);
    }

    private void endStoreLocal(String name, PBytecodeDSLRootNodeGen.Builder b) {
        this.emitNameOperation(name, NameOperation.EndWrite, b);
    }

    private BytecodeLocal getLocal(String name) {
        return this.locals.get(this.maybeMangle(name));
    }

    public void setUpFrame(ArgumentsTy args, PBytecodeDSLRootNodeGen.Builder b) {
        if (this.scope.isFunction()) {
            String[] regularVariables = RootNodeCompiler.orderedKeys(this.varnames, new String[0]);
            for (int i = 0; i < regularVariables.length; ++i) {
                this.locals.put(regularVariables[i], b.createLocal());
            }
        }
        String[] cellVariables = RootNodeCompiler.orderedKeys(this.cellvars, new String[0]);
        BytecodeLocal[] cellVariableLocals = new BytecodeLocal[cellVariables.length];
        for (int i = 0; i < cellVariables.length; ++i) {
            BytecodeLocal local = b.createLocal();
            this.cellLocals.put(cellVariables[i], local);
            cellVariableLocals[i] = local;
        }
        String[] freeVariables = RootNodeCompiler.orderedKeys(this.freevars, new String[0]);
        BytecodeLocal[] freeVariableLocals = new BytecodeLocal[freeVariables.length];
        for (int i = 0; i < freeVariables.length; ++i) {
            BytecodeLocal local = b.createLocal();
            this.freeLocals.put(freeVariables[i], local);
            freeVariableLocals[i] = local;
        }
        this.copyArguments(args, b);
        if (cellVariableLocals.length > 0) {
            ArrayList<BytecodeLocal> toClear = new ArrayList<BytecodeLocal>();
            b.beginStoreRange(cellVariableLocals);
            b.beginCollectToObjectArray();
            for (int i = 0; i < cellVariableLocals.length; ++i) {
                b.beginCreateCell();
                if (this.scope.getUseOfName(cellVariables[i]).contains((Object)Scope.DefUse.DefParam)) {
                    BytecodeLocal param = this.getLocal(cellVariables[i]);
                    b.emitLoadLocal(param);
                    toClear.add(param);
                } else {
                    b.emitLoadNull();
                }
                b.endCreateCell();
            }
            b.endCollectToObjectArray();
            b.endStoreRange();
            for (BytecodeLocal local : toClear) {
                b.emitClearLocal(local);
            }
        }
        if (freeVariableLocals.length > 0) {
            b.beginStoreRange(freeVariableLocals);
            b.emitLoadClosure();
            b.endStoreRange();
        }
    }

    private void copyArguments(ArgumentsTy args, PBytecodeDSLRootNodeGen.Builder b) {
        BytecodeLocal local;
        int i;
        if (args == null) {
            return;
        }
        int argIdx = 9;
        if (args.posOnlyArgs != null) {
            for (i = 0; i < args.posOnlyArgs.length; ++i) {
                local = this.getLocal(args.posOnlyArgs[i].arg);
                assert (local != null);
                b.beginStoreLocal(local);
                b.emitLoadArgument(argIdx++);
                b.endStoreLocal();
            }
        }
        if (args.args != null) {
            for (i = 0; i < args.args.length; ++i) {
                local = this.getLocal(args.args[i].arg);
                assert (local != null);
                b.beginStoreLocal(local);
                b.emitLoadArgument(argIdx++);
                b.endStoreLocal();
            }
        }
        if (args.kwOnlyArgs != null) {
            for (i = 0; i < args.kwOnlyArgs.length; ++i) {
                local = this.getLocal(args.kwOnlyArgs[i].arg);
                assert (local != null);
                b.beginStoreLocal(local);
                b.emitLoadArgument(argIdx++);
                b.endStoreLocal();
            }
        }
        if (args.varArg != null) {
            BytecodeLocal local2 = this.getLocal(args.varArg.arg);
            assert (local2 != null);
            b.beginStoreLocal(local2);
            b.emitLoadVariableArguments();
            b.endStoreLocal();
        }
        if (args.kwArg != null) {
            BytecodeLocal local3 = this.getLocal(args.kwArg.arg);
            assert (local3 != null);
            b.beginStoreLocal(local3);
            b.emitLoadKeywordArguments();
            b.endStoreLocal();
        }
    }

    private static class ArgumentInfo {
        static final ArgumentInfo NO_ARGS = new ArgumentInfo(0, 0, 0, false, false);
        final int argCount;
        final int positionalOnlyArgCount;
        final int kwOnlyArgCount;
        final boolean takesVarArgs;
        final boolean takesVarKeywordArgs;

        ArgumentInfo(int argCount, int positionalOnlyArgCount, int kwOnlyArgCount, boolean takesVarArgs, boolean takesVarKeywordArgs) {
            this.argCount = argCount;
            this.positionalOnlyArgCount = positionalOnlyArgCount;
            this.kwOnlyArgCount = kwOnlyArgCount;
            this.takesVarArgs = takesVarArgs;
            this.takesVarKeywordArgs = takesVarKeywordArgs;
        }

        static ArgumentInfo fromArguments(ArgumentsTy args) {
            boolean splat;
            boolean kwSplat;
            int argc;
            int pargc;
            int kwargc;
            if (args == null) {
                kwargc = 0;
                pargc = 0;
                argc = 0;
                kwSplat = false;
                splat = false;
            } else {
                argc = args.args == null ? 0 : args.args.length;
                pargc = args.posOnlyArgs == null ? 0 : args.posOnlyArgs.length;
                kwargc = args.kwOnlyArgs == null ? 0 : args.kwOnlyArgs.length;
                splat = args.varArg != null;
                kwSplat = args.kwArg != null;
            }
            return new ArgumentInfo(argc, pargc, kwargc, splat, kwSplat);
        }

        private boolean nonEmpty() {
            return this.argCount + this.positionalOnlyArgCount + this.kwOnlyArgCount > 0 || this.takesVarArgs || this.takesVarKeywordArgs;
        }
    }

    static enum NameOperation {
        Read,
        BeginWrite,
        EndWrite,
        Delete;

    }

    private static final class ParamAnnotation {
        final TruffleString name;
        final ExprTy annotation;

        ParamAnnotation(TruffleString name, ExprTy annotation) {
            this.name = name;
            this.annotation = annotation;
        }
    }

    public class StatementCompiler
    implements BaseBytecodeDSLVisitor<Void> {
        private final PBytecodeDSLRootNodeGen.Builder b;
        private BytecodeLabel breakLabel;
        private BytecodeLabel continueLabel;
        private static final int NUM_ARGS_MAX_FIXED = 4;

        public StatementCompiler(PBytecodeDSLRootNodeGen.Builder b) {
            this.b = b;
        }

        @Override
        public Void visit(AliasTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(ArgTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(ArgumentsTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(ComprehensionTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(ExprTy.Attribute node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            RootNodeCompiler.this.beginGetAttribute(node.attr, this.b);
            node.value.accept(this);
            this.b.endGetAttribute();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Await node) {
            if (!RootNodeCompiler.this.scope.isFunction()) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'await' outside function");
            }
            if (RootNodeCompiler.this.scopeType != CompilationScope.AsyncFunction && RootNodeCompiler.this.scopeType != CompilationScope.Comprehension) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'await' outside async function");
            }
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.emitAwait(() -> node.value.accept(this));
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.BinOp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            switch (node.op) {
                case Add: {
                    this.b.beginPyNumberAdd();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberAdd();
                    break;
                }
                case BitAnd: {
                    this.b.beginPyNumberAnd();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberAnd();
                    break;
                }
                case BitOr: {
                    this.b.beginPyNumberOr();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberOr();
                    break;
                }
                case BitXor: {
                    this.b.beginPyNumberXor();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberXor();
                    break;
                }
                case Div: {
                    this.b.beginPyNumberTrueDivide();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberTrueDivide();
                    break;
                }
                case FloorDiv: {
                    this.b.beginPyNumberFloorDivide();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberFloorDivide();
                    break;
                }
                case LShift: {
                    this.b.beginPyNumberLshift();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberLshift();
                    break;
                }
                case MatMult: {
                    this.b.beginPyNumberMatrixMultiply();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberMatrixMultiply();
                    break;
                }
                case Mod: {
                    this.b.beginPyNumberRemainder();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberRemainder();
                    break;
                }
                case Mult: {
                    this.b.beginPyNumberMultiply();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberMultiply();
                    break;
                }
                case Pow: {
                    this.b.beginPow();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPow();
                    break;
                }
                case RShift: {
                    this.b.beginPyNumberRshift();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberRshift();
                    break;
                }
                case Sub: {
                    this.b.beginPyNumberSubtract();
                    node.left.accept(this);
                    node.right.accept(this);
                    this.b.endPyNumberSubtract();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf(node.getClass()));
                }
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.BoolOp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (node.op == BoolOpTy.And) {
                this.b.beginBoolAnd();
            } else {
                this.b.beginBoolOr();
            }
            this.visitSequence(node.values);
            if (node.op == BoolOpTy.And) {
                this.b.endBoolAnd();
            } else {
                this.b.endBoolOr();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private static boolean anyIsStarred(SSTNode[] nodes) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof ExprTy.Starred)) continue;
                return true;
            }
            return false;
        }

        protected final void validateKeywords(KeywordTy[] keywords) {
            for (int i = 0; i < keywords.length; ++i) {
                if (keywords[i].arg == null) continue;
                RootNodeCompiler.this.checkForbiddenName(keywords[i].arg, NameOperation.BeginWrite);
                for (int j = i + 1; j < keywords.length; ++j) {
                    if (!keywords[i].arg.equals(keywords[j].arg)) continue;
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "keyword argument repeated: " + keywords[i].arg);
                }
            }
        }

        private static boolean isAttributeLoad(ExprTy node) {
            return node instanceof ExprTy.Attribute && ((ExprTy.Attribute)node).context == ExprContextTy.Load;
        }

        private void beginCallNAry(int numArgs) {
            assert (numArgs <= 4);
            switch (numArgs) {
                case 0: {
                    this.b.beginCallNilaryMethod();
                    break;
                }
                case 1: {
                    this.b.beginCallUnaryMethod();
                    break;
                }
                case 2: {
                    this.b.beginCallBinaryMethod();
                    break;
                }
                case 3: {
                    this.b.beginCallTernaryMethod();
                    break;
                }
                case 4: {
                    this.b.beginCallQuaternaryMethod();
                }
            }
        }

        private void endCallNAry(int numArgs) {
            assert (numArgs <= 4);
            switch (numArgs) {
                case 0: {
                    this.b.endCallNilaryMethod();
                    break;
                }
                case 1: {
                    this.b.endCallUnaryMethod();
                    break;
                }
                case 2: {
                    this.b.endCallBinaryMethod();
                    break;
                }
                case 3: {
                    this.b.endCallTernaryMethod();
                    break;
                }
                case 4: {
                    this.b.endCallQuaternaryMethod();
                }
            }
        }

        private void emitCall(ExprTy func, ExprTy[] args, KeywordTy[] keywords) {
            boolean useVariadic;
            this.validateKeywords(keywords);
            boolean isMethodCall = StatementCompiler.isAttributeLoad(func) && keywords.length == 0;
            int numArgs = BytecodeDSLCompilerUtils.len(args) + (isMethodCall ? 1 : 0);
            boolean bl = useVariadic = StatementCompiler.anyIsStarred(args) || BytecodeDSLCompilerUtils.len(keywords) > 0 || numArgs > 4;
            if (useVariadic) {
                this.b.beginCallVarargsMethod();
            } else {
                this.beginCallNAry(numArgs);
            }
            if (isMethodCall) {
                BytecodeLocal receiver = this.b.createLocal();
                if (useVariadic) {
                    BytecodeLocal function = this.b.createLocal();
                    this.b.beginBlock();
                    this.b.beginStoreLocal(function);
                    this.emitGetMethod(func, receiver);
                    this.b.endStoreLocal();
                    this.b.emitLoadLocal(function);
                    this.b.endBlock();
                    this.emitUnstar(() -> this.b.emitLoadLocal(receiver), args);
                    this.emitKeywords(keywords, function);
                } else {
                    assert (BytecodeDSLCompilerUtils.len(keywords) == 0);
                    this.emitGetMethod(func, receiver);
                    this.b.emitLoadLocal(receiver);
                    this.visitSequence(args);
                }
            } else if (useVariadic) {
                BytecodeLocal function = this.b.createLocal();
                this.b.beginBlock();
                this.b.beginStoreLocal(function);
                func.accept(this);
                this.b.endStoreLocal();
                this.b.emitLoadLocal(function);
                this.b.endBlock();
                this.emitUnstar(args);
                this.emitKeywords(keywords, function);
            } else {
                assert (BytecodeDSLCompilerUtils.len(keywords) == 0);
                func.accept(this);
                this.visitSequence(args);
            }
            if (useVariadic) {
                this.b.endCallVarargsMethod();
            } else {
                this.endCallNAry(numArgs);
            }
        }

        private void emitGetMethod(ExprTy func, BytecodeLocal receiver) {
            assert (StatementCompiler.isAttributeLoad(func));
            ExprTy.Attribute attrAccess = (ExprTy.Attribute)func;
            this.b.beginBlock();
            this.b.beginStoreLocal(receiver);
            attrAccess.value.accept(this);
            this.b.endStoreLocal();
            String mangled = RootNodeCompiler.this.maybeMangle(attrAccess.attr);
            this.b.beginGetMethod(PythonUtils.toTruffleStringUncached(mangled));
            this.b.emitLoadLocal(receiver);
            this.b.endGetMethod();
            this.b.endBlock();
        }

        @Override
        public Void visit(ExprTy.Call node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            SSTUtils.checkCaller(RootNodeCompiler.this.ctx.errorCallback, node.func);
            this.emitCall(node.func, node.args, node.keywords);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void beginComparison(CmpOpTy op) {
            switch (op) {
                case Eq: {
                    this.b.beginEq();
                    break;
                }
                case NotEq: {
                    this.b.beginNe();
                    break;
                }
                case Lt: {
                    this.b.beginLt();
                    break;
                }
                case LtE: {
                    this.b.beginLe();
                    break;
                }
                case Gt: {
                    this.b.beginGt();
                    break;
                }
                case GtE: {
                    this.b.beginGe();
                    break;
                }
                case Is: {
                    this.b.beginIs();
                    break;
                }
                case IsNot: {
                    this.b.beginNot();
                    this.b.beginIs();
                    break;
                }
                case In: {
                    this.b.beginContains();
                    break;
                }
                case NotIn: {
                    this.b.beginNot();
                    this.b.beginContains();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf((Object)op));
                }
            }
        }

        private void endComparison(CmpOpTy op) {
            switch (op) {
                case Eq: {
                    this.b.endEq();
                    break;
                }
                case NotEq: {
                    this.b.endNe();
                    break;
                }
                case Lt: {
                    this.b.endLt();
                    break;
                }
                case LtE: {
                    this.b.endLe();
                    break;
                }
                case Gt: {
                    this.b.endGt();
                    break;
                }
                case GtE: {
                    this.b.endGe();
                    break;
                }
                case Is: {
                    this.b.endIs();
                    break;
                }
                case IsNot: {
                    this.b.endIs();
                    this.b.endNot();
                    break;
                }
                case In: {
                    this.b.endContains();
                    break;
                }
                case NotIn: {
                    this.b.endContains();
                    this.b.endNot();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf((Object)op));
                }
            }
        }

        @Override
        public Void visit(ExprTy.Compare node) {
            boolean multipleComparisons;
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            SSTUtils.checkCompare(RootNodeCompiler.this.ctx.errorCallback, node);
            boolean bl = multipleComparisons = node.comparators.length > 1;
            if (multipleComparisons) {
                this.b.beginBoolAnd();
            }
            BytecodeLocal tmp = this.b.createLocal();
            for (int i = 0; i < node.comparators.length; ++i) {
                this.beginComparison(node.ops[i]);
                if (i == 0) {
                    node.left.accept(this);
                } else {
                    this.b.emitLoadLocal(tmp);
                }
                if (i != node.comparators.length - 1) {
                    this.b.beginTeeLocal(tmp);
                }
                node.comparators[i].accept(this);
                if (i != node.comparators.length - 1) {
                    this.b.endTeeLocal();
                }
                this.endComparison(node.ops[i]);
            }
            if (multipleComparisons) {
                this.b.endBoolAnd();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void warn(SSTNode node, String message, Object ... arguments) {
            RootNodeCompiler.this.ctx.errorCallback.onWarning(ParserCallbacks.WarningType.Syntax, node.getSourceRange(), message, arguments);
        }

        private void createConstant(ConstantValue value) {
            switch (value.kind) {
                case NONE: {
                    this.b.emitLoadConstant(PNone.NONE);
                    break;
                }
                case ELLIPSIS: {
                    this.b.emitLoadConstant(PEllipsis.INSTANCE);
                    break;
                }
                case BOOLEAN: {
                    RootNodeCompiler.this.emitPythonConstant(value.getBoolean(), this.b);
                    break;
                }
                case LONG: {
                    RootNodeCompiler.this.emitPythonConstant(this.getConstantNumber(value.getLong()), this.b);
                    break;
                }
                case DOUBLE: {
                    RootNodeCompiler.this.emitPythonConstant(value.getDouble(), this.b);
                    break;
                }
                case COMPLEX: {
                    double[] complex = value.getComplex();
                    RootNodeCompiler.this.addConstant(complex);
                    this.b.emitLoadComplex(complex[0], complex[1]);
                    break;
                }
                case BIGINTEGER: {
                    RootNodeCompiler.this.addConstant(value.getBigInteger());
                    this.b.emitLoadBigInt(value.getBigInteger());
                    break;
                }
                case CODEPOINTS: {
                    RootNodeCompiler.this.emitPythonConstant(PythonUtils.codePointsToTruffleString(value.getCodePoints()), this.b);
                    break;
                }
                case BYTES: {
                    RootNodeCompiler.this.addConstant(value.getBytes());
                    this.b.emitLoadBytes(value.getBytes());
                    break;
                }
                case TUPLE: {
                    this.b.beginMakeTuple();
                    this.b.beginCollectToObjectArray();
                    for (ConstantValue cv : value.getTupleElements()) {
                        this.createConstant(cv);
                    }
                    this.b.endCollectToObjectArray();
                    this.b.endMakeTuple();
                    break;
                }
                case FROZENSET: {
                    this.b.beginMakeFrozenSet();
                    for (ConstantValue cv : value.getFrozensetElements()) {
                        this.createConstant(cv);
                    }
                    this.b.endMakeFrozenSet();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not supported: " + String.valueOf((Object)value.kind));
                }
            }
        }

        private Object getConstantNumber(long value) {
            if (value == (long)((int)value)) {
                return (int)value;
            }
            return value;
        }

        @Override
        public Void visit(ExprTy.Constant node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.createConstant(node.value);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Dict node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (BytecodeDSLCompilerUtils.len(node.keys) == 0) {
                this.b.beginMakeDict(0);
                this.b.endMakeDict();
            } else {
                this.b.beginMakeDict(node.keys.length);
                for (int i = 0; i < node.keys.length; ++i) {
                    if (node.keys[i] == null) {
                        this.b.emitLoadConstant(PNone.NO_VALUE);
                    } else {
                        node.keys[i].accept(this);
                    }
                    node.values[i].accept(this);
                }
                this.b.endMakeDict();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.DictComp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginCallUnaryMethod();
            this.emitMakeFunction(node, "<dictcomp>", BytecodeDSLCompilerUtils.COMPREHENSION_ARGS);
            node.generators[0].iter.accept(this);
            this.b.endCallUnaryMethod();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.FormattedValue node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginFormat();
            switch (node.conversion) {
                case 115: {
                    this.b.beginFormatStr();
                    break;
                }
                case 114: {
                    this.b.beginFormatRepr();
                    break;
                }
                case 97: {
                    this.b.beginFormatAscii();
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown conversion: " + node.conversion);
                }
            }
            node.value.accept(this);
            switch (node.conversion) {
                case 115: {
                    this.b.endFormatStr();
                    break;
                }
                case 114: {
                    this.b.endFormatRepr();
                    break;
                }
                case 97: {
                    this.b.endFormatAscii();
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown conversion: " + node.conversion);
                }
            }
            if (node.formatSpec != null) {
                node.formatSpec.accept(this);
            } else {
                this.b.emitLoadConstant(StringLiterals.T_EMPTY_STRING);
            }
            this.b.endFormat();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.GeneratorExp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginCallUnaryMethod();
            this.emitMakeFunction(node, "<genexpr>", BytecodeDSLCompilerUtils.COMPREHENSION_ARGS);
            node.generators[0].iter.accept(this);
            this.b.endCallUnaryMethod();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.IfExp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginConditional();
            this.visitCondition(node.test);
            node.body.accept(this);
            node.orElse.accept(this);
            this.b.endConditional();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.JoinedStr node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (node.values.length == 1) {
                node.values[0].accept(this);
            } else {
                this.b.beginBuildString(node.values.length);
                this.visitSequence(node.values);
                this.b.endBuildString();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Lambda node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.emitMakeFunction(node, "<lambda>", node.args);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.List node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            Compiler.ConstantCollection constantCollection = Compiler.tryCollectConstantCollection(node.elements);
            if (constantCollection != null) {
                this.emitConstantList(constantCollection);
            } else {
                this.b.beginMakeList();
                this.emitUnstar(node.elements);
                this.b.endMakeList();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.ListComp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginCallUnaryMethod();
            this.emitMakeFunction(node, "<listcomp>", BytecodeDSLCompilerUtils.COMPREHENSION_ARGS);
            node.generators[0].iter.accept(this);
            this.b.endCallUnaryMethod();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Name node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            RootNodeCompiler.this.emitReadLocal(node.id, this.b);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.NamedExpr node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            BytecodeLocal tmp = this.b.createLocal();
            this.b.beginStoreLocal(tmp);
            node.value.accept(this);
            this.b.endStoreLocal();
            node.target.accept(new StoreVisitor(() -> this.b.emitLoadLocal(tmp)));
            this.b.emitLoadLocal(tmp);
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void emitConstantList(Compiler.ConstantCollection constantCollection) {
            RootNodeCompiler.this.addConstant(constantCollection.collection);
            switch (constantCollection.elementType) {
                case 1: {
                    this.b.emitMakeConstantIntList((int[])constantCollection.collection);
                    break;
                }
                case 2: {
                    this.b.emitMakeConstantLongList((long[])constantCollection.collection);
                    break;
                }
                case 3: {
                    this.b.emitMakeConstantBooleanList((boolean[])constantCollection.collection);
                    break;
                }
                case 4: {
                    this.b.emitMakeConstantDoubleList((double[])constantCollection.collection);
                    break;
                }
                case 5: {
                    this.b.emitMakeConstantObjectList((Object[])constantCollection.collection);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        private void emitConstantTuple(Compiler.ConstantCollection constantCollection) {
            RootNodeCompiler.this.addConstant(constantCollection.collection);
            switch (constantCollection.elementType) {
                case 1: {
                    this.b.emitMakeConstantIntTuple((int[])constantCollection.collection);
                    break;
                }
                case 2: {
                    this.b.emitMakeConstantLongTuple((long[])constantCollection.collection);
                    break;
                }
                case 3: {
                    this.b.emitMakeConstantBooleanTuple((boolean[])constantCollection.collection);
                    break;
                }
                case 4: {
                    this.b.emitMakeConstantDoubleTuple((double[])constantCollection.collection);
                    break;
                }
                case 5: {
                    this.b.emitMakeConstantObjectTuple((Object[])constantCollection.collection);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        private void emitUnstar(ExprTy[] args) {
            this.emitUnstar(null, args);
        }

        private void emitUnstar(Runnable initialElementsProducer, ExprTy[] args) {
            this.emitUnstar(initialElementsProducer, args, null);
        }

        private void emitUnstar(Runnable initialElementsProducer, ExprTy[] args, Runnable finalElementsProducer) {
            boolean noExtraElements;
            boolean bl = noExtraElements = initialElementsProducer == null && finalElementsProducer == null;
            if (noExtraElements && BytecodeDSLCompilerUtils.len(args) == 0) {
                this.b.emitLoadConstant(PythonUtils.EMPTY_OBJECT_ARRAY);
            } else if (noExtraElements && BytecodeDSLCompilerUtils.len(args) == 1 && args[0] instanceof ExprTy.Starred) {
                this.b.beginUnpackStarred();
                ((ExprTy.Starred)args[0]).value.accept(this);
                this.b.endUnpackStarred();
            } else if (StatementCompiler.anyIsStarred(args)) {
                this.b.beginUnstar();
                boolean inVariadic = false;
                int numOperands = 0;
                if (initialElementsProducer != null) {
                    this.b.beginCollectToObjectArray();
                    initialElementsProducer.run();
                    inVariadic = true;
                }
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] instanceof ExprTy.Starred) {
                        if (inVariadic) {
                            this.b.endCollectToObjectArray();
                            inVariadic = false;
                            ++numOperands;
                        }
                        this.b.beginUnpackStarred();
                        ((ExprTy.Starred)args[i]).value.accept(this);
                        this.b.endUnpackStarred();
                        ++numOperands;
                        continue;
                    }
                    if (!inVariadic) {
                        this.b.beginCollectToObjectArray();
                        inVariadic = true;
                    }
                    args[i].accept(this);
                }
                if (finalElementsProducer != null) {
                    if (!inVariadic) {
                        this.b.beginCollectToObjectArray();
                        inVariadic = true;
                    }
                    finalElementsProducer.run();
                }
                if (inVariadic) {
                    this.b.endCollectToObjectArray();
                    ++numOperands;
                }
                this.b.endUnstar(numOperands);
            } else {
                this.b.beginCollectToObjectArray();
                if (initialElementsProducer != null) {
                    initialElementsProducer.run();
                }
                this.visitSequence(args);
                if (finalElementsProducer != null) {
                    finalElementsProducer.run();
                }
                this.b.endCollectToObjectArray();
            }
        }

        @Override
        public Void visit(ExprTy.Set node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginMakeSet();
            if (BytecodeDSLCompilerUtils.len(node.elements) == 0) {
                this.b.emitLoadConstant(PythonUtils.EMPTY_OBJECT_ARRAY);
            } else {
                this.emitUnstar(node.elements);
            }
            this.b.endMakeSet();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.SetComp node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginCallUnaryMethod();
            this.emitMakeFunction(node, "<setcomp>", BytecodeDSLCompilerUtils.COMPREHENSION_ARGS);
            node.generators[0].iter.accept(this);
            this.b.endCallUnaryMethod();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void visitNoneable(ExprTy node) {
            if (node == null) {
                this.b.emitLoadConstant(PNone.NONE);
            } else {
                node.accept(this);
            }
        }

        @Override
        public Void visit(ExprTy.Slice node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginMakeSlice();
            this.visitNoneable(node.lower);
            this.visitNoneable(node.upper);
            this.visitNoneable(node.step);
            this.b.endMakeSlice();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Starred node) {
            throw RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "can't use starred expression here");
        }

        @Override
        public Void visit(ExprTy.Subscript node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (node.context == ExprContextTy.Load) {
                SSTUtils.checkSubscripter(RootNodeCompiler.this.ctx.errorCallback, node.value);
                SSTUtils.checkIndex(RootNodeCompiler.this.ctx.errorCallback, node.value, node.slice);
            }
            this.b.beginBinarySubscript();
            node.value.accept(this);
            node.slice.accept(this);
            this.b.endBinarySubscript();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Tuple node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            Compiler.ConstantCollection constantCollection = Compiler.tryCollectConstantCollection(node.elements);
            if (constantCollection != null) {
                this.emitConstantTuple(constantCollection);
            } else {
                this.b.beginMakeTuple();
                this.emitUnstar(node.elements);
                this.b.endMakeTuple();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.UnaryOp node) {
            ExprTy exprTy;
            if (node.op == UnaryOpTy.USub && (exprTy = node.operand) instanceof ExprTy.Constant) {
                ExprTy.Constant c = (ExprTy.Constant)exprTy;
                if (c.value.kind == ConstantValue.Kind.BIGINTEGER || c.value.kind == ConstantValue.Kind.DOUBLE || c.value.kind == ConstantValue.Kind.LONG || c.value.kind == ConstantValue.Kind.COMPLEX) {
                    ConstantValue cv = c.value.negate();
                    boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                    this.visit(new ExprTy.Constant(cv, null, c.getSourceRange()));
                    RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                    return null;
                }
            }
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            switch (node.op) {
                case UAdd: {
                    this.b.beginPyNumberPositive();
                    node.operand.accept(this);
                    this.b.endPyNumberPositive();
                    break;
                }
                case Invert: {
                    this.b.beginPyNumberInvert();
                    node.operand.accept(this);
                    this.b.endPyNumberInvert();
                    break;
                }
                case USub: {
                    this.b.beginPyNumberNegative();
                    node.operand.accept(this);
                    this.b.endPyNumberNegative();
                    break;
                }
                case Not: {
                    this.b.beginNot();
                    node.operand.accept(this);
                    this.b.endNot();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf(node.getClass()));
                }
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.Yield node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (!RootNodeCompiler.this.scope.isFunction()) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'yield' outside function");
            }
            RootNodeCompiler.emitYield(statementCompiler -> {
                if (node.value != null) {
                    node.value.accept(this);
                } else {
                    statementCompiler.b.emitLoadConstant(PNone.NONE);
                }
            }, this);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(ExprTy.YieldFrom node) {
            if (!RootNodeCompiler.this.scope.isFunction()) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'yield from' outside function");
            }
            if (RootNodeCompiler.this.scopeType == CompilationScope.AsyncFunction) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'yield from' inside async function");
            }
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.emitYieldFrom(() -> {
                this.b.beginGetYieldFromIter();
                node.value.accept(this);
                this.b.endGetYieldFromIter();
            });
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        public void emitYieldFrom(Runnable generatorOrCoroutineProducer) {
            this.b.beginBlock();
            BytecodeLocal generator = this.b.createLocal();
            BytecodeLocal returnValue = this.b.createLocal();
            BytecodeLocal sentValue = this.b.createLocal();
            BytecodeLocal yieldValue = this.b.createLocal();
            BytecodeLabel end = this.b.createLabel();
            this.b.beginStoreLocal(generator);
            generatorOrCoroutineProducer.run();
            this.b.endStoreLocal();
            this.b.beginStoreLocal(returnValue);
            this.b.emitLoadConstant(PNone.NONE);
            this.b.endStoreLocal();
            this.b.beginStoreLocal(sentValue);
            this.b.emitLoadConstant(PNone.NONE);
            this.b.endStoreLocal();
            this.emitSend(generator, sentValue, yieldValue, returnValue, end);
            this.b.beginWhile();
            this.b.emitLoadConstant(true);
            this.b.beginBlock();
            BytecodeLabel loopEnd = this.b.createLabel();
            this.b.beginTryCatch();
            this.b.beginStoreLocal(sentValue);
            RootNodeCompiler.emitYield(statementCompiler -> statementCompiler.b.emitLoadLocal(yieldValue), this);
            this.b.endStoreLocal();
            this.b.beginIfThenElse();
            this.b.beginYieldFromThrow(yieldValue, returnValue);
            this.b.emitLoadLocal(generator);
            this.b.emitLoadException();
            this.b.endYieldFromThrow();
            this.b.emitBranch(end);
            this.b.emitBranch(loopEnd);
            this.b.endIfThenElse();
            this.b.endTryCatch();
            this.emitSend(generator, sentValue, yieldValue, returnValue, end);
            this.b.emitLabel(loopEnd);
            this.b.endBlock();
            this.b.endWhile();
            this.b.emitLabel(end);
            this.b.emitLoadLocal(returnValue);
            this.b.endBlock();
        }

        private void emitSend(BytecodeLocal generator, BytecodeLocal sentValue, BytecodeLocal yieldValue, BytecodeLocal returnValue, BytecodeLabel end) {
            this.b.beginIfThen();
            this.b.beginYieldFromSend(yieldValue, returnValue);
            this.b.emitLoadLocal(generator);
            this.b.emitLoadLocal(sentValue);
            this.b.endYieldFromSend();
            this.b.emitBranch(end);
            this.b.endIfThen();
        }

        private void emitAwait(Runnable producer) {
            this.emitYieldFrom(() -> {
                this.b.beginGetAwaitable();
                producer.run();
                this.b.endGetAwaitable();
            });
        }

        @Override
        public Void visit(KeywordTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(StmtTy.AnnAssign node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            if (node.value != null) {
                this.emitAssignment(new ExprTy[]{node.target}, node.value);
            }
            if (node.target instanceof ExprTy.Name) {
                String name = ((ExprTy.Name)node.target).id;
                RootNodeCompiler.this.checkForbiddenName(name, NameOperation.BeginWrite);
                if (node.isSimple && (RootNodeCompiler.this.scopeType == CompilationScope.Module || RootNodeCompiler.this.scopeType == CompilationScope.Class)) {
                    this.b.beginSetItem();
                    if (RootNodeCompiler.this.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS)) {
                        RootNodeCompiler.this.emitPythonConstant(Unparser.unparse(node.annotation), this.b);
                    } else {
                        node.annotation.accept(this);
                    }
                    RootNodeCompiler.this.emitNameOperation("__annotations__", NameOperation.Read, this.b);
                    String mangled = RootNodeCompiler.this.maybeMangle(name);
                    RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(mangled), this.b);
                    this.b.endSetItem();
                }
            } else if (node.target instanceof ExprTy.Attribute) {
                if (node.value == null) {
                    ExprTy.Attribute attr = (ExprTy.Attribute)node.target;
                    RootNodeCompiler.this.checkForbiddenName(attr.attr, NameOperation.BeginWrite);
                    if (attr.value != null) {
                        this.checkAnnExpr(attr.value);
                    }
                }
            } else if (node.target instanceof ExprTy.Subscript) {
                if (node.value == null) {
                    ExprTy.Subscript subscript = (ExprTy.Subscript)node.target;
                    if (subscript.value != null) {
                        this.checkAnnExpr(subscript.value);
                    }
                    this.checkAnnSubscr(subscript.slice);
                }
            } else {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "invalid node type for annotated assignment");
            }
            if (!(node.isSimple || RootNodeCompiler.this.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS) || RootNodeCompiler.this.scopeType != CompilationScope.Module && RootNodeCompiler.this.scopeType != CompilationScope.Class)) {
                this.checkAnnExpr(node.annotation);
            }
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void checkAnnExpr(ExprTy expr) {
            expr.accept(this);
        }

        private void checkAnnSubscr(ExprTy expr) {
            if (expr instanceof ExprTy.Slice) {
                ExprTy.Slice slice = (ExprTy.Slice)expr;
                if (slice.lower != null) {
                    this.checkAnnExpr(slice.lower);
                }
                if (slice.upper != null) {
                    this.checkAnnExpr(slice.upper);
                }
                if (slice.step != null) {
                    this.checkAnnExpr(slice.step);
                }
            } else if (expr instanceof ExprTy.Tuple) {
                ExprTy.Tuple tuple = (ExprTy.Tuple)expr;
                for (int i = 0; i < tuple.elements.length; ++i) {
                    this.checkAnnSubscr(tuple.elements[i]);
                }
            } else {
                this.checkAnnExpr(expr);
            }
        }

        @Override
        public Void visit(StmtTy.Assert node) {
            if (RootNodeCompiler.this.ctx.optimizationLevel <= 0) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                this.b.beginIfThen();
                this.b.beginNot();
                node.test.accept(this);
                this.b.endNot();
                this.b.beginAssertFailed();
                if (node.msg == null) {
                    this.b.emitLoadConstant(PNone.NO_VALUE);
                } else {
                    node.msg.accept(this);
                }
                this.b.endAssertFailed();
                this.b.endIfThen();
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            }
            return null;
        }

        public void visitTypeParams(TypeParamTy[] typeParams) {
            boolean useList;
            boolean bl = useList = typeParams.length > 31;
            if (useList) {
                this.b.beginMakeList();
            } else {
                this.b.beginMakeTuple();
            }
            this.b.beginCollectToObjectArray();
            for (TypeParamTy typeParam : typeParams) {
                typeParam.accept(this);
            }
            this.b.endCollectToObjectArray();
            if (useList) {
                this.b.endMakeList();
            } else {
                this.b.endMakeTuple();
            }
        }

        @Override
        public Void visit(StmtTy.Assign node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            this.emitAssignment(node.targets, node.value);
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void emitAssignment(ExprTy[] targets, ExprTy value) {
            if (targets.length == 1) {
                targets[0].accept(new StoreVisitor(() -> value.accept(this)));
            } else {
                BytecodeLocal tmp = this.b.createLocal();
                this.b.beginStoreLocal(tmp);
                value.accept(this);
                this.b.endStoreLocal();
                for (ExprTy target : targets) {
                    target.accept(new StoreVisitor(() -> this.b.emitLoadLocal(tmp)));
                }
            }
        }

        @Override
        public Void visit(StmtTy.AsyncFor node) {
            RootNodeCompiler.this.emitNotImplemented("async for", this.b);
            return null;
        }

        @Override
        public Void visit(StmtTy.AsyncWith node) {
            if (!RootNodeCompiler.this.scope.isFunction()) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'async with' outside function");
            }
            if (RootNodeCompiler.this.scopeType != CompilationScope.AsyncFunction && RootNodeCompiler.this.scopeType != CompilationScope.Comprehension) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'async with' outside async function");
            }
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.visitWithRecurse(node.items, 0, node.body, true);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.AugAssign node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            node.target.accept(new AugStoreVisitor(node.op, node.value));
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void emitKeywords(KeywordTy[] kws, BytecodeLocal function) {
            if (BytecodeDSLCompilerUtils.len(kws) == 0) {
                this.b.emitLoadConstant(PKeyword.EMPTY_KEYWORDS);
            } else {
                KeywordGroup[] groups = this.partitionKeywords(kws);
                this.b.beginMappingToKeywords();
                this.emitKeywordsRecursive(groups, groups.length - 1, function);
                this.b.endMappingToKeywords();
            }
        }

        private KeywordGroup[] partitionKeywords(KeywordTy[] kws) {
            ArrayList<KeywordGroup> groups = new ArrayList<KeywordGroup>();
            int i = 0;
            while (i < kws.length) {
                if (kws[i].arg == null) {
                    groups.add(new SplatKeywords(kws[i].value));
                    ++i;
                    continue;
                }
                ArrayList<TruffleString> kwNames = new ArrayList<TruffleString>();
                ArrayList<ExprTy> kwValues = new ArrayList<ExprTy>();
                while (i < kws.length && kws[i].arg != null) {
                    kwNames.add(PythonUtils.toTruffleStringUncached(kws[i].arg));
                    kwValues.add(kws[i].value);
                    ++i;
                }
                groups.add(new NamedKeywords(kwNames, kwValues));
            }
            return (KeywordGroup[])groups.toArray(KeywordGroup[]::new);
        }

        private void emitKeywordsRecursive(KeywordGroup[] groups, int i, BytecodeLocal function) {
            if (i == 0) {
                this.emitKeywordGroup(groups[i], true, function);
            } else {
                this.b.beginKwargsMerge(function);
                this.emitKeywordsRecursive(groups, i - 1, function);
                this.emitKeywordGroup(groups[i], false, function);
                this.b.endKwargsMerge();
            }
        }

        private void emitKeywordGroup(KeywordGroup group, boolean copy, BytecodeLocal function) {
            if (group instanceof NamedKeywords) {
                NamedKeywords namedKeywords = (NamedKeywords)group;
                this.b.beginMakeDict(namedKeywords.names.size());
                for (int i = 0; i < namedKeywords.names.size(); ++i) {
                    RootNodeCompiler.this.emitPythonConstant(namedKeywords.names.get(i), this.b);
                    namedKeywords.values.get(i).accept(this);
                }
                this.b.endMakeDict();
            } else {
                SplatKeywords splatKeywords = (SplatKeywords)group;
                if (copy) {
                    this.b.beginKwargsMerge(function);
                    this.b.beginMakeDict(0);
                    this.b.endMakeDict();
                    splatKeywords.expr.accept(this);
                    this.b.endKwargsMerge();
                } else {
                    splatKeywords.expr.accept(this);
                }
            }
        }

        @Override
        public Void visit(StmtTy.ClassDef node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            BytecodeLocal[] decoratorsLocals = this.evaluateDecorators(node.decoratorList);
            RootNodeCompiler.this.beginStoreLocal(node.name, this.b);
            this.beginWrapWithDecorators(decoratorsLocals);
            if (node.isGeneric()) {
                RootNodeCompiler typeParamsCompiler = new RootNodeCompiler(RootNodeCompiler.this.ctx, RootNodeCompiler.this, node.name, node, node.typeParams, RootNodeCompiler.this.futureFeatures);
                RootNodeCompiler classBodyCompiler = this.createRootNodeCompilerFor(node, typeParamsCompiler);
                BytecodeDSLCompiler.BytecodeDSLCompilerResult classBody = classBodyCompiler.compileClassDefBody(node);
                BytecodeDSLCompiler.BytecodeDSLCompilerResult typeParamsFun = typeParamsCompiler.compileClassTypeParams(node, classBody.codeUnit());
                this.b.beginCallNilaryMethod();
                String typeParamsName = "<generic parameters of " + node.name + ">";
                this.emitMakeFunction(typeParamsFun.codeUnit(), node.typeParams, typeParamsName, null, null);
                this.b.endCallNilaryMethod();
            } else {
                BytecodeDSLCompiler.BytecodeDSLCompilerResult classBody = this.createRootNodeCompilerFor(node).compileClassDefBody(node);
                this.emitBuildClass(classBody.codeUnit(), node);
            }
            this.endWrapWithDecorators(decoratorsLocals);
            RootNodeCompiler.this.endStoreLocal(node.name, this.b);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void emitBuildClass(BytecodeDSLCodeUnit body, StmtTy.ClassDef node) {
            this.b.beginBlock();
            if (node.isGeneric()) {
                RootNodeCompiler.this.beginStoreLocal(".type_params", this.b);
                this.visitTypeParams(node.typeParams);
                RootNodeCompiler.this.endStoreLocal(".type_params", this.b);
            }
            BytecodeLocal buildClassFunction = this.b.createLocal();
            this.b.beginStoreLocal(buildClassFunction);
            this.b.emitLoadBuildClass();
            this.b.endStoreLocal();
            this.b.beginCallVarargsMethod();
            this.b.emitLoadLocal(buildClassFunction);
            Runnable finalElements = null;
            if (node.isGeneric()) {
                finalElements = () -> {
                    this.b.beginBlock();
                    RootNodeCompiler.this.beginStoreLocal(".generic_base", this.b);
                    this.b.beginMakeGeneric();
                    RootNodeCompiler.this.emitReadLocal(".type_params", this.b);
                    this.b.endMakeGeneric();
                    RootNodeCompiler.this.endStoreLocal(".generic_base", this.b);
                    RootNodeCompiler.this.emitReadLocal(".generic_base", this.b);
                    this.b.endBlock();
                };
            }
            this.emitUnstar(() -> {
                this.emitMakeFunction(body, node, node.name, null, null);
                RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(node.name), this.b);
            }, node.bases, finalElements);
            this.validateKeywords(node.keywords);
            this.emitKeywords(node.keywords, buildClassFunction);
            this.b.endCallVarargsMethod();
            this.b.endBlock();
        }

        @Override
        public Void visit(StmtTy.Delete node) {
            new DeleteVisitor().visitSequence(node.targets);
            return null;
        }

        @Override
        public Void visit(StmtTy.Expr node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (RootNodeCompiler.this.isInteractive) {
                this.b.beginPrintExpr();
                node.value.accept(this);
                this.b.endPrintExpr();
            } else {
                node.value.accept(this);
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.For node) {
            BytecodeLabel currentBreakLabel;
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            BytecodeLocal iter = this.b.createLocal();
            this.b.beginStoreLocal(iter);
            this.b.beginGetIter();
            node.iter.accept(this);
            this.b.endGetIter();
            this.b.endStoreLocal();
            BytecodeLabel oldBreakLabel = this.breakLabel;
            BytecodeLabel oldContinueLabel = this.continueLabel;
            this.breakLabel = currentBreakLabel = this.b.createLabel();
            this.b.beginWhile();
            BytecodeLocal value = this.b.createLocal();
            this.b.beginBlock();
            this.b.emitTraceLineAtLoopHeader(RootNodeCompiler.this.currentLocation.startLine);
            this.b.beginForIterate(value);
            this.b.emitLoadLocal(iter);
            this.b.endForIterate();
            this.b.endBlock();
            this.b.beginBlock();
            this.continueLabel = this.b.createLabel();
            node.target.accept(new StoreVisitor(() -> this.b.emitLoadLocal(value)));
            this.visitSequence(node.body);
            this.b.emitLabel(this.continueLabel);
            this.b.endBlock();
            this.b.endWhile();
            this.breakLabel = oldBreakLabel;
            this.continueLabel = oldContinueLabel;
            this.visitSequence(node.orElse);
            this.b.emitLabel(currentBreakLabel);
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.FunctionDef node) {
            this.emitFunctionDef(node, node.name, node.args, node.body, node.decoratorList, node.returns, node.typeParams);
            return null;
        }

        public void emitFunctionDef(StmtTy node, String name, ArgumentsTy args, StmtTy[] body, ExprTy[] decoratorList, ExprTy returns, TypeParamTy[] typeParams) {
            boolean isGeneric;
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            BytecodeLocal[] decoratorLocals = this.evaluateDecorators(decoratorList);
            RootNodeCompiler.this.beginStoreLocal(name, this.b);
            this.beginWrapWithDecorators(decoratorLocals);
            boolean bl = isGeneric = typeParams != null && typeParams.length > 0;
            if (isGeneric) {
                int argsCount = 0;
                if (BytecodeDSLCompilerUtils.hasDefaultArgs(args)) {
                    ++argsCount;
                }
                if (BytecodeDSLCompilerUtils.hasDefaultKwargs(args)) {
                    ++argsCount;
                }
                this.beginCallNAry(argsCount);
                RootNodeCompiler typeParamsCompiler = new RootNodeCompiler(RootNodeCompiler.this.ctx, RootNodeCompiler.this, null, node, typeParams, RootNodeCompiler.this.futureFeatures);
                RootNodeCompiler funBodyCompiler = this.createRootNodeCompilerFor(node, typeParamsCompiler);
                BytecodeDSLCompiler.BytecodeDSLCompilerResult funBodyUnit = funBodyCompiler.compileFunctionDef(node, name, args, body);
                BytecodeDSLCompiler.BytecodeDSLCompilerResult typeParamsFunUnit = typeParamsCompiler.compileFunctionTypeParams(funBodyUnit.codeUnit(), node, name, args, returns, typeParams);
                String typeParamsName = "<generic parameters of " + name + ">";
                this.emitMakeFunction(typeParamsFunUnit.codeUnit(), typeParams, typeParamsName, null, null);
                if (BytecodeDSLCompilerUtils.hasDefaultArgs(args)) {
                    this.emitDefaultArgsArray(args);
                }
                if (BytecodeDSLCompilerUtils.hasDefaultKwargs(args)) {
                    this.emitDefaultKwargsArray(args);
                }
                this.endCallNAry(argsCount);
            } else {
                BytecodeDSLCompiler.BytecodeDSLCompilerResult funBodyCodeUnit = this.createRootNodeCompilerFor(node).compileFunctionDef(node, name, args, body);
                this.emitBuildFunction(funBodyCodeUnit.codeUnit(), node, name, args, decoratorList, returns);
            }
            this.endWrapWithDecorators(decoratorLocals);
            RootNodeCompiler.this.endStoreLocal(name, this.b);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
        }

        private void emitDefaultArgsArray(ArgumentsTy args) {
            if (BytecodeDSLCompilerUtils.hasDefaultArgs(args)) {
                this.b.beginCollectToObjectArray();
                for (int i = 0; i < args.defaults.length; ++i) {
                    args.defaults[i].accept(this);
                }
                this.b.endCollectToObjectArray();
            } else {
                this.b.emitLoadConstant(PythonUtils.EMPTY_OBJECT_ARRAY);
            }
        }

        private void emitDefaultKwargsArray(ArgumentsTy args) {
            if (!BytecodeDSLCompilerUtils.hasDefaultKwargs(args)) {
                this.b.emitLoadConstant(PKeyword.EMPTY_KEYWORDS);
            } else {
                ArgTy[] kwOnlyArgs = args.kwOnlyArgs;
                ArrayList<TruffleString> keys = new ArrayList<TruffleString>();
                this.b.beginMakeKeywords();
                for (int i = 0; i < args.kwDefaults.length; ++i) {
                    if (args.kwDefaults[i] == null) continue;
                    keys.add(PythonUtils.toTruffleStringUncached(RootNodeCompiler.this.mangle(kwOnlyArgs[i].arg)));
                    args.kwDefaults[i].accept(this);
                }
                this.b.endMakeKeywords(keys.toArray(new TruffleString[0]));
            }
        }

        public void emitBuildFunction(BytecodeDSLCodeUnit codeUnit, StmtTy node, String name, ArgumentsTy args, ExprTy[] decoratorList, ExprTy returns) {
            List<ParamAnnotation> annotations = RootNodeCompiler.this.collectParamAnnotations(args, returns);
            this.emitMakeFunction(codeUnit, node, name, args, annotations);
        }

        public BytecodeLocal[] evaluateDecorators(ExprTy[] decorators) {
            int numDeco = BytecodeDSLCompilerUtils.len(decorators);
            BytecodeLocal[] locals = new BytecodeLocal[numDeco];
            for (int i = 0; i < locals.length; ++i) {
                BytecodeLocal local = locals[i] = this.b.createLocal();
                this.b.beginStoreLocal(local);
                decorators[i].accept(this);
                this.b.endStoreLocal();
            }
            return locals;
        }

        public void beginWrapWithDecorators(BytecodeLocal[] locals) {
            for (int i = 0; i < locals.length; ++i) {
                this.b.beginCallUnaryMethod();
                this.b.emitLoadLocal(locals[i]);
            }
        }

        public void endWrapWithDecorators(BytecodeLocal[] locals) {
            for (int i = 0; i < locals.length; ++i) {
                this.b.endCallUnaryMethod();
            }
        }

        @Override
        public Void visit(StmtTy.AsyncFunctionDef node) {
            this.emitFunctionDef(node, node.name, node.args, node.body, node.decoratorList, node.returns, node.typeParams);
            return null;
        }

        private void emitParamAnnotation(ParamAnnotation paramAnnotation) {
            RootNodeCompiler.this.emitPythonConstant(paramAnnotation.name, this.b);
            if (RootNodeCompiler.this.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS)) {
                RootNodeCompiler.this.emitPythonConstant(Unparser.unparse(paramAnnotation.annotation), this.b);
            } else {
                ExprTy exprTy = paramAnnotation.annotation;
                if (exprTy instanceof ExprTy.Starred) {
                    ExprTy.Starred starred = (ExprTy.Starred)exprTy;
                    this.b.beginBlock();
                    BytecodeLocal local = this.b.createLocal();
                    this.b.beginUnpackToLocals(new BytecodeLocal[]{local});
                    starred.value.accept(this);
                    this.b.endUnpackToLocals();
                    this.b.emitLoadLocal(local);
                    this.b.endBlock();
                } else {
                    paramAnnotation.annotation.accept(this);
                }
            }
        }

        private void emitMakeFunction(SSTNode node, String name, ArgumentsTy args) {
            BytecodeDSLCompiler.BytecodeDSLCompilerResult compilerResult = this.compileNode(node);
            BytecodeDSLCodeUnit codeUnit = compilerResult.codeUnit();
            this.emitMakeFunction(codeUnit, node, name, args, null);
        }

        private void emitMakeFunction(BytecodeDSLCodeUnit codeUnit, Object scopeKey, String name, ArgumentsTy args, List<ParamAnnotation> annotations) {
            this.emitMakeFunction(codeUnit, scopeKey, name, null, null, args, annotations);
        }

        private void emitMakeFunction(BytecodeDSLCodeUnit codeUnit, Object scopeKey, String name, BytecodeLocal defaultArgsLocal, BytecodeLocal defaultKwargsLocal, ArgumentsTy argsForDefaults, List<ParamAnnotation> annotations) {
            TruffleString functionName = PythonUtils.toTruffleStringUncached(name);
            Scope targetScope = RootNodeCompiler.this.ctx.scopeEnvironment.lookupScope(scopeKey);
            TruffleString qualifiedName = codeUnit.qualname;
            RootNodeCompiler.this.addConstant(qualifiedName);
            RootNodeCompiler.this.addConstant(codeUnit);
            this.b.beginMakeFunction(functionName, qualifiedName, codeUnit);
            if (defaultArgsLocal != null) {
                assert (argsForDefaults == null);
                this.b.emitLoadLocal(defaultArgsLocal);
            } else {
                this.emitDefaultArgsArray(argsForDefaults);
            }
            if (defaultKwargsLocal != null) {
                assert (argsForDefaults == null);
                this.b.emitLoadLocal(defaultKwargsLocal);
            } else {
                this.emitDefaultKwargsArray(argsForDefaults);
            }
            if (codeUnit.freevars.length == 0) {
                this.b.emitLoadNull();
            } else {
                this.b.beginMakeCellArray();
                for (int i = 0; i < codeUnit.freevars.length; ++i) {
                    String fv = codeUnit.freevars[i].toJavaStringUncached();
                    BytecodeLocal local = RootNodeCompiler.this.scopeType == CompilationScope.Class && ("__class__".equals(fv) || "__classdict__".equals(fv)) || RootNodeCompiler.this.scope.getUseOfName(fv).contains((Object)Scope.DefUse.Cell) ? RootNodeCompiler.this.cellLocals.get(fv) : RootNodeCompiler.this.freeLocals.get(fv);
                    this.b.emitLoadLocal(local);
                }
                this.b.endMakeCellArray();
            }
            if (annotations != null && annotations.size() > 0) {
                this.b.beginMakeDict(annotations.size());
                for (ParamAnnotation annotation : annotations) {
                    this.emitParamAnnotation(annotation);
                }
                this.b.endMakeDict();
            } else {
                this.b.emitLoadNull();
            }
            this.b.endMakeFunction();
        }

        private BytecodeDSLCompiler.BytecodeDSLCompilerResult compileNode(SSTNode node) {
            return this.createRootNodeCompilerFor(node).compile();
        }

        private RootNodeCompiler createRootNodeCompilerFor(SSTNode node) {
            return new RootNodeCompiler(RootNodeCompiler.this.ctx, RootNodeCompiler.this, node, RootNodeCompiler.this.futureFeatures);
        }

        private RootNodeCompiler createRootNodeCompilerFor(SSTNode node, RootNodeCompiler parent) {
            return new RootNodeCompiler(RootNodeCompiler.this.ctx, RootNodeCompiler.this, node, RootNodeCompiler.this.futureFeatures);
        }

        @Override
        public Void visit(StmtTy.Global node) {
            return null;
        }

        private void visitStatements(StmtTy[] stmts) {
            this.b.beginBlock();
            if (stmts != null) {
                for (StmtTy stmt : stmts) {
                    stmt.accept(this);
                }
            }
            this.b.endBlock();
        }

        @Override
        public Void visit(StmtTy.If node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (node.orElse == null || node.orElse.length == 0) {
                this.b.beginIfThen();
                this.visitCondition(node.test);
                this.visitStatements(node.body);
                this.b.endIfThen();
            } else {
                this.b.beginIfThenElse();
                this.visitCondition(node.test);
                this.visitStatements(node.body);
                this.visitStatements(node.orElse);
                this.b.endIfThenElse();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean producesBoolean(ExprTy node) {
            if (node instanceof ExprTy.UnaryOp) {
                ExprTy.UnaryOp unOp = (ExprTy.UnaryOp)node;
                if (unOp.op == UnaryOpTy.Not) return true;
            }
            if (!(node instanceof ExprTy.Constant)) return false;
            ExprTy.Constant c = (ExprTy.Constant)node;
            if (c.value.kind != ConstantValue.Kind.BOOLEAN) return false;
            return true;
        }

        private void visitCondition(ExprTy node) {
            boolean mayNeedCoercion;
            boolean bl = mayNeedCoercion = !this.producesBoolean(node);
            if (mayNeedCoercion) {
                this.b.beginYes();
            }
            node.accept(this);
            if (mayNeedCoercion) {
                this.b.endYes();
            }
        }

        @Override
        public Void visit(StmtTy.Import node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            for (AliasTy name : node.names) {
                int i;
                RootNodeCompiler.this.addConstant(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
                if (name.asName == null) {
                    String resName = name.name.contains(".") ? name.name.substring(0, name.name.indexOf(46)) : name.name;
                    RootNodeCompiler.this.beginStoreLocal(resName, this.b);
                    this.b.emitImport(PythonUtils.toTruffleStringUncached(name.name), PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, 0);
                    RootNodeCompiler.this.endStoreLocal(resName, this.b);
                    continue;
                }
                String[] parts = name.name.split("\\.");
                RootNodeCompiler.this.beginStoreLocal(name.asName, this.b);
                for (i = parts.length - 1; i >= 0; --i) {
                    if (i != 0) {
                        this.b.beginImportFrom(PythonUtils.toTruffleStringUncached(parts[i]));
                        continue;
                    }
                    this.b.emitImport(PythonUtils.toTruffleStringUncached(name.name), PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, 0);
                }
                for (i = 1; i < parts.length; ++i) {
                    this.b.endImportFrom();
                }
                RootNodeCompiler.this.endStoreLocal(name.asName, this.b);
            }
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.ImportFrom node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (node.getSourceRange().startLine > RootNodeCompiler.this.ctx.futureLineNumber && "__future__".equals(node.module)) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "from __future__ imports must occur at the beginning of the file");
            }
            TruffleString tsModuleName = PythonUtils.toTruffleStringUncached(node.module == null ? "" : node.module);
            if (node.names[0].name.equals("*")) {
                this.b.emitImportStar(tsModuleName, node.level);
            } else {
                this.b.beginBlock();
                BytecodeLocal module = this.b.createLocal();
                TruffleString[] fromList = new TruffleString[node.names.length];
                for (int i = 0; i < fromList.length; ++i) {
                    fromList[i] = PythonUtils.toTruffleStringUncached(node.names[i].name);
                }
                this.b.beginStoreLocal(module);
                this.b.emitImport(tsModuleName, fromList, node.level);
                this.b.endStoreLocal();
                TruffleString[] importedNames = new TruffleString[node.names.length];
                for (int i = 0; i < node.names.length; ++i) {
                    TruffleString name;
                    AliasTy alias = node.names[i];
                    String asName = alias.asName == null ? alias.name : alias.asName;
                    RootNodeCompiler.this.beginStoreLocal(asName, this.b);
                    importedNames[i] = name = PythonUtils.toTruffleStringUncached(alias.name);
                    this.b.beginImportFrom(name);
                    this.b.emitLoadLocal(module);
                    this.b.endImportFrom();
                    RootNodeCompiler.this.endStoreLocal(asName, this.b);
                }
                RootNodeCompiler.this.addConstant(importedNames);
                this.b.endBlock();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.Match node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            BytecodeLocal subject = this.b.createLocal();
            this.b.beginStoreLocal(subject);
            node.subject.accept(this);
            this.b.endStoreLocal();
            this.visitMatchCaseRecursively(node.cases, 0, new PatternContext(subject));
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void visitMatchCaseRecursively(MatchCaseTy[] cases, int index, PatternContext pc) {
            MatchCaseTy c = cases[index];
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(c, this.b);
            if (index != cases.length - 1) {
                this.b.beginIfThenElse();
                pc.allowIrrefutable = c.guard != null;
                this.emitPatternCondition(c, pc);
                this.visitStatements(c.body);
                pc.bindVariables.clear();
                this.visitMatchCaseRecursively(cases, index + 1, pc);
                this.b.endIfThenElse();
            } else if (StatementCompiler.wildcardCheck(c.pattern) && c.guard == null) {
                this.visitStatements(c.body);
            } else {
                this.b.beginIfThen();
                pc.allowIrrefutable = true;
                this.emitPatternCondition(c, pc);
                this.visitStatements(c.body);
                this.b.endIfThen();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
        }

        private void emitPatternCondition(MatchCaseTy currentCase, PatternContext pc) {
            PatternTy pattern = currentCase.pattern;
            ExprTy guard = currentCase.guard;
            this.b.beginPrimitiveBoolAnd();
            this.visitPattern(pattern, pc);
            if (!pc.bindVariables.isEmpty()) {
                this.b.beginBlock();
                for (Map.Entry<String, BytecodeLocal> entry : pc.bindVariables.entrySet()) {
                    RootNodeCompiler.this.beginStoreLocal(entry.getKey(), this.b);
                    this.b.emitLoadLocal(entry.getValue());
                    RootNodeCompiler.this.endStoreLocal(entry.getKey(), this.b);
                }
                this.b.emitLoadConstant(true);
                this.b.endBlock();
            }
            if (guard != null) {
                this.visitCondition(guard);
            }
            this.b.endPrimitiveBoolAnd();
        }

        private void visitPattern(PatternTy pattern, PatternContext pc) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(pattern, this.b);
            if (pattern instanceof PatternTy.MatchAs) {
                PatternTy.MatchAs matchAs = (PatternTy.MatchAs)pattern;
                this.doVisitPattern(matchAs, pc);
            } else if (pattern instanceof PatternTy.MatchClass) {
                PatternTy.MatchClass matchClass = (PatternTy.MatchClass)pattern;
                this.doVisitPattern(matchClass, pc);
            } else if (pattern instanceof PatternTy.MatchMapping) {
                PatternTy.MatchMapping matchMapping = (PatternTy.MatchMapping)pattern;
                this.doVisitPattern(matchMapping, pc);
            } else if (pattern instanceof PatternTy.MatchOr) {
                PatternTy.MatchOr matchOr = (PatternTy.MatchOr)pattern;
                this.doVisitPattern(matchOr, pc);
            } else if (pattern instanceof PatternTy.MatchSequence) {
                PatternTy.MatchSequence matchSequence = (PatternTy.MatchSequence)pattern;
                this.doVisitPattern(matchSequence, pc);
            } else if (pattern instanceof PatternTy.MatchSingleton) {
                PatternTy.MatchSingleton matchSingleton = (PatternTy.MatchSingleton)pattern;
                this.doVisitPattern(matchSingleton, pc);
            } else if (pattern instanceof PatternTy.MatchStar) {
                PatternTy.MatchStar matchStar = (PatternTy.MatchStar)pattern;
                this.doVisitPattern(matchStar, pc);
            } else if (pattern instanceof PatternTy.MatchValue) {
                PatternTy.MatchValue matchValue = (PatternTy.MatchValue)pattern;
                this.doVisitPattern(matchValue, pc);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
        }

        private void visitSubpattern(PatternTy pattern, PatternContext pc) {
            boolean allowIrrefutable = pc.allowIrrefutable;
            pc.allowIrrefutable = true;
            this.visitPattern(pattern, pc);
            pc.allowIrrefutable = allowIrrefutable;
        }

        private void doVisitPattern(PatternTy.MatchAs node, PatternContext pc) {
            this.b.beginBlock();
            if (node.name != null) {
                pc.copySubjectToTemporary(node.name);
            }
            if (node.pattern == null) {
                if (!pc.allowIrrefutable) {
                    if (node.name != null) {
                        RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "name capture '%s' makes remaining patterns unreachable", node.name);
                    }
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "wildcard makes remaining patterns unreachable");
                }
                this.b.emitLoadConstant(true);
            } else {
                assert (node.name != null) : "name should only be null for the empty wildcard pattern '_'";
                this.visitPattern(node.pattern, pc);
            }
            this.b.endBlock();
        }

        private void emitPatternNotImplemented(String kind) {
            this.b.beginBlock();
            RootNodeCompiler.this.emitNotImplemented(kind + " pattern matching", this.b);
            this.b.emitLoadConstant(false);
            this.b.endBlock();
        }

        private BytecodeLocal patternContextSubjectSave(PatternContext pc) {
            BytecodeLocal pcSave = this.b.createLocal();
            this.b.beginStoreLocal(pcSave);
            this.b.emitLoadLocal(pc.subject);
            this.b.endStoreLocal();
            return pcSave;
        }

        private void patternContextSubjectLoad(BytecodeLocal pcSave, PatternContext pc) {
            this.b.beginStoreLocal(pc.subject);
            this.b.emitLoadLocal(pcSave);
            this.b.endStoreLocal();
        }

        private void classMatchLengthChecks(int patLen, int attrsLen, int kwdPatLen, PatternTy.MatchClass node) {
            if (attrsLen != kwdPatLen) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "kwd_attrs (%d) / kwd_patterns (%d) length mismatch in class pattern", attrsLen, kwdPatLen);
            }
            if (Integer.MAX_VALUE < patLen + attrsLen - 1) {
                String id = node.cls instanceof ExprTy.Name ? ((ExprTy.Name)node.cls).id : node.cls.toString();
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "too many sub-patterns in class pattern %s", id);
            }
        }

        private void classMatchVisitSubpatterns(PatternTy[] patterns, PatternTy[] kwdPatterns, BytecodeLocal attrsValueUnpacked, PatternContext pc, int patLen, int attrsLen) {
            BytecodeLocal pcSave = this.patternContextSubjectSave(pc);
            if (patLen + attrsLen == 0) {
                this.b.emitLoadConstant(true);
            } else {
                int i;
                BytecodeLocal temp = this.b.createLocal();
                this.b.beginStoreLocal(temp);
                this.b.beginPrimitiveBoolAnd();
                for (i = 0; i < patLen; ++i) {
                    this.b.beginBlock();
                    this.b.beginStoreLocal(pc.subject);
                    this.b.beginArrayIndex(i);
                    this.b.emitLoadLocal(attrsValueUnpacked);
                    this.b.endArrayIndex();
                    this.b.endStoreLocal();
                    this.visitSubpattern(patterns[i], pc);
                    this.b.endBlock();
                }
                i = 0;
                int j = patLen;
                while (i < attrsLen) {
                    this.b.beginBlock();
                    this.b.beginStoreLocal(pc.subject);
                    this.b.beginArrayIndex(j);
                    this.b.emitLoadLocal(attrsValueUnpacked);
                    this.b.endArrayIndex();
                    this.b.endStoreLocal();
                    this.visitSubpattern(kwdPatterns[i], pc);
                    this.b.endBlock();
                    ++i;
                    ++j;
                }
                this.b.endPrimitiveBoolAnd();
                this.b.endStoreLocal();
                this.patternContextSubjectLoad(pcSave, pc);
                this.b.emitLoadLocal(temp);
            }
        }

        private void doVisitPattern(PatternTy.MatchClass node, PatternContext pc) {
            this.b.beginBlock();
            Object[] patterns = node.patterns;
            Object[] kwdAttrs = node.kwdAttrs;
            Object[] kwdPatterns = node.kwdPatterns;
            int patLen = StatementCompiler.lengthOrZero(patterns);
            int attrsLen = StatementCompiler.lengthOrZero(kwdAttrs);
            int kwdPatLen = StatementCompiler.lengthOrZero(kwdPatterns);
            this.classMatchLengthChecks(patLen, attrsLen, kwdPatLen, node);
            if (attrsLen > 0) {
                this.validateKwdAttrs((String[])kwdAttrs, (PatternTy[])kwdPatterns);
            }
            TruffleString[] tsAttrs = new TruffleString[attrsLen];
            for (int i = 0; i < attrsLen; ++i) {
                tsAttrs[i] = PythonUtils.toTruffleStringUncached((String)kwdAttrs[i]);
            }
            this.b.beginPrimitiveBoolAnd();
            BytecodeLocal attrsValue = this.b.createLocal();
            this.b.beginMatchClass(attrsValue);
            this.b.emitLoadLocal(pc.subject);
            node.cls.accept(this);
            this.b.emitLoadConstant(patLen);
            this.b.emitLoadConstant(tsAttrs);
            this.b.endMatchClass();
            this.b.beginBlock();
            BytecodeLocal attrsValueUnpacked = this.b.createLocal();
            this.b.beginStoreLocal(attrsValueUnpacked);
            this.b.beginUnpackSequence(patLen + attrsLen);
            this.b.emitLoadLocal(attrsValue);
            this.b.endUnpackSequence();
            this.b.endStoreLocal();
            this.classMatchVisitSubpatterns((PatternTy[])patterns, (PatternTy[])kwdPatterns, attrsValueUnpacked, pc, patLen, attrsLen);
            this.b.endBlock();
            this.b.endPrimitiveBoolAnd();
            this.b.endBlock();
        }

        private void validateKwdAttrs(String[] attrs, PatternTy[] patterns) {
            int attrsLen = StatementCompiler.lengthOrZero(attrs);
            for (int i = 0; i < attrsLen; ++i) {
                String attr = attrs[i];
                RootNodeCompiler.this.checkForbiddenName(attr, NameOperation.BeginWrite, patterns[i].getSourceRange());
                for (int j = i + 1; j < attrsLen; ++j) {
                    String other = attrs[j];
                    if (!attr.equals(other)) continue;
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, patterns[j].getSourceRange(), "attribute name repeated in class pattern: `%s`", attr);
                }
            }
        }

        private static int lengthOrZero(Object[] p) {
            return p == null ? 0 : p.length;
        }

        private void checkPatternKeysLength(int keyLen, PatternContext pc) {
            this.b.beginGe();
            this.b.beginGetLen();
            this.b.emitLoadLocal(pc.subject);
            this.b.endGetLen();
            this.b.emitLoadConstant(keyLen);
            this.b.endGe();
        }

        private void processPatternKeys(ExprTy[] keys, int keyLen, PatternTy.MatchMapping node) {
            this.b.beginCollectToObjectArray();
            ArrayList<Object> seen = new ArrayList<Object>();
            for (int i = 0; i < keyLen; ++i) {
                ExprTy key = keys[i];
                if (key instanceof ExprTy.Attribute) {
                    key.accept(this);
                    continue;
                }
                ConstantValue constantValue = null;
                if (key instanceof ExprTy.UnaryOp || key instanceof ExprTy.BinOp) {
                    constantValue = this.foldConstantOp(key);
                } else if (key instanceof ExprTy.Constant) {
                    constantValue = ((ExprTy.Constant)key).value;
                } else {
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "mapping pattern keys may only match literals and attribute lookups");
                }
                assert (constantValue != null);
                Object pythonValue = PythonUtils.pythonObjectFromConstantValue(constantValue);
                for (Object e : seen) {
                    if (!PyObjectRichCompareBool.executeEqUncached(e, pythonValue)) continue;
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "mapping pattern checks duplicate key (%s)", pythonValue);
                }
                seen.add(pythonValue);
                this.createConstant(constantValue);
            }
            this.b.endCollectToObjectArray();
        }

        private void mappingVisitSubpatterns(PatternTy[] patterns, BytecodeLocal values, PatternContext pc) {
            int patLen = patterns.length;
            this.b.beginBlock();
            BytecodeLocal valuesUnpacked = this.b.createLocal();
            this.b.beginStoreLocal(valuesUnpacked);
            this.b.beginUnpackSequence(patLen);
            this.b.emitLoadLocal(values);
            this.b.endUnpackSequence();
            this.b.endStoreLocal();
            BytecodeLocal pcSave = this.patternContextSubjectSave(pc);
            BytecodeLocal temp = this.b.createLocal();
            this.b.beginStoreLocal(temp);
            this.b.beginPrimitiveBoolAnd();
            boolean hadNonWildcardPattern = false;
            for (int i = 0; i < patLen; ++i) {
                if (StatementCompiler.wildcardCheck(patterns[i])) continue;
                hadNonWildcardPattern = true;
                this.b.beginBlock();
                this.b.beginStoreLocal(pc.subject);
                this.b.beginArrayIndex(i);
                this.b.emitLoadLocal(valuesUnpacked);
                this.b.endArrayIndex();
                this.b.endStoreLocal();
                this.visitSubpattern(patterns[i], pc);
                this.b.endBlock();
            }
            if (!hadNonWildcardPattern) {
                this.b.emitLoadConstant(true);
            }
            this.b.endPrimitiveBoolAnd();
            this.b.endStoreLocal();
            this.patternContextSubjectLoad(pcSave, pc);
            this.b.emitLoadLocal(temp);
            this.b.endBlock();
        }

        private void doVisitPattern(PatternTy.MatchMapping node, PatternContext pc) {
            int patLen;
            Object[] keys = node.keys;
            Object[] patterns = node.patterns;
            int keyLen = StatementCompiler.lengthOrZero(keys);
            if (keyLen != (patLen = StatementCompiler.lengthOrZero(patterns))) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "keys (%d) / patterns (%d) length mismatch in mapping pattern", keyLen, patLen);
            }
            this.b.beginPrimitiveBoolAnd();
            this.b.beginCheckTypeFlags(64L);
            this.b.emitLoadLocal(pc.subject);
            this.b.endCheckTypeFlags();
            String starTarget = node.rest;
            if (keyLen == 0 && starTarget == null) {
                this.b.emitLoadConstant(true);
                this.b.endPrimitiveBoolAnd();
                return;
            }
            if (Integer.MAX_VALUE < keyLen - 1) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "too many sub-patterns in mapping pattern");
            }
            if (keyLen > 0) {
                this.checkPatternKeysLength(keyLen, pc);
            }
            this.b.beginBlock();
            BytecodeLocal subjectPatterns = this.b.createLocal();
            BytecodeLocal temp = this.b.createLocal();
            BytecodeLocal keysChecked = this.b.createLocal();
            this.b.beginStoreLocal(temp);
            this.b.beginPrimitiveBoolAnd();
            this.b.beginBlock();
            this.b.beginStoreLocal(keysChecked);
            this.processPatternKeys((ExprTy[])keys, keyLen, node);
            this.b.endStoreLocal();
            this.b.beginMatchKeys(subjectPatterns);
            this.b.emitLoadLocal(pc.subject);
            this.b.emitLoadLocal(keysChecked);
            this.b.endMatchKeys();
            this.b.endBlock();
            if (patLen > 0) {
                this.mappingVisitSubpatterns((PatternTy[])patterns, subjectPatterns, pc);
            }
            this.b.endPrimitiveBoolAnd();
            this.b.endStoreLocal();
            if (starTarget != null) {
                BytecodeLocal starVariable = pc.allocateBindVariable(starTarget);
                this.b.beginStoreLocal(starVariable);
                this.b.beginCopyDictWithoutKeys();
                this.b.emitLoadLocal(pc.subject);
                this.b.emitLoadLocal(keysChecked);
                this.b.endCopyDictWithoutKeys();
                this.b.endStoreLocal();
            }
            this.b.emitLoadLocal(temp);
            this.b.endBlock();
            this.b.endPrimitiveBoolAnd();
        }

        private void checkAlternativePatternDifferentNames(Set<String> control, Map<String, BytecodeLocal> bindVariables) {
            if (!control.equals(bindVariables.keySet())) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "alternative patterns bind different names");
            }
        }

        private void fromPatternContextToLocal(PatternContext pc, BytecodeLocal local_temp) {
            this.b.beginIfThen();
            this.b.emitLoadLocal(local_temp);
            this.b.beginBlock();
            if (!pc.bindVariables.isEmpty()) {
                for (Map.Entry<String, BytecodeLocal> entry : pc.bindVariables.entrySet()) {
                    RootNodeCompiler.this.beginStoreLocal(entry.getKey(), this.b);
                    this.b.emitLoadLocal(entry.getValue());
                    RootNodeCompiler.this.endStoreLocal(entry.getKey(), this.b);
                }
            }
            this.b.endBlock();
            this.b.endIfThen();
        }

        private void visitMatchOrRecursively(PatternTy[] patterns, int index, PatternContext pc, Set<String> control, boolean allowIrrefutable) {
            this.b.beginBoolOr();
            this.b.beginBlock();
            pc = new PatternContext(pc.subject);
            BytecodeLocal local_temp = this.b.createLocal();
            this.b.beginStoreLocal(local_temp);
            this.visitPattern(patterns[index], pc);
            this.b.endStoreLocal();
            if (index == 0) {
                control = new HashSet<String>(pc.bindVariables.keySet());
            }
            this.checkAlternativePatternDifferentNames(control, pc.bindVariables);
            this.fromPatternContextToLocal(pc, local_temp);
            this.b.emitLoadLocal(local_temp);
            this.b.endBlock();
            if (index + 2 < patterns.length) {
                this.visitMatchOrRecursively(patterns, index + 1, pc, control, allowIrrefutable);
                this.b.endBoolOr();
            } else {
                pc = new PatternContext(pc.subject);
                pc.allowIrrefutable = allowIrrefutable;
                this.b.beginBlock();
                local_temp = this.b.createLocal();
                this.b.beginStoreLocal(local_temp);
                this.visitPattern(patterns[index + 1], pc);
                this.b.endStoreLocal();
                this.checkAlternativePatternDifferentNames(control, pc.bindVariables);
                this.fromPatternContextToLocal(pc, local_temp);
                this.b.emitLoadLocal(local_temp);
                this.b.endBlock();
                this.b.endBoolOr();
            }
        }

        private void doVisitPattern(PatternTy.MatchOr node, PatternContext pc) {
            boolean saveIrrefutable = pc.allowIrrefutable;
            pc.allowIrrefutable = false;
            this.visitMatchOrRecursively(node.patterns, 0, pc, null, saveIrrefutable);
        }

        private void patternHelperSequenceUnpack(PatternTy[] patterns, PatternContext pc) {
            int n = BytecodeDSLCompilerUtils.len(patterns);
            this.b.beginBlock();
            BytecodeLocal unpacked = this.b.createLocal();
            this.b.beginStoreLocal(unpacked);
            this.patternUnpackHelper(patterns, pc);
            this.b.endStoreLocal();
            this.b.beginPrimitiveBoolAnd();
            for (int i = 0; i < n; ++i) {
                this.b.beginBlock();
                this.b.beginStoreLocal(pc.subject);
                this.b.beginArrayIndex(i);
                this.b.emitLoadLocal(unpacked);
                this.b.endArrayIndex();
                this.b.endStoreLocal();
                this.visitSubpattern(patterns[i], pc);
                this.b.endBlock();
            }
            this.b.endPrimitiveBoolAnd();
            this.b.endBlock();
        }

        private void patternUnpackHelper(PatternTy[] patterns, PatternContext pc) {
            int n = BytecodeDSLCompilerUtils.len(patterns);
            boolean seenStar = false;
            for (int i = 0; i < n; ++i) {
                PatternTy pattern = patterns[i];
                if (!(pattern instanceof PatternTy.MatchStar)) continue;
                if (seenStar) {
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "multiple starred expressions in sequence pattern");
                }
                seenStar = true;
                int countAfter = n - i - 1;
                if (countAfter != (byte)countAfter) {
                    RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "too many expressions in star-unpacking sequence pattern");
                }
                this.b.beginUnpackEx(i, countAfter);
                this.b.emitLoadLocal(pc.subject);
                this.b.endUnpackEx();
            }
            if (!seenStar) {
                this.b.beginUnpackSequence(n);
                this.b.emitLoadLocal(pc.subject);
                this.b.endUnpackSequence();
            }
        }

        private void patternHelperSequenceSubscr(PatternTy[] patterns, int star, PatternContext pc) {
            int n = BytecodeDSLCompilerUtils.len(patterns);
            this.b.beginBlock();
            BytecodeLocal sequence = this.b.createLocal();
            this.b.beginStoreLocal(sequence);
            this.b.emitLoadLocal(pc.subject);
            this.b.endStoreLocal();
            for (int i = 0; i < n; ++i) {
                PatternTy pattern = patterns[i];
                if (StatementCompiler.wildcardCheck(pattern)) continue;
                if (i == star) {
                    assert (StatementCompiler.wildcardStarCheck(pattern));
                    continue;
                }
                this.b.beginStoreLocal(pc.subject);
                this.b.beginBinarySubscript();
                this.b.emitLoadLocal(sequence);
                if (i < star) {
                    this.b.emitLoadConstant(i);
                } else {
                    this.b.beginPyNumberSubtract();
                    this.b.beginGetLen();
                    this.b.emitLoadLocal(sequence);
                    this.b.endGetLen();
                    this.b.emitLoadConstant(n - i);
                    this.b.endPyNumberSubtract();
                }
                this.b.endBinarySubscript();
                this.b.endStoreLocal();
                this.visitSubpattern(pattern, pc);
            }
            this.b.endBlock();
        }

        private void doVisitPattern(PatternTy.MatchSequence node, PatternContext pc) {
            int size = BytecodeDSLCompilerUtils.len(node.patterns);
            int star = -1;
            boolean onlyWildcard = true;
            boolean starWildcard = false;
            for (int i = 0; i < size; ++i) {
                PatternTy pattern = node.patterns[i];
                if (pattern instanceof PatternTy.MatchStar) {
                    if (star >= 0) {
                        RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "multiple starred names in sequence pattern");
                    }
                    starWildcard = StatementCompiler.wildcardStarCheck(pattern);
                    onlyWildcard &= starWildcard;
                    star = i;
                    continue;
                }
                onlyWildcard &= StatementCompiler.wildcardCheck(pattern);
            }
            this.b.beginBlock();
            BytecodeLocal resultOfAnd = this.b.createLocal();
            BytecodeLocal oldSubject = this.b.createLocal();
            this.b.beginStoreLocal(oldSubject);
            this.b.emitLoadLocal(pc.subject);
            this.b.endStoreLocal();
            this.b.beginStoreLocal(resultOfAnd);
            this.b.beginPrimitiveBoolAnd();
            this.b.beginCheckTypeFlags(32L);
            this.b.emitLoadLocal(pc.subject);
            this.b.endCheckTypeFlags();
            if (star < 0) {
                this.b.beginEq();
                this.b.beginGetLen();
                this.b.emitLoadLocal(pc.subject);
                this.b.endGetLen();
                this.b.emitLoadConstant(size);
                this.b.endEq();
            } else if (size > 1) {
                this.b.beginGe();
                this.b.beginGetLen();
                this.b.emitLoadLocal(pc.subject);
                this.b.endGetLen();
                this.b.emitLoadConstant(size - 1);
                this.b.endGe();
            }
            if (!onlyWildcard) {
                if (starWildcard) {
                    this.patternHelperSequenceSubscr(node.patterns, star, pc);
                } else {
                    this.patternHelperSequenceUnpack(node.patterns, pc);
                }
            }
            this.b.endPrimitiveBoolAnd();
            this.b.endStoreLocal();
            this.b.beginStoreLocal(pc.subject);
            this.b.emitLoadLocal(oldSubject);
            this.b.endStoreLocal();
            this.b.emitLoadLocal(resultOfAnd);
            this.b.endBlock();
        }

        private void doVisitPattern(PatternTy.MatchSingleton node, PatternContext pc) {
            this.b.beginIs();
            this.b.emitLoadLocal(pc.subject);
            switch (node.value.kind) {
                case BOOLEAN: {
                    this.b.emitLoadConstant(node.value.getBoolean());
                    break;
                }
                case NONE: {
                    this.b.emitLoadConstant(PNone.NONE);
                    break;
                }
                default: {
                    throw new IllegalStateException("wrong MatchSingleton value kind " + String.valueOf((Object)node.value.kind));
                }
            }
            this.b.endIs();
        }

        private void doVisitPattern(PatternTy.MatchStar node, PatternContext pc) {
            if (node.name != null) {
                this.b.beginBlock();
                pc.copySubjectToTemporary(node.name);
                this.b.emitLoadConstant(true);
                this.b.endBlock();
            }
        }

        private void doVisitPattern(PatternTy.MatchValue node, PatternContext pc) {
            this.b.beginEq();
            this.b.emitLoadLocal(pc.subject);
            if (node.value instanceof ExprTy.UnaryOp || node.value instanceof ExprTy.BinOp) {
                this.createConstant(this.foldConstantOp(node.value));
            } else if (node.value instanceof ExprTy.Constant || node.value instanceof ExprTy.Attribute) {
                node.value.accept(this);
            } else {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "patterns may only match literals and attribute lookups");
            }
            this.b.endEq();
        }

        private static boolean wildcardCheck(PatternTy pattern) {
            return pattern instanceof PatternTy.MatchAs && ((PatternTy.MatchAs)pattern).name == null;
        }

        private static boolean wildcardStarCheck(PatternTy pattern) {
            return pattern instanceof PatternTy.MatchStar && ((PatternTy.MatchStar)pattern).name == null;
        }

        private ConstantValue foldConstantOp(ExprTy value) {
            if (value instanceof ExprTy.UnaryOp) {
                ExprTy.UnaryOp unaryOp = (ExprTy.UnaryOp)value;
                return this.foldUnaryOpConstant(unaryOp);
            }
            if (value instanceof ExprTy.BinOp) {
                ExprTy.BinOp binOp = (ExprTy.BinOp)value;
                return this.foldBinOpComplexConstant(binOp);
            }
            throw new IllegalStateException("should not reach here");
        }

        private ConstantValue foldUnaryOpConstant(ExprTy.UnaryOp unaryOp) {
            assert (unaryOp.op == UnaryOpTy.USub);
            assert (unaryOp.operand instanceof ExprTy.Constant) : unaryOp.operand;
            ExprTy.Constant c = (ExprTy.Constant)unaryOp.operand;
            ConstantValue ret = c.value.negate();
            assert (ret != null);
            return ret;
        }

        private ConstantValue foldBinOpComplexConstant(ExprTy.BinOp binOp) {
            assert ((binOp.left instanceof ExprTy.UnaryOp || binOp.left instanceof ExprTy.Constant) && binOp.right instanceof ExprTy.Constant) : String.valueOf(binOp.left) + " " + String.valueOf(binOp.right);
            assert (binOp.op == OperatorTy.Sub || binOp.op == OperatorTy.Add);
            ConstantValue left = binOp.left instanceof ExprTy.UnaryOp ? this.foldUnaryOpConstant((ExprTy.UnaryOp)binOp.left) : ((ExprTy.Constant)binOp.left).value;
            ExprTy.Constant right = (ExprTy.Constant)binOp.right;
            switch (binOp.op) {
                case Add: {
                    return left.addComplex(right.value);
                }
                case Sub: {
                    return left.subComplex(right.value);
                }
            }
            throw new IllegalStateException("wrong constant BinOp operator " + String.valueOf((Object)binOp.op));
        }

        @Override
        public Void visit(MatchCaseTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchAs node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchClass node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchMapping node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchOr node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchSequence node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchSingleton node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchStar node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(PatternTy.MatchValue node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(StmtTy.Nonlocal node) {
            return null;
        }

        @Override
        public Void visit(StmtTy.Raise node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginRaise();
            if (node.exc != null) {
                node.exc.accept(this);
            } else {
                this.b.emitLoadConstant(PNone.NO_VALUE);
            }
            if (node.cause != null) {
                node.cause.accept(this);
            } else {
                this.b.emitLoadConstant(PNone.NO_VALUE);
            }
            this.b.endRaise();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.Return node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (!RootNodeCompiler.this.scope.isFunction()) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'return' outside function");
            }
            RootNodeCompiler.this.beginReturn(this.b);
            if (node.value != null) {
                node.value.accept(this);
            } else {
                this.b.emitLoadConstant(PNone.NONE);
            }
            RootNodeCompiler.this.endReturn(this.b);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.Try node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            if (node.finalBody != null && node.finalBody.length != 0) {
                this.b.beginTryCatchOtherwise(() -> {
                    this.b.beginBlock();
                    this.visitSequence(node.finalBody);
                    this.b.endBlock();
                });
                this.emitTryExceptElse(node);
                this.b.beginBlock();
                BytecodeLocal savedException = this.b.createLocal();
                this.emitSaveCurrentException(savedException);
                this.emitSetCurrentException();
                this.b.beginMarkExceptionAsCaught();
                this.b.emitLoadException();
                this.b.endMarkExceptionAsCaught();
                this.b.beginTryCatchOtherwise(() -> this.emitRestoreCurrentException(savedException));
                this.b.beginBlock();
                this.visitSequence(node.finalBody);
                this.b.endBlock();
                this.b.beginBlock();
                this.emitRestoreCurrentException(savedException);
                this.b.beginMarkExceptionAsCaught();
                this.b.emitLoadException();
                this.b.endMarkExceptionAsCaught();
                this.b.beginReraise();
                this.b.emitLoadException();
                this.b.endReraise();
                this.b.endBlock();
                this.b.endTryCatchOtherwise();
                this.b.beginReraise();
                this.b.emitLoadException();
                this.b.endReraise();
                this.b.endBlock();
                this.b.endTryCatchOtherwise();
            } else {
                this.emitTryExceptElse(node);
            }
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void emitTryExceptElse(StmtTy.Try node) {
            if (node.handlers != null && node.handlers.length != 0) {
                this.b.beginBlock();
                BytecodeLocal savedException = this.b.createLocal();
                BytecodeLabel afterElse = this.b.createLabel();
                this.b.beginTryCatch();
                this.b.beginBlock();
                this.visitSequence(node.body);
                this.b.endBlock();
                this.b.beginBlock();
                this.emitSaveCurrentException(savedException);
                this.emitSetCurrentException();
                this.b.beginMarkExceptionAsCaught();
                this.b.emitLoadException();
                this.b.endMarkExceptionAsCaught();
                this.b.beginTryCatchOtherwise(() -> this.emitRestoreCurrentException(savedException));
                this.b.beginBlock();
                SourceRange bareExceptRange = null;
                for (ExceptHandlerTy h : node.handlers) {
                    boolean newStatement = RootNodeCompiler.this.beginSourceSection(h, this.b);
                    if (bareExceptRange != null) {
                        RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "default 'except:' must be last");
                    }
                    ExceptHandlerTy.ExceptHandler handler = (ExceptHandlerTy.ExceptHandler)h;
                    if (handler.type != null) {
                        this.b.beginIfThen();
                        this.b.beginExceptMatch();
                        this.b.emitLoadException();
                        handler.type.accept(this);
                        this.b.endExceptMatch();
                    } else {
                        bareExceptRange = handler.getSourceRange();
                    }
                    this.b.beginBlock();
                    if (handler.name != null) {
                        RootNodeCompiler.this.beginStoreLocal(handler.name, this.b);
                        this.b.beginUnwrapException();
                        this.b.emitLoadException();
                        this.b.endUnwrapException();
                        RootNodeCompiler.this.endStoreLocal(handler.name, this.b);
                        this.b.beginTryCatchOtherwise(() -> this.emitUnbindHandlerVariable(handler));
                        this.b.beginBlock();
                        this.visitSequence(handler.body);
                        this.b.endBlock();
                        this.b.beginBlock();
                        this.emitUnbindHandlerVariable(handler);
                        this.b.beginMarkExceptionAsCaught();
                        this.b.emitLoadException();
                        this.b.endMarkExceptionAsCaught();
                        this.b.beginThrow();
                        this.b.emitLoadException();
                        this.b.endThrow();
                        this.b.endBlock();
                        this.b.endTryCatchOtherwise();
                    } else {
                        this.b.beginBlock();
                        this.visitSequence(handler.body);
                        this.b.endBlock();
                    }
                    this.b.emitBranch(afterElse);
                    this.b.endBlock();
                    if (handler.type != null) {
                        this.b.endIfThen();
                    }
                    RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                }
                this.b.endBlock();
                this.b.beginBlock();
                this.emitRestoreCurrentException(savedException);
                this.b.beginMarkExceptionAsCaught();
                this.b.emitLoadException();
                this.b.endMarkExceptionAsCaught();
                this.b.beginReraise();
                this.b.emitLoadException();
                this.b.endReraise();
                this.b.endBlock();
                this.b.endTryCatchOtherwise();
                if (bareExceptRange == null) {
                    this.b.beginReraise();
                    this.b.emitLoadException();
                    this.b.endReraise();
                }
                this.b.endBlock();
                this.b.endTryCatch();
                if (node.orElse != null) {
                    this.visitSequence(node.orElse);
                }
                this.b.emitLabel(afterElse);
                this.b.endBlock();
            } else {
                this.b.beginBlock();
                this.visitSequence(node.body);
                this.b.endBlock();
            }
        }

        private void emitSaveCurrentException(BytecodeLocal savedException) {
            this.b.beginStoreLocal(savedException);
            this.b.emitGetCurrentException();
            this.b.endStoreLocal();
        }

        private void emitSetCurrentException() {
            this.b.beginSetCurrentException();
            this.b.emitLoadException();
            this.b.endSetCurrentException();
        }

        private void emitRestoreCurrentException(BytecodeLocal savedException) {
            this.b.beginSetCurrentException();
            this.b.emitLoadLocal(savedException);
            this.b.endSetCurrentException();
        }

        private void emitUnbindHandlerVariable(ExceptHandlerTy.ExceptHandler handler) {
            this.b.beginBlock();
            RootNodeCompiler.this.beginStoreLocal(handler.name, this.b);
            this.b.emitLoadConstant(PNone.NONE);
            RootNodeCompiler.this.endStoreLocal(handler.name, this.b);
            RootNodeCompiler.this.emitDelLocal(handler.name, this.b);
            this.b.endBlock();
        }

        @Override
        public Void visit(StmtTy.TryStar node) {
            RootNodeCompiler.this.emitNotImplemented("try star", this.b);
            return null;
        }

        @Override
        public Void visit(ExceptHandlerTy.ExceptHandler node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(StmtTy.While node) {
            BytecodeLabel currentBreakLabel;
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.b.beginBlock();
            BytecodeLabel oldBreakLabel = this.breakLabel;
            BytecodeLabel oldContinueLabel = this.continueLabel;
            this.breakLabel = currentBreakLabel = this.b.createLabel();
            this.b.beginWhile();
            this.b.beginBlock();
            this.b.emitTraceLineAtLoopHeader(RootNodeCompiler.this.currentLocation.startLine);
            this.visitCondition(node.test);
            this.b.endBlock();
            this.b.beginBlock();
            this.continueLabel = this.b.createLabel();
            this.visitStatements(node.body);
            this.b.emitLabel(this.continueLabel);
            this.b.endBlock();
            this.b.endWhile();
            this.breakLabel = oldBreakLabel;
            this.continueLabel = oldContinueLabel;
            this.visitStatements(node.orElse);
            this.b.emitLabel(currentBreakLabel);
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        private void visitWithRecurse(WithItemTy[] items, int index, StmtTy[] body, boolean async) {
            WithItemTy item = items[index];
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(item, this.b);
            this.b.beginBlock();
            BytecodeLocal contextManager = this.b.createLocal();
            this.b.beginStoreLocal(contextManager);
            item.contextExpr.accept(this);
            this.b.endStoreLocal();
            BytecodeLocal exit = this.b.createLocal();
            BytecodeLocal value = this.b.createLocal();
            if (async) {
                this.b.beginAsyncContextManagerEnter(exit, value);
                this.b.emitLoadLocal(contextManager);
                this.b.endAsyncContextManagerEnter();
                this.emitAwait(() -> this.b.emitLoadLocal(value));
            } else {
                this.b.beginContextManagerEnter(exit, value);
                this.b.emitLoadLocal(contextManager);
                this.b.endContextManagerEnter();
            }
            Runnable finallyHandler = async ? () -> this.emitAwait(() -> {
                this.b.beginAsyncContextManagerCallExit();
                this.b.emitLoadConstant(PNone.NONE);
                this.b.emitLoadLocal(exit);
                this.b.emitLoadLocal(contextManager);
                this.b.endAsyncContextManagerCallExit();
            }) : () -> {
                this.b.beginContextManagerExit();
                this.b.emitLoadConstant(PNone.NONE);
                this.b.emitLoadLocal(exit);
                this.b.emitLoadLocal(contextManager);
                this.b.endContextManagerExit();
            };
            this.b.beginTryCatchOtherwise(finallyHandler);
            this.b.beginBlock();
            if (item.optionalVars != null) {
                item.optionalVars.accept(new StoreVisitor(() -> this.b.emitLoadLocal(value)));
            }
            if (index < items.length - 1) {
                this.visitWithRecurse(items, index + 1, body, async);
            } else {
                this.visitSequence(body);
            }
            this.b.endBlock();
            this.b.beginBlock();
            this.b.beginMarkExceptionAsCaught();
            this.b.emitLoadException();
            this.b.endMarkExceptionAsCaught();
            if (async) {
                this.b.beginAsyncContextManagerExit();
                this.b.emitLoadException();
                this.emitAwait(() -> {
                    this.b.beginAsyncContextManagerCallExit();
                    this.b.emitLoadException();
                    this.b.emitLoadLocal(exit);
                    this.b.emitLoadLocal(contextManager);
                    this.b.endAsyncContextManagerCallExit();
                });
                this.b.endAsyncContextManagerExit();
            } else {
                this.b.beginContextManagerExit();
                this.b.emitLoadException();
                this.b.emitLoadLocal(exit);
                this.b.emitLoadLocal(contextManager);
                this.b.endContextManagerExit();
            }
            this.b.endBlock();
            this.b.endTryCatchOtherwise();
            this.b.endBlock();
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
        }

        @Override
        public Void visit(StmtTy.With node) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
            this.visitWithRecurse(node.items, 0, node.body, false);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(WithItemTy node) {
            throw new UnsupportedOperationException(String.valueOf(node.getClass()));
        }

        @Override
        public Void visit(StmtTy.Break aThis) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(aThis, this.b);
            if (this.breakLabel == null) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'break' outside loop");
            }
            this.b.emitBranch(this.breakLabel);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.Continue aThis) {
            boolean newStatement = RootNodeCompiler.this.beginSourceSection(aThis, this.b);
            if (this.continueLabel == null) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "'continue' not properly in loop");
            }
            this.b.emitBranch(this.continueLabel);
            RootNodeCompiler.this.endSourceSection(this.b, newStatement);
            return null;
        }

        @Override
        public Void visit(StmtTy.TypeAlias node) {
            this.b.beginBlock();
            String name = ((ExprTy.Name)node.name).id;
            RootNodeCompiler.this.beginStoreLocal(name, this.b);
            if (node.isGeneric()) {
                RootNodeCompiler typeParamsCompiler = new RootNodeCompiler(RootNodeCompiler.this.ctx, RootNodeCompiler.this, null, node, node.typeParams, RootNodeCompiler.this.futureFeatures);
                BytecodeDSLCompiler.BytecodeDSLCompilerResult body = this.createRootNodeCompilerFor(node, typeParamsCompiler).compileTypeAliasBody(node);
                BytecodeDSLCompiler.BytecodeDSLCompilerResult typeParamsFun = typeParamsCompiler.compileTypeAliasTypeParameters(name, body.codeUnit(), node);
                String typeParamsName = "<generic parameters of " + name + ">";
                this.b.beginCallNilaryMethod();
                this.emitMakeFunction(typeParamsFun.codeUnit(), node.typeParams, typeParamsName, null, null);
                this.b.endCallNilaryMethod();
            } else {
                BytecodeDSLCompiler.BytecodeDSLCompilerResult body = this.createRootNodeCompilerFor(node).compileTypeAliasBody(node);
                this.emitBuildTypeAlias(body.codeUnit(), node);
            }
            RootNodeCompiler.this.endStoreLocal(name, this.b);
            RootNodeCompiler.this.emitReadLocal(name, this.b);
            this.b.endBlock();
            return null;
        }

        public void emitBuildTypeAlias(BytecodeDSLCodeUnit body, StmtTy.TypeAlias node) {
            String name = ((ExprTy.Name)node.name).id;
            this.b.beginMakeTypeAliasType();
            RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(name), this.b);
            if (node.isGeneric()) {
                this.visitTypeParams(node.typeParams);
            } else {
                this.b.emitLoadNull();
            }
            this.emitMakeFunction(body, node, name, null, null);
            this.b.endMakeTypeAliasType();
        }

        @Override
        public Void visit(TypeParamTy.TypeVar node) {
            this.b.beginBlock();
            RootNodeCompiler.this.beginStoreLocal(node.name, this.b);
            if (node.bound != null) {
                BytecodeDSLCompiler.BytecodeDSLCompilerResult code = this.createRootNodeCompilerFor(node).compileBoundTypeVar(node);
                int kind = node.bound instanceof ExprTy.Tuple ? 4 : 3;
                this.b.beginMakeTypeParam(kind);
                RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(node.name), this.b);
                this.emitMakeFunction(code.codeUnit(), node, node.name, null, null);
                this.b.endMakeTypeParam();
            } else {
                this.b.beginMakeTypeParam(0);
                RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(node.name), this.b);
                this.b.emitLoadNull();
                this.b.endMakeTypeParam();
            }
            RootNodeCompiler.this.endStoreLocal(node.name, this.b);
            RootNodeCompiler.this.emitReadLocal(node.name, this.b);
            this.b.endBlock();
            return null;
        }

        @Override
        public Void visit(TypeParamTy.ParamSpec node) {
            this.b.beginBlock();
            RootNodeCompiler.this.beginStoreLocal(node.name, this.b);
            this.b.beginMakeTypeParam(2);
            RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(node.name), this.b);
            this.b.emitLoadNull();
            this.b.endMakeTypeParam();
            RootNodeCompiler.this.endStoreLocal(node.name, this.b);
            RootNodeCompiler.this.emitReadLocal(node.name, this.b);
            this.b.endBlock();
            return null;
        }

        @Override
        public Void visit(TypeParamTy.TypeVarTuple node) {
            this.b.beginBlock();
            RootNodeCompiler.this.beginStoreLocal(node.name, this.b);
            this.b.beginMakeTypeParam(1);
            RootNodeCompiler.this.emitPythonConstant(PythonUtils.toTruffleStringUncached(node.name), this.b);
            this.b.emitLoadNull();
            this.b.endMakeTypeParam();
            RootNodeCompiler.this.endStoreLocal(node.name, this.b);
            RootNodeCompiler.this.emitReadLocal(node.name, this.b);
            this.b.endBlock();
            return null;
        }

        @Override
        public Void visit(StmtTy.Pass node) {
            return null;
        }

        public class StoreVisitor
        implements BaseBytecodeDSLVisitor<Void> {
            private final PBytecodeDSLRootNodeGen.Builder b;
            private final Runnable generateValue;

            StoreVisitor(Runnable generateValue) {
                this.b = StatementCompiler.this.b;
                this.generateValue = generateValue;
            }

            @Override
            public Void visit(ExprTy.Name node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                RootNodeCompiler.this.beginStoreLocal(node.id, this.b);
                this.generateValue.run();
                RootNodeCompiler.this.endStoreLocal(node.id, this.b);
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(ExprTy.Attribute node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                RootNodeCompiler.this.checkForbiddenName(node.attr, NameOperation.BeginWrite);
                RootNodeCompiler.this.beginSetAttribute(node.attr, this.b);
                this.generateValue.run();
                node.value.accept(StatementCompiler.this);
                this.b.endSetAttribute();
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(ExprTy.Subscript node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                this.b.beginSetItem();
                this.generateValue.run();
                node.value.accept(StatementCompiler.this);
                node.slice.accept(StatementCompiler.this);
                this.b.endSetItem();
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }

            private void visitIterableAssign(ExprTy[] nodes) {
                int i;
                this.b.beginBlock();
                BytecodeLocal[] targets = new BytecodeLocal[nodes.length];
                for (int i2 = 0; i2 < targets.length; ++i2) {
                    targets[i2] = this.b.createLocal();
                }
                int indexOfStarred = -1;
                for (i = 0; i < nodes.length; ++i) {
                    if (!(nodes[i] instanceof ExprTy.Starred)) continue;
                    indexOfStarred = i;
                    break;
                }
                if (indexOfStarred == -1) {
                    this.b.beginUnpackToLocals(targets);
                } else {
                    this.b.beginUnpackStarredToLocals(indexOfStarred, targets);
                }
                this.generateValue.run();
                if (indexOfStarred == -1) {
                    this.b.endUnpackToLocals();
                } else {
                    this.b.endUnpackStarredToLocals();
                }
                for (i = 0; i < nodes.length; ++i) {
                    int index = i;
                    ExprTy target = nodes[i];
                    if (nodes[i] instanceof ExprTy.Starred) {
                        target = ((ExprTy.Starred)target).value;
                    }
                    target.accept(new StoreVisitor(() -> this.b.emitLoadLocal(targets[index])));
                }
                this.b.endBlock();
            }

            @Override
            public Void visit(ExprTy.Tuple node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                this.visitIterableAssign(node.elements);
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(StmtTy.TypeAlias node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.TypeVar node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.ParamSpec node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.TypeVarTuple node) {
                return null;
            }

            @Override
            public Void visit(ExprTy.List node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                this.visitIterableAssign(node.elements);
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }
        }

        private class AugStoreVisitor
        implements BaseBytecodeDSLVisitor<Void> {
            private final PBytecodeDSLRootNodeGen.Builder b;
            private final ExprTy value;
            private final OperatorTy op;

            AugStoreVisitor(OperatorTy op, ExprTy value) {
                this.b = StatementCompiler.this.b;
                this.op = op;
                this.value = value;
            }

            private void beginAugAssign() {
                switch (this.op) {
                    case Add: {
                        this.b.beginPyNumberInPlaceAdd();
                        break;
                    }
                    case Sub: {
                        this.b.beginPyNumberInPlaceSubtract();
                        break;
                    }
                    case Mult: {
                        this.b.beginPyNumberInPlaceMultiply();
                        break;
                    }
                    case FloorDiv: {
                        this.b.beginPyNumberInPlaceFloorDivide();
                        break;
                    }
                    case BitAnd: {
                        this.b.beginPyNumberInPlaceAnd();
                        break;
                    }
                    case BitOr: {
                        this.b.beginPyNumberInPlaceOr();
                        break;
                    }
                    case BitXor: {
                        this.b.beginPyNumberInPlaceXor();
                        break;
                    }
                    case RShift: {
                        this.b.beginPyNumberInPlaceRshift();
                        break;
                    }
                    case LShift: {
                        this.b.beginPyNumberInPlaceLshift();
                        break;
                    }
                    case Div: {
                        this.b.beginPyNumberInPlaceTrueDivide();
                        break;
                    }
                    case Mod: {
                        this.b.beginPyNumberInPlaceRemainder();
                        break;
                    }
                    case MatMult: {
                        this.b.beginPyNumberInPlaceMatrixMultiply();
                        break;
                    }
                    case Pow: {
                        this.b.beginInPlacePow();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("aug ass: " + String.valueOf((Object)this.op));
                    }
                }
            }

            private void endAugAssign() {
                switch (this.op) {
                    case Add: {
                        this.b.endPyNumberInPlaceAdd();
                        break;
                    }
                    case Sub: {
                        this.b.endPyNumberInPlaceSubtract();
                        break;
                    }
                    case Mult: {
                        this.b.endPyNumberInPlaceMultiply();
                        break;
                    }
                    case FloorDiv: {
                        this.b.endPyNumberInPlaceFloorDivide();
                        break;
                    }
                    case BitAnd: {
                        this.b.endPyNumberInPlaceAnd();
                        break;
                    }
                    case BitOr: {
                        this.b.endPyNumberInPlaceOr();
                        break;
                    }
                    case BitXor: {
                        this.b.endPyNumberInPlaceXor();
                        break;
                    }
                    case RShift: {
                        this.b.endPyNumberInPlaceRshift();
                        break;
                    }
                    case LShift: {
                        this.b.endPyNumberInPlaceLshift();
                        break;
                    }
                    case Div: {
                        this.b.endPyNumberInPlaceTrueDivide();
                        break;
                    }
                    case Mod: {
                        this.b.endPyNumberInPlaceRemainder();
                        break;
                    }
                    case MatMult: {
                        this.b.endPyNumberInPlaceMatrixMultiply();
                        break;
                    }
                    case Pow: {
                        this.b.endInPlacePow();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("aug ass: " + String.valueOf((Object)this.op));
                    }
                }
            }

            @Override
            public Void visit(ExprTy.Name node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                RootNodeCompiler.this.beginStoreLocal(node.id, this.b);
                this.beginAugAssign();
                RootNodeCompiler.this.emitReadLocal(node.id, this.b);
                this.value.accept(StatementCompiler.this);
                this.endAugAssign();
                RootNodeCompiler.this.endStoreLocal(node.id, this.b);
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(TypeParamTy.TypeVar node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.ParamSpec node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.TypeVarTuple node) {
                return null;
            }

            @Override
            public Void visit(StmtTy.TypeAlias node) {
                return null;
            }

            @Override
            public Void visit(ExprTy.Attribute node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                this.b.beginBlock();
                BytecodeLocal target = this.b.createLocal();
                this.b.beginStoreLocal(target);
                node.value.accept(StatementCompiler.this);
                this.b.endStoreLocal();
                RootNodeCompiler.this.beginSetAttribute(node.attr, this.b);
                this.beginAugAssign();
                RootNodeCompiler.this.beginGetAttribute(node.attr, this.b);
                this.b.emitLoadLocal(target);
                this.b.endGetAttribute();
                this.value.accept(StatementCompiler.this);
                this.endAugAssign();
                this.b.emitLoadLocal(target);
                this.b.endSetAttribute();
                this.b.endBlock();
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(ExprTy.Subscript node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, this.b);
                this.b.beginBlock();
                BytecodeLocal target = this.b.createLocal();
                BytecodeLocal slice = this.b.createLocal();
                this.b.beginStoreLocal(target);
                node.value.accept(StatementCompiler.this);
                this.b.endStoreLocal();
                this.b.beginStoreLocal(slice);
                node.slice.accept(StatementCompiler.this);
                this.b.endStoreLocal();
                this.b.beginSetItem();
                this.beginAugAssign();
                this.b.beginBinarySubscript();
                this.b.emitLoadLocal(target);
                this.b.emitLoadLocal(slice);
                this.b.endBinarySubscript();
                this.value.accept(StatementCompiler.this);
                this.endAugAssign();
                this.b.emitLoadLocal(target);
                this.b.emitLoadLocal(slice);
                this.b.endSetItem();
                this.b.endBlock();
                RootNodeCompiler.this.endSourceSection(this.b, newStatement);
                return null;
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static abstract class KeywordGroup {
            private KeywordGroup() {
            }
        }

        private static final class SplatKeywords
        extends KeywordGroup {
            final ExprTy expr;

            SplatKeywords(ExprTy expr) {
                this.expr = expr;
            }
        }

        private static final class NamedKeywords
        extends KeywordGroup {
            final ArrayList<TruffleString> names;
            final ArrayList<ExprTy> values;

            NamedKeywords(ArrayList<TruffleString> names, ArrayList<ExprTy> values) {
                this.names = names;
                this.values = values;
            }
        }

        private class DeleteVisitor
        implements BaseBytecodeDSLVisitor<Void> {
            private DeleteVisitor() {
            }

            @Override
            public Void visit(ExprTy.Subscript node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, StatementCompiler.this.b);
                StatementCompiler.this.b.beginDeleteItem();
                node.value.accept(StatementCompiler.this);
                node.slice.accept(StatementCompiler.this);
                StatementCompiler.this.b.endDeleteItem();
                RootNodeCompiler.this.endSourceSection(StatementCompiler.this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(ExprTy.Attribute node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, StatementCompiler.this.b);
                StatementCompiler.this.b.beginDeleteAttribute(PythonUtils.toTruffleStringUncached(RootNodeCompiler.this.maybeMangle(node.attr)));
                node.value.accept(StatementCompiler.this);
                StatementCompiler.this.b.endDeleteAttribute();
                RootNodeCompiler.this.endSourceSection(StatementCompiler.this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(ExprTy.Name node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, StatementCompiler.this.b);
                RootNodeCompiler.this.emitNameOperation(node.id, NameOperation.Delete, StatementCompiler.this.b);
                RootNodeCompiler.this.endSourceSection(StatementCompiler.this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(ExprTy.Tuple node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, StatementCompiler.this.b);
                StatementCompiler.this.b.beginBlock();
                this.visitSequence(node.elements);
                StatementCompiler.this.b.endBlock();
                RootNodeCompiler.this.endSourceSection(StatementCompiler.this.b, newStatement);
                return null;
            }

            @Override
            public Void visit(StmtTy.TypeAlias node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.TypeVar node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.ParamSpec node) {
                return null;
            }

            @Override
            public Void visit(TypeParamTy.TypeVarTuple node) {
                return null;
            }

            @Override
            public Void visit(ExprTy.List node) {
                boolean newStatement = RootNodeCompiler.this.beginSourceSection(node, StatementCompiler.this.b);
                StatementCompiler.this.b.beginBlock();
                this.visitSequence(node.elements);
                StatementCompiler.this.b.endBlock();
                RootNodeCompiler.this.endSourceSection(StatementCompiler.this.b, newStatement);
                return null;
            }
        }

        private final class PatternContext {
            private final Map<String, BytecodeLocal> bindVariables = new HashMap<String, BytecodeLocal>();
            private final BytecodeLocal subject;
            private boolean allowIrrefutable = false;

            PatternContext(BytecodeLocal subject) {
                this.subject = subject;
            }

            public void copySubjectToTemporary(String name) {
                BytecodeLocal temporary = this.allocateBindVariable(name);
                StatementCompiler.this.b.beginStoreLocal(temporary);
                StatementCompiler.this.b.emitLoadLocal(this.subject);
                StatementCompiler.this.b.endStoreLocal();
            }

            private BytecodeLocal allocateBindVariable(String name) {
                RootNodeCompiler.this.checkForbiddenName(name, NameOperation.BeginWrite);
                if (this.bindVariables.containsKey(name)) {
                    this.duplicateStoreError(name);
                }
                BytecodeLocal result = StatementCompiler.this.b.createLocal();
                this.bindVariables.put(name, result);
                return result;
            }

            private void duplicateStoreError(String name) {
                RootNodeCompiler.this.ctx.errorCallback.onError(ParserCallbacks.ErrorType.Syntax, RootNodeCompiler.this.currentLocation, "multiple assignments to name '%s' in pattern", name);
            }
        }
    }
}

