/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;

public class PBytecodeGeneratorFunctionRootNode
extends PRootNode {
    private final PBytecodeRootNode rootNode;
    private final TruffleString originalName;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final RootCallTarget[] callTargets;
    private final ConditionProfile isIterableCoroutine = ConditionProfile.create();

    @CompilerDirectives.TruffleBoundary
    public PBytecodeGeneratorFunctionRootNode(PythonLanguage language, FrameDescriptor frameDescriptor, PBytecodeRootNode rootNode, TruffleString originalName) {
        super(language, frameDescriptor);
        this.rootNode = rootNode;
        this.originalName = originalName;
        this.callTargets = new RootCallTarget[rootNode.getCodeUnit().code.length];
        this.callTargets[0] = new PBytecodeGeneratorRootNode(language, rootNode, 0, rootNode.getInitialStackTop()).getCallTarget();
    }

    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        PythonLanguage language = PythonLanguage.get((Node)this);
        PFunction generatorFunction = PArguments.getGeneratorFunction(arguments);
        assert (generatorFunction != null);
        if (this.rootNode.getCodeUnit().isGenerator()) {
            if (this.isIterableCoroutine.profile((generatorFunction.getCode().getFlags() & 0x100) != 0)) {
                return PFactory.createIterableCoroutine(language, generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, this.callTargets, arguments);
            }
            return PFactory.createGenerator(language, generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, this.callTargets, arguments);
        }
        if (this.rootNode.getCodeUnit().isCoroutine()) {
            return PFactory.createCoroutine(language, generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, this.callTargets, arguments);
        }
        if (this.rootNode.getCodeUnit().isAsyncGenerator()) {
            return PFactory.createAsyncGenerator(language, generatorFunction.getName(), generatorFunction.getQualname(), this.rootNode, this.callTargets, arguments);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unknown generator/coroutine type");
    }

    public String getName() {
        return this.originalName.toJavaStringUncached();
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "<generator function root " + String.valueOf(this.originalName) + ">";
    }

    @Override
    public Signature getSignature() {
        return this.rootNode.getSignature();
    }

    @Override
    public boolean isPythonInternal() {
        return this.rootNode.isPythonInternal();
    }

    public SourceSection getSourceSection() {
        return this.rootNode.getSourceSection();
    }

    public PBytecodeRootNode getBytecodeRootNode() {
        return this.rootNode;
    }

    @Override
    protected byte[] extractCode() {
        return this.rootNode.extractCode();
    }
}

