/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

abstract class AbstractMetadataMethod {
    private final RowDescriptor rowDescriptor;
    protected final DbMetadataMediator mediator;

    AbstractMetadataMethod(RowDescriptor rowDescriptor, DbMetadataMediator mediator) {
        this.rowDescriptor = rowDescriptor;
        this.mediator = mediator;
    }

    final ResultSet createMetaDataResultSet(DbMetadataMediator.MetadataQuery metadataQuery) throws SQLException {
        try (ResultSet rs = this.mediator.performMetaDataQuery(metadataQuery);){
            if (!rs.next()) {
                ResultSet resultSet = this.createEmpty();
                return resultSet;
            }
            ArrayList<RowValue> rowValues = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(this.rowDescriptor);
            do {
                rowValues.add(this.createMetadataRow(rs, valueBuilder));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(this.rowDescriptor, rowValues);
            return fBResultSet;
        }
    }

    abstract RowValue createMetadataRow(ResultSet var1, RowValueBuilder var2) throws SQLException;

    final ResultSet createEmpty() throws SQLException {
        return new FBResultSet(this.rowDescriptor, Collections.emptyList());
    }

    static String extractDefault(String defaultDefinition) {
        String prefix;
        if (defaultDefinition == null || defaultDefinition.isEmpty()) {
            return null;
        }
        if (defaultDefinition.length() > 7 && (prefix = defaultDefinition.substring(0, 7)).equalsIgnoreCase("DEFAULT")) {
            String defaultValue = defaultDefinition.substring(7).trim();
            return defaultValue.equalsIgnoreCase("NULL") ? "NULL" : defaultValue;
        }
        return defaultDefinition.trim();
    }
}

