/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGaussianImageSource_h
#define sitkGaussianImageSource_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageSourceTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class GaussianImageSource
\brief Generate an n-dimensional image of a Gaussian.

GaussianImageSource generates an image of a Gaussian. m_Normalized determines whether or not the Gaussian is normalized (whether or not the sum over infinite space is 1.0) When creating an image, it is preferable to not normalize the Gaussian m_Scale scales the output of the Gaussian to span a range larger than 0->1, and is typically set to the maximum value of the output data type (for instance, 255 for uchars)

The output image may be of any dimension.
\sa itk::simple::GaussianSource for the procedural interface
\sa itk::GaussianImageSource for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GaussianImageSource : public ImageFilter {
    public:
      using Self = GaussianImageSource;

      /** Destructor */
      virtual ~GaussianImageSource();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GaussianImageSource();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;



\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputPixelType ( PixelIDValueEnum OutputPixelType ) { this->m_OutputPixelType = OutputPixelType; return *this; }

      /**
       */
      PixelIDValueEnum GetOutputPixelType() const { return this->m_OutputPixelType; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSize ( std::vector<unsigned int> Size ) { this->m_Size = std::move(Size); return *this; }

      /**
       */
      std::vector<unsigned int> GetSize() const { return this->m_Size; }\

      /**
       * Set/Get the standard deviation in each direction.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma ( std::vector<double> Sigma ) { this->m_Sigma = std::move(Sigma); return *this; }

      /** Set the values of the Sigma vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma( double value ) { this->m_Sigma = std::vector<double>(3, value); return *this; }

      /**
       * Set/Get the standard deviation in each direction.
       */
      std::vector<double> GetSigma() const { return this->m_Sigma; }\

      /**
       * Set/Get the mean in each direction.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMean ( std::vector<double> Mean ) { this->m_Mean = std::move(Mean); return *this; }

      /** Set the values of the Mean vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetMean( double value ) { this->m_Mean = std::vector<double>(3, value); return *this; }

      /**
       * Set/Get the mean in each direction.
       */
      std::vector<double> GetMean() const { return this->m_Mean; }\

      /**
       * Gets and sets for Gaussian parameters Set/Get the scale factor to multiply the true value of the Gaussian.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetScale ( double Scale ) { this->m_Scale = Scale; return *this; }

      /**
       * Gets and sets for Gaussian parameters Set/Get the scale factor to multiply the true value of the Gaussian.
       */
      double GetScale() const { return this->m_Scale; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOrigin ( std::vector<double> Origin ) { this->m_Origin = std::move(Origin); return *this; }

      /**
       */
      std::vector<double> GetOrigin() const { return this->m_Origin; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSpacing ( std::vector<double> Spacing ) { this->m_Spacing = std::move(Spacing); return *this; }

      /**
       */
      std::vector<double> GetSpacing() const { return this->m_Spacing; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDirection ( std::vector<double> Direction ) { this->m_Direction = Direction; return *this; }

      /**
       */
      std::vector<double> GetDirection() const { return this->m_Direction; }\

      /**
       * Set/Get whether or not to normalize the Gaussian. Default is false.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalized ( bool Normalized ) { this->m_Normalized = Normalized; return *this; }

      /** Set the value of Normalized to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizedOn() { return this->SetNormalized(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizedOff() { return this->SetNormalized(false); }

      /**
       * Set/Get whether or not to normalize the Gaussian. Default is false.
       */
      bool GetNormalized() const { return this->m_Normalized; }

      /** Name of this class */
      std::string GetName() const { return std::string ("GaussianImageSource"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute (  );


    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)(  );
      template <class TImageType> Image ExecuteInternal (  );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      PixelIDValueEnum  m_OutputPixelType{itk::simple::sitkFloat32};

      std::vector<unsigned int>  m_Size{std::vector<unsigned int>(3, 64)};

      std::vector<double>  m_Sigma{std::vector<double>(3, 16.0)};

      std::vector<double>  m_Mean{std::vector<double>(3, 32.0)};

      double  m_Scale{255};

      std::vector<double>  m_Origin{std::vector<double>(3, 0.0)};

      std::vector<double>  m_Spacing{std::vector<double>(3, 1.0)};

      /* Passing a zero sized array, defaults to identiy matrix. The size of the array must exactly match the direction matrix for the dimension of the image. */
      std::vector<double>  m_Direction{std::vector<double>()};

      bool  m_Normalized{false};





    };



   /**
     * \brief Generate an n-dimensional image of a Gaussian.
     *
     * This function directly calls the execute method of GaussianImageSource
     * in order to support a procedural API
     *
     * \sa itk::simple::GaussianImageSource for the object oriented interface
     */
SITKBasicFilters_EXPORT Image GaussianSource ( PixelIDValueEnum outputPixelType = itk::simple::sitkFloat32, std::vector<unsigned int> size = std::vector<unsigned int>(3, 64), std::vector<double> sigma = std::vector<double>(3, 16.0), std::vector<double> mean = std::vector<double>(3, 32.0), double scale = 255, std::vector<double> origin = std::vector<double>(3, 0.0), std::vector<double> spacing = std::vector<double>(3, 1.0), std::vector<double> direction = std::vector<double>(), bool normalized = false );
}
#endif
