/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCacheRequest;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarCache {
    public static String TABLE_NAME = "maincache";
    private HarCacheRequest beforeRequest;
    private HarCacheRequest afterRequest;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarCache() {
    }

    public HarCache(HarCacheRequest beforeRequest, HarCacheRequest afterRequest, String comment) {
        this.beforeRequest = beforeRequest;
        this.afterRequest = afterRequest;
        this.comment = comment;
    }

    public HarCache(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"cache\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("beforeRequest".equals(name)) {
                this.setBeforeRequest(new HarCacheRequest(jp, true, warnings));
                continue;
            }
            if ("afterRequest".equals(name)) {
                this.setAfterRequest(new HarCacheRequest(jp, false, warnings));
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in cache element", jp.getCurrentLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarCache(HarDatabaseConfig config, long entryId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + "maincache";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,comment FROM " + tableName + " WHERE entry_id=?");
            ps.setLong(1, entryId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarCache for entry id " + entryId + " found in database");
            }
            long cacheId = rs.getLong(1);
            this.setComment(rs.getString(2));
            try {
                this.beforeRequest = new HarCacheRequest(config, cacheId, true);
            }
            catch (Exception ignore) {
                this.beforeRequest = null;
            }
            try {
                this.afterRequest = new HarCacheRequest(config, cacheId, false);
            }
            catch (Exception ignore) {
                this.afterRequest = null;
            }
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARCACHE, cacheId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("cache");
        if (this.beforeRequest != null) {
            this.beforeRequest.writeHar(g);
        }
        if (this.afterRequest != null) {
            this.afterRequest.writeHar(g);
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long entryId, HarDatabaseConfig config, long logId) throws SQLException {
        String cacheTableName;
        if (this.comment == null && this.afterRequest == null && this.beforeRequest == null) {
            return;
        }
        Connection c = config.getConnection();
        String mainCacheTableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(mainCacheTableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + mainCacheTableName + " (id " + config.getDbAutoGeneratedId() + ",comment " + config.getStringDbType() + ",entry_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(mainCacheTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        if (!config.isCreatedTable(cacheTableName = config.getTablePrefix() + HarCacheRequest.TABLE_NAME)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + cacheTableName + " (id " + config.getDbAutoGeneratedId() + ",expires " + config.getTimestampDbType() + ",last_access " + config.getTimestampDbType() + ",etag " + config.getStringDbType() + ",hit_count " + config.getLongDbType() + ",comment " + config.getStringDbType() + ",is_before " + config.getSmallIntDbType() + ",cache_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(cacheTableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        Statement ps = null;
        ResultSet rs = null;
        Statement cachePs = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + mainCacheTableName + " (comment,entry_id) VALUES (?,?)", 1);
            if (this.comment == null) {
                ps.setNull(1, -1);
            } else {
                ps.setString(1, this.comment);
            }
            ps.setLong(2, entryId);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarCache entry");
            }
            long cacheId = rs.getLong(1);
            cachePs = c.prepareStatement("INSERT INTO " + cacheTableName + " (expires,last_access,etag,hit_count,comment,is_before,cache_id) VALUES (?,?,?,?,?,?,?)");
            if (this.beforeRequest != null) {
                this.beforeRequest.writeJDBC(cacheId, config, (PreparedStatement)cachePs, logId);
            }
            if (this.afterRequest != null) {
                this.afterRequest.writeJDBC(cacheId, config, (PreparedStatement)cachePs, logId);
            }
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARCACHE, cacheId, logId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (cachePs != null) {
                    cachePs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        String mainCacheTableName = config.getTablePrefix() + TABLE_NAME;
        String cacheTableName = config.getTablePrefix() + HarCacheRequest.TABLE_NAME;
        if (!config.isCreatedTable(mainCacheTableName)) {
            return;
        }
        Connection c = config.getConnection();
        Statement ps = null;
        Statement cachePs = null;
        try {
            if (config.isCreatedTable(cacheTableName)) {
                cachePs = c.prepareStatement("DELETE FROM " + cacheTableName + " WHERE cache_id IN (SELECT id FROM " + mainCacheTableName + " WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
                cachePs.setLong(1, logId);
                cachePs.executeUpdate();
                config.dropTableIfEmpty(c, cacheTableName, config);
            }
            ps = c.prepareStatement("DELETE FROM " + mainCacheTableName + " WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?)");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, mainCacheTableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (cachePs != null) {
                    cachePs.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public HarCacheRequest getBeforeRequest() {
        return this.beforeRequest;
    }

    public void setBeforeRequest(HarCacheRequest beforeRequest) {
        this.beforeRequest = beforeRequest;
    }

    public HarCacheRequest getAfterRequest() {
        return this.afterRequest;
    }

    public void setAfterRequest(HarCacheRequest afterRequest) {
        this.afterRequest = afterRequest;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"cache\": {" + this.beforeRequest + "," + this.afterRequest + ",\"comment\": " + this.comment + "\", " + this.customFields + "}\n";
    }
}

