/*
 * Alm.vala
 * Copyright (C) 2012 Seif Lotfy <seif@lotfy.com>
 * Copyright (C) 2012 Intel Corp.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * 
alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
 

 
namespace Alm {

	public class AlmWindow : Gtk.ApplicationWindow 
	{
		public AlmWindow (Application app)
		{
			Object(application: app);
			this.set_title (_("Activity Log Manager"));
			var widget = new ActivityLogManager();
			this.add(widget);
			this.show();
		}
		[CCode (instance_pos = -1)]
		public void on_destroy (Gtk.Widget window) 
		{
			Gtk.main_quit();
			this.destroy.connect(on_destroy);
		}
		
	}
	
	public class Application : Gtk.Application {
	
		protected override void activate () {
            new AlmWindow(this);
        }
        
        protected override void startup () {
            base.startup ();
        }
        
        public Application () {
            Object (application_id: "org.zeitgeist.Alm", flags: ApplicationFlags.FLAGS_NONE);
        }
        
        protected override void shutdown () {
            base.shutdown ();
        }
        
        void on_quit_activate () {
            quit ();
        }
        
	}
}

int main (string[] args) 
{
	Intl.bindtextdomain (Config.GETTEXT_PACKAGE, Config.GNOMELOCALEDIR);
	Intl.bind_textdomain_codeset (Config.GETTEXT_PACKAGE, "UTF-8");
	Intl.textdomain (Config.GETTEXT_PACKAGE);

	var alm = new Alm.Application ();
	return alm.run (args);
}
