// Copyright 2022 The PDFium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CORE_FXCRT_FIXED_TRY_ALLOC_ZEROED_DATA_VECTOR_H_
#define CORE_FXCRT_FIXED_TRY_ALLOC_ZEROED_DATA_VECTOR_H_

#include "core/fxcrt/fixed_size_data_vector.h"

// WARNING: Since FX_TryAlloc() can fail, one must always check if a
// FixedTryAllocZeroedDataVector is empty after creating one.
template <typename T>
using FixedTryAllocZeroedDataVector =
    fxcrt::FixedSizeDataVector<T,
                               fxcrt::DataVectorAllocOption::kTryInitialized>;

#endif  // CORE_FXCRT_FIXED_TRY_ALLOC_ZEROED_DATA_VECTOR_H_
