classvec2classmat <- function(yvec)
{
  if (!is.factor(yvec)) yvec <- factor(yvec)
  nclasses <- nlevels(yvec)
  na.idx <- which(is.na(yvec))
  
  outmat <- matrix(0, length(yvec), nclasses)
  dimnames(outmat) <- list(NULL, levels(yvec))
  
  for (i in 1:nclasses)
    outmat[which(as.integer(yvec) == i),i] <- 1

  outmat[na.idx,] <- NA
  
  outmat
}

classmat2classvec <- function(ymat, threshold=0)
{
  class.names <- dimnames(ymat)[[2]]
  if (is.null(class.names)) class.names <- 1:ncol(ymat)

  classes <- apply(ymat, 1, function(x) which(x == max(x))[1])
  classes[apply(ymat, 1, max) < threshold] <- NA
  
  factor(class.names[classes], levels = class.names)
}
