---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, listes, style des listes, 
              énumérations, list
---

# Comment créer son propre environnement de liste ?

Si vous pouvez modifier
les environnements de liste classiques (`itemize`, `enumerate`, `description`),
comme le montre la question
"[](/3_composition/texte/listes/modifier_les_environnements_de_liste)"
vous pouvez aussi créer votre propre environnement de liste.


## Avec les commandes de base

Dans LaTeX, la présentation des listes est associées à de nombreux paramètres.
L'extension <ctanpkg:layouts> permet de les visualiser.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{layouts}

\begin{document}
\begin{figure}
  \centering
  \listdiagram
  \caption{Paramètres des listes} 
\end{figure}
\end{document}
```

L'environnement `list` permet de définir son propre style de liste. Sa syntaxe
est la suivante :

```{noedit}
\begin{list}{⟨label⟩}{⟨format⟩}
...
\end{list}
```

L'argument `⟨label⟩` permet de définir le symbole qui sera associé 
à chaque élément de la liste, `⟨format⟩` permet de définir la mise en page
des éléments de la liste. Les paramètres utilisés pour définir 
cette mise en page sont les suivants :

- `topsep` espace vertical supplémentaire (ajoute à `\parskip`) 
  inséré entre le texte précédant la liste et le premier objet de la liste ;
- `partosep` espace vertical supplémentaire inséré devant la liste 
  si celle-ci est précédée d'une ligne blanche ;
- `itemsep` espace vertical supplémentaire (ajouté à `\parsep`) inséré 
  entre les éléments d'une liste.

Vous pouvez écrire par exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newenvironment{maliste}%
  {\begin{list}%
     {$\rightarrow$}%
     {\setlength{\labelwidth}{30pt}%
     \setlength{\leftmargin}{35pt}%
     \setlength{\itemsep}{\parsep}}%
  }%
  {\end{list}}

\begin{document}
Qu'elle est belle, ma nouvelle liste :
\begin{maliste}
   \item elle est fonctionnelle ;
   \item elle a du cachet :
   \begin{maliste}
      \item ses flêches lui donne beaucoup de dynamisme,
      \item ses espacements sont d'une élégance rare.
   \end{maliste}
\end{maliste}
\end{document}
```