---
myst:
  html_meta:
    keywords: LaTeX, fichiers, TDS, installer Texlive, installer LaTeX, configuration locale,
              texlive directory, texmf privé
---

# Comment procéder à des installations privées de fichiers ?

Il arrive parfois que vous ayez besoin d'une nouvelle version d'une extension ou d'une police, 
mais que la machine que vous utilisez soit maintenue par une personne 
ne voulant pas faire de mise à jour et ne vous donnant pas les droits nécessaires 
pour faire le travail vous-même. Une installation 
[temporaire](/5_fichiers/emplacements/installation_temporaire) 
est alors parfois la bonne approche. Cependant, dès lors qu'une installation soit nécessaire 
pour plus d'un projet, ces installations temporaires ne conviennent pas.

Dans les cas où vous disposez d'un espace de stockage adéquat, 
la bonne approche consiste à créer une installation privée de (La)TeX 
qui inclut les nouveaux éléments dont vous avez besoin. Si cette solution est l'idéale, 
elle n'est généralement pas possible.

Donc, puisque vous ne pouvez pas installer dans l'arborescence `texmf` publique, 
vous devez installer dans une arborescence `texmf` qui vous est propre. 
Heureusement, le standard TDS et les distributions modernes vous permettent de le faire. 
Les distributions les plus modernes se réfèrent à l'arbre comme `$TEXMFHOME` 
mais il s'appelait auparavant `$HOMETEXMF`. 
Ainsi, pour vérifier que votre système TeX supporte bien le mécanisme, vous devriez commencer, 
par exemple, par tester cette commande :

```bash
kpsewhich -var-value TEXMFHOME
```

Cela vous restituera presque invariablement un pointeur vers un sous-répertoire `texmf` 
de votre répertoire personnel. Une exception concerne ici les Macintosh, utilisant MacTeX, 
où le répertoire est conventionnellement `Library/texmf` dans votre répertoire personnel.

Si vous pouvez confirmer que la technique fonctionne, installez votre nouvelle extension (ou autre) 
au [bon endroit](ou_installer_les_packages) dans une arborescence basée 
sur `$HOME/texmf` et générez un index de cette arborescence :

```bash
texhash $HOME/texmf
```

L'argument spécifie ici quelle arborescence vous indexez. Il est ici nécessaire 
puisque vous n'avez pas, par hypothèse, accès à l'arborescence principale, 
et `texhash` sans l'argument essaierait d'écrire l'arborescence principale.

Il y a deux inconvénients à cette méthode simple : premièrement, 
l'installation que vous utilisez peut ne pas définir de répertoire TEXMF personnel, 
et deuxièmement, il peut y avoir un obstacle à l'utilisation de `$HOME/texmf` comme nom par défaut. 
Dans les deux cas, une bonne solution est d'avoir votre propre `texmf.cnf` 
--- une idée qui semble plus effrayante qu'elle ne l'est en réalité. 
Le fichier existant de l'installation peut être localisé avec la commande :

```bash
kpsewhich texmf.cnf
```

Faites une copie du fichier et placez-la dans un répertoire de votre choix. 
Ce peut être n'importe quel répertoire, mais un choix évident est le répertoire `web2c` 
de l'arborescence que vous voulez créer, c'est-à-dire `$HOME/texmf/web2c` ou un répertoire similaire. 
Créez une variable d'environnement pour pointer vers ce répertoire, par exemple en shell Bourne :

```bash
TEXMFCNF=$HOME/texmf/web2c
export TEXMFCNF
```

De même, en C-shell :


```csh
setenv TEXMFCNF $HOME/texmf/web2c
```

Éditez ensuite la copie de `texmf.cnf`. Il y aura une ligne dans le fichier existant 
qui définit l'arborescencee dans laquelle tout est recherché. 
La forme la plus simple de cette ligne est :

```text
TEXMF = !!$TEXMFMAIN
```

Il est toutefois probable qu'il y ait plusieurs paramètres alternatifs 
derrière les marqueurs de commentaires (`%`), 
et la personne qui a installé votre système peut les avoir laissés là. 
Quoi qu'il en soit, vous devez modifier la ligne en vigueur. 
Remplacez ce qui précède par trois lignes :

```text
HOMETEXMF = $HOME/texmf
TEXMF = {$HOMETEXMF,!!$TEXMFMAIN}
% TEXMF = !!$TEXMFMAIN
```

Le point important est que `$HOMETEXMF` doit venir avant ce qui était là avant, 
à l'intérieur des accolades. Supposons que vous avez dans votre cas :


```text
TEXMF = {!!$LOCALTEXMF,!!$TEXMFMAIN}
```

Il doit être converti en :

```text
HOMETEXMF = $HOME/texmf
TEXMF = {$HOMETEXMF,!!$LOCALTEXMF,!!$TEXMFMAIN}
% TEXMF = {!!$LOCALTEXMF,!!$TEXMFMAIN}
```

Pensez à conserver l'original, en tant que commentaire, afin d'avoir un aide-mémoire 
au cas où vous auriez besoin de faire un autre changement par la suite. 

Les signes `!` indiquent à la bibliothèque de recherche de fichiers qu'elle doit insister 
sur une arborescence de répertoires `texhash`. 
Si vous pouvez compter sur le fait que vous vous souviendrez de lancer `texhash` 
sur votre nouvelle arborescence à chaque fois que vous la modifiez, 
alors cela vaut la peine d'ajouter les marques à votre arborescence :

```text
TEXMF = {!!$HOMETEXMF,!!$LOCALTEXMF,!!$TEXMFMAIN}
```

Cette modificaiton permettra à (La)TeX de trouver ses fichiers un peu plus rapidement.

Après avoir effectué tous ces changements, (La)TeX devrait utiliser les fichiers 
de votre nouvelle arborescence, de préférence à tout ce qui se trouve dans l'arborescence principale.
Vous pouvez l'utiliser pour les mises à jour des extensions de l'arborescence principale, 
ainsi que pour l'installation de nouvelles versions.


:::{sources}
[Private installations of files](faquk:FAQ-privinst)
:::
