/* vala-dbus-binding-tool.c generated by valac 0.16.0, the Vala compiler
 * generated from vala-dbus-binding-tool.vala, do not modify */

/*
 * vala-dbus-binding-tool.vala
 *
 * (C) 2009 by Didier "Ptitjes" <ptitjes@free.fr>
 * (C) 2009-2011 the freesmartphone.org team <smartphones-standards@linuxtogo.org>
 *
 * GPLv3
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>
#include <stdio.h>
#include <libxml/parser.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SYNCHRONY (synchrony_get_type ())

#define TYPE_GENERATED_NAMESPACE (generated_namespace_get_type ())
#define GENERATED_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERATED_NAMESPACE, GeneratedNamespace))
#define GENERATED_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERATED_NAMESPACE, GeneratedNamespaceClass))
#define IS_GENERATED_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERATED_NAMESPACE))
#define IS_GENERATED_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERATED_NAMESPACE))
#define GENERATED_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERATED_NAMESPACE, GeneratedNamespaceClass))

typedef struct _GeneratedNamespace GeneratedNamespace;
typedef struct _GeneratedNamespaceClass GeneratedNamespaceClass;
typedef struct _GeneratedNamespacePrivate GeneratedNamespacePrivate;
#define _generated_namespace_unref0(var) ((var == NULL) ? NULL : (var = (generated_namespace_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecGeneratedNamespace ParamSpecGeneratedNamespace;

#define TYPE_BINDING_GENERATOR (binding_generator_get_type ())
#define BINDING_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BINDING_GENERATOR, BindingGenerator))
#define BINDING_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BINDING_GENERATOR, BindingGeneratorClass))
#define IS_BINDING_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BINDING_GENERATOR))
#define IS_BINDING_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BINDING_GENERATOR))
#define BINDING_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BINDING_GENERATOR, BindingGeneratorClass))

typedef struct _BindingGenerator BindingGenerator;
typedef struct _BindingGeneratorClass BindingGeneratorClass;
typedef struct _BindingGeneratorPrivate BindingGeneratorPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	GENERATOR_ERROR_FILE_NOT_FOUND,
	GENERATOR_ERROR_CANT_CREATE_FILE,
	GENERATOR_ERROR_UNKNOWN_DBUS_TYPE
} GeneratorError;
#define GENERATOR_ERROR generator_error_quark ()
typedef enum  {
	SYNCHRONY_AUTO,
	SYNCHRONY_FORCE_SYNC,
	SYNCHRONY_FORCE_ASYNC
} Synchrony;

struct _GeneratedNamespace {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeneratedNamespacePrivate * priv;
	GeneratedNamespace* parent;
	gchar* name;
	GeeMap* members;
	GeeMap* namespaces;
};

struct _GeneratedNamespaceClass {
	GTypeClass parent_class;
	void (*finalize) (GeneratedNamespace *self);
};

struct _ParamSpecGeneratedNamespace {
	GParamSpec parent_instance;
};

struct _BindingGenerator {
	GObject parent_instance;
	BindingGeneratorPrivate * priv;
};

struct _BindingGeneratorClass {
	GObjectClass parent_class;
};

struct _BindingGeneratorPrivate {
	gchar* output_directory;
	GeeMap* namespace_renaming;
	gchar* command;
	guint dbus_timeout;
	gboolean inner_interface_strategy_concat;
	FILE* output;
	GeeList* api_docs;
	GeneratedNamespace* root_namespace;
	GeeMap* name_index;
	GeeMap* error_name_index;
	GeeMap* structs_to_generate;
	gint indentSize;
};


static gpointer generated_namespace_parent_class = NULL;
static gpointer binding_generator_parent_class = NULL;
static GeeSet* binding_generator_registered_names;
static GeeSet* binding_generator_registered_names = NULL;
static gint binding_generator_verbosity;
static gint binding_generator_verbosity = 0;
static gint binding_generator_errors;
static gint binding_generator_errors = 0;
static gboolean binding_generator_synced;
static gboolean binding_generator_synced = FALSE;
static gboolean binding_generator_gdbus;
static gboolean binding_generator_gdbus = FALSE;

GQuark generator_error_quark (void);
GType synchrony_get_type (void) G_GNUC_CONST;
gpointer generated_namespace_ref (gpointer instance);
void generated_namespace_unref (gpointer instance);
GParamSpec* param_spec_generated_namespace (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_generated_namespace (GValue* value, gpointer v_object);
void value_take_generated_namespace (GValue* value, gpointer v_object);
gpointer value_get_generated_namespace (const GValue* value);
GType generated_namespace_get_type (void) G_GNUC_CONST;
enum  {
	GENERATED_NAMESPACE_DUMMY_PROPERTY
};
GeneratedNamespace* generated_namespace_new (void);
GeneratedNamespace* generated_namespace_construct (GType object_type);
static void generated_namespace_finalize (GeneratedNamespace* obj);
GType binding_generator_get_type (void) G_GNUC_CONST;
#define BINDING_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BINDING_GENERATOR, BindingGeneratorPrivate))
enum  {
	BINDING_GENERATOR_DUMMY_PROPERTY
};
#define BINDING_GENERATOR_FSO_NAMESPACE "http://www.freesmartphone.org/schemas/DBusSpecExtension"
#define BINDING_GENERATOR_INTERFACE_ELTNAME "interface"
#define BINDING_GENERATOR_METHOD_ELTNAME "method"
#define BINDING_GENERATOR_SIGNAL_ELTNAME "signal"
#define BINDING_GENERATOR_PROPERTY_ELTNAME "property"
#define BINDING_GENERATOR_ARG_ELTNAME "arg"
#define BINDING_GENERATOR_NAME_ATTRNAME "name"
#define BINDING_GENERATOR_TYPE_ATTRNAME "type"
#define BINDING_GENERATOR_DIRECTION_ATTRNAME "direction"
#define BINDING_GENERATOR_REPLACED_BY_ATTRNAME "replaced-by"
#define BINDING_GENERATOR_IN_ATTRVALUE "in"
#define BINDING_GENERATOR_OUT_ATTRVALUE "out"
#define BINDING_GENERATOR_ENUMERATION_ELTNAME "enumeration"
#define BINDING_GENERATOR_MEMBER_ELTNAME "member"
#define BINDING_GENERATOR_VALUE_ATTRNAME "value"
#define BINDING_GENERATOR_ERRORDOMAIN_ELTNAME "errordomain"
#define BINDING_GENERATOR_ERROR_ELTNAME "error"
#define BINDING_GENERATOR_NO_CONTAINER_ATTRNAME "no-container"
#define BINDING_GENERATOR_THROWS_ELTNAME "throws"
#define BINDING_GENERATOR_STRUCT_ELTNAME "struct"
#define BINDING_GENERATOR_FIELD_ELTNAME "field"
#define BINDING_GENERATOR_ANNOTATION_ELTNAME "annotation"
#define BINDING_GENERATOR_DEPRECATED_ELTNAME "deprecated"
void binding_generator_INFO (const gchar* msg);
void binding_generator_DEBUG (const gchar* msg);
void binding_generator_WARN (const gchar* msg);
void binding_generator_ERROR (const gchar* msg);
gint binding_generator_main (gchar** args, int args_length1);
static void binding_generator_show_usage (const gchar* program_name);
static void binding_generator_show_version (void);
void binding_generator_generate (const gchar* api_path, const gchar* output_directory, GeeMap* namespace_renaming, const gchar* command, guint dbus_timeout, GError** error);
static BindingGenerator* binding_generator_new (const gchar* output_directory, GeeMap* namespace_renaming, const gchar* command, guint dbus_timeout);
static BindingGenerator* binding_generator_construct (GType object_type, const gchar* output_directory, GeeMap* namespace_renaming, const gchar* command, guint dbus_timeout);
static void binding_generator_generate_bindings (BindingGenerator* self, const gchar* api_path, GError** error);
static void binding_generator_add_api_file (BindingGenerator* self, const gchar* api_file, GError** error);
static void binding_generator_index_names (BindingGenerator* self, GeneratedNamespace* ns);
static void binding_generator_generate_namespace (BindingGenerator* self, GeneratedNamespace* ns, GError** error);
static void binding_generator_preprocess_binding_names (BindingGenerator* self, xmlDoc* api_doc);
static void binding_generator_create_binding_file (BindingGenerator* self, const gchar* name, GError** error);
static gchar** binding_generator_get_namespace_path (BindingGenerator* self, GeneratedNamespace* ns, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar* binding_generator_get_indent (BindingGenerator* self, gint offset);
static void binding_generator_update_indent (BindingGenerator* self, gint increment);
static void binding_generator_generate_interface (BindingGenerator* self, const gchar* interface_name, xmlNode* node, Synchrony synchrony, GError** error);
static void binding_generator_generate_proxy_getter (BindingGenerator* self, xmlNode* node, gchar* interface_name, Synchrony synchrony, GError** error);
static void binding_generator_generate_enumeration (BindingGenerator* self, const gchar* enumeration_name, xmlNode* node, GError** error);
static void binding_generator_generate_errordomain (BindingGenerator* self, const gchar* errordomain_name, xmlNode* node, GError** error);
static void binding_generator_generate_explicit_struct (BindingGenerator* self, const gchar* struct_name, xmlNode* node, GError** error);
static gchar* binding_generator_get_namespace_name (BindingGenerator* self, const gchar* interface_name);
static void binding_generator_generate_members (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace, Synchrony synchrony, GError** error);
static void binding_generator_generate_struct (BindingGenerator* self, const gchar* name, const gchar* content_signature, const gchar* dbus_namespace, GError** error);
static gchar* binding_generator_normalized_to_upper_case (BindingGenerator* self, const gchar* name);
static gchar* binding_generator_camel_case_to_upper_case (BindingGenerator* self, const gchar* name);
static gchar* binding_generator_transform_registered_name (BindingGenerator* self, const gchar* name);
static gchar* binding_generator_translate_type (BindingGenerator* self, const gchar* type, const gchar* fso_type, const gchar* type_name, const gchar* dbus_namespace, GError** error);
static gchar* binding_generator_parse_type (BindingGenerator* self, const gchar* type, gchar** tail, const gchar* type_name, const gchar* dbus_namespace, GError** error);
static void binding_generator_generate_method (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace, Synchrony synchrony, GError** error);
static void binding_generator_generate_signal (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace, GError** error);
static void binding_generator_generate_property (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace);
static void binding_generator_generate_error (BindingGenerator* self, xmlNode* node, const gchar* interface_name, GError** error);
static gchar* binding_generator_uncapitalize (BindingGenerator* self, const gchar* name);
static gint binding_generator_get_out_parameter_count (BindingGenerator* self, xmlNode* node);
static gchar* binding_generator_get_struct_name (BindingGenerator* self, const gchar* interface_name, const gchar* param_name);
static gchar* binding_generator_capitalize (BindingGenerator* self, const gchar* type_name);
static gboolean binding_generator_is_simple_type (BindingGenerator* self, const gchar* type);
static gchar* binding_generator_get_subsignature (BindingGenerator* self, const gchar* s, gchar start, gchar end, gchar** tail);
static gchar* binding_generator_plural_to_singular (BindingGenerator* self, const gchar* type_name);
static gchar* binding_generator_strip_namespace (BindingGenerator* self, const gchar* interface_name);
static void binding_generator_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark generator_error_quark (void) {
	return g_quark_from_static_string ("generator_error-quark");
}


GType synchrony_get_type (void) {
	static volatile gsize synchrony_type_id__volatile = 0;
	if (g_once_init_enter (&synchrony_type_id__volatile)) {
		static const GEnumValue values[] = {{SYNCHRONY_AUTO, "SYNCHRONY_AUTO", "auto"}, {SYNCHRONY_FORCE_SYNC, "SYNCHRONY_FORCE_SYNC", "force-sync"}, {SYNCHRONY_FORCE_ASYNC, "SYNCHRONY_FORCE_ASYNC", "force-async"}, {0, NULL, NULL}};
		GType synchrony_type_id;
		synchrony_type_id = g_enum_register_static ("Synchrony", values);
		g_once_init_leave (&synchrony_type_id__volatile, synchrony_type_id);
	}
	return synchrony_type_id__volatile;
}


GeneratedNamespace* generated_namespace_construct (GType object_type) {
	GeneratedNamespace* self = NULL;
	self = (GeneratedNamespace*) g_type_create_instance (object_type);
	return self;
}


GeneratedNamespace* generated_namespace_new (void) {
	return generated_namespace_construct (TYPE_GENERATED_NAMESPACE);
}


static void value_generated_namespace_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_generated_namespace_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		generated_namespace_unref (value->data[0].v_pointer);
	}
}


static void value_generated_namespace_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = generated_namespace_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_generated_namespace_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_generated_namespace_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeneratedNamespace* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = generated_namespace_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_generated_namespace_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeneratedNamespace** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = generated_namespace_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_generated_namespace (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGeneratedNamespace* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GENERATED_NAMESPACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_generated_namespace (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GENERATED_NAMESPACE), NULL);
	return value->data[0].v_pointer;
}


void value_set_generated_namespace (GValue* value, gpointer v_object) {
	GeneratedNamespace* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GENERATED_NAMESPACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GENERATED_NAMESPACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		generated_namespace_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		generated_namespace_unref (old);
	}
}


void value_take_generated_namespace (GValue* value, gpointer v_object) {
	GeneratedNamespace* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GENERATED_NAMESPACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GENERATED_NAMESPACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		generated_namespace_unref (old);
	}
}


static void generated_namespace_class_init (GeneratedNamespaceClass * klass) {
	generated_namespace_parent_class = g_type_class_peek_parent (klass);
	GENERATED_NAMESPACE_CLASS (klass)->finalize = generated_namespace_finalize;
}


static void generated_namespace_instance_init (GeneratedNamespace * self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	GeeHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	GeeHashMap* _tmp7_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, _tmp0_, _tmp1_, _tmp2_);
	self->members = (GeeMap*) _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_GENERATED_NAMESPACE, (GBoxedCopyFunc) generated_namespace_ref, generated_namespace_unref, _tmp4_, _tmp5_, _tmp6_);
	self->namespaces = (GeeMap*) _tmp7_;
	self->ref_count = 1;
}


static void generated_namespace_finalize (GeneratedNamespace* obj) {
	GeneratedNamespace * self;
	self = GENERATED_NAMESPACE (obj);
	_generated_namespace_unref0 (self->parent);
	_g_free0 (self->name);
	_g_object_unref0 (self->members);
	_g_object_unref0 (self->namespaces);
}


GType generated_namespace_get_type (void) {
	static volatile gsize generated_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&generated_namespace_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_generated_namespace_init, value_generated_namespace_free_value, value_generated_namespace_copy_value, value_generated_namespace_peek_pointer, "p", value_generated_namespace_collect_value, "p", value_generated_namespace_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeneratedNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generated_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeneratedNamespace), 0, (GInstanceInitFunc) generated_namespace_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType generated_namespace_type_id;
		generated_namespace_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeneratedNamespace", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&generated_namespace_type_id__volatile, generated_namespace_type_id);
	}
	return generated_namespace_type_id__volatile;
}


gpointer generated_namespace_ref (gpointer instance) {
	GeneratedNamespace* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void generated_namespace_unref (gpointer instance) {
	GeneratedNamespace* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GENERATED_NAMESPACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void binding_generator_INFO (const gchar* msg) {
	gint _tmp0_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = binding_generator_verbosity;
	if (_tmp0_ >= 1) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = stdout;
		_tmp2_ = msg;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("[INFO]  ", _tmp3_, "\n", NULL);
		_tmp5_ = _tmp4_;
		fprintf (_tmp1_, "%s", _tmp5_);
		_g_free0 (_tmp5_);
	}
}


void binding_generator_DEBUG (const gchar* msg) {
	gint _tmp0_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = binding_generator_verbosity;
	if (_tmp0_ >= 2) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = stdout;
		_tmp2_ = msg;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("[DEBUG] ", _tmp3_, "\n", NULL);
		_tmp5_ = _tmp4_;
		fprintf (_tmp1_, "%s", _tmp5_);
		_g_free0 (_tmp5_);
	}
}


void binding_generator_WARN (const gchar* msg) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = stderr;
	_tmp1_ = msg;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("[WARN]  ", _tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	fprintf (_tmp0_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
}


void binding_generator_ERROR (const gchar* msg) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = stderr;
	_tmp1_ = msg;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("[ERROR] ", _tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	fprintf (_tmp0_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = binding_generator_errors;
	binding_generator_errors = _tmp5_ + 1;
}


gint binding_generator_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** split_name;
	gint split_name_length1;
	gint _split_name_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* program_name;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_ = NULL;
	gchar* command;
	gchar* api_path;
	gchar* output_directory;
	guint dbus_timeout;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GEqualFunc _tmp12_;
	GeeHashMap* _tmp13_;
	GeeMap* namespace_renaming;
	const gchar* _tmp58_;
	const gchar* _tmp60_;
	gint _tmp71_;
	GError * _inner_error_ = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = _tmp0_[0];
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "/", 0);
	split_name = _tmp3_;
	split_name_length1 = _vala_array_length (_tmp2_);
	_split_name_size_ = split_name_length1;
	_tmp4_ = split_name;
	_tmp4__length1 = split_name_length1;
	_tmp5_ = split_name;
	_tmp5__length1 = split_name_length1;
	_tmp6_ = _tmp4_[_tmp5__length1 - 1];
	_tmp7_ = g_strdup (_tmp6_);
	program_name = _tmp7_;
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	_tmp9_ = g_strjoinv (" ", _tmp8_);
	command = _tmp9_;
	api_path = NULL;
	output_directory = NULL;
	dbus_timeout = (guint) 120000;
	binding_generator_synced = TRUE;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_str_equal;
	_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp10_, _tmp11_, _tmp12_);
	namespace_renaming = (GeeMap*) _tmp13_;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* arg;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_ = NULL;
				gchar** split_arg;
				gint split_arg_length1;
				gint _split_arg_size_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				GQuark _tmp30_ = 0U;
				static GQuark _tmp29_label0 = 0;
				static GQuark _tmp29_label1 = 0;
				static GQuark _tmp29_label2 = 0;
				static GQuark _tmp29_label3 = 0;
				static GQuark _tmp29_label4 = 0;
				static GQuark _tmp29_label5 = 0;
				static GQuark _tmp29_label6 = 0;
				static GQuark _tmp29_label7 = 0;
				static GQuark _tmp29_label8 = 0;
				static GQuark _tmp29_label9 = 0;
				static GQuark _tmp29_label10 = 0;
				static GQuark _tmp29_label11 = 0;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = args;
				_tmp18__length1 = args_length1;
				if (!(_tmp17_ < _tmp18__length1)) {
					break;
				}
				_tmp19_ = args;
				_tmp19__length1 = args_length1;
				_tmp20_ = i;
				_tmp21_ = _tmp19_[_tmp20_];
				_tmp22_ = g_strdup (_tmp21_);
				arg = _tmp22_;
				_tmp23_ = arg;
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "=", 0);
				split_arg = _tmp25_;
				split_arg_length1 = _vala_array_length (_tmp24_);
				_split_arg_size_ = split_arg_length1;
				_tmp26_ = split_arg;
				_tmp26__length1 = split_arg_length1;
				_tmp27_ = _tmp26_[0];
				_tmp28_ = _tmp27_;
				_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
				if ((_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string ("-h")))) || (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string ("--help"))))) {
					switch (0) {
						default:
						{
							const gchar* _tmp31_;
							_tmp31_ = program_name;
							binding_generator_show_usage (_tmp31_);
							result = 0;
							split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (arg);
							_g_object_unref0 (namespace_renaming);
							_g_free0 (output_directory);
							_g_free0 (api_path);
							_g_free0 (command);
							_g_free0 (program_name);
							split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label2) ? _tmp29_label2 : (_tmp29_label2 = g_quark_from_static_string ("-v")))) {
					switch (0) {
						default:
						{
							gint _tmp32_;
							_tmp32_ = binding_generator_verbosity;
							binding_generator_verbosity = _tmp32_ + 1;
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label3) ? _tmp29_label3 : (_tmp29_label3 = g_quark_from_static_string ("--version")))) {
					switch (0) {
						default:
						{
							binding_generator_show_version ();
							result = 0;
							split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (arg);
							_g_object_unref0 (namespace_renaming);
							_g_free0 (output_directory);
							_g_free0 (api_path);
							_g_free0 (command);
							_g_free0 (program_name);
							split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label4) ? _tmp29_label4 : (_tmp29_label4 = g_quark_from_static_string ("--api-path")))) {
					switch (0) {
						default:
						{
							gchar** _tmp33_;
							gint _tmp33__length1;
							const gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp33_ = split_arg;
							_tmp33__length1 = split_arg_length1;
							_tmp34_ = _tmp33_[1];
							_tmp35_ = g_strdup (_tmp34_);
							_g_free0 (api_path);
							api_path = _tmp35_;
							break;
						}
					}
				} else if ((_tmp30_ == ((0 != _tmp29_label5) ? _tmp29_label5 : (_tmp29_label5 = g_quark_from_static_string ("-d")))) || (_tmp30_ == ((0 != _tmp29_label6) ? _tmp29_label6 : (_tmp29_label6 = g_quark_from_static_string ("--directory"))))) {
					switch (0) {
						default:
						{
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							gchar* _tmp38_;
							_tmp36_ = split_arg;
							_tmp36__length1 = split_arg_length1;
							_tmp37_ = _tmp36_[1];
							_tmp38_ = g_strdup (_tmp37_);
							_g_free0 (output_directory);
							output_directory = _tmp38_;
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label7) ? _tmp29_label7 : (_tmp29_label7 = g_quark_from_static_string ("--strip-namespace")))) {
					switch (0) {
						default:
						{
							GeeMap* _tmp39_;
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							_tmp39_ = namespace_renaming;
							_tmp40_ = split_arg;
							_tmp40__length1 = split_arg_length1;
							_tmp41_ = _tmp40_[1];
							gee_map_set (_tmp39_, _tmp41_, "");
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label8) ? _tmp29_label8 : (_tmp29_label8 = g_quark_from_static_string ("--rename-namespace")))) {
					switch (0) {
						default:
						{
							gchar** _tmp42_;
							gint _tmp42__length1;
							const gchar* _tmp43_;
							gchar** _tmp44_;
							gchar** _tmp45_ = NULL;
							gchar** ns_split;
							gint ns_split_length1;
							gint _ns_split_size_;
							GeeMap* _tmp46_;
							gchar** _tmp47_;
							gint _tmp47__length1;
							const gchar* _tmp48_;
							gchar** _tmp49_;
							gint _tmp49__length1;
							const gchar* _tmp50_;
							_tmp42_ = split_arg;
							_tmp42__length1 = split_arg_length1;
							_tmp43_ = _tmp42_[1];
							_tmp45_ = _tmp44_ = g_strsplit (_tmp43_, ":", 0);
							ns_split = _tmp45_;
							ns_split_length1 = _vala_array_length (_tmp44_);
							_ns_split_size_ = ns_split_length1;
							_tmp46_ = namespace_renaming;
							_tmp47_ = ns_split;
							_tmp47__length1 = ns_split_length1;
							_tmp48_ = _tmp47_[0];
							_tmp49_ = ns_split;
							_tmp49__length1 = ns_split_length1;
							_tmp50_ = _tmp49_[1];
							gee_map_set (_tmp46_, _tmp48_, _tmp50_);
							ns_split = (_vala_array_free (ns_split, ns_split_length1, (GDestroyNotify) g_free), NULL);
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label9) ? _tmp29_label9 : (_tmp29_label9 = g_quark_from_static_string ("--dbus-timeout")))) {
					switch (0) {
						default:
						{
							gchar** _tmp51_;
							gint _tmp51__length1;
							const gchar* _tmp52_;
							gint _tmp53_ = 0;
							_tmp51_ = split_arg;
							_tmp51__length1 = split_arg_length1;
							_tmp52_ = _tmp51_[1];
							_tmp53_ = atoi (_tmp52_);
							dbus_timeout = (guint) _tmp53_;
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label10) ? _tmp29_label10 : (_tmp29_label10 = g_quark_from_static_string ("--no-synced")))) {
					switch (0) {
						default:
						{
							binding_generator_synced = FALSE;
							break;
						}
					}
				} else if (_tmp30_ == ((0 != _tmp29_label11) ? _tmp29_label11 : (_tmp29_label11 = g_quark_from_static_string ("--gdbus")))) {
					switch (0) {
						default:
						{
							binding_generator_gdbus = TRUE;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							FILE* _tmp54_;
							const gchar* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							_tmp54_ = stdout;
							_tmp55_ = program_name;
							_tmp56_ = arg;
							fprintf (_tmp54_, "%s: Unknown option %s\n", _tmp55_, _tmp56_);
							_tmp57_ = program_name;
							binding_generator_show_usage (_tmp57_);
							result = 1;
							split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (arg);
							_g_object_unref0 (namespace_renaming);
							_g_free0 (output_directory);
							_g_free0 (api_path);
							_g_free0 (command);
							_g_free0 (program_name);
							split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					}
				}
				split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (arg);
			}
		}
	}
	_tmp58_ = api_path;
	if (_tmp58_ == NULL) {
		gchar* _tmp59_;
		_tmp59_ = g_strdup ("./");
		_g_free0 (api_path);
		api_path = _tmp59_;
	}
	_tmp60_ = output_directory;
	if (_tmp60_ == NULL) {
		gchar* _tmp61_;
		_tmp61_ = g_strdup (".");
		_g_free0 (output_directory);
		output_directory = _tmp61_;
	}
	{
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		GeeMap* _tmp64_;
		const gchar* _tmp65_;
		guint _tmp66_;
		_tmp62_ = api_path;
		_tmp63_ = output_directory;
		_tmp64_ = namespace_renaming;
		_tmp65_ = command;
		_tmp66_ = dbus_timeout;
		binding_generator_generate (_tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			if (_inner_error_->domain == GENERATOR_ERROR) {
				goto __catch0_generator_error;
			}
			_g_object_unref0 (namespace_renaming);
			_g_free0 (output_directory);
			_g_free0 (api_path);
			_g_free0 (command);
			_g_free0 (program_name);
			split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* ex = NULL;
		GError* _tmp67_;
		const gchar* _tmp68_;
		ex = _inner_error_;
		_inner_error_ = NULL;
		_tmp67_ = ex;
		_tmp68_ = _tmp67_->message;
		binding_generator_ERROR (_tmp68_);
		result = 1;
		_g_error_free0 (ex);
		_g_object_unref0 (namespace_renaming);
		_g_free0 (output_directory);
		_g_free0 (api_path);
		_g_free0 (command);
		_g_free0 (program_name);
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_generator_error:
	{
		GError* ex = NULL;
		GError* _tmp69_;
		const gchar* _tmp70_;
		ex = _inner_error_;
		_inner_error_ = NULL;
		_tmp69_ = ex;
		_tmp70_ = _tmp69_->message;
		binding_generator_ERROR (_tmp70_);
		result = 1;
		_g_error_free0 (ex);
		_g_object_unref0 (namespace_renaming);
		_g_free0 (output_directory);
		_g_free0 (api_path);
		_g_free0 (command);
		_g_free0 (program_name);
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (namespace_renaming);
		_g_free0 (output_directory);
		_g_free0 (api_path);
		_g_free0 (command);
		_g_free0 (program_name);
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp71_ = binding_generator_errors;
	if (_tmp71_ > 0) {
		FILE* _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_;
		_tmp72_ = stdout;
		_tmp73_ = binding_generator_errors;
		_tmp74_ = g_strdup_printf ("%i", _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strconcat ("\n", _tmp75_, " errors detected in API files. The generated files will not be usable." \
"\n", NULL);
		_tmp77_ = _tmp76_;
		fprintf (_tmp72_, "%s", _tmp77_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp75_);
		result = 1;
		_g_object_unref0 (namespace_renaming);
		_g_free0 (output_directory);
		_g_free0 (api_path);
		_g_free0 (command);
		_g_free0 (program_name);
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = 0;
	_g_object_unref0 (namespace_renaming);
	_g_free0 (output_directory);
	_g_free0 (api_path);
	_g_free0 (command);
	_g_free0 (program_name);
	split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return binding_generator_main (argv, argc);
}


static void binding_generator_show_version (void) {
	FILE* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	_tmp0_ = stdout;
	_tmp1_ = string_to_string (PACKAGE_VERSION);
	_tmp2_ = g_strconcat ("Vala D-Bus Binding Tool ", _tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	fprintf (_tmp0_, "%s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stdout;
	fprintf (_tmp4_, "Written by Didier \"Ptitjes\" and the freesmartphone.org team\n");
	_tmp5_ = stdout;
	fprintf (_tmp5_, "This is free software; see the source for copying conditions.\n");
	_tmp6_ = stdout;
	fprintf (_tmp6_, "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PA" \
"RTICULAR PURPOSE.\n");
}


static void binding_generator_show_usage (const gchar* program_name) {
	FILE* _tmp0_;
	FILE* _tmp1_;
	const gchar* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (program_name != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Usage:\n");
	_tmp1_ = stdout;
	_tmp2_ = program_name;
	fprintf (_tmp1_, "  %s [-v] [--version] [--help]\n", _tmp2_);
	_tmp3_ = stdout;
	_tmp4_ = program_name;
	fprintf (_tmp3_, "  %s [--gdbus] [--api-path=PATH] [--no-synced] [--dbus-timeout=TIMEOUT" \
"] [--directory=DIR] [--strip-namespace=NS]* [--rename-namespace=OLD_NS" \
":NEW_NS]*\n", _tmp4_);
}


void binding_generator_generate (const gchar* api_path, const gchar* output_directory, GeeMap* namespace_renaming, const gchar* command, guint dbus_timeout, GError** error) {
	const gchar* _tmp0_;
	GeeMap* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp3_;
	BindingGenerator* _tmp4_;
	BindingGenerator* generator;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (api_path != NULL);
	g_return_if_fail (output_directory != NULL);
	g_return_if_fail (namespace_renaming != NULL);
	g_return_if_fail (command != NULL);
	xmlInitParser ();
	_tmp0_ = output_directory;
	_tmp1_ = namespace_renaming;
	_tmp2_ = command;
	_tmp3_ = dbus_timeout;
	_tmp4_ = binding_generator_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	generator = _tmp4_;
	_tmp5_ = api_path;
	binding_generator_generate_bindings (generator, _tmp5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (generator);
			return;
		} else {
			_g_object_unref0 (generator);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	xmlCleanupParser ();
	_g_object_unref0 (generator);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static BindingGenerator* binding_generator_construct (GType object_type, const gchar* output_directory, GeeMap* namespace_renaming, const gchar* command, guint dbus_timeout) {
	BindingGenerator * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	g_return_val_if_fail (output_directory != NULL, NULL);
	g_return_val_if_fail (namespace_renaming != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	self = (BindingGenerator*) g_object_new (object_type, NULL);
	_tmp0_ = output_directory;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->output_directory);
	self->priv->output_directory = _tmp1_;
	_tmp2_ = namespace_renaming;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->namespace_renaming);
	self->priv->namespace_renaming = _tmp3_;
	_tmp4_ = command;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->command);
	self->priv->command = _tmp5_;
	_tmp6_ = dbus_timeout;
	self->priv->dbus_timeout = _tmp6_;
	return self;
}


static BindingGenerator* binding_generator_new (const gchar* output_directory, GeeMap* namespace_renaming, const gchar* command, guint dbus_timeout) {
	return binding_generator_construct (TYPE_BINDING_GENERATOR, output_directory, namespace_renaming, command, dbus_timeout);
}


static void binding_generator_generate_bindings (BindingGenerator* self, const gchar* api_path, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeneratedNamespace* _tmp15_;
	GeneratedNamespace* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (api_path != NULL);
	_tmp0_ = api_path;
	_tmp1_ = g_str_has_suffix (_tmp0_, ".xml");
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = api_path;
		binding_generator_add_api_file (self, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		const gchar* _tmp3_;
		GDir* _tmp4_ = NULL;
		GDir* dir;
		gchar* name = NULL;
		_tmp3_ = api_path;
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error_);
		dir = _tmp4_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		while (TRUE) {
			GDir* _tmp5_;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			_tmp5_ = dir;
			_tmp6_ = g_dir_read_name (_tmp5_);
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (name);
			name = _tmp7_;
			_tmp8_ = name;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = name;
			_tmp10_ = g_str_has_suffix (_tmp9_, ".xml");
			if (_tmp10_) {
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp11_ = api_path;
				_tmp12_ = name;
				_tmp13_ = g_build_filename (_tmp11_, _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				binding_generator_add_api_file (self, _tmp14_, &_inner_error_);
				_g_free0 (_tmp14_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (name);
						_g_dir_close0 (dir);
						return;
					} else {
						_g_free0 (name);
						_g_dir_close0 (dir);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_free0 (name);
		_g_dir_close0 (dir);
	}
	_tmp15_ = self->priv->root_namespace;
	binding_generator_index_names (self, _tmp15_);
	_tmp16_ = self->priv->root_namespace;
	binding_generator_generate_namespace (self, _tmp16_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void binding_generator_add_api_file (BindingGenerator* self, const gchar* api_file, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	xmlDoc* _tmp5_ = NULL;
	xmlDoc* api_doc;
	xmlDoc* _tmp6_;
	GeeList* _tmp9_;
	xmlDoc* _tmp10_;
	xmlDoc* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (api_file != NULL);
	_tmp0_ = api_file;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("Adding API file ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	binding_generator_INFO (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = api_file;
	_tmp5_ = xmlParseFile (_tmp4_);
	api_doc = _tmp5_;
	_tmp6_ = api_doc;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp7_ = api_file;
		_tmp8_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_FILE_NOT_FOUND, _tmp7_);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = self->priv->api_docs;
	_tmp10_ = api_doc;
	gee_collection_add ((GeeCollection*) _tmp9_, _tmp10_);
	_tmp11_ = api_doc;
	binding_generator_preprocess_binding_names (self, _tmp11_);
}


static void binding_generator_create_binding_file (BindingGenerator* self, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* _tmp2_;
	FILE* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	FILE* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	FILE* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = fopen (_tmp0_, "w");
	_fclose0 (self->priv->output);
	self->priv->output = _tmp1_;
	_tmp2_ = self->priv->output;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = name;
		_tmp4_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_CANT_CREATE_FILE, _tmp3_);
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = self->priv->output;
	_tmp6_ = string_to_string (PACKAGE_VERSION);
	_tmp7_ = g_strconcat ("/* Generated by vala-dbus-binding-tool ", _tmp6_, ". Do not modify! */\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp5_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->output;
	_tmp10_ = self->priv->command;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("/* Generated with: ", _tmp11_, " */\n", NULL);
	_tmp13_ = _tmp12_;
	fprintf (_tmp9_, "%s", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = binding_generator_gdbus;
	if (!_tmp14_) {
		FILE* _tmp15_;
		_tmp15_ = self->priv->output;
		fprintf (_tmp15_, "using DBus;\n");
	}
	_tmp16_ = self->priv->output;
	fprintf (_tmp16_, "using GLib;\n");
}


static gpointer _generated_namespace_ref0 (gpointer self) {
	return self ? generated_namespace_ref (self) : NULL;
}


static void binding_generator_preprocess_binding_names (BindingGenerator* self, xmlDoc* api_doc) {
	g_return_if_fail (self != NULL);
	{
		xmlDoc* _tmp0_;
		xmlNode* _tmp1_ = NULL;
		xmlNode* _tmp2_;
		xmlNode* iter;
		_tmp0_ = api_doc;
		_tmp1_ = xmlDocGetRootElement (_tmp0_);
		_tmp2_ = _tmp1_->children;
		iter = _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				xmlNode* _tmp7_;
				xmlNode* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				xmlNode* _tmp13_;
				xmlElementType _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				xmlNode* _tmp17_;
				xmlElementType _tmp18_;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				xmlNode* _tmp22_;
				const gchar* _tmp23_;
				gboolean _tmp26_;
				gboolean _tmp29_;
				gboolean _tmp32_;
				xmlNode* _tmp33_;
				gchar* _tmp34_ = NULL;
				gchar* no_error_container_string;
				gboolean _tmp35_ = FALSE;
				const gchar* _tmp36_;
				gboolean _tmp38_;
				gboolean no_error_container;
				xmlNode* _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* dbus_interface_name;
				const gchar* _tmp41_;
				gchar** _tmp42_;
				gchar** _tmp43_ = NULL;
				gchar** split_name;
				gint split_name_length1;
				gint _split_name_size_;
				gchar* short_name = NULL;
				gint last_part = 0;
				gboolean _tmp44_ = FALSE;
				xmlNode* _tmp45_;
				const gchar* _tmp46_;
				gboolean _tmp48_;
				gint i;
				GeneratedNamespace* _tmp70_;
				GeneratedNamespace* _tmp71_;
				GeneratedNamespace* ns;
				gchar* interface_name;
				gboolean _tmp169_;
				GeneratedNamespace* _tmp229_;
				GeeMap* _tmp230_;
				const gchar* _tmp231_;
				gboolean _tmp232_ = FALSE;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					xmlNode* _tmp5_;
					xmlNode* _tmp6_;
					_tmp5_ = iter;
					_tmp6_ = _tmp5_->next;
					iter = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = iter;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = iter;
				_tmp9_ = _tmp8_->name;
				_tmp10_ = string_to_string (_tmp9_);
				_tmp11_ = g_strconcat ("   Processing ", _tmp10_, " as type %d", NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = iter;
				_tmp14_ = _tmp13_->type;
				_tmp15_ = g_strdup_printf (_tmp12_, _tmp14_);
				_tmp16_ = _tmp15_;
				binding_generator_DEBUG (_tmp16_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp12_);
				_tmp17_ = iter;
				_tmp18_ = _tmp17_->type;
				if (_tmp18_ != XML_ELEMENT_NODE) {
					binding_generator_DEBUG ("      not a node; continuing");
					continue;
				}
				_tmp22_ = iter;
				_tmp23_ = _tmp22_->name;
				if (g_strcmp0 (_tmp23_, BINDING_GENERATOR_INTERFACE_ELTNAME) != 0) {
					xmlNode* _tmp24_;
					const gchar* _tmp25_;
					_tmp24_ = iter;
					_tmp25_ = _tmp24_->name;
					_tmp21_ = g_strcmp0 (_tmp25_, BINDING_GENERATOR_ENUMERATION_ELTNAME) != 0;
				} else {
					_tmp21_ = FALSE;
				}
				_tmp26_ = _tmp21_;
				if (_tmp26_) {
					xmlNode* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = iter;
					_tmp28_ = _tmp27_->name;
					_tmp20_ = g_strcmp0 (_tmp28_, BINDING_GENERATOR_ERRORDOMAIN_ELTNAME) != 0;
				} else {
					_tmp20_ = FALSE;
				}
				_tmp29_ = _tmp20_;
				if (_tmp29_) {
					xmlNode* _tmp30_;
					const gchar* _tmp31_;
					_tmp30_ = iter;
					_tmp31_ = _tmp30_->name;
					_tmp19_ = g_strcmp0 (_tmp31_, BINDING_GENERATOR_STRUCT_ELTNAME) != 0;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp32_ = _tmp19_;
				if (_tmp32_) {
					binding_generator_DEBUG ("      not interface or enumeration or errordomain or struct; continuin" \
"g");
					continue;
				}
				_tmp33_ = iter;
				_tmp34_ = xmlGetNsProp (_tmp33_, BINDING_GENERATOR_NO_CONTAINER_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE);
				no_error_container_string = _tmp34_;
				_tmp36_ = no_error_container_string;
				if (_tmp36_ != NULL) {
					const gchar* _tmp37_;
					_tmp37_ = no_error_container_string;
					_tmp35_ = g_strcmp0 (_tmp37_, "true") == 0;
				} else {
					_tmp35_ = FALSE;
				}
				_tmp38_ = _tmp35_;
				no_error_container = _tmp38_;
				_tmp39_ = iter;
				_tmp40_ = xmlGetProp (_tmp39_, BINDING_GENERATOR_NAME_ATTRNAME);
				dbus_interface_name = _tmp40_;
				_tmp41_ = dbus_interface_name;
				_tmp43_ = _tmp42_ = g_strsplit (_tmp41_, ".", 0);
				split_name = _tmp43_;
				split_name_length1 = _vala_array_length (_tmp42_);
				_split_name_size_ = split_name_length1;
				_tmp45_ = iter;
				_tmp46_ = _tmp45_->name;
				if (g_strcmp0 (_tmp46_, BINDING_GENERATOR_ERRORDOMAIN_ELTNAME) == 0) {
					gboolean _tmp47_;
					_tmp47_ = no_error_container;
					_tmp44_ = _tmp47_;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp48_ = _tmp44_;
				if (_tmp48_) {
					gchar* _tmp49_;
					gchar** _tmp50_;
					gint _tmp50__length1;
					_tmp49_ = g_strdup ("Error");
					_g_free0 (short_name);
					short_name = _tmp49_;
					_tmp50_ = split_name;
					_tmp50__length1 = split_name_length1;
					last_part = _tmp50__length1;
				} else {
					gchar** _tmp51_;
					gint _tmp51__length1;
					gchar** _tmp52_;
					gint _tmp52__length1;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					gchar** _tmp55_;
					gint _tmp55__length1;
					_tmp51_ = split_name;
					_tmp51__length1 = split_name_length1;
					_tmp52_ = split_name;
					_tmp52__length1 = split_name_length1;
					_tmp53_ = _tmp51_[_tmp52__length1 - 1];
					_tmp54_ = g_strdup (_tmp53_);
					_g_free0 (short_name);
					short_name = _tmp54_;
					_tmp55_ = split_name;
					_tmp55__length1 = split_name_length1;
					last_part = _tmp55__length1 - 1;
				}
				i = 0;
				{
					gboolean _tmp56_;
					_tmp56_ = TRUE;
					while (TRUE) {
						gboolean _tmp57_;
						gint _tmp59_;
						gint _tmp60_;
						gchar** _tmp61_;
						gint _tmp61__length1;
						gint _tmp62_;
						const gchar* _tmp63_;
						gchar* _tmp64_;
						gchar* part;
						GeeMap* _tmp65_;
						const gchar* _tmp66_;
						gpointer _tmp67_ = NULL;
						gchar* _tmp68_;
						gboolean _tmp69_;
						_tmp57_ = _tmp56_;
						if (!_tmp57_) {
							gint _tmp58_;
							_tmp58_ = i;
							i = _tmp58_ + 1;
						}
						_tmp56_ = FALSE;
						_tmp59_ = i;
						_tmp60_ = last_part;
						if (!(_tmp59_ < _tmp60_)) {
							break;
						}
						_tmp61_ = split_name;
						_tmp61__length1 = split_name_length1;
						_tmp62_ = i;
						_tmp63_ = _tmp61_[_tmp62_];
						_tmp64_ = g_strdup (_tmp63_);
						part = _tmp64_;
						_tmp65_ = self->priv->namespace_renaming;
						_tmp66_ = part;
						_tmp67_ = gee_map_get (_tmp65_, _tmp66_);
						_tmp68_ = (gchar*) _tmp67_;
						_tmp69_ = g_strcmp0 (_tmp68_, "") != 0;
						_g_free0 (_tmp68_);
						if (_tmp69_) {
							_g_free0 (part);
							break;
						}
						_g_free0 (part);
					}
				}
				_tmp70_ = self->priv->root_namespace;
				_tmp71_ = _generated_namespace_ref0 (_tmp70_);
				ns = _tmp71_;
				{
					gboolean _tmp72_;
					_tmp72_ = TRUE;
					while (TRUE) {
						gboolean _tmp73_;
						gint _tmp75_;
						gint _tmp76_;
						gchar** _tmp77_;
						gint _tmp77__length1;
						gint _tmp78_;
						const gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* part;
						gboolean _tmp81_ = FALSE;
						GeeMap* _tmp82_;
						const gchar* _tmp83_;
						gboolean _tmp84_ = FALSE;
						gboolean _tmp89_;
						gboolean _tmp93_ = FALSE;
						GeneratedNamespace* _tmp94_;
						GeeMap* _tmp95_;
						const gchar* _tmp96_;
						gboolean _tmp97_ = FALSE;
						gboolean _tmp99_;
						GeneratedNamespace* child;
						GeneratedNamespace* _tmp134_;
						GeeMap* _tmp135_;
						const gchar* _tmp136_;
						gboolean _tmp137_ = FALSE;
						GeneratedNamespace* _tmp153_;
						GeeMap* _tmp154_;
						const gchar* _tmp155_;
						gboolean _tmp156_ = FALSE;
						GeneratedNamespace* _tmp167_;
						GeneratedNamespace* _tmp168_;
						_tmp73_ = _tmp72_;
						if (!_tmp73_) {
							gint _tmp74_;
							_tmp74_ = i;
							i = _tmp74_ + 1;
						}
						_tmp72_ = FALSE;
						_tmp75_ = i;
						_tmp76_ = last_part;
						if (!(_tmp75_ < _tmp76_)) {
							break;
						}
						_tmp77_ = split_name;
						_tmp77__length1 = split_name_length1;
						_tmp78_ = i;
						_tmp79_ = _tmp77_[_tmp78_];
						_tmp80_ = g_strdup (_tmp79_);
						part = _tmp80_;
						_tmp82_ = self->priv->namespace_renaming;
						_tmp83_ = part;
						_tmp84_ = gee_map_has_key (_tmp82_, _tmp83_);
						if (_tmp84_) {
							GeeMap* _tmp85_;
							const gchar* _tmp86_;
							gpointer _tmp87_ = NULL;
							gchar* _tmp88_;
							_tmp85_ = self->priv->namespace_renaming;
							_tmp86_ = part;
							_tmp87_ = gee_map_get (_tmp85_, _tmp86_);
							_tmp88_ = (gchar*) _tmp87_;
							_tmp81_ = g_strcmp0 (_tmp88_, "") != 0;
							_g_free0 (_tmp88_);
						} else {
							_tmp81_ = FALSE;
						}
						_tmp89_ = _tmp81_;
						if (_tmp89_) {
							GeeMap* _tmp90_;
							const gchar* _tmp91_;
							gpointer _tmp92_ = NULL;
							_tmp90_ = self->priv->namespace_renaming;
							_tmp91_ = part;
							_tmp92_ = gee_map_get (_tmp90_, _tmp91_);
							_g_free0 (part);
							part = (gchar*) _tmp92_;
						}
						_tmp94_ = ns;
						_tmp95_ = _tmp94_->members;
						_tmp96_ = part;
						_tmp97_ = gee_map_has_key (_tmp95_, _tmp96_);
						if (_tmp97_) {
							gboolean _tmp98_;
							_tmp98_ = self->priv->inner_interface_strategy_concat;
							_tmp93_ = _tmp98_;
						} else {
							_tmp93_ = FALSE;
						}
						_tmp99_ = _tmp93_;
						if (_tmp99_) {
							GeneratedNamespace* _tmp100_;
							GeeMap* _tmp101_;
							const gchar* _tmp102_;
							gboolean _tmp103_ = FALSE;
							_tmp100_ = ns;
							_tmp101_ = _tmp100_->namespaces;
							_tmp102_ = part;
							_tmp103_ = gee_map_has_key (_tmp101_, _tmp102_);
							if (_tmp103_) {
								GeneratedNamespace* _tmp104_;
								GeeMap* _tmp105_;
								const gchar* _tmp106_;
								gpointer _tmp107_ = NULL;
								GeneratedNamespace* child;
								GeneratedNamespace* _tmp130_;
								GeeMap* _tmp131_;
								const gchar* _tmp132_;
								GeneratedNamespace* _tmp133_;
								_tmp104_ = ns;
								_tmp105_ = _tmp104_->namespaces;
								_tmp106_ = part;
								_tmp107_ = gee_map_get (_tmp105_, _tmp106_);
								child = (GeneratedNamespace*) _tmp107_;
								{
									GeneratedNamespace* _tmp108_;
									GeeMap* _tmp109_;
									GeeSet* _tmp110_;
									GeeSet* _tmp111_;
									GeeSet* _tmp112_;
									GeeIterator* _tmp113_ = NULL;
									GeeIterator* _tmp114_;
									GeeIterator* _interf_name_it;
									_tmp108_ = child;
									_tmp109_ = _tmp108_->members;
									_tmp110_ = gee_map_get_keys (_tmp109_);
									_tmp111_ = _tmp110_;
									_tmp112_ = _tmp111_;
									_tmp113_ = gee_iterable_iterator ((GeeIterable*) _tmp112_);
									_tmp114_ = _tmp113_;
									_g_object_unref0 (_tmp112_);
									_interf_name_it = _tmp114_;
									while (TRUE) {
										GeeIterator* _tmp115_;
										gboolean _tmp116_ = FALSE;
										GeeIterator* _tmp117_;
										gpointer _tmp118_ = NULL;
										gchar* interf_name;
										GeneratedNamespace* _tmp119_;
										GeeMap* _tmp120_;
										const gchar* _tmp121_;
										gpointer _tmp122_ = NULL;
										xmlNode* interf;
										GeneratedNamespace* _tmp123_;
										GeeMap* _tmp124_;
										const gchar* _tmp125_;
										const gchar* _tmp126_;
										gchar* _tmp127_;
										gchar* _tmp128_;
										xmlNode* _tmp129_;
										_tmp115_ = _interf_name_it;
										_tmp116_ = gee_iterator_next (_tmp115_);
										if (!_tmp116_) {
											break;
										}
										_tmp117_ = _interf_name_it;
										_tmp118_ = gee_iterator_get (_tmp117_);
										interf_name = (gchar*) _tmp118_;
										_tmp119_ = child;
										_tmp120_ = _tmp119_->members;
										_tmp121_ = interf_name;
										_tmp122_ = gee_map_get (_tmp120_, _tmp121_);
										interf = _tmp122_;
										_tmp123_ = ns;
										_tmp124_ = _tmp123_->members;
										_tmp125_ = part;
										_tmp126_ = interf_name;
										_tmp127_ = g_strconcat (_tmp125_, _tmp126_, NULL);
										_tmp128_ = _tmp127_;
										_tmp129_ = interf;
										gee_map_set (_tmp124_, _tmp128_, _tmp129_);
										_g_free0 (_tmp128_);
										_g_free0 (interf_name);
									}
									_g_object_unref0 (_interf_name_it);
								}
								_tmp130_ = ns;
								_tmp131_ = _tmp130_->namespaces;
								_tmp132_ = part;
								gee_map_unset (_tmp131_, _tmp132_, NULL);
								_tmp133_ = child;
								_generated_namespace_unref0 (_tmp133_->parent);
								_tmp133_->parent = NULL;
								_generated_namespace_unref0 (child);
							}
							_g_free0 (part);
							break;
						}
						child = NULL;
						_tmp134_ = ns;
						_tmp135_ = _tmp134_->namespaces;
						_tmp136_ = part;
						_tmp137_ = gee_map_has_key (_tmp135_, _tmp136_);
						if (_tmp137_) {
							GeneratedNamespace* _tmp138_;
							GeeMap* _tmp139_;
							const gchar* _tmp140_;
							gpointer _tmp141_ = NULL;
							_tmp138_ = ns;
							_tmp139_ = _tmp138_->namespaces;
							_tmp140_ = part;
							_tmp141_ = gee_map_get (_tmp139_, _tmp140_);
							_generated_namespace_unref0 (child);
							child = (GeneratedNamespace*) _tmp141_;
						} else {
							GeneratedNamespace* _tmp142_;
							GeneratedNamespace* _tmp143_;
							GeneratedNamespace* _tmp144_;
							GeneratedNamespace* _tmp145_;
							GeneratedNamespace* _tmp146_;
							const gchar* _tmp147_;
							gchar* _tmp148_;
							GeneratedNamespace* _tmp149_;
							GeeMap* _tmp150_;
							const gchar* _tmp151_;
							GeneratedNamespace* _tmp152_;
							_tmp142_ = generated_namespace_new ();
							_generated_namespace_unref0 (child);
							child = _tmp142_;
							_tmp143_ = child;
							_tmp144_ = ns;
							_tmp145_ = _generated_namespace_ref0 (_tmp144_);
							_generated_namespace_unref0 (_tmp143_->parent);
							_tmp143_->parent = _tmp145_;
							_tmp146_ = child;
							_tmp147_ = part;
							_tmp148_ = g_strdup (_tmp147_);
							_g_free0 (_tmp146_->name);
							_tmp146_->name = _tmp148_;
							_tmp149_ = ns;
							_tmp150_ = _tmp149_->namespaces;
							_tmp151_ = part;
							_tmp152_ = child;
							gee_map_set (_tmp150_, _tmp151_, _tmp152_);
						}
						_tmp153_ = ns;
						_tmp154_ = _tmp153_->members;
						_tmp155_ = part;
						_tmp156_ = gee_map_has_key (_tmp154_, _tmp155_);
						if (_tmp156_) {
							GeneratedNamespace* _tmp157_;
							GeeMap* _tmp158_;
							const gchar* _tmp159_;
							GeneratedNamespace* _tmp160_;
							GeeMap* _tmp161_;
							const gchar* _tmp162_;
							gpointer _tmp163_ = NULL;
							GeneratedNamespace* _tmp164_;
							GeeMap* _tmp165_;
							const gchar* _tmp166_;
							_tmp157_ = child;
							_tmp158_ = _tmp157_->members;
							_tmp159_ = part;
							_tmp160_ = ns;
							_tmp161_ = _tmp160_->members;
							_tmp162_ = part;
							_tmp163_ = gee_map_get (_tmp161_, _tmp162_);
							gee_map_set (_tmp158_, _tmp159_, _tmp163_);
							_tmp164_ = ns;
							_tmp165_ = _tmp164_->members;
							_tmp166_ = part;
							gee_map_unset (_tmp165_, _tmp166_, NULL);
						}
						_tmp167_ = child;
						_tmp168_ = _generated_namespace_ref0 (_tmp167_);
						_generated_namespace_unref0 (ns);
						ns = _tmp168_;
						_generated_namespace_unref0 (child);
						_g_free0 (part);
					}
				}
				interface_name = NULL;
				_tmp169_ = self->priv->inner_interface_strategy_concat;
				if (_tmp169_) {
					GString* _tmp170_;
					GString* name_builder;
					GString* _tmp180_;
					const gchar* _tmp181_;
					GString* _tmp182_;
					const gchar* _tmp183_;
					gchar* _tmp184_;
					GeneratedNamespace* _tmp185_;
					GeeMap* _tmp186_;
					const gchar* _tmp187_;
					gboolean _tmp188_ = FALSE;
					_tmp170_ = g_string_new ("");
					name_builder = _tmp170_;
					{
						gboolean _tmp171_;
						_tmp171_ = TRUE;
						while (TRUE) {
							gboolean _tmp172_;
							gint _tmp174_;
							gint _tmp175_;
							GString* _tmp176_;
							gchar** _tmp177_;
							gint _tmp177__length1;
							gint _tmp178_;
							const gchar* _tmp179_;
							_tmp172_ = _tmp171_;
							if (!_tmp172_) {
								gint _tmp173_;
								_tmp173_ = i;
								i = _tmp173_ + 1;
							}
							_tmp171_ = FALSE;
							_tmp174_ = i;
							_tmp175_ = last_part;
							if (!(_tmp174_ < _tmp175_)) {
								break;
							}
							_tmp176_ = name_builder;
							_tmp177_ = split_name;
							_tmp177__length1 = split_name_length1;
							_tmp178_ = i;
							_tmp179_ = _tmp177_[_tmp178_];
							g_string_append (_tmp176_, _tmp179_);
						}
					}
					_tmp180_ = name_builder;
					_tmp181_ = short_name;
					g_string_append (_tmp180_, _tmp181_);
					_tmp182_ = name_builder;
					_tmp183_ = _tmp182_->str;
					_tmp184_ = g_strdup (_tmp183_);
					_g_free0 (interface_name);
					interface_name = _tmp184_;
					_tmp185_ = ns;
					_tmp186_ = _tmp185_->namespaces;
					_tmp187_ = short_name;
					_tmp188_ = gee_map_has_key (_tmp186_, _tmp187_);
					if (_tmp188_) {
						GeneratedNamespace* _tmp189_;
						GeeMap* _tmp190_;
						const gchar* _tmp191_;
						gpointer _tmp192_ = NULL;
						GeneratedNamespace* child;
						GeneratedNamespace* _tmp215_;
						GeeMap* _tmp216_;
						const gchar* _tmp217_;
						GeneratedNamespace* _tmp218_;
						_tmp189_ = ns;
						_tmp190_ = _tmp189_->namespaces;
						_tmp191_ = short_name;
						_tmp192_ = gee_map_get (_tmp190_, _tmp191_);
						child = (GeneratedNamespace*) _tmp192_;
						{
							GeneratedNamespace* _tmp193_;
							GeeMap* _tmp194_;
							GeeSet* _tmp195_;
							GeeSet* _tmp196_;
							GeeSet* _tmp197_;
							GeeIterator* _tmp198_ = NULL;
							GeeIterator* _tmp199_;
							GeeIterator* _interf_name_it;
							_tmp193_ = child;
							_tmp194_ = _tmp193_->members;
							_tmp195_ = gee_map_get_keys (_tmp194_);
							_tmp196_ = _tmp195_;
							_tmp197_ = _tmp196_;
							_tmp198_ = gee_iterable_iterator ((GeeIterable*) _tmp197_);
							_tmp199_ = _tmp198_;
							_g_object_unref0 (_tmp197_);
							_interf_name_it = _tmp199_;
							while (TRUE) {
								GeeIterator* _tmp200_;
								gboolean _tmp201_ = FALSE;
								GeeIterator* _tmp202_;
								gpointer _tmp203_ = NULL;
								gchar* interf_name;
								GeneratedNamespace* _tmp204_;
								GeeMap* _tmp205_;
								const gchar* _tmp206_;
								gpointer _tmp207_ = NULL;
								xmlNode* interf;
								GeneratedNamespace* _tmp208_;
								GeeMap* _tmp209_;
								const gchar* _tmp210_;
								const gchar* _tmp211_;
								gchar* _tmp212_;
								gchar* _tmp213_;
								xmlNode* _tmp214_;
								_tmp200_ = _interf_name_it;
								_tmp201_ = gee_iterator_next (_tmp200_);
								if (!_tmp201_) {
									break;
								}
								_tmp202_ = _interf_name_it;
								_tmp203_ = gee_iterator_get (_tmp202_);
								interf_name = (gchar*) _tmp203_;
								_tmp204_ = child;
								_tmp205_ = _tmp204_->members;
								_tmp206_ = interf_name;
								_tmp207_ = gee_map_get (_tmp205_, _tmp206_);
								interf = _tmp207_;
								_tmp208_ = ns;
								_tmp209_ = _tmp208_->members;
								_tmp210_ = short_name;
								_tmp211_ = interf_name;
								_tmp212_ = g_strconcat (_tmp210_, _tmp211_, NULL);
								_tmp213_ = _tmp212_;
								_tmp214_ = interf;
								gee_map_set (_tmp209_, _tmp213_, _tmp214_);
								_g_free0 (_tmp213_);
								_g_free0 (interf_name);
							}
							_g_object_unref0 (_interf_name_it);
						}
						_tmp215_ = ns;
						_tmp216_ = _tmp215_->namespaces;
						_tmp217_ = short_name;
						gee_map_unset (_tmp216_, _tmp217_, NULL);
						_tmp218_ = child;
						_generated_namespace_unref0 (_tmp218_->parent);
						_tmp218_->parent = NULL;
						_generated_namespace_unref0 (child);
					}
					_g_string_free0 (name_builder);
				} else {
					GeneratedNamespace* _tmp219_;
					GeeMap* _tmp220_;
					const gchar* _tmp221_;
					gboolean _tmp222_ = FALSE;
					const gchar* _tmp227_;
					gchar* _tmp228_;
					_tmp219_ = ns;
					_tmp220_ = _tmp219_->namespaces;
					_tmp221_ = short_name;
					_tmp222_ = gee_map_has_key (_tmp220_, _tmp221_);
					if (_tmp222_) {
						GeneratedNamespace* _tmp223_;
						GeeMap* _tmp224_;
						const gchar* _tmp225_;
						gpointer _tmp226_ = NULL;
						_tmp223_ = ns;
						_tmp224_ = _tmp223_->namespaces;
						_tmp225_ = short_name;
						_tmp226_ = gee_map_get (_tmp224_, _tmp225_);
						_generated_namespace_unref0 (ns);
						ns = (GeneratedNamespace*) _tmp226_;
					}
					_tmp227_ = short_name;
					_tmp228_ = g_strdup (_tmp227_);
					_g_free0 (interface_name);
					interface_name = _tmp228_;
				}
				_tmp229_ = ns;
				_tmp230_ = _tmp229_->members;
				_tmp231_ = interface_name;
				_tmp232_ = gee_map_has_key (_tmp230_, _tmp231_);
				if (!_tmp232_) {
					GeneratedNamespace* _tmp233_;
					GeeMap* _tmp234_;
					const gchar* _tmp235_;
					xmlNode* _tmp236_;
					_tmp233_ = ns;
					_tmp234_ = _tmp233_->members;
					_tmp235_ = interface_name;
					_tmp236_ = iter;
					gee_map_set (_tmp234_, _tmp235_, _tmp236_);
				} else {
					GeneratedNamespace* _tmp237_;
					GeeMap* _tmp238_;
					const gchar* _tmp239_;
					gpointer _tmp240_ = NULL;
					xmlNode* iter2;
					xmlNode* _tmp241_;
					gchar* _tmp242_ = NULL;
					gchar* name;
					const gchar* _tmp243_;
					const gchar* _tmp244_ = NULL;
					const gchar* _tmp245_;
					const gchar* _tmp246_ = NULL;
					gchar* _tmp247_ = NULL;
					gchar* _tmp248_;
					_tmp237_ = ns;
					_tmp238_ = _tmp237_->members;
					_tmp239_ = interface_name;
					_tmp240_ = gee_map_get (_tmp238_, _tmp239_);
					iter2 = _tmp240_;
					_tmp241_ = iter2;
					_tmp242_ = xmlGetProp (_tmp241_, BINDING_GENERATOR_NAME_ATTRNAME);
					name = _tmp242_;
					_tmp243_ = interface_name;
					_tmp244_ = string_to_string (_tmp243_);
					_tmp245_ = name;
					_tmp246_ = string_to_string (_tmp245_);
					_tmp247_ = g_strconcat (_tmp244_, " has been added already as namespace ", _tmp246_, NULL);
					_tmp248_ = _tmp247_;
					binding_generator_ERROR (_tmp248_);
					_g_free0 (_tmp248_);
					_g_free0 (name);
				}
				_g_free0 (interface_name);
				_generated_namespace_unref0 (ns);
				_g_free0 (short_name);
				split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (dbus_interface_name);
				_g_free0 (no_error_container_string);
			}
		}
	}
}


static void binding_generator_index_names (BindingGenerator* self, GeneratedNamespace* ns) {
	GeneratedNamespace* _tmp0_;
	GeeMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = _tmp0_->members;
	_tmp2_ = gee_map_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeneratedNamespace* _tmp4_;
		gint _tmp5_ = 0;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* namespace_name;
		_tmp4_ = ns;
		_tmp6_ = binding_generator_get_namespace_path (self, _tmp4_, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp5_;
		_tmp8_ = g_strjoinv (".", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		namespace_name = _tmp9_;
		{
			GeneratedNamespace* _tmp10_;
			GeeMap* _tmp11_;
			GeeSet* _tmp12_;
			GeeSet* _tmp13_;
			GeeSet* _tmp14_;
			GeeIterator* _tmp15_ = NULL;
			GeeIterator* _tmp16_;
			GeeIterator* _name_it;
			_tmp10_ = ns;
			_tmp11_ = _tmp10_->members;
			_tmp12_ = gee_map_get_keys (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp14_);
			_name_it = _tmp16_;
			while (TRUE) {
				GeeIterator* _tmp17_;
				gboolean _tmp18_ = FALSE;
				GeeIterator* _tmp19_;
				gpointer _tmp20_ = NULL;
				gchar* name;
				GeneratedNamespace* _tmp21_;
				GeeMap* _tmp22_;
				const gchar* _tmp23_;
				gpointer _tmp24_ = NULL;
				xmlNode* api;
				xmlNode* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* dbus_name;
				xmlNode* _tmp27_;
				const gchar* _tmp28_;
				_tmp17_ = _name_it;
				_tmp18_ = gee_iterator_next (_tmp17_);
				if (!_tmp18_) {
					break;
				}
				_tmp19_ = _name_it;
				_tmp20_ = gee_iterator_get (_tmp19_);
				name = (gchar*) _tmp20_;
				_tmp21_ = ns;
				_tmp22_ = _tmp21_->members;
				_tmp23_ = name;
				_tmp24_ = gee_map_get (_tmp22_, _tmp23_);
				api = _tmp24_;
				_tmp25_ = api;
				_tmp26_ = xmlGetProp (_tmp25_, BINDING_GENERATOR_NAME_ATTRNAME);
				dbus_name = _tmp26_;
				_tmp27_ = api;
				_tmp28_ = _tmp27_->name;
				if (g_strcmp0 (_tmp28_, BINDING_GENERATOR_ERRORDOMAIN_ELTNAME) == 0) {
					const gchar* _tmp29_;
					const gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_;
					GeeMap* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					_tmp29_ = dbus_name;
					_tmp30_ = string_to_string (_tmp29_);
					_tmp31_ = g_strconcat ("Registering new errordomain ", _tmp30_, NULL);
					_tmp32_ = _tmp31_;
					binding_generator_INFO (_tmp32_);
					_g_free0 (_tmp32_);
					_tmp33_ = self->priv->error_name_index;
					_tmp34_ = dbus_name;
					_tmp35_ = namespace_name;
					_tmp36_ = g_strconcat (_tmp35_, ".", NULL);
					_tmp37_ = _tmp36_;
					_tmp38_ = name;
					_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
					_tmp40_ = _tmp39_;
					gee_map_set (_tmp33_, _tmp34_, _tmp40_);
					_g_free0 (_tmp40_);
					_g_free0 (_tmp37_);
				} else {
					GeeMap* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					_tmp41_ = self->priv->name_index;
					_tmp42_ = dbus_name;
					_tmp43_ = namespace_name;
					_tmp44_ = g_strconcat (_tmp43_, ".", NULL);
					_tmp45_ = _tmp44_;
					_tmp46_ = name;
					_tmp47_ = g_strconcat (_tmp45_, _tmp46_, NULL);
					_tmp48_ = _tmp47_;
					gee_map_set (_tmp41_, _tmp42_, _tmp48_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp45_);
				}
				_g_free0 (dbus_name);
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		_g_free0 (namespace_name);
	}
	{
		GeneratedNamespace* _tmp49_;
		GeeMap* _tmp50_;
		GeeSet* _tmp51_;
		GeeSet* _tmp52_;
		GeeSet* _tmp53_;
		GeeIterator* _tmp54_ = NULL;
		GeeIterator* _tmp55_;
		GeeIterator* _name_it;
		_tmp49_ = ns;
		_tmp50_ = _tmp49_->namespaces;
		_tmp51_ = gee_map_get_keys (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp52_;
		_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
		_tmp55_ = _tmp54_;
		_g_object_unref0 (_tmp53_);
		_name_it = _tmp55_;
		while (TRUE) {
			GeeIterator* _tmp56_;
			gboolean _tmp57_ = FALSE;
			GeeIterator* _tmp58_;
			gpointer _tmp59_ = NULL;
			gchar* name;
			GeneratedNamespace* _tmp60_;
			GeeMap* _tmp61_;
			const gchar* _tmp62_;
			gpointer _tmp63_ = NULL;
			GeneratedNamespace* child;
			GeneratedNamespace* _tmp64_;
			_tmp56_ = _name_it;
			_tmp57_ = gee_iterator_next (_tmp56_);
			if (!_tmp57_) {
				break;
			}
			_tmp58_ = _name_it;
			_tmp59_ = gee_iterator_get (_tmp58_);
			name = (gchar*) _tmp59_;
			_tmp60_ = ns;
			_tmp61_ = _tmp60_->namespaces;
			_tmp62_ = name;
			_tmp63_ = gee_map_get (_tmp61_, _tmp62_);
			child = (GeneratedNamespace*) _tmp63_;
			_tmp64_ = child;
			binding_generator_index_names (self, _tmp64_);
			_generated_namespace_unref0 (child);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** binding_generator_get_namespace_path (BindingGenerator* self, GeneratedNamespace* ns, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** reversed_namespace_names;
	gint reversed_namespace_names_length1;
	gint _reversed_namespace_names_size_;
	GeneratedNamespace* _tmp1_;
	GeneratedNamespace* _tmp2_;
	GeneratedNamespace* a_namespace;
	gchar** _tmp12_ = NULL;
	gchar** namespace_names;
	gint namespace_names_length1;
	gint _namespace_names_size_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	reversed_namespace_names = _tmp0_;
	reversed_namespace_names_length1 = 0;
	_reversed_namespace_names_size_ = reversed_namespace_names_length1;
	_tmp1_ = ns;
	_tmp2_ = _generated_namespace_ref0 (_tmp1_);
	a_namespace = _tmp2_;
	while (TRUE) {
		GeneratedNamespace* _tmp3_;
		const gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		GeneratedNamespace* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GeneratedNamespace* _tmp9_;
		GeneratedNamespace* _tmp10_;
		GeneratedNamespace* _tmp11_;
		_tmp3_ = a_namespace;
		_tmp4_ = _tmp3_->name;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = reversed_namespace_names;
		_tmp5__length1 = reversed_namespace_names_length1;
		_tmp6_ = a_namespace;
		_tmp7_ = _tmp6_->name;
		_tmp8_ = g_strdup (_tmp7_);
		_vala_array_add1 (&reversed_namespace_names, &reversed_namespace_names_length1, &_reversed_namespace_names_size_, _tmp8_);
		_tmp9_ = a_namespace;
		_tmp10_ = _tmp9_->parent;
		_tmp11_ = _generated_namespace_ref0 (_tmp10_);
		_generated_namespace_unref0 (a_namespace);
		a_namespace = _tmp11_;
	}
	_tmp12_ = g_new0 (gchar*, 0 + 1);
	namespace_names = _tmp12_;
	namespace_names_length1 = 0;
	_namespace_names_size_ = namespace_names_length1;
	{
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint i;
		_tmp13_ = reversed_namespace_names;
		_tmp13__length1 = reversed_namespace_names_length1;
		i = _tmp13__length1 - 1;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ - 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ >= 0)) {
					break;
				}
				_tmp18_ = namespace_names;
				_tmp18__length1 = namespace_names_length1;
				_tmp19_ = reversed_namespace_names;
				_tmp19__length1 = reversed_namespace_names_length1;
				_tmp20_ = i;
				_tmp21_ = _tmp19_[_tmp20_];
				_tmp22_ = g_strdup (_tmp21_);
				_vala_array_add2 (&namespace_names, &namespace_names_length1, &_namespace_names_size_, _tmp22_);
			}
		}
	}
	_tmp23_ = namespace_names;
	_tmp23__length1 = namespace_names_length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_generated_namespace_unref0 (a_namespace);
	reversed_namespace_names = (_vala_array_free (reversed_namespace_names, reversed_namespace_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void binding_generator_generate_namespace (BindingGenerator* self, GeneratedNamespace* ns, GError** error) {
	GeneratedNamespace* _tmp0_;
	GeeMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = _tmp0_->members;
	_tmp2_ = gee_map_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeneratedNamespace* _tmp4_;
		gint _tmp5_ = 0;
		gchar** _tmp6_ = NULL;
		gchar** namespace_names;
		gint namespace_names_length1;
		gint _namespace_names_size_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp63_;
		gint _tmp63__length1;
		_tmp4_ = ns;
		_tmp6_ = binding_generator_get_namespace_path (self, _tmp4_, &_tmp5_);
		namespace_names = _tmp6_;
		namespace_names_length1 = _tmp5_;
		_namespace_names_size_ = namespace_names_length1;
		_tmp7_ = self->priv->output_directory;
		_tmp8_ = g_strconcat (_tmp7_, "/", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = namespace_names;
		_tmp10__length1 = namespace_names_length1;
		_tmp11_ = g_strjoinv ("-", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) (-1));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp9_, _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, ".vala", NULL);
		_tmp18_ = _tmp17_;
		binding_generator_create_binding_file (self, _tmp18_, &_inner_error_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp19_ = namespace_names;
		_tmp19__length1 = namespace_names_length1;
		{
			gchar** name_collection = NULL;
			gint name_collection_length1 = 0;
			gint _name_collection_size_ = 0;
			gint name_it = 0;
			name_collection = _tmp19_;
			name_collection_length1 = _tmp19__length1;
			for (name_it = 0; name_it < _tmp19__length1; name_it = name_it + 1) {
				gchar* _tmp20_;
				gchar* name = NULL;
				_tmp20_ = g_strdup (name_collection[name_it]);
				name = _tmp20_;
				{
					FILE* _tmp21_;
					FILE* _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = self->priv->output;
					fprintf (_tmp21_, "\n");
					_tmp22_ = self->priv->output;
					_tmp23_ = binding_generator_get_indent (self, 0);
					_tmp24_ = _tmp23_;
					_tmp25_ = name;
					fprintf (_tmp22_, "%snamespace %s {\n", _tmp24_, _tmp25_);
					_g_free0 (_tmp24_);
					binding_generator_update_indent (self, +1);
					_g_free0 (name);
				}
			}
		}
		{
			GeneratedNamespace* _tmp26_;
			GeeMap* _tmp27_;
			GeeSet* _tmp28_;
			GeeSet* _tmp29_;
			GeeSet* _tmp30_;
			GeeIterator* _tmp31_ = NULL;
			GeeIterator* _tmp32_;
			GeeIterator* _name_it;
			_tmp26_ = ns;
			_tmp27_ = _tmp26_->members;
			_tmp28_ = gee_map_get_keys (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_;
			_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
			_tmp32_ = _tmp31_;
			_g_object_unref0 (_tmp30_);
			_name_it = _tmp32_;
			while (TRUE) {
				GeeIterator* _tmp33_;
				gboolean _tmp34_ = FALSE;
				GeeIterator* _tmp35_;
				gpointer _tmp36_ = NULL;
				gchar* name;
				GeneratedNamespace* _tmp37_;
				GeeMap* _tmp38_;
				const gchar* _tmp39_;
				gpointer _tmp40_ = NULL;
				xmlNode* api;
				xmlNode* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				GQuark _tmp45_ = 0U;
				_tmp33_ = _name_it;
				_tmp34_ = gee_iterator_next (_tmp33_);
				if (!_tmp34_) {
					break;
				}
				_tmp35_ = _name_it;
				_tmp36_ = gee_iterator_get (_tmp35_);
				name = (gchar*) _tmp36_;
				_tmp37_ = ns;
				_tmp38_ = _tmp37_->members;
				_tmp39_ = name;
				_tmp40_ = gee_map_get (_tmp38_, _tmp39_);
				api = _tmp40_;
				_tmp41_ = api;
				_tmp42_ = _tmp41_->name;
				_tmp43_ = _tmp42_;
				_tmp45_ = (NULL == _tmp43_) ? 0 : g_quark_from_string (_tmp43_);
				if (_tmp45_ == g_quark_from_string (BINDING_GENERATOR_INTERFACE_ELTNAME)) {
					switch (0) {
						default:
						{
							const gchar* _tmp46_;
							xmlNode* _tmp47_;
							xmlNode* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gboolean _tmp51_;
							xmlNode* _tmp54_;
							const gchar* _tmp55_;
							gchar* _tmp56_;
							_tmp46_ = name;
							_tmp47_ = api;
							binding_generator_generate_interface (self, _tmp46_, _tmp47_, SYNCHRONY_AUTO, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp48_ = api;
							_tmp49_ = name;
							_tmp50_ = g_strdup (_tmp49_);
							binding_generator_generate_proxy_getter (self, _tmp48_, _tmp50_, SYNCHRONY_AUTO, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp51_ = binding_generator_synced;
							if (_tmp51_) {
								const gchar* _tmp52_;
								xmlNode* _tmp53_;
								_tmp52_ = name;
								_tmp53_ = api;
								binding_generator_generate_interface (self, _tmp52_, _tmp53_, SYNCHRONY_FORCE_SYNC, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == GENERATOR_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (name);
										_g_object_unref0 (_name_it);
										namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
										return;
									} else {
										_g_free0 (name);
										_g_object_unref0 (_name_it);
										namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp54_ = api;
							_tmp55_ = name;
							_tmp56_ = g_strdup (_tmp55_);
							binding_generator_generate_proxy_getter (self, _tmp54_, _tmp56_, SYNCHRONY_FORCE_SYNC, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp45_ == g_quark_from_string (BINDING_GENERATOR_ENUMERATION_ELTNAME)) {
					switch (0) {
						default:
						{
							const gchar* _tmp57_;
							xmlNode* _tmp58_;
							_tmp57_ = name;
							_tmp58_ = api;
							binding_generator_generate_enumeration (self, _tmp57_, _tmp58_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp45_ == g_quark_from_string (BINDING_GENERATOR_ERRORDOMAIN_ELTNAME)) {
					switch (0) {
						default:
						{
							const gchar* _tmp59_;
							xmlNode* _tmp60_;
							_tmp59_ = name;
							_tmp60_ = api;
							binding_generator_generate_errordomain (self, _tmp59_, _tmp60_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp45_ == g_quark_from_string (BINDING_GENERATOR_STRUCT_ELTNAME)) {
					switch (0) {
						default:
						{
							const gchar* _tmp61_;
							xmlNode* _tmp62_;
							_tmp61_ = name;
							_tmp62_ = api;
							binding_generator_generate_explicit_struct (self, _tmp61_, _tmp62_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (name);
									_g_object_unref0 (_name_it);
									namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				}
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		_tmp63_ = namespace_names;
		_tmp63__length1 = namespace_names_length1;
		{
			gchar** name_collection = NULL;
			gint name_collection_length1 = 0;
			gint _name_collection_size_ = 0;
			gint name_it = 0;
			name_collection = _tmp63_;
			name_collection_length1 = _tmp63__length1;
			for (name_it = 0; name_it < _tmp63__length1; name_it = name_it + 1) {
				gchar* _tmp64_;
				gchar* name = NULL;
				_tmp64_ = g_strdup (name_collection[name_it]);
				name = _tmp64_;
				{
					FILE* _tmp65_;
					gchar* _tmp66_ = NULL;
					gchar* _tmp67_;
					binding_generator_update_indent (self, -1);
					_tmp65_ = self->priv->output;
					_tmp66_ = binding_generator_get_indent (self, 0);
					_tmp67_ = _tmp66_;
					fprintf (_tmp65_, "%s}\n", _tmp67_);
					_g_free0 (_tmp67_);
					_g_free0 (name);
				}
			}
		}
		_fclose0 (self->priv->output);
		self->priv->output = NULL;
		namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		GeneratedNamespace* _tmp68_;
		GeeMap* _tmp69_;
		GeeSet* _tmp70_;
		GeeSet* _tmp71_;
		GeeSet* _tmp72_;
		GeeIterator* _tmp73_ = NULL;
		GeeIterator* _tmp74_;
		GeeIterator* _name_it;
		_tmp68_ = ns;
		_tmp69_ = _tmp68_->namespaces;
		_tmp70_ = gee_map_get_keys (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = _tmp71_;
		_tmp73_ = gee_iterable_iterator ((GeeIterable*) _tmp72_);
		_tmp74_ = _tmp73_;
		_g_object_unref0 (_tmp72_);
		_name_it = _tmp74_;
		while (TRUE) {
			GeeIterator* _tmp75_;
			gboolean _tmp76_ = FALSE;
			GeeIterator* _tmp77_;
			gpointer _tmp78_ = NULL;
			gchar* name;
			GeneratedNamespace* _tmp79_;
			GeeMap* _tmp80_;
			const gchar* _tmp81_;
			gpointer _tmp82_ = NULL;
			GeneratedNamespace* child;
			GeneratedNamespace* _tmp83_;
			_tmp75_ = _name_it;
			_tmp76_ = gee_iterator_next (_tmp75_);
			if (!_tmp76_) {
				break;
			}
			_tmp77_ = _name_it;
			_tmp78_ = gee_iterator_get (_tmp77_);
			name = (gchar*) _tmp78_;
			_tmp79_ = ns;
			_tmp80_ = _tmp79_->namespaces;
			_tmp81_ = name;
			_tmp82_ = gee_map_get (_tmp80_, _tmp81_);
			child = (GeneratedNamespace*) _tmp82_;
			_tmp83_ = child;
			binding_generator_generate_namespace (self, _tmp83_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GENERATOR_ERROR) {
					g_propagate_error (error, _inner_error_);
					_generated_namespace_unref0 (child);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					return;
				} else {
					_generated_namespace_unref0 (child);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_generated_namespace_unref0 (child);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
}


static void binding_generator_generate_interface (BindingGenerator* self, const gchar* interface_name, xmlNode* node, Synchrony synchrony, GError** error) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* dbus_name;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* namespace_name;
	Synchrony _tmp4_;
	gchar* _tmp5_ = NULL;
	Synchrony _tmp6_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* iface_name;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	FILE* _tmp17_;
	FILE* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	guint _tmp22_;
	FILE* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	xmlNode* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	Synchrony _tmp32_;
	FILE* _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	GeeMap* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	dbus_name = _tmp1_;
	_tmp2_ = interface_name;
	_tmp3_ = binding_generator_get_namespace_name (self, _tmp2_);
	namespace_name = _tmp3_;
	_tmp4_ = synchrony;
	g_assert (_tmp4_ != SYNCHRONY_FORCE_ASYNC);
	_tmp6_ = synchrony;
	if (_tmp6_ == SYNCHRONY_FORCE_SYNC) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = interface_name;
		_tmp8_ = g_strconcat (_tmp7_, "Sync", NULL);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = interface_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp10_;
	}
	_tmp11_ = _tmp5_;
	_tmp12_ = g_strdup (_tmp11_);
	iface_name = _tmp12_;
	_tmp13_ = dbus_name;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = g_strconcat ("Generating interface ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	binding_generator_INFO (_tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = self->priv->output;
	fprintf (_tmp17_, "\n");
	_tmp18_ = self->priv->output;
	_tmp19_ = binding_generator_get_indent (self, 0);
	_tmp20_ = _tmp19_;
	_tmp21_ = dbus_name;
	_tmp22_ = self->priv->dbus_timeout;
	fprintf (_tmp18_, "%s[DBus (name = \"%s\", timeout = %u)]\n", _tmp20_, _tmp21_, _tmp22_);
	_g_free0 (_tmp20_);
	_tmp23_ = self->priv->output;
	_tmp24_ = binding_generator_get_indent (self, 0);
	_tmp25_ = _tmp24_;
	_tmp26_ = iface_name;
	fprintf (_tmp23_, "%spublic interface %s : GLib.Object {\n", _tmp25_, _tmp26_);
	_g_free0 (_tmp25_);
	binding_generator_update_indent (self, +1);
	_tmp27_ = node;
	_tmp28_ = iface_name;
	_tmp29_ = dbus_name;
	_tmp30_ = binding_generator_get_namespace_name (self, _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = synchrony;
	binding_generator_generate_members (self, _tmp27_, _tmp28_, _tmp31_, _tmp32_, &_inner_error_);
	_g_free0 (_tmp31_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (iface_name);
			_g_free0 (_tmp5_);
			_g_free0 (namespace_name);
			_g_free0 (dbus_name);
			return;
		} else {
			_g_free0 (iface_name);
			_g_free0 (_tmp5_);
			_g_free0 (namespace_name);
			_g_free0 (dbus_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	binding_generator_update_indent (self, -1);
	_tmp33_ = self->priv->output;
	_tmp34_ = binding_generator_get_indent (self, 0);
	_tmp35_ = _tmp34_;
	fprintf (_tmp33_, "%s}\n", _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = self->priv->structs_to_generate;
	_tmp37_ = gee_map_get_size (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != 0) {
		GeeMap* _tmp55_;
		{
			GeeMap* _tmp39_;
			GeeSet* _tmp40_;
			GeeSet* _tmp41_;
			GeeSet* _tmp42_;
			GeeIterator* _tmp43_ = NULL;
			GeeIterator* _tmp44_;
			GeeIterator* _name_it;
			_tmp39_ = self->priv->structs_to_generate;
			_tmp40_ = gee_map_get_keys (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _tmp41_;
			_tmp43_ = gee_iterable_iterator ((GeeIterable*) _tmp42_);
			_tmp44_ = _tmp43_;
			_g_object_unref0 (_tmp42_);
			_name_it = _tmp44_;
			while (TRUE) {
				GeeIterator* _tmp45_;
				gboolean _tmp46_ = FALSE;
				GeeIterator* _tmp47_;
				gpointer _tmp48_ = NULL;
				gchar* name;
				const gchar* _tmp49_;
				GeeMap* _tmp50_;
				const gchar* _tmp51_;
				gpointer _tmp52_ = NULL;
				gchar* _tmp53_;
				const gchar* _tmp54_;
				_tmp45_ = _name_it;
				_tmp46_ = gee_iterator_next (_tmp45_);
				if (!_tmp46_) {
					break;
				}
				_tmp47_ = _name_it;
				_tmp48_ = gee_iterator_get (_tmp47_);
				name = (gchar*) _tmp48_;
				_tmp49_ = name;
				_tmp50_ = self->priv->structs_to_generate;
				_tmp51_ = name;
				_tmp52_ = gee_map_get (_tmp50_, _tmp51_);
				_tmp53_ = (gchar*) _tmp52_;
				_tmp54_ = namespace_name;
				binding_generator_generate_struct (self, _tmp49_, _tmp53_, _tmp54_, &_inner_error_);
				_g_free0 (_tmp53_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GENERATOR_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (name);
						_g_object_unref0 (_name_it);
						_g_free0 (iface_name);
						_g_free0 (_tmp5_);
						_g_free0 (namespace_name);
						_g_free0 (dbus_name);
						return;
					} else {
						_g_free0 (name);
						_g_object_unref0 (_name_it);
						_g_free0 (iface_name);
						_g_free0 (_tmp5_);
						_g_free0 (namespace_name);
						_g_free0 (dbus_name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		_tmp55_ = self->priv->structs_to_generate;
		gee_map_clear (_tmp55_);
	}
	_g_free0 (iface_name);
	_g_free0 (_tmp5_);
	_g_free0 (namespace_name);
	_g_free0 (dbus_name);
}


static void binding_generator_generate_enumeration (BindingGenerator* self, const gchar* enumeration_name, xmlNode* node, GError** error) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* dbus_name;
	xmlNode* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* type;
	const gchar* _tmp4_;
	gboolean string_enum;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	FILE* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_;
	FILE* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	FILE* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	FILE* _tmp62_;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (enumeration_name != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	dbus_name = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = xmlGetProp (_tmp2_, BINDING_GENERATOR_TYPE_ATTRNAME);
	type = _tmp3_;
	_tmp4_ = type;
	string_enum = g_strcmp0 (_tmp4_, "s") == 0;
	_tmp5_ = type;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = dbus_name;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = g_strconcat ("Generating enumeration ", _tmp6_, " for ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	binding_generator_INFO (_tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->output;
	fprintf (_tmp11_, "\n");
	_tmp13_ = string_enum;
	if (_tmp13_) {
		_tmp12_ = " (use_string_marshalling = true)";
	} else {
		_tmp12_ = "";
	}
	_tmp14_ = self->priv->output;
	_tmp15_ = binding_generator_get_indent (self, 0);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp12_;
	fprintf (_tmp14_, "%s[DBus%s]\n", _tmp16_, _tmp17_);
	_g_free0 (_tmp16_);
	_tmp18_ = self->priv->output;
	_tmp19_ = binding_generator_get_indent (self, 0);
	_tmp20_ = _tmp19_;
	_tmp21_ = enumeration_name;
	fprintf (_tmp18_, "%spublic enum %s {\n", _tmp20_, _tmp21_);
	_g_free0 (_tmp20_);
	binding_generator_update_indent (self, +1);
	{
		xmlNode* _tmp22_;
		xmlNode* _tmp23_;
		xmlNode* iter;
		_tmp22_ = node;
		_tmp23_ = _tmp22_->children;
		iter = _tmp23_;
		{
			gboolean _tmp24_;
			_tmp24_ = TRUE;
			while (TRUE) {
				gboolean _tmp25_;
				xmlNode* _tmp28_;
				xmlNode* _tmp29_;
				xmlElementType _tmp30_;
				xmlNode* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				GQuark _tmp35_ = 0U;
				_tmp25_ = _tmp24_;
				if (!_tmp25_) {
					xmlNode* _tmp26_;
					xmlNode* _tmp27_;
					_tmp26_ = iter;
					_tmp27_ = _tmp26_->next;
					iter = _tmp27_;
				}
				_tmp24_ = FALSE;
				_tmp28_ = iter;
				if (!(_tmp28_ != NULL)) {
					break;
				}
				_tmp29_ = iter;
				_tmp30_ = _tmp29_->type;
				if (_tmp30_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp31_ = iter;
				_tmp32_ = _tmp31_->name;
				_tmp33_ = _tmp32_;
				_tmp35_ = (NULL == _tmp33_) ? 0 : g_quark_from_string (_tmp33_);
				if (_tmp35_ == g_quark_from_string (BINDING_GENERATOR_MEMBER_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp36_;
							gchar* _tmp37_ = NULL;
							gchar* _tmp38_;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_;
							gchar* member_name;
							xmlNode* _tmp41_;
							gchar* _tmp42_ = NULL;
							gchar* member_value;
							gboolean _tmp43_;
							gchar* _tmp48_ = NULL;
							gboolean _tmp49_;
							const gchar* _tmp53_ = NULL;
							xmlNode* _tmp54_;
							xmlNode* _tmp55_;
							FILE* _tmp56_;
							gchar* _tmp57_ = NULL;
							gchar* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							const gchar* _tmp61_;
							_tmp36_ = iter;
							_tmp37_ = xmlGetProp (_tmp36_, BINDING_GENERATOR_NAME_ATTRNAME);
							_tmp38_ = _tmp37_;
							_tmp39_ = binding_generator_normalized_to_upper_case (self, _tmp38_);
							_tmp40_ = _tmp39_;
							_g_free0 (_tmp38_);
							member_name = _tmp40_;
							_tmp41_ = iter;
							_tmp42_ = xmlGetProp (_tmp41_, BINDING_GENERATOR_VALUE_ATTRNAME);
							member_value = _tmp42_;
							_tmp43_ = string_enum;
							if (_tmp43_) {
								FILE* _tmp44_;
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_;
								const gchar* _tmp47_;
								_tmp44_ = self->priv->output;
								_tmp45_ = binding_generator_get_indent (self, 0);
								_tmp46_ = _tmp45_;
								_tmp47_ = member_value;
								fprintf (_tmp44_, "%s[DBus (value=\"%s\")]\n", _tmp46_, _tmp47_);
								_g_free0 (_tmp46_);
							}
							_tmp49_ = string_enum;
							if (_tmp49_) {
								gchar* _tmp50_;
								_tmp50_ = g_strdup ("");
								_g_free0 (_tmp48_);
								_tmp48_ = _tmp50_;
							} else {
								const gchar* _tmp51_;
								gchar* _tmp52_ = NULL;
								_tmp51_ = member_value;
								_tmp52_ = g_strdup_printf (" = %s", _tmp51_);
								_g_free0 (_tmp48_);
								_tmp48_ = _tmp52_;
							}
							_tmp54_ = iter;
							_tmp55_ = _tmp54_->next;
							if (_tmp55_ == NULL) {
								_tmp53_ = "";
							} else {
								_tmp53_ = ",";
							}
							_tmp56_ = self->priv->output;
							_tmp57_ = binding_generator_get_indent (self, 0);
							_tmp58_ = _tmp57_;
							_tmp59_ = member_name;
							_tmp60_ = _tmp48_;
							_tmp61_ = _tmp53_;
							fprintf (_tmp56_, "%s%s%s%s\n", _tmp58_, _tmp59_, _tmp60_, _tmp61_);
							_g_free0 (_tmp58_);
							_g_free0 (_tmp48_);
							_g_free0 (member_value);
							_g_free0 (member_name);
							break;
						}
					}
				}
			}
		}
	}
	binding_generator_update_indent (self, -1);
	_tmp62_ = self->priv->output;
	_tmp63_ = binding_generator_get_indent (self, 0);
	_tmp64_ = _tmp63_;
	fprintf (_tmp62_, "%s}\n", _tmp64_);
	_g_free0 (_tmp64_);
	_g_free0 (type);
	_g_free0 (dbus_name);
}


static void binding_generator_generate_errordomain (BindingGenerator* self, const gchar* errordomain_name, xmlNode* node, GError** error) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* dbus_name;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	FILE* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	FILE* _tmp47_;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errordomain_name != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	dbus_name = _tmp1_;
	_tmp2_ = errordomain_name;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = dbus_name;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("Generating errordomain ", _tmp3_, " for ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	binding_generator_INFO (_tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->output;
	fprintf (_tmp8_, "\n");
	_tmp9_ = self->priv->output;
	_tmp10_ = binding_generator_get_indent (self, 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = dbus_name;
	fprintf (_tmp9_, "%s[DBus (name = \"%s\")]\n", _tmp11_, _tmp12_);
	_g_free0 (_tmp11_);
	_tmp13_ = self->priv->output;
	_tmp14_ = binding_generator_get_indent (self, 0);
	_tmp15_ = _tmp14_;
	_tmp16_ = errordomain_name;
	fprintf (_tmp13_, "%spublic errordomain %s {\n", _tmp15_, _tmp16_);
	_g_free0 (_tmp15_);
	binding_generator_update_indent (self, +1);
	{
		xmlNode* _tmp17_;
		xmlNode* _tmp18_;
		xmlNode* iter;
		_tmp17_ = node;
		_tmp18_ = _tmp17_->children;
		iter = _tmp18_;
		{
			gboolean _tmp19_;
			_tmp19_ = TRUE;
			while (TRUE) {
				gboolean _tmp20_;
				xmlNode* _tmp23_;
				xmlNode* _tmp24_;
				xmlElementType _tmp25_;
				xmlNode* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				GQuark _tmp30_ = 0U;
				_tmp20_ = _tmp19_;
				if (!_tmp20_) {
					xmlNode* _tmp21_;
					xmlNode* _tmp22_;
					_tmp21_ = iter;
					_tmp22_ = _tmp21_->next;
					iter = _tmp22_;
				}
				_tmp19_ = FALSE;
				_tmp23_ = iter;
				if (!(_tmp23_ != NULL)) {
					break;
				}
				_tmp24_ = iter;
				_tmp25_ = _tmp24_->type;
				if (_tmp25_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp26_ = iter;
				_tmp27_ = _tmp26_->name;
				_tmp28_ = _tmp27_;
				_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
				if (_tmp30_ == g_quark_from_string (BINDING_GENERATOR_ERROR_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp31_;
							gchar* _tmp32_ = NULL;
							gchar* dbus_error_name;
							const gchar* _tmp33_;
							gchar* _tmp34_ = NULL;
							gchar* error_name;
							FILE* _tmp35_;
							gchar* _tmp36_ = NULL;
							gchar* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_ = NULL;
							xmlNode* _tmp40_;
							xmlNode* _tmp41_;
							FILE* _tmp42_;
							gchar* _tmp43_ = NULL;
							gchar* _tmp44_;
							const gchar* _tmp45_;
							const gchar* _tmp46_;
							_tmp31_ = iter;
							_tmp32_ = xmlGetProp (_tmp31_, BINDING_GENERATOR_NAME_ATTRNAME);
							dbus_error_name = _tmp32_;
							_tmp33_ = dbus_error_name;
							_tmp34_ = binding_generator_camel_case_to_upper_case (self, _tmp33_);
							error_name = _tmp34_;
							_tmp35_ = self->priv->output;
							_tmp36_ = binding_generator_get_indent (self, 0);
							_tmp37_ = _tmp36_;
							_tmp38_ = dbus_error_name;
							fprintf (_tmp35_, "%s[DBus (name = \"%s\")]\n", _tmp37_, _tmp38_);
							_g_free0 (_tmp37_);
							_tmp40_ = iter;
							_tmp41_ = _tmp40_->next;
							if (_tmp41_ == NULL) {
								_tmp39_ = "";
							} else {
								_tmp39_ = ",";
							}
							_tmp42_ = self->priv->output;
							_tmp43_ = binding_generator_get_indent (self, 0);
							_tmp44_ = _tmp43_;
							_tmp45_ = error_name;
							_tmp46_ = _tmp39_;
							fprintf (_tmp42_, "%s%s%s\n", _tmp44_, _tmp45_, _tmp46_);
							_g_free0 (_tmp44_);
							_g_free0 (error_name);
							_g_free0 (dbus_error_name);
							break;
						}
					}
				}
			}
		}
	}
	binding_generator_update_indent (self, -1);
	_tmp47_ = self->priv->output;
	_tmp48_ = binding_generator_get_indent (self, 0);
	_tmp49_ = _tmp48_;
	fprintf (_tmp47_, "%s}\n", _tmp49_);
	_g_free0 (_tmp49_);
	_g_free0 (dbus_name);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void binding_generator_generate_explicit_struct (BindingGenerator* self, const gchar* struct_name, xmlNode* node, GError** error) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* dbus_name;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* ctor_signature;
	gchar* _tmp18_;
	gchar* ctor_body;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_;
	const gchar* _tmp86_;
	gchar* _tmp87_ = NULL;
	gchar* _tmp88_;
	gchar* _tmp89_ = NULL;
	gchar* _tmp90_;
	gchar* constructor;
	FILE* _tmp91_;
	const gchar* _tmp92_;
	gboolean _tmp93_;
	FILE* _tmp109_;
	gchar* _tmp110_ = NULL;
	gchar* _tmp111_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (struct_name != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	dbus_name = _tmp1_;
	_tmp2_ = struct_name;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = dbus_name;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("Generating explicit struct ", _tmp3_, " for ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	binding_generator_INFO (_tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->output;
	fprintf (_tmp8_, "\n");
	_tmp9_ = self->priv->output;
	_tmp10_ = binding_generator_get_indent (self, 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = struct_name;
	fprintf (_tmp9_, "%spublic struct %s {\n", _tmp11_, _tmp12_);
	_g_free0 (_tmp11_);
	binding_generator_update_indent (self, +1);
	_tmp13_ = binding_generator_get_indent (self, 0);
	_tmp14_ = _tmp13_;
	_tmp15_ = struct_name;
	_tmp16_ = g_strdup_printf ("%spublic %s (", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	ctor_signature = _tmp17_;
	_tmp18_ = g_strdup ("");
	ctor_body = _tmp18_;
	{
		xmlNode* _tmp19_;
		xmlNode* _tmp20_;
		xmlNode* iter;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->children;
		iter = _tmp20_;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_;
				xmlNode* _tmp25_;
				xmlNode* _tmp26_;
				xmlElementType _tmp27_;
				xmlNode* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				GQuark _tmp32_ = 0U;
				_tmp22_ = _tmp21_;
				if (!_tmp22_) {
					xmlNode* _tmp23_;
					xmlNode* _tmp24_;
					_tmp23_ = iter;
					_tmp24_ = _tmp23_->next;
					iter = _tmp24_;
				}
				_tmp21_ = FALSE;
				_tmp25_ = iter;
				if (!(_tmp25_ != NULL)) {
					break;
				}
				_tmp26_ = iter;
				_tmp27_ = _tmp26_->type;
				if (_tmp27_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp28_ = iter;
				_tmp29_ = _tmp28_->name;
				_tmp30_ = _tmp29_;
				_tmp32_ = (NULL == _tmp30_) ? 0 : g_quark_from_string (_tmp30_);
				if (_tmp32_ == g_quark_from_string (BINDING_GENERATOR_FIELD_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp33_;
							gchar* _tmp34_ = NULL;
							gchar* _tmp35_;
							gchar* _tmp36_ = NULL;
							gchar* _tmp37_;
							gchar* field_name;
							gchar* _tmp38_;
							gchar* field_type;
							FILE* _tmp61_;
							gchar* _tmp62_ = NULL;
							gchar* _tmp63_;
							const gchar* _tmp64_;
							const gchar* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							const gchar* _tmp68_;
							gchar* _tmp69_ = NULL;
							gchar* _tmp70_;
							gchar* _tmp71_;
							const gchar* _tmp72_;
							gchar* _tmp73_ = NULL;
							gchar* _tmp74_;
							const gchar* _tmp75_;
							const gchar* _tmp76_;
							gchar* _tmp77_ = NULL;
							gchar* _tmp78_;
							gchar* _tmp79_;
							_tmp33_ = iter;
							_tmp34_ = xmlGetProp (_tmp33_, BINDING_GENERATOR_NAME_ATTRNAME);
							_tmp35_ = _tmp34_;
							_tmp36_ = binding_generator_transform_registered_name (self, _tmp35_);
							_tmp37_ = _tmp36_;
							_g_free0 (_tmp35_);
							field_name = _tmp37_;
							_tmp38_ = g_strdup ("unknown");
							field_type = _tmp38_;
							{
								xmlNode* _tmp39_;
								gchar* _tmp40_ = NULL;
								gchar* _tmp41_;
								xmlNode* _tmp42_;
								gchar* _tmp43_ = NULL;
								gchar* _tmp44_;
								const gchar* _tmp45_;
								const gchar* _tmp46_;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_;
								gchar* _tmp51_;
								_tmp39_ = iter;
								_tmp40_ = xmlGetProp (_tmp39_, BINDING_GENERATOR_TYPE_ATTRNAME);
								_tmp41_ = _tmp40_;
								_tmp42_ = iter;
								_tmp43_ = xmlGetNsProp (_tmp42_, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE);
								_tmp44_ = _tmp43_;
								_tmp45_ = struct_name;
								_tmp46_ = dbus_name;
								_tmp47_ = binding_generator_get_namespace_name (self, _tmp46_);
								_tmp48_ = _tmp47_;
								_tmp49_ = binding_generator_translate_type (self, _tmp41_, _tmp44_, _tmp45_, _tmp48_, &_inner_error_);
								_tmp50_ = _tmp49_;
								_g_free0 (_tmp48_);
								_g_free0 (_tmp44_);
								_g_free0 (_tmp41_);
								_tmp51_ = _tmp50_;
								if (_inner_error_ != NULL) {
									if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
										goto __catch1_generator_error_unknown_dbus_type;
									}
									goto __finally1;
								}
								_g_free0 (field_type);
								field_type = _tmp51_;
							}
							goto __finally1;
							__catch1_generator_error_unknown_dbus_type:
							{
								GError* ex = NULL;
								const gchar* _tmp52_;
								const gchar* _tmp53_ = NULL;
								const gchar* _tmp54_;
								const gchar* _tmp55_ = NULL;
								GError* _tmp56_;
								const gchar* _tmp57_;
								const gchar* _tmp58_ = NULL;
								gchar* _tmp59_ = NULL;
								gchar* _tmp60_;
								ex = _inner_error_;
								_inner_error_ = NULL;
								_tmp52_ = struct_name;
								_tmp53_ = string_to_string (_tmp52_);
								_tmp54_ = field_name;
								_tmp55_ = string_to_string (_tmp54_);
								_tmp56_ = ex;
								_tmp57_ = _tmp56_->message;
								_tmp58_ = string_to_string (_tmp57_);
								_tmp59_ = g_strconcat ("In struct ", _tmp53_, " field ", _tmp55_, " : Unknown dbus type ", _tmp58_, NULL);
								_tmp60_ = _tmp59_;
								binding_generator_ERROR (_tmp60_);
								_g_free0 (_tmp60_);
								_g_error_free0 (ex);
							}
							__finally1:
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (field_type);
									_g_free0 (field_name);
									_g_free0 (ctor_body);
									_g_free0 (ctor_signature);
									_g_free0 (dbus_name);
									return;
								} else {
									_g_free0 (field_type);
									_g_free0 (field_name);
									_g_free0 (ctor_body);
									_g_free0 (ctor_signature);
									_g_free0 (dbus_name);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp61_ = self->priv->output;
							_tmp62_ = binding_generator_get_indent (self, 0);
							_tmp63_ = _tmp62_;
							_tmp64_ = field_type;
							_tmp65_ = field_name;
							fprintf (_tmp61_, "%spublic %s %s;\n", _tmp63_, _tmp64_, _tmp65_);
							_g_free0 (_tmp63_);
							_tmp66_ = ctor_signature;
							_tmp67_ = field_type;
							_tmp68_ = field_name;
							_tmp69_ = g_strdup_printf ("%s %s, ", _tmp67_, _tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = g_strconcat (_tmp66_, _tmp70_, NULL);
							_g_free0 (ctor_signature);
							ctor_signature = _tmp71_;
							_g_free0 (_tmp70_);
							_tmp72_ = ctor_body;
							_tmp73_ = binding_generator_get_indent (self, +1);
							_tmp74_ = _tmp73_;
							_tmp75_ = field_name;
							_tmp76_ = field_name;
							_tmp77_ = g_strdup_printf ("%sthis.%s = %s;\n", _tmp74_, _tmp75_, _tmp76_);
							_tmp78_ = _tmp77_;
							_tmp79_ = g_strconcat (_tmp72_, _tmp78_, NULL);
							_g_free0 (ctor_body);
							ctor_body = _tmp79_;
							_g_free0 (_tmp78_);
							_g_free0 (_tmp74_);
							_g_free0 (field_type);
							_g_free0 (field_name);
							break;
						}
					}
				}
			}
		}
	}
	_tmp80_ = ctor_signature;
	_tmp81_ = ctor_signature;
	_tmp82_ = strlen (_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp84_ = string_substring (_tmp80_, (glong) 0, (glong) (_tmp83_ - 2));
	_tmp85_ = _tmp84_;
	_tmp86_ = ctor_body;
	_tmp87_ = binding_generator_get_indent (self, 0);
	_tmp88_ = _tmp87_;
	_tmp89_ = g_strdup_printf ("%s ) {\n%s%s}", _tmp85_, _tmp86_, _tmp88_);
	_tmp90_ = _tmp89_;
	_g_free0 (_tmp88_);
	_g_free0 (_tmp85_);
	constructor = _tmp90_;
	_tmp91_ = self->priv->output;
	_tmp92_ = constructor;
	fprintf (_tmp91_, "\n%s\n", _tmp92_);
	_tmp93_ = binding_generator_gdbus;
	if (_tmp93_) {
		const gchar* _tmp94_;
		const gchar* _tmp95_ = NULL;
		gchar* _tmp96_ = NULL;
		gchar* _tmp97_;
		FILE* _tmp98_;
		gchar* _tmp99_ = NULL;
		gchar* _tmp100_;
		const gchar* _tmp101_;
		FILE* _tmp102_;
		gchar* _tmp103_ = NULL;
		gchar* _tmp104_;
		const gchar* _tmp105_;
		FILE* _tmp106_;
		gchar* _tmp107_ = NULL;
		gchar* _tmp108_;
		_tmp94_ = struct_name;
		_tmp95_ = string_to_string (_tmp94_);
		_tmp96_ = g_strconcat ("Generating from_variant method for ", _tmp95_, NULL);
		_tmp97_ = _tmp96_;
		binding_generator_INFO (_tmp97_);
		_g_free0 (_tmp97_);
		_tmp98_ = self->priv->output;
		_tmp99_ = binding_generator_get_indent (self, 0);
		_tmp100_ = _tmp99_;
		_tmp101_ = struct_name;
		fprintf (_tmp98_, "\n%spublic static %s from_variant (Variant v) {\n", _tmp100_, _tmp101_);
		_g_free0 (_tmp100_);
		binding_generator_update_indent (self, 1);
		_tmp102_ = self->priv->output;
		_tmp103_ = binding_generator_get_indent (self, 0);
		_tmp104_ = _tmp103_;
		_tmp105_ = struct_name;
		fprintf (_tmp102_, "%sreturn v as %s;\n", _tmp104_, _tmp105_);
		_g_free0 (_tmp104_);
		binding_generator_update_indent (self, -1);
		_tmp106_ = self->priv->output;
		_tmp107_ = binding_generator_get_indent (self, 0);
		_tmp108_ = _tmp107_;
		fprintf (_tmp106_, "%s}\n", _tmp108_);
		_g_free0 (_tmp108_);
	}
	binding_generator_update_indent (self, -1);
	_tmp109_ = self->priv->output;
	_tmp110_ = binding_generator_get_indent (self, 0);
	_tmp111_ = _tmp110_;
	fprintf (_tmp109_, "%s}", _tmp111_);
	_g_free0 (_tmp111_);
	_g_free0 (constructor);
	_g_free0 (ctor_body);
	_g_free0 (ctor_signature);
	_g_free0 (dbus_name);
}


static void binding_generator_generate_struct (BindingGenerator* self, const gchar* name, const gchar* content_signature, const gchar* dbus_namespace, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gint attribute_number;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* signature;
	gchar* tail;
	FILE* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (content_signature != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_tmp0_ = name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = content_signature;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = dbus_namespace;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("Generating struct ", _tmp1_, " w/ signature ", _tmp3_, " in dbus namespace ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	binding_generator_INFO (_tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->output;
	fprintf (_tmp8_, "\n");
	_tmp9_ = self->priv->output;
	_tmp10_ = binding_generator_get_indent (self, 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = name;
	fprintf (_tmp9_, "%spublic struct %s {\n", _tmp11_, _tmp12_);
	_g_free0 (_tmp11_);
	binding_generator_update_indent (self, +1);
	attribute_number = 1;
	_tmp13_ = content_signature;
	_tmp14_ = g_strdup (_tmp13_);
	signature = _tmp14_;
	tail = NULL;
	while (TRUE) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* type;
		FILE* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp15_ = signature;
		if (!(g_strcmp0 (_tmp15_, "") != 0)) {
			break;
		}
		_tmp16_ = signature;
		_tmp17_ = dbus_namespace;
		_tmp19_ = binding_generator_parse_type (self, _tmp16_, &_tmp18_, "", _tmp17_, &_inner_error_);
		_g_free0 (tail);
		tail = _tmp18_;
		type = _tmp19_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (tail);
				_g_free0 (signature);
				return;
			} else {
				_g_free0 (tail);
				_g_free0 (signature);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp20_ = self->priv->output;
		_tmp21_ = binding_generator_get_indent (self, 0);
		_tmp22_ = _tmp21_;
		_tmp23_ = type;
		_tmp24_ = attribute_number;
		fprintf (_tmp20_, "%spublic %s attr%d;\n", _tmp22_, _tmp23_, _tmp24_);
		_g_free0 (_tmp22_);
		_tmp25_ = attribute_number;
		attribute_number = _tmp25_ + 1;
		_tmp26_ = tail;
		_tmp27_ = g_strdup (_tmp26_);
		_g_free0 (signature);
		signature = _tmp27_;
		_g_free0 (type);
	}
	binding_generator_update_indent (self, -1);
	_tmp28_ = self->priv->output;
	_tmp29_ = binding_generator_get_indent (self, 0);
	_tmp30_ = _tmp29_;
	fprintf (_tmp28_, "%s}\n", _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (tail);
	_g_free0 (signature);
}


static void binding_generator_generate_members (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace, Synchrony synchrony, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	{
		xmlNode* _tmp0_;
		xmlNode* _tmp1_;
		xmlNode* iter;
		_tmp0_ = node;
		_tmp1_ = _tmp0_->children;
		iter = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				xmlNode* _tmp6_;
				xmlNode* _tmp7_;
				xmlElementType _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				GQuark _tmp13_ = 0U;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					xmlNode* _tmp4_;
					xmlNode* _tmp5_;
					_tmp4_ = iter;
					_tmp5_ = _tmp4_->next;
					iter = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = iter;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = iter;
				_tmp8_ = _tmp7_->type;
				if (_tmp8_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp9_ = iter;
				_tmp10_ = _tmp9_->name;
				_tmp11_ = _tmp10_;
				_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
				if (_tmp13_ == g_quark_from_string (BINDING_GENERATOR_METHOD_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp14_;
							const gchar* _tmp15_;
							const gchar* _tmp16_;
							Synchrony _tmp17_;
							_tmp14_ = iter;
							_tmp15_ = interface_name;
							_tmp16_ = dbus_namespace;
							_tmp17_ = synchrony;
							binding_generator_generate_method (self, _tmp14_, _tmp15_, _tmp16_, _tmp17_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp13_ == g_quark_from_string (BINDING_GENERATOR_SIGNAL_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp18_;
							const gchar* _tmp19_;
							const gchar* _tmp20_;
							_tmp18_ = iter;
							_tmp19_ = interface_name;
							_tmp20_ = dbus_namespace;
							binding_generator_generate_signal (self, _tmp18_, _tmp19_, _tmp20_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp13_ == g_quark_from_string (BINDING_GENERATOR_PROPERTY_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp21_;
							const gchar* _tmp22_;
							const gchar* _tmp23_;
							_tmp21_ = iter;
							_tmp22_ = interface_name;
							_tmp23_ = dbus_namespace;
							binding_generator_generate_property (self, _tmp21_, _tmp22_, _tmp23_);
							break;
						}
					}
				} else if (_tmp13_ == g_quark_from_string (BINDING_GENERATOR_ERROR_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp24_;
							const gchar* _tmp25_;
							_tmp24_ = iter;
							_tmp25_ = interface_name;
							binding_generator_generate_error (self, _tmp24_, _tmp25_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				}
			}
		}
	}
}


static void binding_generator_generate_method (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace, Synchrony synchrony, GError** error) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* realname;
	xmlNode* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* name;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gint unknown_param_count;
	xmlNode* _tmp17_;
	gint _tmp18_ = 0;
	gint out_param_count;
	gboolean first_param;
	gboolean first_error;
	GString* _tmp19_;
	GString* args_builder;
	GString* _tmp20_;
	GString* throws_builder;
	gchar* _tmp21_;
	gchar* return_value_type;
	gboolean async_method;
	gboolean noreply_method;
	gboolean deprecated_method;
	gchar* _tmp22_;
	gchar* deprecated_method_replaced_by;
	gboolean _tmp125_ = FALSE;
	gboolean _tmp126_;
	gboolean _tmp128_;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp136_;
	gboolean _tmp138_;
	gboolean _tmp145_;
	const gchar* _tmp147_ = NULL;
	gboolean _tmp148_;
	GString* _tmp149_;
	const gchar* _tmp150_;
	Synchrony _tmp151_;
	FILE* _tmp152_;
	gboolean _tmp153_;
	gboolean _tmp162_;
	const gchar* _tmp171_ = NULL;
	gboolean _tmp172_;
	FILE* _tmp173_;
	gchar* _tmp174_ = NULL;
	gchar* _tmp175_;
	const gchar* _tmp176_;
	const gchar* _tmp177_;
	const gchar* _tmp178_;
	GString* _tmp179_;
	const gchar* _tmp180_;
	GString* _tmp181_;
	const gchar* _tmp182_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	realname = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = xmlGetProp (_tmp2_, BINDING_GENERATOR_NAME_ATTRNAME);
	_tmp4_ = _tmp3_;
	_tmp5_ = binding_generator_uncapitalize (self, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = binding_generator_transform_registered_name (self, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	name = _tmp8_;
	_tmp9_ = name;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = realname;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = interface_name;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = g_strconcat ("   Generating method ", _tmp10_, " (originally ", _tmp12_, ") for ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	binding_generator_INFO (_tmp16_);
	_g_free0 (_tmp16_);
	unknown_param_count = 0;
	_tmp17_ = node;
	_tmp18_ = binding_generator_get_out_parameter_count (self, _tmp17_);
	out_param_count = _tmp18_;
	first_param = TRUE;
	first_error = TRUE;
	_tmp19_ = g_string_new ("");
	args_builder = _tmp19_;
	_tmp20_ = g_string_new ("");
	throws_builder = _tmp20_;
	_tmp21_ = g_strdup ("void");
	return_value_type = _tmp21_;
	async_method = FALSE;
	noreply_method = FALSE;
	deprecated_method = FALSE;
	_tmp22_ = g_strdup ("");
	deprecated_method_replaced_by = _tmp22_;
	{
		xmlNode* _tmp23_;
		xmlNode* _tmp24_;
		xmlNode* iter;
		_tmp23_ = node;
		_tmp24_ = _tmp23_->children;
		iter = _tmp24_;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_;
				xmlNode* _tmp29_;
				xmlNode* _tmp30_;
				xmlElementType _tmp31_;
				xmlNode* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				GQuark _tmp36_ = 0U;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					xmlNode* _tmp27_;
					xmlNode* _tmp28_;
					_tmp27_ = iter;
					_tmp28_ = _tmp27_->next;
					iter = _tmp28_;
				}
				_tmp25_ = FALSE;
				_tmp29_ = iter;
				if (!(_tmp29_ != NULL)) {
					break;
				}
				_tmp30_ = iter;
				_tmp31_ = _tmp30_->type;
				if (_tmp31_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp32_ = iter;
				_tmp33_ = _tmp32_->name;
				_tmp34_ = _tmp33_;
				_tmp36_ = (NULL == _tmp34_) ? 0 : g_quark_from_string (_tmp34_);
				if (_tmp36_ == g_quark_from_string (BINDING_GENERATOR_ARG_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp37_;
							gchar* _tmp38_ = NULL;
							gchar* _tmp39_;
							gchar* _tmp40_ = NULL;
							gchar* _tmp41_;
							gchar* param_name;
							gboolean _tmp42_ = FALSE;
							const gchar* _tmp43_;
							gboolean _tmp45_;
							gchar* _tmp49_;
							gchar* param_type;
							xmlNode* _tmp73_;
							gchar* _tmp74_ = NULL;
							gchar* param_dir;
							const gchar* _tmp75_;
							const gchar* _tmp76_;
							GQuark _tmp78_ = 0U;
							_tmp37_ = iter;
							_tmp38_ = xmlGetProp (_tmp37_, BINDING_GENERATOR_NAME_ATTRNAME);
							_tmp39_ = _tmp38_;
							_tmp40_ = binding_generator_transform_registered_name (self, _tmp39_);
							_tmp41_ = _tmp40_;
							_g_free0 (_tmp39_);
							param_name = _tmp41_;
							_tmp43_ = param_name;
							if (_tmp43_ == NULL) {
								_tmp42_ = TRUE;
							} else {
								const gchar* _tmp44_;
								_tmp44_ = param_name;
								_tmp42_ = g_strcmp0 (_tmp44_, "") == 0;
							}
							_tmp45_ = _tmp42_;
							if (_tmp45_) {
								gint _tmp46_;
								gchar* _tmp47_ = NULL;
								gint _tmp48_;
								_tmp46_ = unknown_param_count;
								_tmp47_ = g_strdup_printf ("param%i", _tmp46_);
								_g_free0 (param_name);
								param_name = _tmp47_;
								_tmp48_ = unknown_param_count;
								unknown_param_count = _tmp48_ + 1;
							}
							_tmp49_ = g_strdup ("unknown");
							param_type = _tmp49_;
							{
								xmlNode* _tmp50_;
								gchar* _tmp51_ = NULL;
								gchar* _tmp52_;
								xmlNode* _tmp53_;
								gchar* _tmp54_ = NULL;
								gchar* _tmp55_;
								const gchar* _tmp56_;
								const gchar* _tmp57_;
								gchar* _tmp58_ = NULL;
								gchar* _tmp59_;
								const gchar* _tmp60_;
								gchar* _tmp61_ = NULL;
								gchar* _tmp62_;
								gchar* _tmp63_;
								_tmp50_ = iter;
								_tmp51_ = xmlGetProp (_tmp50_, BINDING_GENERATOR_TYPE_ATTRNAME);
								_tmp52_ = _tmp51_;
								_tmp53_ = iter;
								_tmp54_ = xmlGetNsProp (_tmp53_, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE);
								_tmp55_ = _tmp54_;
								_tmp56_ = interface_name;
								_tmp57_ = param_name;
								_tmp58_ = binding_generator_get_struct_name (self, _tmp56_, _tmp57_);
								_tmp59_ = _tmp58_;
								_tmp60_ = dbus_namespace;
								_tmp61_ = binding_generator_translate_type (self, _tmp52_, _tmp55_, _tmp59_, _tmp60_, &_inner_error_);
								_tmp62_ = _tmp61_;
								_g_free0 (_tmp59_);
								_g_free0 (_tmp55_);
								_g_free0 (_tmp52_);
								_tmp63_ = _tmp62_;
								if (_inner_error_ != NULL) {
									if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
										goto __catch2_generator_error_unknown_dbus_type;
									}
									goto __finally2;
								}
								_g_free0 (param_type);
								param_type = _tmp63_;
							}
							goto __finally2;
							__catch2_generator_error_unknown_dbus_type:
							{
								GError* ex = NULL;
								const gchar* _tmp64_;
								const gchar* _tmp65_ = NULL;
								const gchar* _tmp66_;
								const gchar* _tmp67_ = NULL;
								GError* _tmp68_;
								const gchar* _tmp69_;
								const gchar* _tmp70_ = NULL;
								gchar* _tmp71_ = NULL;
								gchar* _tmp72_;
								ex = _inner_error_;
								_inner_error_ = NULL;
								_tmp64_ = interface_name;
								_tmp65_ = string_to_string (_tmp64_);
								_tmp66_ = name;
								_tmp67_ = string_to_string (_tmp66_);
								_tmp68_ = ex;
								_tmp69_ = _tmp68_->message;
								_tmp70_ = string_to_string (_tmp69_);
								_tmp71_ = g_strconcat ("In interface ", _tmp65_, " method ", _tmp67_, " : Unknown dbus type ", _tmp70_, NULL);
								_tmp72_ = _tmp71_;
								binding_generator_ERROR (_tmp72_);
								_g_free0 (_tmp72_);
								_g_error_free0 (ex);
							}
							__finally2:
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == GENERATOR_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (param_type);
									_g_free0 (param_name);
									_g_free0 (deprecated_method_replaced_by);
									_g_free0 (return_value_type);
									_g_string_free0 (throws_builder);
									_g_string_free0 (args_builder);
									_g_free0 (name);
									_g_free0 (realname);
									return;
								} else {
									_g_free0 (param_type);
									_g_free0 (param_name);
									_g_free0 (deprecated_method_replaced_by);
									_g_free0 (return_value_type);
									_g_string_free0 (throws_builder);
									_g_string_free0 (args_builder);
									_g_free0 (name);
									_g_free0 (realname);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp73_ = iter;
							_tmp74_ = xmlGetProp (_tmp73_, BINDING_GENERATOR_DIRECTION_ATTRNAME);
							param_dir = _tmp74_;
							_tmp75_ = param_dir;
							_tmp76_ = _tmp75_;
							_tmp78_ = (NULL == _tmp76_) ? 0 : g_quark_from_string (_tmp76_);
							if (_tmp78_ == g_quark_from_string (BINDING_GENERATOR_OUT_ATTRVALUE)) {
								switch (0) {
									default:
									{
										const gchar* _tmp79_;
										gint _tmp81_;
										_tmp79_ = param_type;
										if (_tmp79_ == NULL) {
											gchar* _tmp80_;
											_tmp80_ = g_strdup ("void");
											_g_free0 (param_type);
											param_type = _tmp80_;
										}
										_tmp81_ = out_param_count;
										if (_tmp81_ != 1) {
											gboolean _tmp82_;
											GString* _tmp84_;
											GString* _tmp85_;
											const gchar* _tmp86_;
											GString* _tmp87_;
											GString* _tmp88_;
											const gchar* _tmp89_;
											_tmp82_ = first_param;
											if (!_tmp82_) {
												GString* _tmp83_;
												_tmp83_ = args_builder;
												g_string_append (_tmp83_, ", ");
											}
											_tmp84_ = args_builder;
											g_string_append (_tmp84_, "out ");
											_tmp85_ = args_builder;
											_tmp86_ = param_type;
											g_string_append (_tmp85_, _tmp86_);
											_tmp87_ = args_builder;
											g_string_append (_tmp87_, " ");
											_tmp88_ = args_builder;
											_tmp89_ = param_name;
											g_string_append (_tmp88_, _tmp89_);
											first_param = FALSE;
										} else {
											const gchar* _tmp90_;
											gchar* _tmp91_;
											_tmp90_ = param_type;
											_tmp91_ = g_strdup (_tmp90_);
											_g_free0 (return_value_type);
											return_value_type = _tmp91_;
										}
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gboolean _tmp92_;
										GString* _tmp94_;
										const gchar* _tmp95_;
										GString* _tmp96_;
										GString* _tmp97_;
										const gchar* _tmp98_;
										_tmp92_ = first_param;
										if (!_tmp92_) {
											GString* _tmp93_;
											_tmp93_ = args_builder;
											g_string_append (_tmp93_, ", ");
										}
										_tmp94_ = args_builder;
										_tmp95_ = param_type;
										g_string_append (_tmp94_, _tmp95_);
										_tmp96_ = args_builder;
										g_string_append (_tmp96_, " ");
										_tmp97_ = args_builder;
										_tmp98_ = param_name;
										g_string_append (_tmp97_, _tmp98_);
										first_param = FALSE;
										break;
									}
								}
							}
							_g_free0 (param_dir);
							_g_free0 (param_type);
							_g_free0 (param_name);
							break;
						}
					}
				} else if (_tmp36_ == g_quark_from_string (BINDING_GENERATOR_THROWS_ELTNAME)) {
					switch (0) {
						default:
						{
							gchar* errordomain_name;
							xmlNode* _tmp99_;
							gchar* _tmp100_ = NULL;
							gchar* fso_type;
							const gchar* _tmp101_;
							const gchar* _tmp105_;
							gboolean _tmp115_;
							GString* _tmp117_;
							const gchar* _tmp118_;
							errordomain_name = NULL;
							_tmp99_ = iter;
							_tmp100_ = xmlGetProp (_tmp99_, BINDING_GENERATOR_TYPE_ATTRNAME);
							fso_type = _tmp100_;
							_tmp101_ = fso_type;
							if (_tmp101_ != NULL) {
								GeeMap* _tmp102_;
								const gchar* _tmp103_;
								gpointer _tmp104_ = NULL;
								_tmp102_ = self->priv->error_name_index;
								_tmp103_ = fso_type;
								_tmp104_ = gee_map_get (_tmp102_, _tmp103_);
								_g_free0 (errordomain_name);
								errordomain_name = (gchar*) _tmp104_;
							}
							_tmp105_ = errordomain_name;
							if (_tmp105_ == NULL) {
								const gchar* _tmp106_;
								const gchar* _tmp107_ = NULL;
								const gchar* _tmp108_;
								const gchar* _tmp109_ = NULL;
								const gchar* _tmp110_;
								const gchar* _tmp111_ = NULL;
								gchar* _tmp112_ = NULL;
								gchar* _tmp113_;
								gchar* _tmp114_;
								_tmp106_ = interface_name;
								_tmp107_ = string_to_string (_tmp106_);
								_tmp108_ = name;
								_tmp109_ = string_to_string (_tmp108_);
								_tmp110_ = fso_type;
								_tmp111_ = string_to_string (_tmp110_);
								_tmp112_ = g_strconcat ("In interface ", _tmp107_, " method ", _tmp109_, " : Unknown dbus error ", _tmp111_, NULL);
								_tmp113_ = _tmp112_;
								binding_generator_ERROR (_tmp113_);
								_g_free0 (_tmp113_);
								_tmp114_ = g_strdup ("<unknown>");
								_g_free0 (errordomain_name);
								errordomain_name = _tmp114_;
							}
							_tmp115_ = first_error;
							if (!_tmp115_) {
								GString* _tmp116_;
								_tmp116_ = throws_builder;
								g_string_append (_tmp116_, ", ");
							}
							_tmp117_ = throws_builder;
							_tmp118_ = errordomain_name;
							g_string_append (_tmp117_, _tmp118_);
							first_error = FALSE;
							_g_free0 (fso_type);
							_g_free0 (errordomain_name);
							break;
						}
					}
				} else if (_tmp36_ == g_quark_from_string (BINDING_GENERATOR_ANNOTATION_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp119_;
							gchar* _tmp120_ = NULL;
							gchar* annotation_name;
							const gchar* _tmp121_;
							const gchar* _tmp122_;
							_tmp119_ = iter;
							_tmp120_ = xmlGetProp (_tmp119_, BINDING_GENERATOR_NAME_ATTRNAME);
							annotation_name = _tmp120_;
							_tmp121_ = annotation_name;
							if (g_strcmp0 (_tmp121_, "org.freedesktop.DBus.GLib.Async") == 0) {
								async_method = TRUE;
							}
							_tmp122_ = annotation_name;
							if (g_strcmp0 (_tmp122_, "org.freedesktop.DBus.GLib.NoReply") == 0) {
								noreply_method = TRUE;
							}
							_g_free0 (annotation_name);
							break;
						}
					}
				} else if (_tmp36_ == g_quark_from_string (BINDING_GENERATOR_DEPRECATED_ELTNAME)) {
					switch (0) {
						default:
						{
							xmlNode* _tmp123_;
							gchar* _tmp124_ = NULL;
							deprecated_method = TRUE;
							_tmp123_ = iter;
							_tmp124_ = xmlGetProp (_tmp123_, BINDING_GENERATOR_REPLACED_BY_ATTRNAME);
							_g_free0 (deprecated_method_replaced_by);
							deprecated_method_replaced_by = _tmp124_;
							break;
						}
					}
				}
			}
		}
	}
	_tmp126_ = async_method;
	if (_tmp126_) {
		gboolean _tmp127_;
		_tmp127_ = noreply_method;
		_tmp125_ = _tmp127_;
	} else {
		_tmp125_ = FALSE;
	}
	_tmp128_ = _tmp125_;
	if (_tmp128_) {
		const gchar* _tmp129_;
		const gchar* _tmp130_ = NULL;
		const gchar* _tmp131_;
		const gchar* _tmp132_ = NULL;
		gchar* _tmp133_ = NULL;
		gchar* _tmp134_;
		_tmp129_ = interface_name;
		_tmp130_ = string_to_string (_tmp129_);
		_tmp131_ = name;
		_tmp132_ = string_to_string (_tmp131_);
		_tmp133_ = g_strconcat ("In interface ", _tmp130_, " method ", _tmp132_, " : Requested both async and noreply; which is not supported by Vala. W" \
"ill force sync.", NULL);
		_tmp134_ = _tmp133_;
		binding_generator_WARN (_tmp134_);
		_g_free0 (_tmp134_);
		async_method = FALSE;
	}
	_tmp136_ = noreply_method;
	if (_tmp136_) {
		gint _tmp137_;
		_tmp137_ = out_param_count;
		_tmp135_ = _tmp137_ > 0;
	} else {
		_tmp135_ = FALSE;
	}
	_tmp138_ = _tmp135_;
	if (_tmp138_) {
		const gchar* _tmp139_;
		const gchar* _tmp140_ = NULL;
		const gchar* _tmp141_;
		const gchar* _tmp142_ = NULL;
		gchar* _tmp143_ = NULL;
		gchar* _tmp144_;
		_tmp139_ = interface_name;
		_tmp140_ = string_to_string (_tmp139_);
		_tmp141_ = name;
		_tmp142_ = string_to_string (_tmp141_);
		_tmp143_ = g_strconcat ("In interface ", _tmp140_, " method ", _tmp142_, " : noreply methods are not allowed to have out parameters!", NULL);
		_tmp144_ = _tmp143_;
		binding_generator_ERROR (_tmp144_);
		_g_free0 (_tmp144_);
	}
	_tmp145_ = first_error;
	if (!_tmp145_) {
		GString* _tmp146_;
		_tmp146_ = throws_builder;
		g_string_append (_tmp146_, ", ");
	}
	_tmp148_ = binding_generator_gdbus;
	if (_tmp148_) {
		_tmp147_ = "DBusError, IOError";
	} else {
		_tmp147_ = "DBus.Error";
	}
	_tmp149_ = throws_builder;
	_tmp150_ = _tmp147_;
	g_string_append (_tmp149_, _tmp150_);
	_tmp151_ = synchrony;
	switch (_tmp151_) {
		case SYNCHRONY_FORCE_SYNC:
		{
			async_method = FALSE;
			break;
		}
		case SYNCHRONY_FORCE_ASYNC:
		{
			async_method = TRUE;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp152_ = self->priv->output;
	fprintf (_tmp152_, "\n");
	_tmp153_ = noreply_method;
	if (_tmp153_) {
		FILE* _tmp154_;
		gchar* _tmp155_ = NULL;
		gchar* _tmp156_;
		const gchar* _tmp157_;
		_tmp154_ = self->priv->output;
		_tmp155_ = binding_generator_get_indent (self, 0);
		_tmp156_ = _tmp155_;
		_tmp157_ = realname;
		fprintf (_tmp154_, "%s[DBus (name = \"%s\", no_reply = true)]\n", _tmp156_, _tmp157_);
		_g_free0 (_tmp156_);
	} else {
		FILE* _tmp158_;
		gchar* _tmp159_ = NULL;
		gchar* _tmp160_;
		const gchar* _tmp161_;
		_tmp158_ = self->priv->output;
		_tmp159_ = binding_generator_get_indent (self, 0);
		_tmp160_ = _tmp159_;
		_tmp161_ = realname;
		fprintf (_tmp158_, "%s[DBus (name = \"%s\")]\n", _tmp160_, _tmp161_);
		_g_free0 (_tmp160_);
	}
	_tmp162_ = deprecated_method;
	if (_tmp162_) {
		const gchar* _tmp163_;
		gint _tmp164_;
		gint _tmp165_;
		_tmp163_ = deprecated_method_replaced_by;
		_tmp164_ = strlen (_tmp163_);
		_tmp165_ = _tmp164_;
		if (_tmp165_ == 0) {
			FILE* _tmp166_;
			_tmp166_ = self->priv->output;
			fprintf (_tmp166_, "[Deprecated]\n");
		} else {
			FILE* _tmp167_;
			const gchar* _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			_tmp167_ = self->priv->output;
			_tmp168_ = deprecated_method_replaced_by;
			_tmp169_ = g_strdup_printf ("[Deprecated (replacement = \"%s\")]", _tmp168_);
			_tmp170_ = _tmp169_;
			fprintf (_tmp167_, "%s", _tmp170_);
			_g_free0 (_tmp170_);
		}
	}
	_tmp172_ = async_method;
	if (_tmp172_) {
		_tmp171_ = " async";
	} else {
		_tmp171_ = "";
	}
	_tmp173_ = self->priv->output;
	_tmp174_ = binding_generator_get_indent (self, 0);
	_tmp175_ = _tmp174_;
	_tmp176_ = _tmp171_;
	_tmp177_ = return_value_type;
	_tmp178_ = name;
	_tmp179_ = args_builder;
	_tmp180_ = _tmp179_->str;
	_tmp181_ = throws_builder;
	_tmp182_ = _tmp181_->str;
	fprintf (_tmp173_, "%spublic abstract%s %s %s(%s) throws %s;\n", _tmp175_, _tmp176_, _tmp177_, _tmp178_, _tmp180_, _tmp182_);
	_g_free0 (_tmp175_);
	_g_free0 (deprecated_method_replaced_by);
	_g_free0 (return_value_type);
	_g_string_free0 (throws_builder);
	_g_string_free0 (args_builder);
	_g_free0 (name);
	_g_free0 (realname);
}


static gint binding_generator_get_out_parameter_count (BindingGenerator* self, xmlNode* node) {
	gint result = 0;
	gint out_param_count;
	g_return_val_if_fail (self != NULL, 0);
	out_param_count = 0;
	{
		xmlNode* _tmp0_;
		xmlNode* _tmp1_;
		xmlNode* iter;
		_tmp0_ = node;
		_tmp1_ = _tmp0_->children;
		iter = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				xmlNode* _tmp6_;
				xmlNode* _tmp7_;
				xmlElementType _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				xmlNode* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gboolean _tmp14_;
				gint _tmp15_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					xmlNode* _tmp4_;
					xmlNode* _tmp5_;
					_tmp4_ = iter;
					_tmp5_ = _tmp4_->next;
					iter = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = iter;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = iter;
				_tmp8_ = _tmp7_->type;
				if (_tmp8_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp9_ = iter;
				_tmp10_ = _tmp9_->name;
				if (g_strcmp0 (_tmp10_, BINDING_GENERATOR_ARG_ELTNAME) != 0) {
					continue;
				}
				_tmp11_ = iter;
				_tmp12_ = xmlGetProp (_tmp11_, BINDING_GENERATOR_DIRECTION_ATTRNAME);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strcmp0 (_tmp13_, BINDING_GENERATOR_OUT_ATTRVALUE) != 0;
				_g_free0 (_tmp13_);
				if (_tmp14_) {
					continue;
				}
				_tmp15_ = out_param_count;
				out_param_count = _tmp15_ + 1;
			}
		}
	}
	result = out_param_count;
	return result;
}


static void binding_generator_generate_signal (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace, GError** error) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* realname;
	xmlNode* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* name;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gint unknown_param_count;
	gboolean first_param;
	GString* _tmp17_;
	GString* args_builder;
	FILE* _tmp74_;
	FILE* _tmp75_;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_;
	const gchar* _tmp78_;
	FILE* _tmp79_;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_;
	const gchar* _tmp82_;
	GString* _tmp83_;
	const gchar* _tmp84_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	realname = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = xmlGetProp (_tmp2_, BINDING_GENERATOR_NAME_ATTRNAME);
	_tmp4_ = _tmp3_;
	_tmp5_ = binding_generator_uncapitalize (self, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = binding_generator_transform_registered_name (self, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	name = _tmp8_;
	_tmp9_ = name;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = realname;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = interface_name;
	_tmp14_ = string_to_string (_tmp13_);
	_tmp15_ = g_strconcat ("   Generating signal ", _tmp10_, " (originally ", _tmp12_, ") for ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	binding_generator_INFO (_tmp16_);
	_g_free0 (_tmp16_);
	unknown_param_count = 0;
	first_param = TRUE;
	_tmp17_ = g_string_new ("");
	args_builder = _tmp17_;
	{
		xmlNode* _tmp18_;
		xmlNode* _tmp19_;
		xmlNode* iter;
		_tmp18_ = node;
		_tmp19_ = _tmp18_->children;
		iter = _tmp19_;
		{
			gboolean _tmp20_;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_;
				xmlNode* _tmp24_;
				xmlNode* _tmp25_;
				xmlElementType _tmp26_;
				xmlNode* _tmp27_;
				const gchar* _tmp28_;
				xmlNode* _tmp29_;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_;
				gchar* param_name;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp35_;
				gboolean _tmp37_;
				gchar* _tmp41_;
				gchar* param_type;
				gboolean _tmp67_;
				GString* _tmp69_;
				const gchar* _tmp70_;
				GString* _tmp71_;
				GString* _tmp72_;
				const gchar* _tmp73_;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					xmlNode* _tmp22_;
					xmlNode* _tmp23_;
					_tmp22_ = iter;
					_tmp23_ = _tmp22_->next;
					iter = _tmp23_;
				}
				_tmp20_ = FALSE;
				_tmp24_ = iter;
				if (!(_tmp24_ != NULL)) {
					break;
				}
				_tmp25_ = iter;
				_tmp26_ = _tmp25_->type;
				if (_tmp26_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp27_ = iter;
				_tmp28_ = _tmp27_->name;
				if (g_strcmp0 (_tmp28_, BINDING_GENERATOR_ARG_ELTNAME) != 0) {
					continue;
				}
				_tmp29_ = iter;
				_tmp30_ = xmlGetProp (_tmp29_, BINDING_GENERATOR_NAME_ATTRNAME);
				_tmp31_ = _tmp30_;
				_tmp32_ = binding_generator_transform_registered_name (self, _tmp31_);
				_tmp33_ = _tmp32_;
				_g_free0 (_tmp31_);
				param_name = _tmp33_;
				_tmp35_ = param_name;
				if (_tmp35_ == NULL) {
					_tmp34_ = TRUE;
				} else {
					const gchar* _tmp36_;
					_tmp36_ = param_name;
					_tmp34_ = g_strcmp0 (_tmp36_, "") == 0;
				}
				_tmp37_ = _tmp34_;
				if (_tmp37_) {
					gint _tmp38_;
					gchar* _tmp39_ = NULL;
					gint _tmp40_;
					_tmp38_ = unknown_param_count;
					_tmp39_ = g_strdup_printf ("param%i", _tmp38_);
					_g_free0 (param_name);
					param_name = _tmp39_;
					_tmp40_ = unknown_param_count;
					unknown_param_count = _tmp40_ + 1;
				}
				_tmp41_ = g_strdup ("unknown");
				param_type = _tmp41_;
				{
					xmlNode* _tmp42_;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_;
					xmlNode* _tmp45_;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					const gchar* _tmp54_;
					gchar* _tmp55_ = NULL;
					gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp42_ = iter;
					_tmp43_ = xmlGetProp (_tmp42_, BINDING_GENERATOR_TYPE_ATTRNAME);
					_tmp44_ = _tmp43_;
					_tmp45_ = iter;
					_tmp46_ = xmlGetNsProp (_tmp45_, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE);
					_tmp47_ = _tmp46_;
					_tmp48_ = interface_name;
					_tmp49_ = param_name;
					_tmp50_ = binding_generator_capitalize (self, _tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
					_tmp53_ = _tmp52_;
					_tmp54_ = dbus_namespace;
					_tmp55_ = binding_generator_translate_type (self, _tmp44_, _tmp47_, _tmp53_, _tmp54_, &_inner_error_);
					_tmp56_ = _tmp55_;
					_g_free0 (_tmp53_);
					_g_free0 (_tmp51_);
					_g_free0 (_tmp47_);
					_g_free0 (_tmp44_);
					_tmp57_ = _tmp56_;
					if (_inner_error_ != NULL) {
						if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
							goto __catch3_generator_error_unknown_dbus_type;
						}
						goto __finally3;
					}
					_g_free0 (param_type);
					param_type = _tmp57_;
				}
				goto __finally3;
				__catch3_generator_error_unknown_dbus_type:
				{
					GError* ex = NULL;
					const gchar* _tmp58_;
					const gchar* _tmp59_ = NULL;
					const gchar* _tmp60_;
					const gchar* _tmp61_ = NULL;
					GError* _tmp62_;
					const gchar* _tmp63_;
					const gchar* _tmp64_ = NULL;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					ex = _inner_error_;
					_inner_error_ = NULL;
					_tmp58_ = interface_name;
					_tmp59_ = string_to_string (_tmp58_);
					_tmp60_ = name;
					_tmp61_ = string_to_string (_tmp60_);
					_tmp62_ = ex;
					_tmp63_ = _tmp62_->message;
					_tmp64_ = string_to_string (_tmp63_);
					_tmp65_ = g_strconcat ("In interface ", _tmp59_, " signal ", _tmp61_, " : Unknown dbus type ", _tmp64_, NULL);
					_tmp66_ = _tmp65_;
					binding_generator_ERROR (_tmp66_);
					_g_free0 (_tmp66_);
					_g_error_free0 (ex);
				}
				__finally3:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GENERATOR_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (param_type);
						_g_free0 (param_name);
						_g_string_free0 (args_builder);
						_g_free0 (name);
						_g_free0 (realname);
						return;
					} else {
						_g_free0 (param_type);
						_g_free0 (param_name);
						_g_string_free0 (args_builder);
						_g_free0 (name);
						_g_free0 (realname);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp67_ = first_param;
				if (!_tmp67_) {
					GString* _tmp68_;
					_tmp68_ = args_builder;
					g_string_append (_tmp68_, ", ");
				}
				_tmp69_ = args_builder;
				_tmp70_ = param_type;
				g_string_append (_tmp69_, _tmp70_);
				_tmp71_ = args_builder;
				g_string_append (_tmp71_, " ");
				_tmp72_ = args_builder;
				_tmp73_ = param_name;
				g_string_append (_tmp72_, _tmp73_);
				first_param = FALSE;
				_g_free0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	_tmp74_ = self->priv->output;
	fprintf (_tmp74_, "\n");
	_tmp75_ = self->priv->output;
	_tmp76_ = binding_generator_get_indent (self, 0);
	_tmp77_ = _tmp76_;
	_tmp78_ = realname;
	fprintf (_tmp75_, "%s[DBus (name = \"%s\")]\n", _tmp77_, _tmp78_);
	_g_free0 (_tmp77_);
	_tmp79_ = self->priv->output;
	_tmp80_ = binding_generator_get_indent (self, 0);
	_tmp81_ = _tmp80_;
	_tmp82_ = name;
	_tmp83_ = args_builder;
	_tmp84_ = _tmp83_->str;
	fprintf (_tmp79_, "%spublic signal void %s(%s);\n", _tmp81_, _tmp82_, _tmp84_);
	_g_free0 (_tmp81_);
	_g_string_free0 (args_builder);
	_g_free0 (name);
	_g_free0 (realname);
}


static void binding_generator_generate_property (BindingGenerator* self, xmlNode* node, const gchar* interface_name, const gchar* dbus_namespace) {
	xmlNode* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* realname;
	xmlNode* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* name;
	gchar* _tmp9_;
	gchar* typename;
	gchar* _tmp10_;
	gchar* rawtype;
	gchar* _tmp34_;
	gchar* accesstype;
	xmlNode* _tmp35_;
	xmlAttr* _tmp36_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_;
	const gchar* _tmp58_ = NULL;
	const gchar* _tmp59_;
	gboolean _tmp60_ = FALSE;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* owned_specifier;
	gchar* _tmp63_ = NULL;
	const gchar* _tmp64_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* accessimpl;
	FILE* _tmp73_;
	FILE* _tmp74_;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_;
	FILE* _tmp77_;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_tmp0_ = node;
	_tmp1_ = xmlGetProp (_tmp0_, BINDING_GENERATOR_NAME_ATTRNAME);
	realname = _tmp1_;
	_tmp2_ = node;
	_tmp3_ = xmlGetProp (_tmp2_, BINDING_GENERATOR_NAME_ATTRNAME);
	_tmp4_ = _tmp3_;
	_tmp5_ = binding_generator_uncapitalize (self, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = binding_generator_transform_registered_name (self, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	name = _tmp8_;
	_tmp9_ = g_strdup ("unknown");
	typename = _tmp9_;
	_tmp10_ = g_strdup ("");
	rawtype = _tmp10_;
	{
		xmlNode* _tmp11_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		xmlNode* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp11_ = node;
		_tmp12_ = xmlGetProp (_tmp11_, BINDING_GENERATOR_TYPE_ATTRNAME);
		_g_free0 (rawtype);
		rawtype = _tmp12_;
		_tmp13_ = rawtype;
		_tmp14_ = node;
		_tmp15_ = xmlGetNsProp (_tmp14_, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE);
		_tmp16_ = _tmp15_;
		_tmp17_ = interface_name;
		_tmp18_ = binding_generator_capitalize (self, name);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = dbus_namespace;
		_tmp23_ = binding_generator_translate_type (self, _tmp13_, _tmp16_, _tmp21_, _tmp22_, &_inner_error_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
		_tmp25_ = _tmp24_;
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
				goto __catch4_generator_error_unknown_dbus_type;
			}
			goto __finally4;
		}
		_g_free0 (typename);
		typename = _tmp25_;
	}
	goto __finally4;
	__catch4_generator_error_unknown_dbus_type:
	{
		GError* ex = NULL;
		const gchar* _tmp26_;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		ex = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = interface_name;
		_tmp27_ = string_to_string (_tmp26_);
		_tmp28_ = string_to_string (name);
		_tmp29_ = ex;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat ("In interface ", _tmp27_, " property ", _tmp28_, " : Unknown dbus type ", _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		binding_generator_ERROR (_tmp33_);
		_g_free0 (_tmp33_);
		_g_error_free0 (ex);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (rawtype);
		_g_free0 (typename);
		_g_free0 (name);
		_g_free0 (realname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp34_ = g_strdup ("readwrite");
	accesstype = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = xmlHasProp (_tmp35_, "access");
	if (_tmp36_ != NULL) {
		xmlNode* _tmp37_;
		gchar* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		const gchar* _tmp40_;
		gboolean _tmp42_;
		_tmp37_ = node;
		_tmp38_ = xmlGetProp (_tmp37_, "access");
		_g_free0 (accesstype);
		accesstype = _tmp38_;
		_tmp40_ = accesstype;
		if (g_strcmp0 (_tmp40_, "readwrite") != 0) {
			const gchar* _tmp41_;
			_tmp41_ = accesstype;
			_tmp39_ = g_strcmp0 (_tmp41_, "readonly") != 0;
		} else {
			_tmp39_ = FALSE;
		}
		_tmp42_ = _tmp39_;
		if (_tmp42_) {
			const gchar* _tmp43_;
			const gchar* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			const gchar* _tmp46_;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_;
			_tmp43_ = interface_name;
			_tmp44_ = string_to_string (_tmp43_);
			_tmp45_ = string_to_string (name);
			_tmp46_ = accesstype;
			_tmp47_ = string_to_string (_tmp46_);
			_tmp48_ = g_strconcat ("In interface ", _tmp44_, " property ", _tmp45_, " : Unknown access type: ", _tmp47_, NULL);
			_tmp49_ = _tmp48_;
			binding_generator_ERROR (_tmp49_);
			_g_free0 (_tmp49_);
		}
	}
	_tmp50_ = string_to_string (name);
	_tmp51_ = string_to_string (realname);
	_tmp52_ = typename;
	_tmp53_ = string_to_string (_tmp52_);
	_tmp54_ = interface_name;
	_tmp55_ = string_to_string (_tmp54_);
	_tmp56_ = g_strconcat ("   Generating property ", _tmp50_, " (originally ", _tmp51_, ") of type ", _tmp53_, " for ", _tmp55_, NULL);
	_tmp57_ = _tmp56_;
	binding_generator_INFO (_tmp57_);
	_g_free0 (_tmp57_);
	_tmp59_ = rawtype;
	_tmp60_ = binding_generator_is_simple_type (self, _tmp59_);
	if (_tmp60_) {
		_tmp58_ = "";
	} else {
		_tmp58_ = "owned";
	}
	_tmp61_ = _tmp58_;
	_tmp62_ = g_strdup (_tmp61_);
	owned_specifier = _tmp62_;
	_tmp64_ = accesstype;
	if (g_strcmp0 (_tmp64_, "readonly") == 0) {
		const gchar* _tmp65_;
		const gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		_tmp65_ = owned_specifier;
		_tmp66_ = string_to_string (_tmp65_);
		_tmp67_ = g_strconcat (_tmp66_, " get;", NULL);
		_g_free0 (_tmp63_);
		_tmp63_ = _tmp67_;
	} else {
		const gchar* _tmp68_;
		const gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		_tmp68_ = owned_specifier;
		_tmp69_ = string_to_string (_tmp68_);
		_tmp70_ = g_strconcat (_tmp69_, " get; set;", NULL);
		_g_free0 (_tmp63_);
		_tmp63_ = _tmp70_;
	}
	_tmp71_ = _tmp63_;
	_tmp72_ = g_strdup (_tmp71_);
	accessimpl = _tmp72_;
	_tmp73_ = self->priv->output;
	fprintf (_tmp73_, "\n");
	_tmp74_ = self->priv->output;
	_tmp75_ = binding_generator_get_indent (self, 0);
	_tmp76_ = _tmp75_;
	fprintf (_tmp74_, "%s[DBus (name = \"%s\")]\n", _tmp76_, realname);
	_g_free0 (_tmp76_);
	_tmp77_ = self->priv->output;
	_tmp78_ = binding_generator_get_indent (self, 0);
	_tmp79_ = _tmp78_;
	_tmp80_ = typename;
	_tmp81_ = accessimpl;
	fprintf (_tmp77_, "%spublic abstract %s %s { %s }\n", _tmp79_, _tmp80_, name, _tmp81_);
	_g_free0 (_tmp79_);
	_g_free0 (accessimpl);
	_g_free0 (_tmp63_);
	_g_free0 (owned_specifier);
	_g_free0 (accesstype);
	_g_free0 (rawtype);
	_g_free0 (typename);
	_g_free0 (name);
	_g_free0 (realname);
}


static void binding_generator_generate_error (BindingGenerator* self, xmlNode* node, const gchar* interface_name, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
}


static void binding_generator_generate_proxy_getter (BindingGenerator* self, xmlNode* node, gchar* interface_name, Synchrony synchrony, GError** error) {
	gboolean async_method;
	Synchrony _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	async_method = TRUE;
	_tmp0_ = synchrony;
	switch (_tmp0_) {
		case SYNCHRONY_FORCE_SYNC:
		{
			async_method = FALSE;
			break;
		}
		case SYNCHRONY_FORCE_ASYNC:
		{
			async_method = TRUE;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp1_ = async_method;
	if (!_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = interface_name;
		_tmp3_ = g_strconcat (_tmp2_, "Sync", NULL);
		_g_free0 (interface_name);
		interface_name = _tmp3_;
	}
	_tmp4_ = binding_generator_gdbus;
	if (!_tmp4_) {
		FILE* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		FILE* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		FILE* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		_tmp5_ = self->priv->output;
		_tmp6_ = binding_generator_get_indent (self, 0);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = interface_name;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = interface_name;
		_tmp12_ = binding_generator_uncapitalize (self, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("\n", _tmp8_, "public ", _tmp10_, " get_", _tmp14_, "_proxy(DBus.Connection con, string busname, DBus.ObjectPath path) {", NULL);
		_tmp16_ = _tmp15_;
		fprintf (_tmp5_, "%s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp7_);
		binding_generator_update_indent (self, +1);
		_tmp17_ = self->priv->output;
		_tmp18_ = binding_generator_get_indent (self, 0);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = interface_name;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("\n", _tmp20_, "return con.get_object(busname, path) as ", _tmp22_, ";", NULL);
		_tmp24_ = _tmp23_;
		fprintf (_tmp17_, "%s", _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp19_);
		binding_generator_update_indent (self, -1);
		_tmp25_ = self->priv->output;
		_tmp26_ = binding_generator_get_indent (self, 0);
		_tmp27_ = _tmp26_;
		_tmp28_ = string_to_string (_tmp27_);
		_tmp29_ = g_strconcat ("\n", _tmp28_, "}", NULL);
		_tmp30_ = _tmp29_;
		fprintf (_tmp25_, "%s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp27_);
	}
	_g_free0 (interface_name);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* binding_generator_translate_type (BindingGenerator* self, const gchar* type, const gchar* fso_type, const gchar* type_name, const gchar* dbus_namespace, GError** error) {
	gchar* result = NULL;
	gchar* tail;
	const gchar* _tmp0_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (dbus_namespace != NULL, NULL);
	tail = NULL;
	_tmp0_ = fso_type;
	if (_tmp0_ != NULL) {
		GeeMap* _tmp1_;
		const gchar* _tmp2_;
		gpointer _tmp3_ = NULL;
		gchar* vala_type;
		const gchar* _tmp4_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = self->priv->name_index;
		_tmp2_ = fso_type;
		_tmp3_ = gee_map_get (_tmp1_, _tmp2_);
		vala_type = (gchar*) _tmp3_;
		_tmp4_ = vala_type;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			GError* _tmp6_;
			_tmp5_ = fso_type;
			_tmp6_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE, _tmp5_);
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (vala_type);
				_g_free0 (tail);
				return NULL;
			} else {
				_g_free0 (vala_type);
				_g_free0 (tail);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp8_ = type;
		_tmp9_ = g_str_has_prefix (_tmp8_, "a");
		if (_tmp9_) {
			_tmp7_ = "[]";
		} else {
			_tmp7_ = "";
		}
		_tmp10_ = vala_type;
		_tmp11_ = _tmp7_;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		result = _tmp12_;
		_g_free0 (vala_type);
		_g_free0 (tail);
		return result;
	}
	_tmp13_ = type;
	_tmp14_ = type_name;
	_tmp15_ = dbus_namespace;
	_tmp17_ = binding_generator_parse_type (self, _tmp13_, &_tmp16_, _tmp14_, _tmp15_, &_inner_error_);
	_g_free0 (tail);
	tail = _tmp16_;
	_tmp18_ = _tmp17_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (tail);
			return NULL;
		} else {
			_g_free0 (tail);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = _tmp18_;
	_tmp20_ = string_replace (_tmp19_, "][", ",");
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	result = _tmp21_;
	_g_free0 (tail);
	return result;
}


static gboolean binding_generator_is_simple_type (BindingGenerator* self, const gchar* type) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((((((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("b")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("i"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("n"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("q"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("t"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("u"))))) || (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("x"))))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("d"))))) {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}


static gchar* binding_generator_parse_type (BindingGenerator* self, const gchar* type, gchar** tail, const gchar* type_name, const gchar* dbus_namespace, GError** error) {
	gchar* _vala_tail = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp130_;
	const gchar* _tmp131_ = NULL;
	gchar* _tmp132_ = NULL;
	gchar* _tmp133_;
	GError* _tmp134_;
	GError* _tmp135_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (dbus_namespace != NULL, NULL);
	_tmp0_ = type;
	_tmp1_ = string_substring (_tmp0_, (glong) 1, (glong) (-1));
	_g_free0 (_vala_tail);
	_vala_tail = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = g_str_has_prefix (_tmp2_, "y");
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("uint8");
		result = _tmp4_;
		if (tail) {
			*tail = _vala_tail;
		} else {
			_g_free0 (_vala_tail);
		}
		return result;
	} else {
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = type;
		_tmp6_ = g_str_has_prefix (_tmp5_, "b");
		if (_tmp6_) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("bool");
			result = _tmp7_;
			if (tail) {
				*tail = _vala_tail;
			} else {
				_g_free0 (_vala_tail);
			}
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp13_;
			_tmp9_ = type;
			_tmp10_ = g_str_has_prefix (_tmp9_, "n");
			if (_tmp10_) {
				_tmp8_ = TRUE;
			} else {
				const gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				_tmp11_ = type;
				_tmp12_ = g_str_has_prefix (_tmp11_, "i");
				_tmp8_ = _tmp12_;
			}
			_tmp13_ = _tmp8_;
			if (_tmp13_) {
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("int");
				result = _tmp14_;
				if (tail) {
					*tail = _vala_tail;
				} else {
					_g_free0 (_vala_tail);
				}
				return result;
			} else {
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp16_;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp20_;
				_tmp16_ = type;
				_tmp17_ = g_str_has_prefix (_tmp16_, "q");
				if (_tmp17_) {
					_tmp15_ = TRUE;
				} else {
					const gchar* _tmp18_;
					gboolean _tmp19_ = FALSE;
					_tmp18_ = type;
					_tmp19_ = g_str_has_prefix (_tmp18_, "u");
					_tmp15_ = _tmp19_;
				}
				_tmp20_ = _tmp15_;
				if (_tmp20_) {
					gchar* _tmp21_;
					_tmp21_ = g_strdup ("uint");
					result = _tmp21_;
					if (tail) {
						*tail = _vala_tail;
					} else {
						_g_free0 (_vala_tail);
					}
					return result;
				} else {
					const gchar* _tmp22_;
					gboolean _tmp23_ = FALSE;
					_tmp22_ = type;
					_tmp23_ = g_str_has_prefix (_tmp22_, "x");
					if (_tmp23_) {
						gchar* _tmp24_;
						_tmp24_ = g_strdup ("int64");
						result = _tmp24_;
						if (tail) {
							*tail = _vala_tail;
						} else {
							_g_free0 (_vala_tail);
						}
						return result;
					} else {
						const gchar* _tmp25_;
						gboolean _tmp26_ = FALSE;
						_tmp25_ = type;
						_tmp26_ = g_str_has_prefix (_tmp25_, "t");
						if (_tmp26_) {
							gchar* _tmp27_;
							_tmp27_ = g_strdup ("uint64");
							result = _tmp27_;
							if (tail) {
								*tail = _vala_tail;
							} else {
								_g_free0 (_vala_tail);
							}
							return result;
						} else {
							const gchar* _tmp28_;
							gboolean _tmp29_ = FALSE;
							_tmp28_ = type;
							_tmp29_ = g_str_has_prefix (_tmp28_, "d");
							if (_tmp29_) {
								gchar* _tmp30_;
								_tmp30_ = g_strdup ("double");
								result = _tmp30_;
								if (tail) {
									*tail = _vala_tail;
								} else {
									_g_free0 (_vala_tail);
								}
								return result;
							} else {
								const gchar* _tmp31_;
								gboolean _tmp32_ = FALSE;
								_tmp31_ = type;
								_tmp32_ = g_str_has_prefix (_tmp31_, "s");
								if (_tmp32_) {
									gchar* _tmp33_;
									_tmp33_ = g_strdup ("string");
									result = _tmp33_;
									if (tail) {
										*tail = _vala_tail;
									} else {
										_g_free0 (_vala_tail);
									}
									return result;
								} else {
									const gchar* _tmp34_;
									gboolean _tmp35_ = FALSE;
									_tmp34_ = type;
									_tmp35_ = g_str_has_prefix (_tmp34_, "o");
									if (_tmp35_) {
										const gchar* _tmp36_ = NULL;
										gboolean _tmp37_;
										const gchar* _tmp38_;
										gchar* _tmp39_;
										_tmp37_ = binding_generator_gdbus;
										if (_tmp37_) {
											_tmp36_ = "GLib.ObjectPath";
										} else {
											_tmp36_ = "DBus.ObjectPath";
										}
										_tmp38_ = _tmp36_;
										_tmp39_ = g_strdup (_tmp38_);
										result = _tmp39_;
										if (tail) {
											*tail = _vala_tail;
										} else {
											_g_free0 (_vala_tail);
										}
										return result;
									} else {
										const gchar* _tmp40_;
										gboolean _tmp41_ = FALSE;
										_tmp40_ = type;
										_tmp41_ = g_str_has_prefix (_tmp40_, "v");
										if (_tmp41_) {
											const gchar* _tmp42_ = NULL;
											gboolean _tmp43_;
											const gchar* _tmp44_;
											gchar* _tmp45_;
											_tmp43_ = binding_generator_gdbus;
											if (_tmp43_) {
												_tmp42_ = "GLib.Variant";
											} else {
												_tmp42_ = "GLib.Value";
											}
											_tmp44_ = _tmp42_;
											_tmp45_ = g_strdup (_tmp44_);
											result = _tmp45_;
											if (tail) {
												*tail = _vala_tail;
											} else {
												_g_free0 (_vala_tail);
											}
											return result;
										} else {
											gboolean _tmp46_ = FALSE;
											const gchar* _tmp47_;
											gboolean _tmp48_ = FALSE;
											gboolean _tmp51_;
											_tmp47_ = type;
											_tmp48_ = g_str_has_prefix (_tmp47_, "a{");
											if (_tmp48_) {
												const gchar* _tmp49_;
												gboolean _tmp50_ = FALSE;
												_tmp49_ = type;
												_tmp50_ = g_str_has_suffix (_tmp49_, "}");
												_tmp46_ = _tmp50_;
											} else {
												_tmp46_ = FALSE;
											}
											_tmp51_ = _tmp46_;
											if (_tmp51_) {
												const gchar* _tmp52_;
												gchar* _tmp53_ = NULL;
												gchar* _tmp54_ = NULL;
												gchar* tmp_type;
												gchar* tail2;
												gchar* tail3;
												GString* _tmp55_;
												GString* vala_type;
												GString* _tmp56_;
												const gchar* _tmp57_;
												const gchar* _tmp58_;
												gchar* _tmp59_ = NULL;
												gchar* _tmp60_;
												gchar* _tmp61_;
												gchar* _tmp62_;
												const gchar* _tmp63_;
												gchar* _tmp64_ = NULL;
												gchar* _tmp65_ = NULL;
												gchar* _tmp66_;
												gchar* foo;
												GString* _tmp67_;
												const gchar* _tmp68_;
												GString* _tmp69_;
												const gchar* _tmp70_;
												const gchar* _tmp71_;
												gchar* _tmp72_ = NULL;
												gchar* _tmp73_;
												const gchar* _tmp74_;
												gchar* _tmp75_ = NULL;
												gchar* _tmp76_ = NULL;
												gchar* _tmp77_;
												gchar* value_type;
												const gchar* _tmp78_;
												GString* _tmp81_;
												const gchar* _tmp82_;
												GString* _tmp83_;
												GString* _tmp84_;
												const gchar* _tmp85_;
												gchar* _tmp86_;
												_tmp52_ = type;
												_tmp54_ = binding_generator_get_subsignature (self, _tmp52_, '{', '}', &_tmp53_);
												_g_free0 (_vala_tail);
												_vala_tail = _tmp53_;
												tmp_type = _tmp54_;
												tail2 = NULL;
												tail3 = NULL;
												_tmp55_ = g_string_new ("");
												vala_type = _tmp55_;
												_tmp56_ = vala_type;
												g_string_append (_tmp56_, "GLib.HashTable<");
												_tmp57_ = tmp_type;
												_tmp58_ = type_name;
												_tmp59_ = binding_generator_plural_to_singular (self, _tmp58_);
												_tmp60_ = _tmp59_;
												_tmp61_ = g_strconcat (_tmp60_, "Key", NULL);
												_tmp62_ = _tmp61_;
												_tmp63_ = dbus_namespace;
												_tmp65_ = binding_generator_parse_type (self, _tmp57_, &_tmp64_, _tmp62_, _tmp63_, &_inner_error_);
												_g_free0 (tail2);
												tail2 = _tmp64_;
												_tmp66_ = _tmp65_;
												_g_free0 (_tmp62_);
												_g_free0 (_tmp60_);
												foo = _tmp66_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == GENERATOR_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_string_free0 (vala_type);
														_g_free0 (tail3);
														_g_free0 (tail2);
														_g_free0 (tmp_type);
														return NULL;
													} else {
														_g_string_free0 (vala_type);
														_g_free0 (tail3);
														_g_free0 (tail2);
														_g_free0 (tmp_type);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_tmp67_ = vala_type;
												_tmp68_ = foo;
												g_string_append (_tmp67_, _tmp68_);
												_tmp69_ = vala_type;
												g_string_append (_tmp69_, ", ");
												_tmp70_ = tail2;
												_tmp71_ = type_name;
												_tmp72_ = binding_generator_plural_to_singular (self, _tmp71_);
												_tmp73_ = _tmp72_;
												_tmp74_ = dbus_namespace;
												_tmp76_ = binding_generator_parse_type (self, _tmp70_, &_tmp75_, _tmp73_, _tmp74_, &_inner_error_);
												_g_free0 (tail3);
												tail3 = _tmp75_;
												_tmp77_ = _tmp76_;
												_g_free0 (_tmp73_);
												value_type = _tmp77_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == GENERATOR_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (foo);
														_g_string_free0 (vala_type);
														_g_free0 (tail3);
														_g_free0 (tail2);
														_g_free0 (tmp_type);
														return NULL;
													} else {
														_g_free0 (foo);
														_g_string_free0 (vala_type);
														_g_free0 (tail3);
														_g_free0 (tail2);
														_g_free0 (tmp_type);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_tmp78_ = value_type;
												if (g_strcmp0 (_tmp78_, "GLib.Value") == 0) {
													const gchar* _tmp79_;
													gchar* _tmp80_;
													_tmp79_ = value_type;
													_tmp80_ = g_strconcat (_tmp79_, "?", NULL);
													_g_free0 (value_type);
													value_type = _tmp80_;
												}
												_tmp81_ = vala_type;
												_tmp82_ = value_type;
												g_string_append (_tmp81_, _tmp82_);
												_tmp83_ = vala_type;
												g_string_append (_tmp83_, ">");
												_tmp84_ = vala_type;
												_tmp85_ = _tmp84_->str;
												_tmp86_ = g_strdup (_tmp85_);
												result = _tmp86_;
												_g_free0 (value_type);
												_g_free0 (foo);
												_g_string_free0 (vala_type);
												_g_free0 (tail3);
												_g_free0 (tail2);
												_g_free0 (tmp_type);
												if (tail) {
													*tail = _vala_tail;
												} else {
													_g_free0 (_vala_tail);
												}
												return result;
											} else {
												const gchar* _tmp87_;
												gboolean _tmp88_ = FALSE;
												_tmp87_ = type;
												_tmp88_ = g_str_has_prefix (_tmp87_, "a");
												if (_tmp88_) {
													gchar* tail2;
													const gchar* _tmp89_;
													const gchar* _tmp90_;
													gchar* _tmp91_ = NULL;
													gchar* _tmp92_;
													const gchar* _tmp93_;
													gchar* _tmp94_ = NULL;
													gchar* _tmp95_ = NULL;
													gchar* _tmp96_;
													gchar* _tmp97_;
													gchar* _tmp98_;
													gchar* _tmp99_;
													gchar* _tmp100_;
													tail2 = NULL;
													_tmp89_ = _vala_tail;
													_tmp90_ = type_name;
													_tmp91_ = binding_generator_plural_to_singular (self, _tmp90_);
													_tmp92_ = _tmp91_;
													_tmp93_ = dbus_namespace;
													_tmp95_ = binding_generator_parse_type (self, _tmp89_, &_tmp94_, _tmp92_, _tmp93_, &_inner_error_);
													_g_free0 (tail2);
													tail2 = _tmp94_;
													_tmp96_ = _tmp95_;
													_g_free0 (_tmp92_);
													_tmp97_ = _tmp96_;
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == GENERATOR_ERROR) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (tail2);
															return NULL;
														} else {
															_g_free0 (tail2);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_tmp98_ = _tmp97_;
													_tmp99_ = g_strconcat (_tmp98_, "[]", NULL);
													_tmp100_ = _tmp99_;
													_g_free0 (_tmp98_);
													result = _tmp100_;
													_g_free0 (tail2);
													if (tail) {
														*tail = _vala_tail;
													} else {
														_g_free0 (_vala_tail);
													}
													return result;
												} else {
													gboolean _tmp101_ = FALSE;
													const gchar* _tmp102_;
													gboolean _tmp103_ = FALSE;
													gboolean _tmp106_;
													_tmp102_ = type;
													_tmp103_ = g_str_has_prefix (_tmp102_, "(");
													if (_tmp103_) {
														const gchar* _tmp104_;
														gboolean _tmp105_ = FALSE;
														_tmp104_ = type;
														_tmp105_ = g_str_has_suffix (_tmp104_, ")");
														_tmp101_ = _tmp105_;
													} else {
														_tmp101_ = FALSE;
													}
													_tmp106_ = _tmp101_;
													if (_tmp106_) {
														const gchar* _tmp107_;
														gchar* _tmp108_ = NULL;
														gchar* _tmp109_ = NULL;
														gchar* sub_type;
														gint number;
														const gchar* _tmp110_;
														gchar* _tmp111_;
														gchar* unique_type_name;
														GeeMap* _tmp118_;
														const gchar* _tmp119_;
														gchar* _tmp120_;
														gchar* _tmp121_;
														const gchar* _tmp122_;
														gchar* _tmp123_;
														gchar* _tmp124_;
														gboolean _tmp125_ = FALSE;
														gboolean _tmp126_;
														_tmp107_ = type;
														_tmp109_ = binding_generator_get_subsignature (self, _tmp107_, '(', ')', &_tmp108_);
														_g_free0 (_vala_tail);
														_vala_tail = _tmp108_;
														sub_type = _tmp109_;
														number = 2;
														_tmp110_ = type_name;
														_tmp111_ = g_strconcat (_tmp110_, "Struct", NULL);
														unique_type_name = _tmp111_;
														while (TRUE) {
															GeeMap* _tmp112_;
															const gchar* _tmp113_;
															gboolean _tmp114_ = FALSE;
															const gchar* _tmp115_;
															gint _tmp116_;
															gchar* _tmp117_ = NULL;
															_tmp112_ = self->priv->structs_to_generate;
															_tmp113_ = unique_type_name;
															_tmp114_ = gee_map_has_key (_tmp112_, _tmp113_);
															if (!_tmp114_) {
																break;
															}
															_tmp115_ = unique_type_name;
															_tmp116_ = number;
															number = _tmp116_ + 1;
															_tmp117_ = g_strdup_printf ("%s%d", _tmp115_, _tmp116_);
															_g_free0 (unique_type_name);
															unique_type_name = _tmp117_;
														}
														_tmp118_ = self->priv->name_index;
														_tmp119_ = dbus_namespace;
														_tmp120_ = g_strconcat (_tmp119_, ".", NULL);
														_tmp121_ = _tmp120_;
														_tmp122_ = unique_type_name;
														_tmp123_ = g_strconcat (_tmp121_, _tmp122_, NULL);
														_tmp124_ = _tmp123_;
														_tmp125_ = gee_map_has_key (_tmp118_, _tmp124_);
														_tmp126_ = !_tmp125_;
														_g_free0 (_tmp124_);
														_g_free0 (_tmp121_);
														if (_tmp126_) {
															GeeMap* _tmp127_;
															const gchar* _tmp128_;
															const gchar* _tmp129_;
															_tmp127_ = self->priv->structs_to_generate;
															_tmp128_ = unique_type_name;
															_tmp129_ = sub_type;
															gee_map_set (_tmp127_, _tmp128_, _tmp129_);
														}
														result = unique_type_name;
														_g_free0 (sub_type);
														if (tail) {
															*tail = _vala_tail;
														} else {
															_g_free0 (_vala_tail);
														}
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp130_ = type;
	_tmp131_ = string_to_string (_tmp130_);
	_tmp132_ = g_strconcat ("dbustype: '", _tmp131_, "' unknown", NULL);
	_tmp133_ = _tmp132_;
	_tmp134_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE, _tmp133_);
	_tmp135_ = _tmp134_;
	_g_free0 (_tmp133_);
	_inner_error_ = _tmp135_;
	if (_inner_error_->domain == GENERATOR_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (tail) {
		*tail = _vala_tail;
	} else {
		_g_free0 (_vala_tail);
	}
}


static gchar* binding_generator_get_struct_name (BindingGenerator* self, const gchar* interface_name, const gchar* param_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* striped_interface_name;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* name;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	g_return_val_if_fail (param_name != NULL, NULL);
	_tmp0_ = interface_name;
	_tmp1_ = binding_generator_strip_namespace (self, _tmp0_);
	striped_interface_name = _tmp1_;
	_tmp2_ = param_name;
	_tmp3_ = binding_generator_capitalize (self, _tmp2_);
	name = _tmp3_;
	_tmp5_ = name;
	_tmp6_ = striped_interface_name;
	_tmp7_ = g_str_has_prefix (_tmp5_, _tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = name;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp9_;
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = striped_interface_name;
		_tmp11_ = name;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp12_;
	}
	result = _tmp4_;
	_g_free0 (name);
	_g_free0 (striped_interface_name);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* binding_generator_get_namespace_name (BindingGenerator* self, const gchar* interface_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong last_dot;
	const gchar* _tmp10_;
	glong _tmp11_;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	_tmp0_ = interface_name;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	last_dot = (glong) (_tmp2_ - 1);
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		glong _tmp4_;
		gboolean _tmp8_;
		glong _tmp9_;
		_tmp4_ = last_dot;
		if (_tmp4_ >= ((glong) 0)) {
			const gchar* _tmp5_;
			glong _tmp6_;
			gchar _tmp7_ = '\0';
			_tmp5_ = interface_name;
			_tmp6_ = last_dot;
			_tmp7_ = string_get (_tmp5_, _tmp6_);
			_tmp3_ = _tmp7_ != '.';
		} else {
			_tmp3_ = FALSE;
		}
		_tmp8_ = _tmp3_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = last_dot;
		last_dot = _tmp9_ - 1;
	}
	_tmp10_ = interface_name;
	_tmp11_ = last_dot;
	_tmp12_ = string_substring (_tmp10_, (glong) 0, _tmp11_);
	result = _tmp12_;
	return result;
}


static gchar* binding_generator_strip_namespace (BindingGenerator* self, const gchar* interface_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong last_dot;
	const gchar* _tmp10_;
	glong _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	glong _tmp15_;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	_tmp0_ = interface_name;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	last_dot = (glong) (_tmp2_ - 1);
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		glong _tmp4_;
		gboolean _tmp8_;
		glong _tmp9_;
		_tmp4_ = last_dot;
		if (_tmp4_ >= ((glong) 0)) {
			const gchar* _tmp5_;
			glong _tmp6_;
			gchar _tmp7_ = '\0';
			_tmp5_ = interface_name;
			_tmp6_ = last_dot;
			_tmp7_ = string_get (_tmp5_, _tmp6_);
			_tmp3_ = _tmp7_ != '.';
		} else {
			_tmp3_ = FALSE;
		}
		_tmp8_ = _tmp3_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = last_dot;
		last_dot = _tmp9_ - 1;
	}
	_tmp10_ = interface_name;
	_tmp11_ = last_dot;
	_tmp12_ = interface_name;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = last_dot;
	_tmp16_ = string_substring (_tmp10_, _tmp11_ + 1, (_tmp14_ - _tmp15_) - 1);
	result = _tmp16_;
	return result;
}


static gchar* binding_generator_capitalize (BindingGenerator* self, const gchar* type_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	GString* _tmp3_;
	GString* capitalized_name;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_tmp0_ = type_name;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "_", 0);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = g_string_new ("");
	capitalized_name = _tmp3_;
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	{
		gchar** part_collection = NULL;
		gint part_collection_length1 = 0;
		gint _part_collection_size_ = 0;
		gint part_it = 0;
		part_collection = _tmp4_;
		part_collection_length1 = _tmp4__length1;
		for (part_it = 0; part_it < _tmp4__length1; part_it = part_it + 1) {
			gchar* _tmp5_;
			gchar* part = NULL;
			_tmp5_ = g_strdup (part_collection[part_it]);
			part = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = part;
				if (g_strcmp0 (_tmp6_, "") != 0) {
					GString* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					GString* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					_tmp7_ = capitalized_name;
					_tmp8_ = part;
					_tmp9_ = string_substring (_tmp8_, (glong) 0, (glong) 1);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_utf8_strup (_tmp10_, (gssize) (-1));
					_tmp12_ = _tmp11_;
					g_string_append (_tmp7_, _tmp12_);
					_g_free0 (_tmp12_);
					_g_free0 (_tmp10_);
					_tmp13_ = capitalized_name;
					_tmp14_ = part;
					_tmp15_ = part;
					_tmp16_ = strlen (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = string_substring (_tmp14_, (glong) 1, (glong) (_tmp17_ - 1));
					_tmp19_ = _tmp18_;
					g_string_append (_tmp13_, _tmp19_);
					_g_free0 (_tmp19_);
				}
				_g_free0 (part);
			}
		}
	}
	_tmp20_ = capitalized_name;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_string_free0 (capitalized_name);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* binding_generator_uncapitalize (BindingGenerator* self, const gchar* name) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* uncapitalized_name;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	uncapitalized_name = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_ = '\0';
				gunichar c;
				gunichar _tmp11_;
				gboolean _tmp12_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = name;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = name;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
				c = (gunichar) _tmp10_;
				_tmp11_ = c;
				_tmp12_ = g_unichar_isupper (_tmp11_);
				if (_tmp12_) {
					gint _tmp13_;
					GString* _tmp15_;
					gunichar _tmp16_;
					gunichar _tmp17_ = 0U;
					_tmp13_ = i;
					if (_tmp13_ > 0) {
						GString* _tmp14_;
						_tmp14_ = uncapitalized_name;
						g_string_append_unichar (_tmp14_, (gunichar) '_');
					}
					_tmp15_ = uncapitalized_name;
					_tmp16_ = c;
					_tmp17_ = g_unichar_tolower (_tmp16_);
					g_string_append_unichar (_tmp15_, _tmp17_);
				} else {
					GString* _tmp18_;
					gunichar _tmp19_;
					_tmp18_ = uncapitalized_name;
					_tmp19_ = c;
					g_string_append_unichar (_tmp18_, _tmp19_);
				}
			}
		}
	}
	_tmp20_ = uncapitalized_name;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = binding_generator_transform_registered_name (self, _tmp21_);
	result = _tmp22_;
	_g_string_free0 (uncapitalized_name);
	return result;
}


static gchar* binding_generator_normalized_to_upper_case (BindingGenerator* self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = string_replace (_tmp0_, "-", "_");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strup (_tmp2_, (gssize) (-1));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gchar* binding_generator_camel_case_to_upper_case (BindingGenerator* self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = binding_generator_uncapitalize (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strup (_tmp2_, (gssize) (-1));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gchar* binding_generator_transform_registered_name (BindingGenerator* self, const gchar* name) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = name;
	if (_tmp1_ != NULL) {
		GeeSet* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = binding_generator_registered_names;
		_tmp3_ = name;
		_tmp4_ = gee_collection_contains ((GeeCollection*) _tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = name;
		_tmp7_ = g_strconcat (_tmp6_, "_", NULL);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = name;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	return result;
}


static gchar* binding_generator_plural_to_singular (BindingGenerator* self, const gchar* type_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_tmp0_ = type_name;
	_tmp1_ = g_str_has_suffix (_tmp0_, "ies");
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = type_name;
		_tmp3_ = type_name;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp5_ - 3));
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "y", NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		return result;
	} else {
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = type_name;
		_tmp11_ = g_str_has_suffix (_tmp10_, "ses");
		if (_tmp11_) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gchar* _tmp16_ = NULL;
			_tmp12_ = type_name;
			_tmp13_ = type_name;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = string_substring (_tmp12_, (glong) 0, (glong) (_tmp15_ - 2));
			result = _tmp16_;
			return result;
		} else {
			const gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp17_ = type_name;
			_tmp18_ = g_str_has_suffix (_tmp17_, "us");
			if (_tmp18_) {
				const gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = type_name;
				_tmp20_ = g_strdup (_tmp19_);
				result = _tmp20_;
				return result;
			} else {
				const gchar* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp21_ = type_name;
				_tmp22_ = g_str_has_suffix (_tmp21_, "i");
				if (_tmp22_) {
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp23_ = type_name;
					_tmp24_ = type_name;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp26_ - 1));
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat (_tmp28_, "o", NULL);
					_tmp30_ = _tmp29_;
					_g_free0 (_tmp28_);
					result = _tmp30_;
					return result;
				} else {
					const gchar* _tmp31_;
					gboolean _tmp32_ = FALSE;
					_tmp31_ = type_name;
					_tmp32_ = g_str_has_suffix (_tmp31_, "s");
					if (_tmp32_) {
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						gint _tmp35_;
						gint _tmp36_;
						gchar* _tmp37_ = NULL;
						_tmp33_ = type_name;
						_tmp34_ = type_name;
						_tmp35_ = strlen (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = string_substring (_tmp33_, (glong) 0, (glong) (_tmp36_ - 1));
						result = _tmp37_;
						return result;
					} else {
						const gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp38_ = type_name;
						_tmp39_ = g_strdup (_tmp38_);
						result = _tmp39_;
						return result;
					}
				}
			}
		}
	}
}


static gchar* binding_generator_get_indent (BindingGenerator* self, gint offset) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indentSize;
	_tmp1_ = offset;
	_tmp2_ = g_strnfill ((gsize) (_tmp0_ + _tmp1_), '\t');
	result = _tmp2_;
	return result;
}


static void binding_generator_update_indent (BindingGenerator* self, gint increment) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->indentSize;
	_tmp1_ = increment;
	self->priv->indentSize = _tmp0_ + _tmp1_;
}


static gchar* binding_generator_get_subsignature (BindingGenerator* self, const gchar* s, gchar start, gchar end, gchar** tail) {
	gchar* _vala_tail = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gint iter;
	gint counter;
	gint begin;
	gchar c = '\0';
	const gchar* _tmp20_;
	gint _tmp21_;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* tmp;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	data = (gchar*) _tmp0_;
	data_length1 = -1;
	_data_size_ = data_length1;
	iter = 0;
	counter = 0;
	begin = 0;
	{
		gboolean _tmp1_;
		iter = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_;
			gint _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			gchar _tmp10_;
			gchar _tmp11_;
			gchar _tmp12_;
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gint _tmp3_;
				_tmp3_ = iter;
				iter = _tmp3_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = iter;
			_tmp5_ = s;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp4_ < _tmp7_)) {
				break;
			}
			_tmp8_ = data;
			_tmp8__length1 = data_length1;
			_tmp9_ = iter;
			_tmp10_ = _tmp8_[_tmp9_];
			c = _tmp10_;
			_tmp11_ = c;
			_tmp12_ = start;
			if (_tmp11_ == _tmp12_) {
				gint _tmp13_;
				gint _tmp15_;
				_tmp13_ = counter;
				if (_tmp13_ == 0) {
					gint _tmp14_;
					_tmp14_ = iter;
					begin = _tmp14_;
				}
				_tmp15_ = counter;
				counter = _tmp15_ + 1;
			} else {
				gchar _tmp16_;
				gchar _tmp17_;
				_tmp16_ = c;
				_tmp17_ = end;
				if (_tmp16_ == _tmp17_) {
					gint _tmp18_;
					gint _tmp19_;
					_tmp18_ = counter;
					counter = _tmp18_ - 1;
					_tmp19_ = counter;
					if (_tmp19_ == 0) {
						break;
					}
				}
			}
		}
	}
	_tmp20_ = s;
	_tmp21_ = iter;
	_tmp22_ = string_substring (_tmp20_, (glong) (_tmp21_ + 1), (glong) (-1));
	_g_free0 (_vala_tail);
	_vala_tail = _tmp22_;
	_tmp23_ = s;
	_tmp24_ = begin;
	_tmp25_ = iter;
	_tmp26_ = begin;
	_tmp27_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) ((_tmp25_ - _tmp26_) - 1));
	tmp = _tmp27_;
	result = tmp;
	if (tail) {
		*tail = _vala_tail;
	} else {
		_g_free0 (_vala_tail);
	}
	return result;
}


static void binding_generator_class_init (BindingGeneratorClass * klass) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	GeeSet* _tmp21_;
	GeeSet* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	binding_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BindingGeneratorPrivate));
	G_OBJECT_CLASS (klass)->finalize = binding_generator_finalize;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	binding_generator_registered_names = (GeeSet*) _tmp2_;
	_tmp3_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp3_, "using");
	_tmp4_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp4_, "namespace");
	_tmp5_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp5_, "public");
	_tmp6_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp6_, "private");
	_tmp7_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp7_, "internal");
	_tmp8_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp8_, "errordomain");
	_tmp9_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp9_, "class");
	_tmp10_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp10_, "struct");
	_tmp11_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp11_, "new");
	_tmp12_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp12_, "for");
	_tmp13_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp13_, "while");
	_tmp14_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp14_, "foreach");
	_tmp15_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp15_, "switch");
	_tmp16_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp16_, "case");
	_tmp17_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp17_, "static");
	_tmp18_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp18_, "unowned");
	_tmp19_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp19_, "weak");
	_tmp20_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp20_, "register");
	_tmp21_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp21_, "message");
	_tmp22_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp22_, "get_type");
	_tmp23_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp23_, "dispose");
	_tmp24_ = binding_generator_registered_names;
	gee_collection_add ((GeeCollection*) _tmp24_, "result");
}


static void binding_generator_instance_init (BindingGenerator * self) {
	GeeArrayList* _tmp0_;
	GeneratedNamespace* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	GeeHashMap* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GEqualFunc _tmp8_;
	GeeHashMap* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GEqualFunc _tmp12_;
	GeeHashMap* _tmp13_;
	self->priv = BINDING_GENERATOR_GET_PRIVATE (self);
	self->priv->inner_interface_strategy_concat = TRUE;
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	self->priv->api_docs = (GeeList*) _tmp0_;
	_tmp1_ = generated_namespace_new ();
	self->priv->root_namespace = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_str_equal;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp2_, _tmp3_, _tmp4_);
	self->priv->name_index = (GeeMap*) _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_str_equal;
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp6_, _tmp7_, _tmp8_);
	self->priv->error_name_index = (GeeMap*) _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_str_equal;
	_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp10_, _tmp11_, _tmp12_);
	self->priv->structs_to_generate = (GeeMap*) _tmp13_;
	self->priv->indentSize = 0;
}


static void binding_generator_finalize (GObject* obj) {
	BindingGenerator * self;
	self = BINDING_GENERATOR (obj);
	_g_free0 (self->priv->output_directory);
	_g_object_unref0 (self->priv->namespace_renaming);
	_g_free0 (self->priv->command);
	_fclose0 (self->priv->output);
	_g_object_unref0 (self->priv->api_docs);
	_generated_namespace_unref0 (self->priv->root_namespace);
	_g_object_unref0 (self->priv->name_index);
	_g_object_unref0 (self->priv->error_name_index);
	_g_object_unref0 (self->priv->structs_to_generate);
	G_OBJECT_CLASS (binding_generator_parent_class)->finalize (obj);
}


GType binding_generator_get_type (void) {
	static volatile gsize binding_generator_type_id__volatile = 0;
	if (g_once_init_enter (&binding_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BindingGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BindingGenerator), 0, (GInstanceInitFunc) binding_generator_instance_init, NULL };
		GType binding_generator_type_id;
		binding_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "BindingGenerator", &g_define_type_info, 0);
		g_once_init_leave (&binding_generator_type_id__volatile, binding_generator_type_id);
	}
	return binding_generator_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



