# Редиректы и псевдонимы

### Редирект

Редиректы также определяются в конфигурации путей `routes`. Для редиректа с `/a` на `/b`, укажите:

``` js
const router = new VueRouter({
  routes: [
    { path: '/a', redirect: '/b' }
  ]
})
```

В качестве цели редиректа можно использовать и именованный путь:

``` js
const router = new VueRouter({
  routes: [
    { path: '/a', redirect: { name: 'foo' }}
  ]
})
```

Можно даже указать функцию для организации динамического редиректа:

``` js
const router = new VueRouter({
  routes: [
    { path: '/a', redirect: to => {
      // в функцию в качестве аргумента передаётся путь
      // возвращаемым значением должна быть строка или объект пути
    }}
  ]
})
```

Обратите внимание, что [сторожевые хуки](../advanced/navigation-guards.md) не применяются на маршруте, который служит для перенаправления, только на его цель. В приведённом ниже примере добавление хуков `beforeEnter` или `beforeLeave` на маршрут `/a` не будет иметь никакого эффекта.

Для демонстрации более сложных возможностей, обратите внимание на [этот пример](https://github.com/vuejs/vue-router/blob/dev/examples/redirect/app.js).

### Псевдонимы

При редиректе, если пользователь переходит по пути `/a`, URL заменяется на `/b` и затем уже `/b` рассматривается как основной путь. В чём отличие псевдонима?

**В случае, когда псевдонимом `/a` является `/b`, при посещении пользователем `/b` URL останется равным `/b`, но роутер выполнит все действия так, как если бы он был равен `/a`.**

В виде конфигурации роутера вышесказанное может быть выражено так:

``` js
const router = new VueRouter({
  routes: [
    { path: '/a', component: A, alias: '/b' }
  ]
})
```

Псевдонимы позволяют не ограничиваться вложенными структурами при организации связи URL и UI.

Этот [пример](https://github.com/vuejs/vue-router/blob/dev/examples/route-alias/app.js) демонстрирует более продвинутое использование возможностей.
